#ifndef lint
static char sccsid[] = "@(#)matd.c	1.1 2/16/85";
#endif

/*
 * Mac Atp Transfer Daemon
 *
 * history
 * 02/16/85	croft	adapted from ucb/caltech tftpd.
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <sys/wait.h>
#include <sys/file.h>
#include <netinet/in.h>

#include <signal.h>
#include <stdio.h>
#include <strings.h>
#include <errno.h>
#include <ctype.h>
#include <setjmp.h>

#include <atalk.h>
#include <atalku.h>
#include <mat.h>

#include <pwd.h>

#define	LOGFILE		"/tmp/matd.log"

extern	int errno;
int	reapchild();
long	time(), tloc;		/* time of day */
int	pid;			/* process pid */
int	uid;			/* user id */
int	gid;			/* group id */
char	*user;			/* user name string */
char	*pass;			/* password string */
char	*file;			/* filename string */
char	upf[64];		/* string storage for user/pass/file */
char	*linep;			/* char pointer for line being parsed */
char	*home;			/* home directory */

struct atpsoc as;		/* atp socket */
char	resbuf[RESLEN];		/* response buffer */
extern char *sys_errlist[];	/* system error list */
extern int errno;
char	childsoc;		/* child's socket number */
char	xxx;


main(argc, argv)
{
	register int n;
	int f;

#ifndef DEBUG
	if (fork())
		exit(0);
	for (f = 0; f < 10; f++)
		(void) close(f);
	(void) open("/", 0);
	(void) dup2(0, 1);
	(void) dup2(0, 2);
	{ int t = open("/dev/tty", 2);	
	  if (t >= 0) {
		ioctl(t, TIOCNOTTY, (char *)0);
		(void) close(t);
	  }
	}
#endif
	signal(SIGCHLD, reapchild);

	time(&tloc);
	log("#\n#    matd starting at %s#\n", ctime(&tloc));

	if (atpopenres(&as, MATSOCKET) < 0) {
		perror("atpopen");
		log("atpopen failed\n");
		exit(1);
	}
	for (;;) {
		int op;
		atpdisconnect(&as);
		atprecreq(&as);
		switch (op = (ntohl(as.req.atp.userData) & OPMASK)) {
		case OPCHECK:
			opcheck();	/* doesnt fork */
			break;

		case OPREAD:
			if (fork() == 0)
				opread();
			break;

		case OPWRITE:
			if (fork() == 0)
				opwrite();
			break;

		default:
			log("matd: Bad OPCODE (%x)\n", op);
		}
	}
}


reapchild()
{
	union wait status;

	while (wait3(&status, WNOHANG, 0) > 0)
		;
}


/*
 * User / password check.
 */
opcheck()
{
	if (!gooduser())
		return;
	atpsendres(&as, 0, 0, OPCHECK|OPACK);
}


/*
 * Write file.
 */
opwrite()
{
	int op, count, fd;
	char *cp;
	int timer();
	
	checkuf();	/* check username and filename */
	if ((fd = open(file, O_WRONLY|O_TRUNC|O_CREAT, 0644)) < 0) {
		cp = sys_errlist[errno];
		goto bad;
	}
	atpsendres(&as, &childsoc, 1, OPWRITE|OPACK);
	signal(SIGALRM, timer);
	for (;;) {
		alarm(IDLETO);
		atprecreq(&as);
		if ((op = (ntohl(as.req.atp.userData) & OPMASK)) != OPDATA) {
			cp = "expected OPDATA";
			goto bad;
		}
		count = ntohl(as.req.atp.userData) >> 16;
		atpsendres(&as, 0, 0, OPDATA|OPACK);
		if (count == 0)
			break;
		write(fd, as.req.data, count);
	}
	close(fd);
	log("%d: Received %s\n", pid, file);
	exit(0);
bad:
	nak(cp);
	exit(1);
}


/*
 * Read file.
 */
opread()
{
	int op, count, fd;
	char *cp;
	int timer();
	
	checkuf();	/* check username and filename */
	if ((fd = open(file, O_RDONLY, 0)) < 0) {
		cp = sys_errlist[errno];
		goto bad;
	}
	atpsendres(&as, &childsoc, 1, OPREAD|OPACK);
	signal(SIGALRM, timer);
	for (;;) {
		alarm(IDLETO);
		atprecreq(&as);
		if ((op = (ntohl(as.req.atp.userData) & OPMASK)) != OPDATA) {
			cp = "expected OPDATA";
			goto bad;
		}
		count = read(fd, resbuf, RESLEN);
		if (count < 0) {
			cp = sys_errlist[errno];
			goto bad;
		}
		atpsendres(&as, resbuf, count,(count << 16) | OPDATA | OPACK);
		if (count == 0)
			break;
	}
	close(fd);
	log("%d: Sent %s\n", pid, file);
	exit(0);
bad:
	nak(cp);
	exit(1);
}


/*
 * Check username and filename.
 */
checkuf()
{
	char *lclname;

	/* close and rebind the socket */
	childsoc = atprebind(&as, ddpWKS);
	/* Save the PID and starting time */
	pid = getpid();
	time(&tloc);
	log("%d: process forked at %s", pid, ctime(&tloc));
	if (!gooduser())
		exit(1);
	setreuid(uid, uid);
	setregid(gid, gid);
	chdir(home);
#ifdef notdef
	/* Translate the file name so ~ works */
	lclname = (char *) ftrans(file);
	if (*lclname == '\0') {
		nak("file not found");
		exit(1);
	}
	file = lclname;
#endif notdef
}


/*
 * Alarm timer expired, exit process.
 */
timer()
{
	log("%d: Timed out\n", pid);
	exit(1);
}


/*
 * Log an error message.
 */
log(fmt, args)
char *fmt;
{
	FILE *f_log;

	if ((f_log = fopen(LOGFILE, "a+")) == NULL) {
		perror("log_mess: Problems accessing the logfile.");
	}
	_doprnt(fmt, &args, f_log);
	fclose(f_log);
}


/*
 * Returns true if good username and password.
 */
gooduser()
{
	register char *cp;
	char *getfield();
	struct passwd *p;

	strncpy(upf, as.req.data, sizeof upf - 1);
	linep = upf;
	user = getfield();
	pass = getfield();
	file = getfield();
	if ((p = (struct passwd *)getpwnam(user)) == NULL) {
		cp = "no such user name";
		goto bad;
	}
	uid = p->pw_uid;
	gid = p->pw_gid;
	home = p->pw_dir;
	cp = (char *)crypt(pass, p->pw_passwd);
	if (strcmp(cp, p->pw_passwd) != 0) {
		cp = "bad password";
		goto bad;
	}
	return (1);
bad:
	nak(cp);
	return (0);
}


/*
 * Get next field from string at *linep.
 */
char *
getfield()
{
	register char *start = linep;

	for ( ; *linep ; linep++)
		if (*linep == SEPCHAR)
			break;
	if (*linep)
		*linep++ = 0;
	return (start);
}


/*
 * Negative acknowledge (OPERROR) with error string 's'.
 */
nak(s)
	char *s;
{
	atpsendres(&as, s, strlen(s)+1, OPERROR);
	log("%d: Error %s\n", pid, s);
}
