/*	mat.h	1.0	03/17/84	*/

/*
 * MAT - Mac ATP Test program (or: Mac ATP Transfer) 'protocol' defines
 *
 */

/*
 * history
 * 03/17/84	Croft	created.
 */


#define	MATSOCKET	33	/* server socket number (should use
				   NBP instead) */
#define	PROTOCOL	2	/* protocol number */
#define	VERSION		1	/* version number */

#define	OPACK		1	/* acknowledge bit (or'ed into opcode) */
#define	OP(n)		((PROTOCOL << 12) | (VERSION << 8) | n )
#define	OPMASK		0xFFFF	/* opcode mask */

/* opcodes */
#define	OPCHECK		OP(2)	/* check user/password */
#define	OPWRITE		OP(4)	/* write a file */
#define	OPREAD		OP(6)	/* read a file */
#define	OPDATA		OP(8)	/* data transfer */
#define	OPERROR		OP(10)	/* error reply */

#define	RESLEN		2048	/* response data length */
#define	REQLEN		512	/* request data length */

#define	SEPCHAR		'|'	/* field separator character */
#define	IDLETO		30	/* idle timeout */


