/*	efsd.c	x.x	03/30/85	*/

/*
 * efs daemon
 */

/*
 *  Copyright (c) 1984 by John Seamons, Lucasfilm Ltd.
 *  All rights reserved.
 *
 * history
 * 07/XX/84	jks	created
 * 03/30/85	croft	added appletalk
 * 04/20/85	croft	children properly cleaned up
 * 05/11/85	croft	fixed 'multiple open' bug
 */


#include <sys/types.h>
#include <sys/file.h>
#include <sys/stat.h>
#include <sys/dir.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <sys/wait.h>
#include <netinet/in.h>

#include <stdio.h>
#include <errno.h>
#include <signal.h>
#include <pwd.h>

#include <mac/quickdraw.h>
#include <mac/toolintf.h>
#include "fs.h"
#include "efs.h"
#include <atalk.h>
#include <atalku.h>

#define	COUNT		0
#define	FIND_NAME	1
#define	FIND_NUM	2

#define LOGFILE		"/tmp/efsd.log"
#define TRACEFILE	"/tmp/efsd.%d"	/* where %d is the pid */

#define	NKIDS		32	/* max number of child processes */
struct kids {
	int	pid;
	short	net;
	short	node;
} kids[NKIDS];

int debug = 0;
extern int errno;

int	reapchild();
long	time(), tloc;		/* time of day */
int	pid;			/* process pid */
int	uid;			/* user id */
int	gid;			/* group id */
char	*user;			/* user name string */
char	*pass;			/* password string */
char	upf[64];		/* string storage for user/pass/file */
char	*linep;			/* char pointer for line being parsed */
char	*home;			/* home directory */

struct atpsoc as;		/* atp socket */
extern char *sys_errlist[];	/* system error list */
char	childsoc;		/* child's socket number */
char	xxx;
FILE	*trace;			/* trace log */


main (argc, argv)
char *argv[];
{
	register int n;
	int f;

	if (fork())
		exit(0);
	for (f = 0; f < 10; f++)
		(void) close(f);
	(void) open("/", 0);
	(void) dup2(0, 1);
	(void) dup2(0, 2);
	{ int t = open("/dev/tty", 2);	
	  if (t >= 0) {
		ioctl(t, TIOCNOTTY, (char *)0);
		(void) close(t);
	  }
	}

	argv++;  argc--;
	if (argc && strcmp (*argv, "-d") == 0) {
		debug++;
		argv++;  argc--;
	}

	signal(SIGCHLD, reapchild);

	time(&tloc);
	log("efsd starting at %s", ctime(&tloc));

	if (atpopenres(&as, EFSSOCKET) < 0) {
		perror("atpopen");
		log("atpopen failed");
		exit(1);
	}
	for (;;) {
		int op, pid;
		atpdisconnect(&as);
		atprecreq(&as);
		switch (op = (ntohl(as.req.atp.userData) & OPMASK)) {
		case OPNEW:
			if ((pid = fork()) == 0)
				newuser();	/* never returns */
			killoldkid(pid, ntohs(as.reqddp.srcNet),
			    as.reqddp.srcNode);
			break;

		default:
			log("Bad OPCODE (%x)", op);
		}
	}
}


/*
 * Process spawned for new user.
 */
newuser()
{
	int timer();

	/* close and rebind the socket */
	childsoc = atprebind(&as, ddpWKS);
	/* Save the PID and starting time */
	pid = getpid();
	if (!gooduser())
		exit(1);
	time(&tloc);
	log("forked, user %s soc %d at %s", user,
	    childsoc&0xFF, ctime(&tloc));
	if (debug) {
		char tname[64];
		sprintf(tname, TRACEFILE, pid);
		if ((trace = fopen (tname, "w")) == NULL) {
			log("can't open tracefile");
			exit (-1);
		}
	}
	setreuid(uid, uid);
	setregid(gid, gid);
	chdir(home);
	chdir("mac");
	atpsendres(&as, &childsoc, 1, OPNEW|OPACK);
	signal(SIGALRM, timer);
	alarm(IDLETO);
	efsd();
}


efsd()
{
	register struct netBuf *np = (struct netBuf *)as.req.data;
	register int fd, flags, cnt, dirIndex, i;
	DIR *dirp;
	register struct direct *dp;
	struct stat statb;
	register char *cp;
	int posMode;
	char fn[256], to[256], wd[256], c;

	getwd (wd);
	dprintf ("listening..\n");
getrequest:
	alarm(IDLETO);
	atprecreq(&as);
	if ((i = ntohl(as.req.atp.userData)) != OPNORM) {
		log("bad opcode %x", i);
		exit (1);
	}
	np->n_dlen = ntohs(np->n_dlen);
	dprintf ("cmd 0x%x dlen %d ",
		np->n_cmd, np->n_dlen);

	switch (np->n_cmd) {

	case MountVol:
		np->n_un.n_mountVol.n_numFiles = efsDir (COUNT);
		np->n_un.n_mountVol.n_len = strlen (wd);
		strcpy (np->n_un.n_mountVol.n_volname, wd);
		dprintf ("MountVol %d files ",
			np->n_un.n_mountVol.n_numFiles);
		np->n_un.n_mountVol.n_numFiles =
			htons (np->n_un.n_mountVol.n_numFiles);
		efsReply (sizeof (short) + strlen (wd) + 1);
		break;

	case GetFileInfo:
		strcpy (fn, np->n_un.n_fname);
		strcat (fn, ".IF");
		cp = fn + strlen (fn) - 3;
		dprintf ("GetFileInfo <%s> ", fn);
		if ((dirIndex = efsDir (FIND_NAME, fn)) == 0) {
			efsError (ENOENT);
			break;
		}
		if ((fd = open (fn, O_RDONLY)) < 0) {
			efsError (errno);
			break;
		}
		bzero (&np->n_un.n_gfi.n_FDir, sizeof (fileDirectory));
		dprintf ("flNum %d ", dirIndex);
		*(long*)np->n_un.n_gfi.n_FDir.fdFlNum = htonl (dirIndex);
		if (read (fd, np->n_un.n_gfi.n_FDir.fdUsrWds,
		    sizeof (finderInfo)) < 0) {
			close (fd);
			efsError (errno);
			break;
		}
		close (fd);
		strcpy (cp, ".DF");
		if (stat (fn, &statb) < 0) {
			efsError (errno);
			break;
		}
		*(long*)np->n_un.n_gfi.n_FDir.fdLgLen =
			*(long*)np->n_un.n_gfi.n_FDir.fdPyLen =
			htonl (statb.st_size);
		strcpy (cp, ".RF");
		if (stat (fn, &statb) < 0) {
			efsError (errno);
			break;
		}
		*(long*)np->n_un.n_gfi.n_FDir.fdRLgLen =
			*(long*)np->n_un.n_gfi.n_FDir.fdRPyLen =
			htonl (statb.st_size);
		/* TODO: CrDat & MdDat */
		efsReply (sizeof (fileDirectory));
		break;

	case GetFileInfoByID:
		np->n_un.n_dirIndex = ntohs (np->n_un.n_dirIndex);
		dprintf ("GetFileInfoByID %d ", np->n_un.n_dirIndex);
		if ((dirIndex = efsDir (FIND_NUM, np->n_un.n_dirIndex, fn))
		    == 0) {
			efsError (ENOENT);
			break;
		}
		dprintf ("<%s> ", fn);
		cp = fn + strlen (fn) - 3;
		if ((fd = open (fn, O_RDONLY)) < 0) {
			efsError (errno);
			break;
		}
		bzero (&np->n_un.n_gfi.n_FDir, sizeof (fileDirectory));
		if (read (fd, np->n_un.n_gfi.n_FDir.fdUsrWds,
		    sizeof (finderInfo)) < 0) {
			close (fd);
			efsError (errno);
			break;
		}
		close (fd);
		*(long*)np->n_un.n_gfi.n_FDir.fdFlNum = htonl (dirIndex);
		strcpy (cp, ".DF");
		if (stat (fn, &statb) < 0) {
			efsError (errno);
			break;
		}
		*(long*)np->n_un.n_gfi.n_FDir.fdLgLen =
			*(long*)np->n_un.n_gfi.n_FDir.fdPyLen =
			htonl (statb.st_size);
		strcpy (cp, ".RF");
		if (stat (fn, &statb) < 0) {
			efsError (errno);
			break;
		}
		*(long*)np->n_un.n_gfi.n_FDir.fdRLgLen =
			*(long*)np->n_un.n_gfi.n_FDir.fdRPyLen =
			htonl (statb.st_size);
		/* TODO: CrDat & MdDat */
		strcpy (cp, "");
		np->n_un.n_gfi.n_len = strlen (fn);
		strcpy (np->n_un.n_gfi.n_name, fn);
		efsReply (sizeof (fileDirectory) + strlen (fn) + 1);
		break;

	case SetFileInfo:
		strcpy (fn, np->n_un.n_fname);
		strcat (fn, ".IF");
		dprintf ("SetFileInfo <%s> ", fn);
		if ((fd = open (fn, O_WRONLY | O_TRUNC)) < 0) {
			efsError (errno);
			break;
		}
		cp = np->n_un.n_fname + strlen (np->n_un.n_fname) + 1;
		if (write (fd, cp, sizeof (finderInfo)) < 0) {
			close (fd);
			efsError (errno);
			break;
		}
		close (fd);
		/* TODO: CrDat & MdDat */
		efsReply (0);
		break;

	case Open:
	case OpenRF:
		strcpy (fn, np->n_un.n_open.n_fname);
		strcat (fn, ".IF");
		cp = fn + strlen (fn) - 3;
		dprintf ("%s <%s> ", (np->n_cmd==Open)? "Open":"OpenRF",
		         fn);
		if ((dirIndex = efsDir (FIND_NAME, fn)) == 0) {
			efsError (ENOENT);
			break;
		}
		if (np->n_cmd == OpenRF) {
			strcpy (cp, ".RF");
		} else {
			strcpy (cp, ".DF");
		}
		switch (np->n_un.n_open.n_perm) {
		case IO_RW:
		case IO_CURRENT:
		default: flags = O_RDWR;  break;
		case IO_READONLY: flags = O_RDONLY;  break;
		case IO_WRITEONLY: flags = O_WRONLY;  break;
		}
		if ((fd = open (fn, flags)) < 0) {
			efsError (errno);
			break;
		}
		fstat (fd, &statb);
		np->n_un.n_oreply.n_size = htonl (statb.st_size);
		np->n_un.n_oreply.n_flNum = htonl (dirIndex);
		np->n_un.n_oreply.n_fd = htonl (fd);
		efsReply (3 * sizeof (long));
		break;

	case Create:
		dprintf ("Create <%s> ", np->n_un.n_fname);
		strcpy (fn, np->n_un.n_fname);
		strcat (fn, ".DF");
		if ((fd = open (fn, O_CREAT | O_EXCL | O_TRUNC, 0666)) < 0) {
			efsError (errno);
			break;
		}
		close (fd);
		strcpy (fn, np->n_un.n_fname);
		strcat (fn, ".RF");
		if ((fd = open (fn, O_CREAT | O_EXCL | O_TRUNC, 0666)) < 0) {
			efsError (errno);
			break;
		}
		close (fd);
		strcpy (fn, np->n_un.n_fname);
		strcat (fn, ".IF");
		if ((fd = open (fn, O_CREAT | O_EXCL | O_TRUNC, 0666)) < 0) {
			efsError (errno);
			break;
		}
		close (fd);
		efsReply (0);
		break;

	case Delete:
		dprintf ("Delete <%s> ", np->n_un.n_fname);
		strcpy (fn, np->n_un.n_fname);
		strcat (fn, ".DF");
		if (unlink (fn) < 0) {
			efsError (errno);
			break;
		}
		strcpy (fn, np->n_un.n_fname);
		strcat (fn, ".RF");
		if (unlink (fn) < 0) {
			efsError (errno);
			break;
		}
		strcpy (fn, np->n_un.n_fname);
		strcat (fn, ".IF");
		if (unlink (fn) < 0) {
			efsError (errno);
			break;
		}
		efsReply (0);
		break;

	case Rename:
		dprintf ("Rename <%s> to <%s> ", np->n_un.n_fname,
			np->n_un.n_fname + strlen (np->n_un.n_fname) + 1);
		cp = np->n_un.n_fname;
		strcpy (fn, cp);
		strcat (fn, ".DF");
		strcpy (to, cp + strlen (cp) + 1);
		strcat (to, ".DF");
		if (rename (fn, to) < 0) {
			efsError (errno);
			break;
		}
		strcpy (fn, cp);
		strcat (fn, ".RF");
		strcpy (to, cp + strlen (cp) + 1);
		strcat (to, ".RF");
		if (rename (fn, to) < 0) {
			efsError (errno);
			break;
		}
		strcpy (fn, cp);
		strcat (fn, ".IF");
		strcpy (to, cp + strlen (cp) + 1);
		strcat (to, ".IF");
		if (rename (fn, to) < 0) {
			efsError (errno);
			break;
		}
		efsReply (0);
		break;


	case Close:
		dprintf ("Close ");
		fd = ntohs (np->n_un.n_flNum);
		efsReply (0);
		close (fd);
		break;

	case Read:
		dprintf ("Read ");
		fd = ntohs (np->n_un.n_read.n_flNum);
		posMode = ntohs (np->n_un.n_read.n_posMode);
		if (lseek (fd, ntohl (np->n_un.n_read.n_mark), L_SET) < 0) {
			efsError (errno);
			break;
		}
		if ((cnt = read (fd, np->n_un.n_rreply.n_buf,
		    ntohl (np->n_un.n_read.n_reqCount))) < 0) {
			efsError (errno);
			break;
		}
		if (posMode & IO_NLMODE) {
			c = (posMode >> 8) & 0xff;
			if (cp = (char*) index (np->n_un.n_rreply.n_buf, c))
				cnt = cp - np->n_un.n_rreply.n_buf + 1;
		}
		np->n_un.n_rreply.n_actCount = htonl (cnt);
		efsReply (sizeof (long) + cnt);
		break;

	case Write:
		dprintf ("Write ");
		fd = ntohs (np->n_un.n_write.n_flNum);
		if (lseek (fd, ntohl (np->n_un.n_write.n_mark), L_SET) < 0) {
			efsError (errno);
			break;
		}
		if ((cnt = write (fd, np->n_un.n_write.n_buf,
		    ntohl (np->n_un.n_write.n_reqCount))) < 0) {
			efsError (errno);
			break;
		}
		np->n_un.n_wreply.n_actCount = htonl (cnt);
		efsReply (sizeof (long));
		break;

	default:
		break;
	}
	dprintf ("\n");
	goto getrequest;
}

#define	EBADFLNUM	100
#define	x		extFSErr

char errorList[] = {
	x, wrPermErr, fnfErr, x, x, ioErr, x, x, x, x, x, x, x, wrPermErr, x,
	x, x, dupFnErr, x, x, x, x, x, x, x, x, x, x, x, x, x, x, x, x, x
};

efsError(err) {
	register char e;
	register struct netBuf *np = (struct netBuf *)as.req.data;
	if (err>0 && err < 35)
		e = errorList[err];
	else
		e = extFSErr;
	dprintf ("err %d mac %d", err, e);
	np->n_cmd = e;
	np->n_dlen = 0;
	atpsendres(&as, np, HDRSIZE, OPNORM|OPACK);
}

efsReply (dlen) {
	register struct netBuf *np = (struct netBuf *)as.req.data;
	dprintf ("reply %d ", dlen);
	np->n_cmd = 0;
	np->n_dlen = htons(dlen);
	atpsendres(&as, np, HDRSIZE + dlen, OPNORM|OPACK);
}

efsDir (op, value, fn)
char *fn;
{
	DIR *dirp;
	register struct direct *dp;
	register int di;
	register char *cp;

	dirp = opendir (".");
	for (dp = readdir (dirp), di=0;  dp;  dp = readdir (dirp)) {
		cp = dp->d_name + strlen (dp->d_name) - 3;
		if (strncmp (cp, ".IF", 3) == 0)
			di++;
		switch (op) {
		case FIND_NAME:
			if (strcmp (value, dp->d_name) == 0) {
				closedir (dirp);
				return (di);
			}
		case FIND_NUM:
			if (di == value) {
				strcpy (fn, dp->d_name);
				closedir (dirp);
				return (di);
			}
		}
	}
	closedir (dirp);
	if (op == COUNT)
		return (di);
	return (0);
}

dprintf (str, p1, p2, p3, p4, p5, p6, p7, p8)
char *str;
{
	if (debug) {
		fprintf (trace, str, p1, p2, p3, p4, p5, p6, p7, p8);
		fflush (trace);
	}
}

/*
 * Returns true if good username and password.
 */
gooduser()
{
	register char *cp;
	char *getfield();
	struct passwd *p;

	strncpy(upf, as.req.data, sizeof upf - 1);
	linep = upf;
	user = getfield();
	pass = getfield();
	if ((p = (struct passwd *)getpwnam(user)) == NULL) {
		cp = "no such user name";
		goto bad;
	}
	uid = p->pw_uid;
	gid = p->pw_gid;
	home = p->pw_dir;
	cp = (char *)crypt(pass, p->pw_passwd);
	if (strcmp(cp, p->pw_passwd) != 0) {
		cp = "bad password";
		goto bad;
	}
	return (1);
bad:
	nak(cp);
	return (0);
}


reapchild()
{
	union wait status;
	int pid;
	register struct kids *kp;

	while ((pid = wait3(&status, WNOHANG, 0)) > 0)
		for (kp = &kids[0] ; kp < &kids[NKIDS] ; kp++)
			if (kp->pid == pid)
				kp->pid = 0;
}


/*
 * Alarm timer expired, exit process.
 */
timer()
{
	log("Timed out");
	exit(1);
}


/*
 * Log an error message.
 */
log(fmt, args)
char *fmt;
{
	FILE *f_log;

	if ((f_log = fopen(LOGFILE, "a+")) == NULL) {
		perror("log_mess: Problems accessing the logfile.");
	}
	fprintf(f_log, "%d: ", pid);
	_doprnt(fmt, &args, f_log);
	putc('\n', f_log);
	fclose(f_log);
}


/*
 * Get next field from string at *linep.
 */
char *
getfield()
{
	register char *start = linep;

	for ( ; *linep ; linep++)
		if (*linep == SEPCHAR)
			break;
	if (*linep)
		*linep++ = 0;
	return (start);
}


/*
 * Negative acknowledge (OPERROR) with error string 's'.
 */
nak(s)
	char *s;
{
	atpsendres(&as, s, strlen(s)+1, OPERROR);
	log("Error %s", s);
}


/*
 * If the Mac user has rebooted, kill the old child daemon if it exists.
 */
killoldkid(pid, net, node)
{
	register struct kids *kp, *kpfree;
	kpfree = 0;

	for (kp = &kids[0] ; kp < &kids[NKIDS] ; kp++) {
		if (kp->pid == 0) {
			if (kpfree == 0)
				kpfree = kp;
			continue;
		}
		if (kp->net != net || kp->node != node)
			continue;
		log("killed old child %d", kp->pid);
		kill(kp->pid, SIGHUP);
		kp->pid = pid;
		return;
	}
	kp = kpfree;
	kp->pid = pid;
	kp->net = net;
	kp->node = node;
}
