/*	atalk.h		1.3	02/19/85	*/

/*
 * AppleTalk definitions.
 *
 * Copyright (C) 1984, Apple Computer Inc.
 *  Gene Tyacke, Alan Oppenheimer, G. Sidhu, Rich Andrews.
 *
 * C language version (C) 1984, Stanford Univ. SUMEX project.
 * May be used but not sold without permission.
 */

/*
 * history
 * 08/24/84	GRT	Created.
 * 10/23/84	GRT	
 * 12/01/84	Croft	Created C version;  added packet headers, *Params.
 * 03/16/85	Croft	etc.
 */


/* error codes */

#define	ddpSktErr	-91	/* error in socket number */
#define	ddpLenErr	-92	/* data length too big */
#define	noBridgeErr	-93	/* no net bridge for non-local send */
#define	lapProtErr	-94	/* error in attach/detach */
#define	excessCollsns	-95	/* excessive collisions on write */
#define	portInUse	-97	/* driver Open error */
#define	portNotCf	-98	/* driver Open error */
/* ATP error codes */
#define	reqFailed	-1096	/* SendRequest failed: retrys exceeded */
#define	badATPSkt	-1099	/* bad ATP responding socket */
#define	noRelErr	-1101	/* no release received */
#define	noDataArea	-1104	/* no data area for MPP request */
#define	reqAborted	-1105	/* SendRequest aborted by RelTCB */
/* NBP error codes */
#define	nbpBuffOvr	-1024	/* buffer overflow in LookupName */
#define	nbpNoConfirm	-1025	/* name not confirmed on ConfirmName */
#define	nbpConfDiff	-1026	/* name confirmed at different socket */
#define	nbpDuplicate	-1027	/* duplicate name already exists */
#define	nbpNotFound	-1028	/* name not found on remove */
#define	nbpNISErr	-1029	/* error trying to open the NIS */


/* misc structures */

typedef struct {		/* WDS, write data structure */
	u_short	size;
	u_char	*ptr;
} WDS;

typedef struct {		/* BDS, buffer data structure */
	short	buffSize;
	char	*buffPtr;
	short	dataSize;
	long	userData;
} BDS;

#define	userBytes userData

typedef struct {		/* AddrBlock */
	u_short	net;
	u_char	node;
	u_char	skt;
} AddrBlock;


/*
 * For each protocol, its header structure, definitions, 
 * and control / status parameter block.
 */

struct LAP {			/* LAP */
	u_char	dst;
	u_char	src;
	u_char	type;
};

typedef struct LAP LAPAdrBlock;	/* LAPAdrBlock */
#define	dstNodeID	dst
#define	srcNodeID	src
#define	lapProtType	type

/* LAP definitions */
#define	lapShortDDP	1	/* short DDP type */
#define	lapDDP		2	/* DDP type */
#define	lapSize		3	/* size of lap header */

#ifdef MAC
struct LAPParam {		/* LAP CSParam control / status calls */
	u_short	unused;
	WDS	*wds;
};
/* LAP CSCodes */
#define	lapWrite	242
#define	lapDetach	243
#define	lapAttach	245
#endif MAC


struct DDP {			/* DDP */
	u_short	length;
	u_short	checksum;
	u_short	dstNet;
	u_short	srcNet;
	u_char	dstNode;
	u_char	srcNode;
	u_char	dstSkt;
	u_char	srcSkt;
	u_char	type;
};

struct ShortDDP {		/* ShortDDP */
	u_short	length;
	u_char	dstSkt;
	u_char	srcSkt;
	u_char	type;
};

/* DDP definitions */
#define	ddpMaxWKS	0x7F
#define	ddpMaxData	586
#define	ddpLengthMask	0x3FF
#define	ddpHopShift	10
#define	ddpSize		13	/* size of DDP header */
#define	ddpSSize	5
#define	ddpWKS		128	/* boundary of DDP well known sockets */
#define	ddpRTMP		1	/* RTMP type */
#define	ddpNBP		2	/* NBP type */
#define	ddpATP		3	/* ATP type */
#define	ddpIP		22	/* IP type */
#define	ddpARP		23	/* ARP type */

#define	ddpWKSUnix	768	/* start of WKS range on UNIX */
#define	ddpNWKSUnix	16384	/* start of non-WKS .. */
#define	ddpIPSkt	72	/* socket used by Dartmouth encapsulation */

#define	ddp2ipskt(dskt) ((dskt & ddpWKS) ? dskt + ddpNWKSUnix \
	: dskt + ddpWKSUnix)

#ifdef	MAC
struct DDPParam {		/* DDP CSParam control / status calls */
	u_char	skt;
	u_char	checksum;
	Ptr	ptr;		/* socket listener or WDS */
};

/* DDP CSCodes */
#define	ddpWrite	246
#define	ddpCloseSkt	247
#define	ddpOpenSkt	248
#endif	MAC


struct RTMP {			/* RTMP */
	u_short	net;
	u_char	idLen;
	u_char	id;		/* start of ID field */
};

struct RTMPtuple {
	u_short	net;
	u_char	hops;
};
#define	rtmpSkt	1		/* number of RTMP socket */
#define	rtmpSize	4	/* minimum size */
#define	rtmpTupleSize	3


struct NBP {			/* NBP */
	u_char	control;
	u_char	id;		/*
	[if request:]
	AddrBlock requester;
	Tuple	entity;
	[if reply:]
	Tuple	entities[];	*/
};
/*
 * A Tuple is a block containing 3 Pascal strings (object, type, zone),
 * followed by the AddrBlock of that entity (is it even byte aligned?)
 */
#define	nbpBrRq		0x10
#define	nbpLkUp		0x20
#define	nbpLkUpReply	0x30
#define	nbpNIS		2
#define	nbpTupleMax	15
#define	nbpEquals	'='
#define	nbpStar		'*'
	

struct ATP {			/* ATP */
	u_char	control;
	u_char	bitmap;
	u_short	transID;
	long	userData;
};
#define	atpSize		8	/* sizeof struct ATP */
#define	atpReqCode	0x40
#define	atpRspCode	0x80
#define	atpRelCode	0xC0
#define	atpXO		0x20
#define	atpEOM		0x10
#define	atpSTS		0x08
#define	atpSendChk	0x01
#define	atpTIDValid	0x02
#define	atpFlagMask	0x3F
#define	atpControlMask	0xF8
#define	atpMaxNum	8
#define	atpMaxData	578
#define	atpNData	512+16	/* normal amount of data */

#ifdef	MAC
struct ATPParam {		/* CSParam for ATP request */
	u_char	atpSocket;
	u_char	atpFlags;
	AddrBlock atpAddrBlock;
	u_short	atpReqLength;
	Ptr	atpReq;
	BDS	*atpBDS;
	u_char	atpBitMap;
	u_char	atpTimeOut;
	u_short	atpTID;
};
#define	atpNumBufs	atpBitMap
#define	atpBDSSize	atpTimeOut
#define	atpRetries	atpTID
#define	atpNumRsp	(atpTID>>8)
#define	atpUserData	ioNamePtr
#define	atpReqTID	ioVRefNum
#define	atpCurrBitMap	atpSocket
/* ATP CSCodes */
#define	atpRelRspCB	249
#define	atpCloseSkt	250
#define	atpAddResponse	251
#define	atpSendResponse	252
#define	atpGetRequest	253
#define	atpOpenSkt	254
#define	atpSendRequest	255
#define	atpRelTCB	256
#endif	MAC


typedef struct {		/* Str32 */
	u_char	s[32];
} Str32;

typedef struct {		/* EntityName */
	Str32	objStr;
	Str32	typeStr;
	Str32	zoneStr;
} EntityName;

typedef struct {		/* RetransType */
	u_char	retransInterval;
	u_char	retransCount;
} RetransType;

typedef struct {		/* BDSType */
	BDS	a[8];
} BDSType;

#ifdef never
/* 
 * ABusRecord;  might not be of use, since C access may be thru
 * same calls that assembler access uses (read/write/control/status).
 */
typedef struct {		/* ABusRecord */
	u_short	abOpCode;
	u_short	abResult;
	long	abUserReference;
	union {
		struct {
			LAPAdrBlock lapAddress;	/* XXX check alignment */
			u_short	lapReqCount;
			u_short	lapActCount;
			Ptr	lapDataPtr;
		} lap;
		struct {
			u_char	ddpType;
			u_char	ddpSocket;
			AddrBlock ddpAddress;
			u_short	ddpReqCount;
			u_short	ddpActCount;
			Ptr	ddpDataPtr;
			u_char	ddpNodeID;
		} ddp;
		struct {
			EntityName *nbpEntityPtr;
			Ptr	nbpBufPtr;
			u_short	nbpBufSize;
			u_short	nbpDataField;
			AddrBlock nbpAddress;
			RetransType nbpRetransmitInfo;
		} nbp;
		struct {
			u_char	atpSocket;
			u_char	atpxx;	/* XXX check alignment */
			AddrBlock atpAddress;
			u_short	atpReqCount;
			Ptr	atpDataPtr;
			BDSType *atpRspBDSPtr;
			u_char	atpBitMap;
			u_char	atpyy;
			u_short	atpTransID;
			u_short	atpActCount;
			long	atpUserData;
			u_char	atpXO;	/* XXX check */
			u_char	atpEOM;
			u_char	atpTimeOut;
			u_char	atpRetries;
			u_char	atpNumBufs;
			u_char	atpNumRsp;
			u_char	atpBDSSize;
		} atp;
	} ab;
} ABusRecord;

/* abOpCode */
#define	tLAPRead	0
#define	tLAPWrite	1
#define	tDDPRead	2
#define	tDDPWrite	3
#define	tNBPLookup	4
#define	tNBPConfirm	5
#define	tNBPRegister	6
#define	tATPSndRequest	7
#define	tATPGetRequest	8
#define	tATPSdRsp	9
#define	tATPAddRsp	10

#define lapSize		20
#define ddpSize		26
#define nbpSize		26
#define atpSize		46

#endif never
