/* writero.c */
/*
 * HCR Confidential
 *
 * These computer programs are the confidential, proprietary property
 * of HCR (Human Computing Resources Corporation, 10 St. Mary Street,
 * Toronto, Ontario, Canada), and may not be disclosed except with the
 * prior written agreement of HCR.
 *
 * Copyright (c) 1984, 1985, 1986 Human Computing Resources Corporation
 * All Rights Reserved
 */
/*	This module writes the program back out on the intermediate file.
 */

#ifndef lint
static char *rcsid = "@(#) (Gould) $Header: writero.c,v 5.5 89/05/12 12:53:38 pcc Rel-3_0 $";
/* static char ID[] = "@(#)writero.c	15.1	of 86/11/29"; */
#endif

/*
 *	Imported Objects
 */

# include <stdio.h>
# include <assert.h>
# include <cmanifest.h>
# include <instruct.h>
# include <flow.h>
# include <temp.h>
# include <tree.h>
# include <opt.h>
# include <pcc.h>
# include <erroro.h>
# include <writero.h>

/*
 *	Exported Objects
 */

int 	wdebug = 0;		/* Instructions Written */


/*	Private Objects
 */

/*
 *	Forward
 */

static void WriteInstruction();
static void WriteTree();

void
WriteList(list)			/* Simply writes a list of instructions */
	InstrList list;
{
	Instruction p;

	for (p = list.first; p != NULL; p = p->next) {
		WriteInstruction(p);
	}
}

/*
 * Write out the blocks of the program IN THE ORDER IN WHICH THEY WERE READ
 */
void
WriteFlow()
{
	BasicBlock b;

	for (b = FirstBlock; b != NULL; b = b->next)
		if( b->reachable )
			WriteList(b->code);
}

static void
WriteInstruction(p)
	Instruction p;
{

	register int i;

	if( p->tag == Expr )
		p->u.ex.root = FinalOpt(p->u.ex.root);

	if (wdebug) PrintInstruction(p);

	switch (p->tag) {
	case Passed:
		printf("%s\n", p->u.tx.line);
		break;

	case Block_Start:
			/* make sure that allocation data get written out */
		PUpdtBBeg(p);
		putchar(BBEG);
		printf("%d\t%u\t",
			p->u.bs.ftnno, p->u.bs.autooff);
		/*
		 *	Write out machine dependent args
		 */

		PccWriteInst(p);
		printf("\n");
		break;

	case Block_End:
			/* make sure updated allocation data written */
		PUpdtBEnd(p);
		putchar(BEND);

		/*
		 *	Write out machine dependent args
		 */

		PccWriteInst(p);

		printf("\n");
		break;

	case Label:
		putchar(ILABEL);
		printf("%d\t\n", p->u.lb.lab_num);
		break;

	case UBranch:
		putchar(IBRANCH);
		printf("%d\t\n", p->u.ub.target);
		break;

	case Return:
		putchar(IRETURN);
		printf("%d\t%d\t\n", p->u.rt.r_lab, p->u.rt.r_count);
		break;
	
	case Expr:
		putchar(EXPR);
		printf("%d\t%s\n", p->u.ex.lineno, p->u.ex.filename);
		WriteTree(p->u.ex.root);
		break;

	case FcnStart:
		printf("%c", FBEGIN);
		PccWriteInst(p);
		break;

	case FcnEnd:
		putchar(FEND);
		putchar('\n');
		break;

	case Switch:
		printf("%c%d\t%d\t%d\t\n", ESWITCH, p->u.sw.ncases,
				p->u.sw.swregister, p->u.sw.defaultlabel);
		for( i = 0; i < p->u.sw.ncases; i++ )
		{
			printf("%d\t%d\t\n", p->u.sw.swtable[i].sval,
				p->u.sw.swtable[i].slab );
		}
		break;

	case ParamFetch:
		printf("%c%d\t%d\t%d\t\n", PFETCH, p->u.pf.reg,
				p->u.pf.offset, p->u.pf.type);
		break;

	case ParamHere:
		printf("%c", PFHERE);
		PccWriteInst(p);
		printf("\n");
		if (ParamLoads.first != NULL) {	/* Load params to regs */
			WriteList(ParamLoads);
		}
		break;

	case ParamSave:
		printf("%c%d\t\n", PSAVE, p->u.ps.npassed);
		break;

	default:
		InternalFault("WriteInstruction called with tag=%d", (int)(p->tag));
	}
}

static void
WriteTree(p)
	register NODE *p;
{
	register ty;
	register i;


	ty = optype(p->in.op);

		/* hide STLABELs, OCONVTREEs, LTEMPs, TNAMEs and TREGs
		 * from pass2.
		 * Also check for unallocated LNAMEs and LADDRs.
		 */
	i = p->in.op;
	switch(i)
	{
	case STLABEL:
		i = ICON;
		break;
	case LTEMP:
	case TNAME:
		assert(p->tn.lval != NOOFFSET);
		i = LNAME;
		break;

	case LNAME:
	case LADDR:
		assert(p->tn.lval != NOOFFSET);
		break;

	case TREG:
		i = REG;
		break;
	}

	printf( "%d\t%o\t", i, p->in.type );

	if( i == FCON ) {
		fltprint(p);	/* print floating numbers in
				 * mach. dep. part
				 */
	} else {
		if( ty == LTYPE ) {
			printf( CONFMT, p->tn.lval );
			fputs( "\t", stdout );
		}
		if( ty != BITYPE )
			printf( "%d\t", p->tn.rval );
	}


	/* handle special cases */

	switch( p->in.op ){

	default:
		if (p->tn.identifier != NULL) {
			fputs( p->tn.identifier, stdout);
		}
		putchar('\n');
		break;

	case STARG:
	case STASG:
	case STCALL:
	case UNARY STCALL:
		/* print out size */
		printf("%d\t%d\t\n", p->stn.stsize, p->stn.stalign);
		break;

	}

	if( ty != LTYPE ) WriteTree( p->in.left );
	if( ty == BITYPE ) WriteTree( p->in.right );

}
