/* target.h */
/*
 * HCR Confidential
 *
 * These computer programs are the confidential, proprietary property
 * of HCR (Human Computing Resources Corporation, 10 St. Mary Street,
 * Toronto, Ontario, Canada), and may not be disclosed except with the
 * prior written agreement of HCR.
 *
 * Copyright (c) 1984, 1985, 1986 Human Computing Resources Corporation
 * All Rights Reserved
 */

/*
 *	The tables and functions in this file provide information about
 *	the target machine.
 */

#ifndef TARGET_HDR
#define TARGET_HDR

#include <bool.h>
#include <config.h>
#include <tree.h>

#ifndef lint
/*	@(#) (Gould) $Header: target.h,v 5.5 89/05/12 12:53:01 pcc Rel-3_0 $		  */
/* static char TARGETH_SCCSID[] = "@(#)target.h	14.3	of 86/11/13"; */
#endif

/*
 * We do not do any local processing of input trees
 */

#define	LclPreTree(p)	PreTree(p)

/*
 *	Currently, we don't attempt to capture addresses of globals.
 *	eventually, we will look for objects in far data, and
 *	do the transform on them.
 */

#define GlobalAddrTransform(id)	False

/*
 *	Interface to the Cost Functions
 */

#define COST_INFINITY	0x1fffffff	/* Must be less than half CostMax */
#define COST_NAME	18
#define COST_LNAME	18
#define COST_ADDR	18
#define COST_LADDR	28
#define COST_ICON	9
#define COST_REG	5		/* (MEY) 16-Feb-87 was 9 */
#define COST_UNKNOWN	-0x20000000	/* Minus infinity! */
#define CostSaveReg	-15		/* assumed overall cost of new reg */

extern CostType OpCost();	/* Cost of evaluating an op */
extern CostType MachCost();	/* Machine Dependent cost function */

extern int LoopWeight();	/* Compute loop weight from nesting depth */

/*
 *	Routine to look at a DAG node and determine if it is addressable.
 *	In particular, will it be turned into an OREG by pass 2?
 */

extern Boolean IsAddressable();

/*
 *	RefSpecial() looks at a DAG node and determines if its
 *	reference count (or those of its descendants) must be
 *	adjusted in a machine dependent way.  If so, it is
 *	responsible for making the adjustment and recursing.
 */

extern Boolean	RefSpecial();

/*
 *	Interface to routine to determine which ops may be safely lifted
 *	from loops.
 */

extern Boolean NoErrors();

extern TreeNode SpecialTree();

extern Boolean IsSmallIcon();	/* is a node a small icon ? */

/*
 *	Resource Allocation
 */

#define NumResources	2		/* registers and stack */
#define RegResource	0		/* Used by macros below */
#define StackResource	1

typedef int	ResrcIndex;

typedef Boolean (*brfp)();		/* Boolean Resource Function ptr */
typedef void	(*vrfp)();		/* void Resource Function ptr */

typedef struct {
		Operator op;		/* Prototypical op for OpCost() */
		brfp can_allocate;	/* can id go in r ? */
		brfp alloc_resource;	/* attempt to allocated id to r */
		CostType initial_benefit;	/* default benefit for r */
		vrfp load_param;	/* load a parameter to r */
	} AllocXfer;

extern AllocXfer ResVector[];	/* initialized in target.c */

/*
 *	Interface routines.  The definitions are machine dependent.
 */


#define CanAllocate(id, r)	(*(ResVector[r].can_allocate))(id)
#define AllocResource(id, r)	(*(ResVector[r].alloc_resource))(id)

#define ResRefCost(r, type)	OpCost(ResVector[r].op, (type))
extern CostType ResStoreCost();

#define InitialBenefit(r)	ResVector[r].initial_benefit
#define CostParamLoad(id, r)	((r) == RegResource ? \
					ResRefCost(StackResource,SymType(id)) \
					: 0)

#define LoadParam(r, params, t, old_lval) \
				(*(ResVector[r].load_param))(params, t, old_lval)

extern void DemoteReg();	/* Called to undo the parameter load (if any)
				 * for a demoted register parameter */
#endif
