/* readero.c */
/*
 * HCR Confidential
 *
 * These computer programs are the confidential, proprietary property
 * of HCR (Human Computing Resources Corporation, 10 St. Mary Street,
 * Toronto, Ontario, Canada), and may not be disclosed except with the
 * prior written agreement of HCR.
 *
 * Copyright (c) 1984, 1985, 1986 Human Computing Resources Corporation
 * All Rights Reserved
 */

/*
 *	Read the intermediate code file from pass 1.
 */

#ifndef lint
static char *rcsid = "@(#) (Gould) $Header: readero.c,v 5.5 89/05/12 12:52:31 pcc Rel-3_0 $";
/* static char ID[] = "@(#)readero.c	15.3	of 86/10/25"; */
#endif

/*	Imported Objects
 */

# include <stdio.h>
# include <assert.h>
# include <instruct.h>
# include <tree.h>
# include <temp.h>
# include <dagsymbol.h>
# include <bool.h>
# include <option.h>
# include <opt.h>
# include <storage.h>
# include <ops.h>
# include <erroro.h>
# include <pcc.h>
# include <target.h>
# include <readero.h>

/*	Exported Objects
 */

#ifdef	INLINER
int MaxP1ILabel = 0;	/* Largest label from pass 1 or inliner so far.
			 * Note: not initialized on each pass so, after
			 * first pass, it is the max over whole file.
			 */

int LastParam;	/* largest cookie used for parameters */
#endif	/* INLINER */

/*	Forward Declarations
 */

static TreeNode eread();
static void ReadStabInfo();
static void ReadIdentifier();
static void LookForEOL();
static void PassLine();

/*
 *	Private
 */

#define STBUFSZ	BUFSIZ

/*	some storage declarations */

int tdebug = 0;		/* tree building debug */

int xdebug = 0;

/*ARGSUSED*/

void
ReadICode(header, params, function, trailer, consumer)
	InstrList *header;
	InstrList *params;
	InstrList *function;
	InstrList *trailer;	/* used by f77 freadero */
	void (*consumer)(/*Instruction*/);
{
	register c;
	register char *cp;
	register TreeNode p;
	char stemp[STBUFSZ];
	Instruction ci;			/* Current Instruction */
	Instruction Start;		/* Start of code to analyze */
	int i;
	InstrList *CurList;
	Boolean FBSeen;


#ifdef	INLINER
	LastParam = NoId;
#endif	/* INLINER */
	NextLocalId = 0;	/* Initialized to max cookie seen + 1 */
	FBSeen = False;
	CurList = header;
	while( (c=getchar()) > 0 ) {

	switch( c ){

	case '\n': continue;	/* ignore blank line */

	default:	/* Just preserve the line */

		PassLine(CurList, c);
		break;

	case ITEXT:
	case IDATA:
		/* An initialization or a return to text.  Choose the
		 * appropriate instruction list, and preserve the line.
		 */

		CurList = ( FBSeen && c == ITEXT ) ? function : header;
		PassLine(CurList, c);		
		break;


	case IASM:		/* ASM Statement ! */

		AsmStmt = True;
		PassLine(CurList, c);
		break;
	
	case BBEG:
		/* beginning of a block */
		assert(FBSeen);		/* make sure order is correct */
		CurList = function;	/* in case hanging .data */
		ci = AddInstruction(Block_Start, CurList);
		ci->u.bs.ftnno = rdin(10);
		ci->u.bs.autooff = (unsigned int) rdin(10); /* autooff for block gives max offset of autos in block */

		PAlloBBeg(ci);
		if( getchar() != '\n' ) ExternalFault( "intermediate file format error");
		break;

	case BEND:  /* end of block */
		ci = AddInstruction(Block_End, CurList);
		PAlloBEnd(ci);		
		LookForEOL();
		break;

	case FBEGIN:		/* Start of Function */

		/* First, change things so we append to the program
		 * Then, start the program again.
		 */

		FBSeen = True;
		CurList = function;
		Start = ci = AddInstruction(FcnStart, CurList);
		PAlloInit(ci);	/* reads m.d. arguments */

		/* Collect function name */

		cp = ftnname;
		while( (c = getchar()) != '\n')
		{
			if( c <= 0 )
				ExternalFault("intermediate file format eof");
			*cp++ = c;
		}
		*cp++ = '\0';
		assert( (cp-ftnname) <= BUFSIZ );
		ci->u.fb.fname = StoreText(ftnname);

		break;

	case FEND:		/* End of Function */
		LookForEOL();

		ci = AddInstruction(FcnEnd, CurList);

		/* Optimize  It */

		(*consumer)(Start);
		Start = NULL;

#ifdef	INLINER
		LastParam = NoId;
#endif	/* INLINER */
		NextLocalId = 0;	/* to be re-set in next function */
		CurList = header;
		FBSeen = False;

		break;
		
	case ILABEL:
		ci = AddInstruction(Label, CurList);
		ci->u.lb.lab_num = i = rdin(10);
#ifdef	INLINER
		if (i>MaxP1ILabel)
			MaxP1ILabel = i;
#endif	/* INLINER */
		LookForEOL();
		break;

	case IBRANCH:
		ci = AddInstruction(UBranch, CurList);
		ci->u.ub.target = rdin(10);
		LookForEOL();
		break;

	case STABINFO:
		ReadStabInfo();
		break;

	case IRETURN:
		ci = AddInstruction(Return, CurList);
		ci->u.rt.r_lab = rdin(10);	/* label to branch to */
		ci->u.rt.r_count = rdin(10);	/* registers saved */
		LookForEOL();
		break;

	case ESWITCH:
		ci = AddInstruction(Switch, CurList);
		ci->u.sw.ncases = rdin(10);
		ci->u.sw.swregister = rdin(10);
		ci->u.sw.defaultlabel = rdin(10);
		ci->u.sw.swtable = (struct sw *)
					calloc( (unsigned) ci->u.sw.ncases,
						sizeof(struct sw));
		CheckStorage(ci->u.sw.swtable, "storage for cases (%d)", ci->u.sw.ncases);
		LookForEOL();
		for( i = 0; i < ci->u.sw.ncases; i++ )
		{
			ci->u.sw.swtable[i].sval = rdin(10);
			ci->u.sw.swtable[i].slab = rdin(10);
			LookForEOL();
		}
		break;

	case PFETCH:	/* These are coming in in order */
		ci = AddInstruction(ParamFetch, params);
		ci->u.pf.reg = rdin(10);
		ci->u.pf.offset = rdin(10);
		ci->u.pf.type = rdin(10);
		LookForEOL();
		break;

	case PFHERE:	/* Put parameter fetches here */
		ci = AddInstruction(ParamHere, CurList);
		PccReadInst(ci);
		LookForEOL();
		break;

	case PSAVE:
		ci = AddInstruction(ParamSave, CurList);
		ci->u.ps.npassed = rdin(10);
		LookForEOL();
#ifdef	INLINER
		assert(LastParam == NoId);
		LastParam = MaxIdentifier;
#endif	/* INLINER */
		break;

	case EXPR:
		/* compile code for an expression */
		ci = AddInstruction(Expr, CurList);
		ci->u.ex.lineno = rdin( 10 );
		for( cp=stemp; (*cp=getchar()) != '\n'; ++cp ) ; /* VOID, reads filename */
		*cp = '\0';
		ci->u.ex.filename = EnterFilename(stemp);
		p = eread();

		if( tdebug ) fwalk( p, eprint, 0 );

		ci->u.ex.root = p;

		break;

		} /* switch */

		} /* while */

	/* EOF */
}

static TreeNode
eread(){

	/* call eread recursively to get subtrees, if any */

	register TreeNode p;
	register int i;

	i = rdin( 10 );

	p = TreeAllocate();

	p->in.op = (Operator) i;
	p->in.type = rdin(8 );

	i = optype(i);

	if(p->in.op == FCON ) {
			fltread(p);	/* read fp numbers in machdep part */
	} else {
		if( i == LTYPE ) p->tn.lval = rdin( 10 );
		if( i != BITYPE ) p->tn.rval = rdin( 10 );
	}


	if( p->in.op == STASG || p->in.op == STARG || p->in.op == STCALL || p->in.op == UNARY STCALL ){
		p->stn.stsize = rdin( 10 );
		p->stn.stalign = rdin(10);
		if( getchar() != '\n' ) ExternalFault( "newline expected" );
		}
	else {   /* usual case */
		ReadIdentifier(p);
	}

	/* now, recursively read descendents, if any */

	if( i != LTYPE ) p->in.left = eread();
	if( i == BITYPE ) p->in.right = eread();

	return( LclPreTree(p) );

}

/*
 *	Read the identifier text for a node, and set the identifier
 *	field.  May enter symbols in the symbol table for NAMEs and
 *	ADDRs that were created by the compiler.  If debug is set,
 *	checks that the returned name is textually the same as
 *	the one just read in.
 */

static void
ReadIdentifier(t)
	TreeNode t;
{
	char * pc;
	char name[STBUFSZ];
	char c;
	Identifier id;

	/*
	 *	Read the identifier text for the node
	 */

	pc = name;
	while ((c = getchar()) != '\n') {
		*pc++ = c;
	}
	*pc = '\0';

	if (name[0] != '\0') {		/* an actual name */

		/*
		 *	Now look up the appropriate identifier in the
		 *	symbol table.
		 */

		switch(t->in.op) {

			case PNAME:
			case LNAME:
			case STATNAME:
				assert(t->tn.lval != NOOFFSET);
				id = IdLookUp(t->in.op, (CONSZ) t->tn.rval, ANYTYPE);
				break;

			case STADDR:
			case LADDR:
			case PADDR:
				id = IdLookUp(ToNAME(t->in.op), (CONSZ) t->tn.rval, ANYTYPE);
				break;

			case ADDR:
#ifndef MPX
			case CADDR:
#endif
				id = IdLookUp(NAME, (CONSZ) t->tn.rval, ANYTYPE);
				break;

			case NAME:
				assert(t->tn.rval != 0);
				id = IdLookUp(t->in.op, (CONSZ) t->tn.rval, ANYTYPE);
				break;

			default:
				InternalFault("Can't ReadIdentifier for %s\n",
					opst[(int) t->in.op]);
		}

		/*
		 *	id is now the appropriate identifier
		 */

		assert(id != NoId);
		t->tn.identifier = IdText(id);
		assert(t->tn.identifier != NULL);
#ifdef IdDebug
		assert(strcmp(t->tn.identifier, name) == 0);
#endif
	} else
		t->tn.identifier = NULL;
}

/*
 * Read one line of symbol table information
 */

static void
ReadStabInfo()
{
	char sbuf[STBUFSZ];
	int id_cookie;		/* identifier id from pass 1 */
	Identifier id;		/* identifier as we know it */
	Operator namespace;	/* essentially, identifier class - NAME,
				 * LNAME, PNAME, etc. */
	TWORD type;		/* identifier type */
	register char *cp;
	int c;

	id_cookie = rdin(10);
	type = rdin(10);
	namespace = (Operator) rdin(10);

	cp = sbuf;
	while( (c=getchar()) != '\n')
	{
		if (c <= 0) ExternalFault("intermedate file format eof");
		*cp++ = c;
	}
	*cp++ = '\0';

#ifdef	INLINER
	if (namespace == NAME) {
		if (id_cookie<0 && -id_cookie>MaxP1ILabel)
			MaxP1ILabel = -id_cookie;
	}
#endif	/* INLINER */

	/*
	 *	Record the largest cookie seen for LNAMEs.  This is
	 *	used to create new LNAMEs. (temp.[ch])
	 */

	if (namespace == LNAME && (id_cookie >= NextLocalId))
			NextLocalId = id_cookie + 1;

	PccFixIdentifier( sbuf, namespace, id_cookie);

	id = Pass1Symbol(namespace, (CONSZ) id_cookie, type, sbuf);

	/* We must ensure that STATNAMEs - local statics - cannot go in
	 * registers.  We also must ensure that they are treated with
	 * suspicion over (possible recursive) procedure calls.  For now,
	 * do this last by pretending that the identifier has had its
	 * address taken.
	 */

	if( namespace == STATNAME )
	{
		SetNotPromotable(id, True);
		SetAddressed(id);
	}
}

CONSZ
rdin( base )
	int base;
{
	register sign, c;
	CONSZ val;

	sign = 1;
	val = 0;

	while( (c=getchar()) > 0 ) {
		if( c == '-' ){
			if( val != 0 ) ExternalFault( "illegal -");
			sign = -sign;
			continue;
			}
		if( c == '\t' || c == ' ') break;
		if( c>='0' && c<='9' ) {
			val *= base;
			if( sign > 0 )
				val += c-'0';
			else
				val -= c-'0';
			continue;
			}
		if(( c>='a' && c<='f') && base == 16 ) {
			val *= base;
			if( sign > 0 )
				val += c-'a'+10;
			else
				val -= c-'a'+10;
			continue;
			}
		ExternalFault( "illegal character `%c' on intermediate file", c );
		break;
		}

	if( c <= 0 ) {
		ExternalFault( "unexpected EOF");
		}
	return( val );
	}


static void
PassLine(l, c)		/* Add line as "passed" to l; c is first char */
	InstrList *l;
	char c;
{
	char stemp[STBUFSZ];
	Instruction ci;
	register char *cp;
	
	ci = AddInstruction(Passed, l);

	/* copy line */

	cp = stemp;
	*cp++ = c;		/* Preserve first char */
	while ((*cp = getchar()) != '\n') ++cp;
	*cp = '\0';
	assert( (cp-stemp) <= STBUFSZ );

	ci->u.tx.line = StoreText(stemp);
}

static void
LookForEOL()
{
	register int c;

	while( (c=getchar()) != '\n') {
		if (c <= 0) ExternalFault("intermedate file format eof");
	}
}
