/* pcc.c */
/*
 * HCR Confidential
 *
 * These computer programs are the confidential, proprietary property
 * of HCR (Human Computing Resources Corporation, 10 St. Mary Street,
 * Toronto, Ontario, Canada), and may not be disclosed except with the
 * prior written agreement of HCR.
 *
 * Copyright (c) 1984, 1985, 1986 Human Computing Resources Corporation
 * All Rights Reserved
 */
/*
 *	This modules and tables in this file provide information on the
 *	implementation of pcc on the target machine
 */

#ifndef lint
static char *rcsid = "@(#) (Gould) $Header: pcc.c,v 5.5 89/05/12 12:52:19 pcc Rel-3_0 $";
/* static char ID[] = "@(#)pcc.c	14.7	of 86/12/11"; */
#endif

# include <pcc.h>
# include <assert.h>
# include <tree.h>
# include <opt.h>
# include <instruct.h>
# include <bool.h>
# include <readero.h>
# include <erroro.h>
# include <option.h>

# ifdef FORT
# include <bincode.h>
# endif

/*
 *	Following should be corrected when debug stuff re-done
 */

extern int AllocDebug;		/* from allocate.c */
extern int GoodGlobals;		/* from dag.c */

static Boolean DoSCONV(), DoPCONV();

/*
 *	Functions whose semantics are such that we abandon
 *	optimization of any function in which they are called.
 */

char *BadFcnNames[] = {
		"_setjmp",
		NULL				/* end of list */
};

static union {
		double d;
	long l[2];
} cheat;

#ifdef FORT

void
fltread(p)
	register NODE *p;
{
	cheat.l[0] = lread();
	cheat.l[1] = lread();
	p->fpn.dval = cheat.d;
}

void
fltprint(p)
	register NODE *p;
{
	cheat.d = p->fpn.dval;
	p2word(cheat.l[0]);
	p2word(cheat.l[1]);
}

#else

void
fltread(p)
	register NODE *p;
{
	/* read floating point constants in from intermedate file in
	 * a machine dependent way.
	 */
#ifdef MPX
	cheat.l[0] = rdin(16);
	cheat.l[1] = rdin(16);
#else
	cheat.l[0] = rdin(10);
	cheat.l[1] = rdin(10);
#endif
	p->fpn.dval = cheat.d;
}

void
fltprint(p)
	register NODE *p;
{
	/* print the value of a floating point constant to the intermediate
	 * file
	 */

	cheat.d = p->fpn.dval;
#ifdef MPX
	printf("%x\t%x\t",cheat.l[0], cheat.l[1]);
#else
	printf("%d\t%d\t",cheat.l[0], cheat.l[1]);
#endif
}
#endif /* FORT */

/*
 *	Read the machine dependent parts of certain instructions.
 *	Certain instructions are read elsewhere, notably in the register
 *	allocation routines.
 */

/*ARGUSED*/

void
PccReadInst(p)
	Instruction p;
{
	/*	Currently, none for Vax C */
	switch (p->tag) {
		default:
			InternalFault("PccReadInst called with tag %d",
						(int) (p->tag));
			break;

		case ParamHere:
			p->u.ph.phere_data.ftnno = rdin(10);
			break;
	}
}

/*
 *	Output machine dependent parts of instructions.
 */

void
PccWriteInst(p)
	Instruction p;
{
	switch (p->tag) {
		case Block_Start:
			printf("%d\t", p->u.bs.bbeg_data.maxtreg);
			break;

		case Block_End:
			printf("%d\t%d\t", p->u.be.bend_data.reg_use,
				           p->u.be.bend_data.maxfarloc);
					   /* (MEY) 17-Feb-87 Addr. changes */
			break;

		case FcnStart:
			printf("%s\n", p->u.fb.fname);
#ifndef MPX
			printf("%c.fartext\n", ITEXT);
#endif
			break;

		case ParamHere:
			printf("%d\t", p->u.ph.phere_data.ftnno);
			break;

		default:
			InternalFault("PccWriteInst called with tag %d",
					(int) (p->tag));
	}
}

/*
 *	Debug output
 */

void
PccPrintInst(p)
	Instruction p;
{
	switch (p->tag) {
		case Block_Start:
			printf("maxtreg: %d", p->u.bs.bbeg_data.maxtreg);
			break;

		case Block_End:
			printf("reg_use %d  maxfarloc: %d", 
				p->u.be.bend_data.reg_use,
				p->u.be.bend_data.maxfarloc);
			break;

		case FcnStart:
			break;

		case ParamHere:
			printf("ftnno %d\n", p->u.ph.phere_data.ftnno);
			break;

		default:
			InternalFault("PccPrintInst called with tag %d",
					(int) (p->tag));
	}
}

/*ARGSUSED*/

void
PccFreeInst(i)
	Instruction i;
{
	/* no effect on the VAX */
	return;
}

/*
 *	Reserved Registers
 *	List of registers, and their preferred types, that can
 *	appear for themselves in the intermediate code.
 */

RegList
ReservedRegs[] = {
#ifndef MPX
			{B2,	 INCREF(INT)},  /* Explicit B2 */
			{B6,	 INCREF(INT)},  /* Explicit B6 */
#endif
			{ARGREG, INCREF(INT)},	/* arg pointer */
			{STKREG, INCREF(INT)},	/* frame pointer */
#ifndef MPX
			{CCPREG, INCREF(INT)},	/* constant pool pointer (MEY)*/
#endif
			{1,	 INCREF(STRTY)},/* for returning structs */
			{2,	 INCREF(STRTY)},/* the same */
			{-1,	 UNDEF}
		};

#ifdef FORT
Build ReservedRegs List!
#endif

/*
 *	Routines to handle stack and register allocation
 */

/*
 *	Local storage recording the state of allocation
 *	at the moment
 */

int NoRegAlloc = 0;	/* Don't put things in registers */

static int maxoff;	/* max extent of stack frame allocated */
static int curoff;	/* current stack frame offset */
static int offhi;	/* stack frame high water mark since last advance */

static int FirstFree;	/* First free reg loc. - to save time searching */
static Boolean UserRegFreed; /* Was a user reg. var freed? */

static int savereg;	/* save nregs for block end.  THIS IS A HACK */

static struct {
	Boolean perm;	/* Has this register been allocated permanently? */
	Boolean temp;	/* Has this register been allocated temporarily
			 * (during the register allocation process)? Turned off
			 * again once the register has been allocated
			 * permanently */
	} regfree[REGSZ];


/*
 *	Forward
 */

static int AllocateStack();
static int szty();

/*
 *	Initialize private information on register and stack use
 * 	Called when FBEGIN read in.
 */

/* ARGSUSED */
void
PAlloInit(inst)
	Instruction inst;
{
	int i;

	/*
	 *	No extra arguments on the Vax
	 */

	offsz = caloff();
	maxoff = offhi = 0;
	FirstFree = MAXRVAR;
	UserRegFreed = False;
	for( i = MINRVAR; i <= MAXRVAR; i++ )
	{
		regfree[i].perm = True;
		regfree[i].temp = True;
	}
}

/*
 *	 Update information on register and stack use by pass 1.
 *	 Called when BBEG read in.
 */

void
PAlloBBeg(inst)
	Instruction inst;
{
	/*
	 *	Read in machine dependent stuff
	 */

	inst->u.bs.bbeg_data.maxtreg = rdin(10);

	/*
	 *	Update stack allocation data.
	 */

	if( maxoff < inst->u.bs.autooff )
		maxoff = offhi = inst->u.bs.autooff;

	/*
	 * All registers used by pass 1 are permanently unavailable.
	 * Do not set .temp here - it confuses AdvanceAllocation()
	 */

	while( FirstFree > inst->u.bs.bbeg_data.maxtreg )
		regfree[FirstFree--].perm = False;
}

/*ARGSUSED*/

void
PAlloBEnd(inst)
	Instruction inst;
{
	inst->u.be.bend_data.reg_use = rdin(10);
#ifndef MPX
	inst->u.be.bend_data.maxfarloc = rdin(10);
#else
	inst->u.be.bend_data.maxfarloc = 0;
#endif
}

/* This routine is called to fix up the name of an identifier as read
 * in.  On the Gould, we must wipe out the real name of static locals and
 * replace it by .Lnnn, the name as it will appear in the code
 */

void
PccFixIdentifier( sbuf, namespace, id_cookie)
	char *sbuf;		/* buffer containing name as read in */
	Operator namespace;	/* essentially, identifier class - NAME,
				 * LNAME, PNAME, etc. */
	int id_cookie;		/* identifier id from pass 1 */
{

	if (id_cookie < 0) {		/* static, correct the name */
		if (pdebug) {
			printf("Static id %s changed to label %d\n", sbuf, -id_cookie);
		}
		sprintf(sbuf, LABFMT, -id_cookie);
	}
}

/*
 *	Convert internal form to external form for a procedure name.
 *	May return NULL if no mapping exists (e.g., for a reserved
 *	name).  Result may point to in, or may point into work.
 *	Storage management is up to the caller.
 */

char *
PublicName(in, work)
	char *in;
	char *work;
{
	if (*in == '#')		/* a "far" procedure name ? */
		++in;
	return (*in == '_') ? in+1 : NULL;
}


/*
 *	These routines are called during output of the program
 *	to update the information about allocation.
 */

void
PUpdtBBeg(p)
	Instruction p;
{
	int i;

	assert(InstType(p) == Block_Start);
	p->u.bs.autooff = maxoff;

	/* If we tossed a user register variable, there may be busy
	 * registers at locations less than FirstFree.  In that case,
	 * pass 2 cannot use the free registers we have created - so
	 * forget about them.
	 */

	if( UserRegFreed )
	{
		for( i = MINRVAR; i <= MAXRVAR; i++ )
		{
			if( !regfree[i].perm )
			{
				FirstFree = i-1;
		/**/		break;
			}
		}
		UserRegFreed = False;	/* save doing this again */
	}
	p->u.bs.bbeg_data.maxtreg = FirstFree;
	savereg = FirstFree;			/* HACK */
}

void
PUpdtBEnd(p)
	Instruction p;
{
	assert(InstType(p) == Block_End);
#ifdef FORT
	p->u.rt.r_count = FirstFree;
#else
	p->u.be.bend_data.reg_use = savereg;		/* HACK */
#endif
}

/*
 *	This routine allocates space in the stack for the tree t.
 *	It is updated to have the approriate offset in the appropriate place.
 *	Returns true if space allocated (implies t changed).
 */

Boolean
PAlloStack(t)
	TreeNode t;
{
	int offset;

	assert(t->tn.lval == NOOFFSET);
	curoff = maxoff;
	offset = AllocateStack(szty(t->in.type));
	if( curoff > offhi )		/* Update high water mark */
		offhi = curoff;
	t->tn.lval = offset;
	if (AllocDebug)
		printf("%c! var %s allocated offset %d\n", ASM_CCHAR,
				t->in.identifier, t->tn.lval);
	return True;
}

/*
 *	Attempt to allocate register(s) for t, which is updated
 *	to reflect allocation if done.  Returns True if allocation
 *	successful.
 */

Boolean
PAlloReg(t)
	TreeNode t;
{
	int reg;
	int sz;

	if( NoRegAlloc )
/**/		return False;

		/* For now, dont put doubles in registers */

	sz = szty(t->tn.type);
	if( sz != 1 )
/**/		return False;

	for( reg = FirstFree; reg >= MINRVAR; reg-- )
	{
		if( regfree[reg].perm )
		{
			/*	Show this register allocated in current
			 *	round.
			 */

			regfree[reg].temp = False;

			/*
			 *	This code is machine independent, but
			 *	is most easily maintained here.
			 */

			if (AllocDebug)
				printf("%c! Var %s put in register %d\n",
						ASM_CCHAR,
						t->tn.identifier, reg);
			t->in.op = TREG;
			t->in.identifier = NULL;
			t->tn.rval = reg;
			t->tn.lval = 0;
/**/			return True;
		}
	}

	return False;
}

/*
 *	Free up the register from a user register variable that has been
 *	tossed.
 *	WARNING: THE CALLER OF THIS ROUTINE IS RESPONSIBLE FOR ENSURING THAT
 *	THIS REGISTER IS NOT USED AS A USER REGISTER VARIABLE IN SOME OTHER
 *	BLOCK IN THE FUNCTION, AND FOR ENSURING THAT THIS REGISTER IS REALLY A
 *	REGISTER VARIABLE.
 */

void
PccFreeUserReg(t)
	TreeNode t;
{
	int reg;

	assert(t->in.op == REG);

	reg = t->tn.rval;
	assert( reg >= MINRVAR  && reg <= MAXRVAR);
	regfree[reg].perm = True;
	if( FirstFree < reg )
	{
		FirstFree = reg;
		UserRegFreed = True;
	}

	if( AllocDebug > 1)
		printf("User register %d freed\n", reg);
}


/*
 *	Commit existing allocations.
 */

void
PccAdvanceAllocation()
{
	int reg;

	maxoff = offhi;

	/* A register high water mark might save time here, at the expense
	 * of time in the allocation routine, which is more heavily used.
	 */

	for( reg = FirstFree; reg >= MINRVAR; reg-- )
	{
		if( !regfree[reg].temp )
		{
			regfree[reg].temp = True;
			regfree[reg].perm = False;
			FirstFree = reg - 1;
		}
	}
}

static int
AllocateStack( k )		/* See pass2 mktemp() */
{

	/* allocate k integers worth of temp space */
	/* we also make the convention that, if the number of words is more than 1,
	/* it must be aligned for storing doubles... */

# ifndef BACKAUTO
	int t;

	if( k>1 ){
		SETOFF( curoff, ALDOUBLE );
	}

	t = curoff;
	curoff += k*SZINT;
	assert(curoff < offsz);
	return(t/SZCHAR);

# else
	curoff += k*SZINT;
	if( k>1 ) {
		SETOFF( curoff, ALDOUBLE );
	}
#ifndef FORT
	/*jwf this line blows f77*/
	assert(curoff < offsz);
#endif
	return( -(curoff/SZCHAR) );
# endif
}

static int
szty(t)
	TWORD t;
{
	/* size, in registers, needed to hold thing of type t */
#ifdef FORT
	return( (t==DOUBLE) ? 2 : 1 );
#else
	return( (t==DOUBLE||t==FLOAT) ? 2 : 1 );
#endif
}

/*
 *	End of allocation submodule
 */

/*
 *	Types Submodule
 *
 *	This module exports routines that deal with types and type
 *	conversions in a machine dependent way.
 *
 *	Note 1: we may decide to move this stuff in target.[ch]
 *	Note 2: we will someday try to make this stuff smaller,
 *		and mostly table driven, and put the control structure
 *		back into tree.c
 */

/*
 *	What should the type of a temporary be?  For performance
 *	reasons, we promote any char or short temp to type int,
 *	and any unsigned char or unsigned short temp to type unsigned
 *	int.  This allows them to be promoted to registers.
 *
 *
 */

TWORD
TempType(ty)
	TWORD ty;
{
	switch (ty) {
		case CHAR:
		case SHORT:
			ty = INT;
			break;

		case UCHAR:
		case USHORT:
			ty = UNSIGNED;
			break;
	}
	return ty;
}

/*
 *	Can an automatic variable of type t OK for a register variable
 */

Boolean
cisreg( t )
	TWORD t;
{

	if( ISPTR(t) )
/**/		return True;
	else
	switch(t) {

		case FLOAT:
		case INT: case UNSIGNED:
		case LONG: case ULONG:
/**/			return(True);

		default:
/**/			return False;

	}
}

/*
 * Try to cast node p to type ty.  If the cast is possible, do it - including
 * any conversions or type painting.
 * The logic here is similar to the logic in cases SCONV and PCONV in
 * clocal() in the compiler.
 */

Boolean
DoCast(p, ty)
	TreeNode p;
	TWORD ty;
{
	if( ty == p->in.type )
		return True;

	return ((ty&TMASK)==0) ? DoSCONV(p,ty) : DoPCONV(p,ty) ;
}

static Boolean
DoPCONV(p, ty)
	TreeNode p;
	TWORD ty;
{
	TWORD tyl;

	tyl = p->in.type;

	if( (tyl==CHAR || tyl==UCHAR || tyl==SHORT || tyl==USHORT) && p->in.op != ICON )
		return False;

	/* Paint type down.  All pointers are the same size. */

	p->in.type = ty;

	/* If we have painted a type down onto an SCONV, make it a PCONV
	 */
	if( p->in.op == SCONV )
		p->in.op = PCONV;

	return True;
}

static Boolean
DoSCONV(p, ty)
	TreeNode p;
	TWORD ty;
{
	TWORD tyl;
	Boolean TossIt = False;	/* Should we toss the cast away? */

	tyl = p->in.type;

	if( ty == tyl )
		return True;
	
	if( p->in.op == FCON )
	{
		if( ty == FLOAT )
			p->fpn.dval = (float) p->fpn.dval;
		else
		if( ty != DOUBLE )
			switch( ty ) {
				case CHAR:
				case SHORT:
				case INT:
				case LONG:
					p->in.op = ICON;
					p->in.type = LONG;
					p->tn.lval = (CONSZ) p->fpn.dval;
					DoSCONV( p, ty );
					break;
				case UCHAR:
				case USHORT:
				case UNSIGNED:
				case ULONG:
					p->in.op = ICON;
					p->in.type = ULONG;
					p->tn.lval = (UCONSZ) p->fpn.dval;
					DoSCONV( p, ty );
					break;
				default:
/**/					return( False );
			}
	}
	else
	if( p->in.op == ICON )
	{
		/* simulate conversion here.  Unlike pass1, we do not
		 * have to worry about pointers - they are ADDRS
		 */
		CONSZ val;
		val = p->tn.lval;
		switch( ty ){
		case CHAR:
			/*
			 * Probably should install the onlyuchar
			 * code from clocal().  I believe that
			 * if that option is on, we'll never see
			 * a CHAR, but ...
			 */
			p->tn.lval = (char) val;
			break;
		case UCHAR:
			p->tn.lval = val & 0XFF;
			break;
		case USHORT:
			p->tn.lval = val & 0XFFFFL;
			break;
		case SHORT:
			/*
			 *	This code from clocal() in the compiler.
			 *	It is not clear to me why a simple
			 *	cast is not sufficient, but I am
			 *	playing it safe.
			 */

			val &= 0xffff;
			if (val & 0x8000) {
				val |= ~0xffff;
			}
			p->tn.lval = val;
			break;
		case UNSIGNED:
			p->tn.lval = val & 0xFFFFFFFFL;
			break;
		case INT:
			p->tn.lval = (int)val;
			break;
		case LONG:
			/*
			 *	This code is from clocal() in the compiler.
			 *	I am not sure how it could be invoked,
			 *	since it appears that LONGs are converted
			 *	to INT by pass 1.  Better safe than
			 *	sorry.
			 */

			if (tyl == UNSIGNED &&
			    p->tn.lval & (1 << (SZINT -1)))
				return False;
			break;
		case FLOAT:
			if( ISUNSIGNED(tyl) )
				p->fpn.dval = (float)(UCONSZ)val;
			else
				p->fpn.dval = (float)val;
			p->in.op = FCON;
			break;
		case DOUBLE:
			if( ISUNSIGNED(tyl) )
				p->fpn.dval = (double)(UCONSZ)val;
			else
				p->fpn.dval = (double)val;
			p->in.op = FCON;
			break;
		default:
			if( !ISPTR(ty) )
				return False;
			p->tn.lval = (int)val;
			break;
		}
		p->in.type = ty;
	}
	else
	{
		/* Try to get rid of the conversion */
		Boolean rfloat, isfloat;

		rfloat  = (ty  == FLOAT || ty  == DOUBLE);
		isfloat = (tyl == FLOAT || tyl == DOUBLE);

		if( rfloat || isfloat )
			return False;

			/* Unsigned fields cannot have type coloured
			 * down on signed extraction.
			 * Likewise signed fields on an unsigned
			 * extraction.
			 */
		if( p->in.op == FLD && ISUNSIGNED(tyl) != ISUNSIGNED(ty) )
			return False;

		/*
		 *	Registers are treated just like other operands.
		 *	If [U]CHARs or [U]SHORTs can be stored in registers,
		 *	this will not be correct and special code
		 *	will be needed (e.g., VAX)
		 */

		switch(ty)
		{
		case CHAR:
		case UCHAR:
			if( tyl != CHAR && tyl != UCHAR )
				return False;
			break;
		case SHORT:
		case USHORT:
			if( tyl != CHAR && tyl != UCHAR && tyl != SHORT &&
			    tyl != USHORT)
				return False;
			break;
#ifdef FORT
		case FLOAT:
		case DOUBLE:
			/* FLOAT <-> DOUBLE conversions mean
			 * something in FORTRAN
			 */
			return False;
#endif
		case LONG:	/* used for bit fields */
			return False;
		}

		TossIt = tlen(ty) != tlen(tyl);
	}
		/* paint type down if possible */
	if( !TossIt )
	{
		p->in.type = ty;

		/* Now fix up a potential problem.  In theory, we should
		 * never be called upon to paint a type down onto a PCONV.
		 * In practice, it might happen from judicious use of
		 * temporaries.  So, play it safe and turn a PCONV into an
		 * SCONV
		 */
		if( p->in.op == PCONV )
			p->in.op = SCONV;
	}

	return True;
}

int
tlen(ty)
	TWORD ty; 
{
	switch(ty)
	{
	case CHAR:
	case UCHAR:
		return(1);
			
	case SHORT:
	case USHORT:
		return(2);
			
	case DOUBLE:
		return(8);
			
	default:
		return(4);
	}
}

/*
 *	Local option handling and initialization
 */

Boolean					/* return False if unrecognised */
LocalOption(p)
	char *p;			/* points at current argument */
{
	return False;
}

void
LocalInit()				/* do local initializations */
{
}
