/* opt.c */
/*
 * HCR Confidential
 *
 * These computer programs are the confidential, proprietary property
 * of HCR (Human Computing Resources Corporation, 10 St. Mary Street,
 * Toronto, Ontario, Canada), and may not be disclosed except with the
 * prior written agreement of HCR.
 *
 * Copyright (c) 1984, 1985, 1986 Human Computing Resources Corporation
 * All Rights Reserved
 */
/*
 *	Driver for optimization pass
 */

/*
 *	Imported Objects
 */

#ifndef lint
static char *rcsid = "@(#) (Gould) $Header: opt.c,v 5.5 89/05/12 12:52:04 pcc Rel-3_0 $";
/* static char ID[] = "@(#)opt.c	15.8	of 86/11/27"; */
#endif

# include <allocate.h>
# include <assert.h>
# include <availexpr.h>
# include <carrier.h>
# include <comsubex.h>
# include <constant.h>
# include <dag.h>
# include <dagsymbol.h>
# include <dagtree.h>
# include <deadstore.h>
# include <delay.h>
# include <duchain.h>
# include <erroro.h>
# include <gcomsubex.h>
# include <idiom.h>
# include <instruct.h>
# include <labels.h>
# include <livedead.h>
# include <loop.h>
# include <longset.h>
# include <opt.h>
# include <option.h>
# include <pcc.h>
# include <readero.h>
# include <writero.h>
# include <stdio.h>
# include <storage.h>
# include <tree.h>
# include <udchain.h>
# include <undef.h>
# include <config.h>
# ifdef FILLSPILL
# include <fillspill.h>
# include <f77copy.h>
# endif /* FILLSPILL */
# ifdef FORT
# include <bincode.h>
# endif
#ifdef	INLINER
# include <inliner.h>
#endif	/* INLINER */

/*
 *	Naughty  - Must be fixed
 */

extern char *sbrk();	/* Used for interrogation only */

/*
 *	Forward Declarations
 */

static void OptPass();
static void Optimize();		/* optimize the current function */

/*
 *	Globals
 */

int pdebug = 0;			/* Print program */
int bdebug = 0;			/* Blocks */
int ndebug = 0;			/* No DAG */

int Statistics = 0;		/* Statistics */
Boolean WarningOption = True;	/* Warn about lack of optimization */

Boolean AsmStmt;		/* ASM statement found */

int BadFcn;			/* Index of difficult function called */

Boolean AssignedGoto;		/* Function contains Assigned Goto */
				/* in C, this will be set False, and never
				 * changed.
				 */

InstrList ParamLoads;		/* register parameter loads */

InstrList header;		/* instructions before the FcnStart */
InstrList function;		/* Original list of instructions */
InstrList trailer;		/* at end of function (f77 only) */

char ftnname[BUFSIZ+1];		/* Name of current function (without '_') */

/*
 *	Private Data
 */

static unsigned long starting_break;	/* Break value at start of program */

int
main(argc, argv)
	int argc;
	char *argv[];
{
	ProcessArgs(argc, argv);

#ifdef	INLINER
	if (inlining) {
		InlinerPass();
		if (fseek(stdin, 0L,  0) != 0)
			ExternalFault("can't rewind stdin");
	}
#endif	/* INLINER */
	OptPass();
	return(0);
}

static void
OptPass() {
	Init();
	LocalInit();		/* machine dep. global init */

	ReadICode(&header, &ParamLoads, &function, &trailer, Optimize);
	assert(function.first == NULL);	/* Never saw a function start */
	WriteList(header);		/* Do the end of the program */
# ifdef FORT
	p2eof();			/* Stupid f77 needs EOF cookie */
# endif
	if (Statistics)
		PrintStatistics();
}

void
Init()
{
	starting_break = (unsigned long) sbrk(0);

#ifdef STORESTATS
	InitStoreStats();
#endif

	AsmStmt = False;
	BadFcn = -1;
	ftnname[0] = '\0';	/* No function at beginning */

	AssignedGoto = False;	/* in C, this will never change */

	mkdope();
	InitSets();
#ifndef	INLINER
	TreeInit();
#endif	/* INLINER */
	InitList(&function);
	InitList(&ParamLoads);
	InitList(&header);
	InitList(&trailer);
	InitSymManager();
	InitDagModule();
}

static void
Optimize(s)
	Instruction s;			/* starting instruction of code */
{
	Boolean	BuiltGraph = False;
#ifdef	INLINER
	Boolean AllocatedVars = False;
#endif	/* INLINER */

	if (pdebug != 0) {
		printf("Header\n");
		PrintIList(header);
		printf("Parameter Loads\n");
		PrintIList(ParamLoads);
		printf("Function code\n");
		PrintIList(function);
		printf("Function trailer\n");
		PrintIList(trailer);
	}

	if (AsmStmt)
		WarnNoOpt("used asm statement", (char *) NULL);
	else
	if (BadFcn >= 0 && BadFcnNames[BadFcn] != NULL)
		WarnNoOpt("called %s()", BadFcnNames[BadFcn]);
	else
	if (AssignedGoto) {
		/*
		 *	For f77, an assigned goto makes the flow graph very difficult
		 *	to build, so we simply don't do it, and do no transformations
		 *	on the function.
		 *	For C, this is a constant False.
		 *
		 *	This test must be before any tests that examine the
		 *	basic blocks or the flow graph.
		 */

		WarnNoOpt("used assigned GOTO statement", (char *) NULL);
	} else {		/* We can do it */
#ifdef	INLINER
		if (inlining)
			InlineSubstitute(&function,ftnname);
#endif	/* INLINER */
		BuildBlocks(s);
		if (bdebug != 0) {
			PrintBlocks();
			DumpLabelTable();
		}

		BuildGraph();
		BuiltGraph = True;
		if (!IsReducible())
			WarnNoOpt("has irreducible flow graph", (char *) NULL);
		else {
#ifdef FILLSPILL
			if( !NoFillSpill ) {
				MarkFunctions();
				CopyInOut();
			}
#endif /* FILLSPILL */
			BuildDAGS();
			CheckDelay();
			InitDUInfo();
			DUChains();
			LiveDead();
			InitUDInfo();
			UDChains();
			DeadStores();
			ChooseCarrier();
			ConstantProp();
			LoopInvariants();
			ReclaimUnusedVars(&ParamLoads);
			MarkUndefined();
			AvailableExpressions();
			GlobalCommon();
			FindIdioms();
			FindCommon();
			AllocVars(&ParamLoads);
#ifdef	INLINER
			AllocatedVars = True;
#endif	/* INLINER */
			FinalCarriers();
			RewriteDAGS();
		}
	}

	/*
	 * 	Write out the header
	 */

	WriteList(header);
	FreeIList(&header);

	if (!BuiltGraph) {	/* Didn't build the Flow Graph */
		WriteList(function);
		FreeIList(&function);
	} else {
#ifdef	INLINER
		if (!AllocatedVars && inlining)
			IrrAllocate();
#endif	/* INLINER */
		/* The normal course of events */
		WriteFlow();
	}
	WriteList(trailer);
	FreeIList(&trailer);
	FreeIList(&ParamLoads);
	ResetProg();
}

void
ResetProg()
{
	AsmStmt = False;
	BadFcn = -1;

	AssignedGoto = False;		/* Never set true in C */

	InitList(&function);		/* Clear the function */
	InitList(&ParamLoads);		/* and the parameter loads */
	InitList(&header);		/* and the header */
	InitList(&trailer);		/* and the trailer */

	if (!AssignedGoto)
		FreeFlow();		/* Recover the flow graph */
	InitTable();			/* Recover the symbol table */
#ifndef	INLINER
	TreeInit();			/* Check */
#endif	/* INLINER */
}

PrintStatistics()
{
	unsigned long b;

	b = (unsigned long) sbrk(0);

	fprintf(stderr, "Optimizer Statistics\n");
	fprintf(stderr, "Total Memory: %lu Delta break: %lu\n", b,
		  b - starting_break);

#ifdef STORESTATS
	if (Statistics > 2) {
		PrintMemStats();
	}
#endif

}


