/* ops.h */
/*
 * HCR Confidential
 *
 * These computer programs are the confidential, proprietary property
 * of HCR (Human Computing Resources Corporation, 10 St. Mary Street,
 * Toronto, Ontario, Canada), and may not be disclosed except with the
 * prior written agreement of HCR.
 *
 * Copyright (c) 1984, 1985, 1986 Human Computing Resources Corporation
 * All Rights Reserved
 */
/*
 *	Interface to ops - intermediate code operator info
 */

#ifndef OPSHEADER

#define OPSHEADER

#ifndef lint
/*	@(#) (Gould) $Header: ops.h,v 5.5 89/05/12 12:52:01 pcc Rel-3_0 $		  */
/* static char OPSH_SCCSID[] = "@(#)ops.h	9.2	of 86/02/20"; */
#endif

#include <bool.h>
#include <cmanifest.h>


typedef unsigned char	Operator;	/* An intermediate code operator */

	/* Forced and Literal would be faster if they could use dope[] */

#define Forced(op) (callop(op) || asgop(op) || (op) == CBRANCH || \
			(op) == FORCE )

#define Literal(op) ((op) == ICON || (op) == FCON || (op) == ADDR || \
			(op) == LADDR || (op) == PADDR || \
			(op) == STADDR || (op) == STLABEL)

#define CascadeOp(op) ((op) == ANDAND || (op) == OROR)

#define ConditionalOp(op) ((op) == ANDAND || (op) == OROR || (op) == QUEST)

	/* Might op be changed by CALL, indirect store, etc? */

#define MayBeChanged(op) (callop(op) || asgop(op) || (op) == UNARY MUL)

#define Is_Icon(d)	((d)->op == ICON)
#define Is_Addition(d)	((d)->op == PLUS || (d)->op == MINUS)
#define IsAddrConst(d)	(Is_Addition(d) && ((Is_Addr((d)->u.in.left) && \
					   Is_Icon((d)->u.in.right)) || \
					  (Is_Addr((d)->u.in.right) && \
					   Is_Icon((d)->u.in.left))))

#define IsShift(op)	(dope[(op)] & SHFFLG)

extern Boolean	SideEffectOp();		/* Does op have a side effect ? */
extern Operator	OpMap();		/* Map Side effect op to normal */
extern Boolean	OpAssignable();		/* True if op can become op= */

extern Operator ToNAME();		/* map addrs to names */
extern Operator ToADDR();		/* map names to addrs */
extern Boolean Is_Addr();		/* is a node an address ? */

#endif
