/* instruct.h */

/*
 * HCR Confidential
 *
 * These computer programs are the confidential, proprietary property
 * of HCR (Human Computing Resources Corporation, 10 St. Mary Street,
 * Toronto, Ontario, Canada), and may not be disclosed except with the
 * prior written agreement of HCR.
 *
 * Copyright (c) 1984, 1985, 1986 Human Computing Resources Corporation
 * All Rights Reserved
 */
/*
 *	The instructions that make up a program.
 *	The program is represented as a linked list of Instructions.
 */

#ifndef INCL_INSTRUCT
#define INCL_INSTRUCT

#ifndef lint
/*	@(#) (Gould) $Header: instruct.h,v 5.5 89/05/12 12:51:13 pcc Rel-3_0 $		  */
/* static char INSTRUCT_ID[] = "@(#)	instruct.h	15.1	of 86/10/14"; */
#endif

# include <config.h>
# include <tree.h>
# include <pcc.h>

typedef enum {Passed, Block_Start, Block_End, Expr, Label, UBranch,
#ifdef FORT
	      ArithIf, OnlyFileName, EntryPoint, f77_Special, CopyOut,
#endif
	      FcnStart, FcnEnd, Return, Switch, ParamFetch, ParamHere,
	      ParamSave, FreeInst}
	 InstTag;

typedef struct Inst {
	struct Inst *next;
	InstTag tag;	/* what kind of entry is this? */
	union {
		struct {		/* tag = Passed */
			char *line;
		} tx;

		struct {		/* tag = FcnStart */
			char *fname;
			fbeg_type fbeg_data;
		} fb;

		struct {		/* tag = Block_Start */
			int ftnno;		/* function number */
			unsigned autooff;
#ifdef FORT
			unsigned argloc;	/* to fudge arg offsets */
#endif
			bbeg_type bbeg_data;
		} bs;

		struct {		/* tag = Block_End */
			bend_type bend_data;
		} be;

		struct {		/* tag = Label */
			LabelType lab_num;
		} lb;

		struct {		/* tag = UBranch */
			LabelType target;
		} ub;

		struct {		/* tag = Return */
			LabelType r_lab;	/* label to branch to */
			RegCount r_count;	/* registers saved */
		} rt;

		struct {	 	/* tag = Expr */
			TreeNode root;		/* root of tree */
			char *filename;
			LineNumber lineno;	/* line number of tree */
		} ex;

#ifdef FORT
		struct {		/* tag = OnlyFileName */
				/* Note:  This type of node exists because
				 * the f77 compiler in its infinite stupidity
				 * sometimes uses Expr nodes to pass along a
				 * file name.  We must pass these along.
				 */
			char *filename;
			LineNumber lineno;
		} ofn;

		struct {		/* tag = EntryPoint */
			char *ename;
			LabelType pro_label;
		} ent;
#endif

		struct {		/* tag = Switch */
			int ncases;
			LabelType defaultlabel;
			RegisterNumber swregister;	/* number of
					 * register containing the
					 * expression
					 */
			struct sw *swtable; /* table of value,label pairs */
		} sw;

		struct {		/* tag = ParamHere */
			phere_type phere_data;
		} ph;

		struct {		/* tag = ParamFetch */
			int offset;		/* offset in bytes */
			TWORD type;		/* type */
			RegisterNumber reg;	/* register number */
		} pf;

		struct {		/* tag = ParamSave */
			int npassed;		/* number of parameters passed
						 * in registers (or # of bytes)
						 */
		} ps;

#ifdef FORT
		struct {		/* tag = ArithIf */
			TWORD type;
			LabelType labs[3];		/* -ve, 0, +ve */
		} aif;
#endif

#ifdef FORT
		/*
		 *	This variant is included to handle f77
		 *	operators that PCO need not understand.
		 *	They are usually simply passed through.
		 */

		struct {		/* tag = f77_Special */
			spec_type f77_data;
		} f77_sp;
#endif /* FORT */

	} u;
} Instr, *Instruction;

typedef struct IL {
	Instruction first;
	Instruction last;	/* for last append */
} InstrList;

/*
 *	Access Routines
 */

#define InstType(i)	((i)->tag)

#define IsCBranch(i)	(InstType(i) == Expr &&	(i)->u.ex.root->in.op == CBRANCH)

#define IsUBranch(i)	(InstType(i) == UBranch)

#define IsReturn(i)	(InstType(i) == Return)

#define IsBend(i)	(InstType(i) == Block_End)

#define IsSwitch(i)	(InstType(i) == Switch)

#ifdef FORT

#define IsEntry(i)	(InstType(i) == EntryPoint)

#define IsArithIf(i)	(InstType(i) == ArithIf)

#define	IsBranch(i)	(IsUBranch(i) || IsCBranch(i) || IsSwitch(i)|| \
				IsArithIf(i))

#else

#define	IsBranch(i)	(IsUBranch(i) || IsCBranch(i) || IsSwitch(i))

#endif

/*
 *	Exported Objects
 */

extern void	   ConcatInstructions();/* Join two instruction lists   */
extern void	   AppendInstruction(); /* Append inst. to list		*/
extern void	   DelInstruction();	/* Delete inst. from list	*/
extern Instruction AddInstruction();	/* Add an instruction		*/
extern Instruction CreateInstruction();	/* Create an instruction	*/
extern char *      StoreText();		/* Squirrel away some text	*/
extern char *	   EnterFilename();	/* Save a file name		*/
extern void	   InitList();		/* Initialize an instruction list */
extern void	   FreeIList();		/* Free a List			*/
extern LabelType   BranchTarget();	/* Target of a branch instr.	*/
extern void	   InstFree();		/* Free an Instruction		*/
extern void        PrintInstruction();	/* Debug			*/
extern void	   PrintIList();	/* Debug 			*/

#endif
