/* activity.h */
/*
 * HCR Confidential
 *
 * These computer programs are the confidential, proprietary property
 * of HCR (Human Computing Resources Corporation, 10 St. Mary Street,
 * Toronto, Ontario, Canada), and may not be disclosed except with the
 * prior written agreement of HCR.
 *
 * Copyright (c) 1984, 1985, 1986 Human Computing Resources Corporation
 * All Rights Reserved
 */

/*
 *	Activity Count: Computes dependency information
 */

#ifndef ACTIVITY

#define ACTIVITY

#ifndef lint
/*	@(#) (Gould) $Header: activity.h,v 5.5 89/05/12 12:49:00 pcc Rel-3_0 $		  */
/* static char ACT_SCCSID[] = "@(#)	activity.h	15.1	of 86/09/17"; */
#endif

# include <bool.h>
# include <dag.h>

/*
 *	Exported Objects
 */

/*
 *	This is the node that has caused the current round of evaluations,
 *	the root of the tree that UpdateActivity is currently traversing.
 */

extern DAG_Node ActRoot;

/*
 *	Exported Operations
 */

extern void InitActivity();		/* TEMPORARY */
extern void DoneActivity();		/* TEMPORARY */

/* Updates activity count of a node after evaluation. */

extern void
UpdateActivity(/* DAG_Node n; void (*FinishNode)(DAG_Node n) */);

/* Recursively does tree */

extern void
DecrementActivity(/* DAG_Node n; void (*FinishNode)(DAG_Node n) */);

/* Increase activity count in a tree (idioms) */

extern void
IncrementActivity(/* DAG_Node n */);

/* Activity count processing of entire DAG */

extern Boolean
ActivityDag(/* DAG_Node d; Boolean (*EvalNode)(DAG_Node n) */);

#endif
