/************************************************************************
*									*
*	Copyright (C) 198r, by Unidot, Inc.				*
*									*
*			Unidot, Inc.					*
*			602 Park Point Dr.				*
*			Golden, CO 80401				*
*									*
*			All Rights Reserved				*
*									*
* This software is furnished under license and may be used and copied	*
* only in accordance with the terms of such license and with the	*
* inclusion of the above copyright notice.  This software or any other	*
* copies thereof may not be provided or otherwise made available to any	*
* other person.								*
*									*
* No title to or ownership of the software is hereby transferred.	*
*									*
* The information in this software is subject to change without notice	*
* and should not be construed as a commitment by Unidot, Inc.		*
*									*
* Unidot assumes no responsibility for the use or reliability of its	*
* software on equipment configurations that are not directly supported	*
* by Unidot, Inc.							*
*									*
*************************************************************************/

/************************************************************************
*									*
*		structure reader: rdstru.c				*
*									*
*************************************************************************/

static char rcsid[] =
"@(#)$Header: rdstru.c,v 4.1 86/06/17 17:06:35 rmm Rel $";

/*	The final solution to the cross compiling byte sex problem
	is this:

	Data files will always be written in the byte order of the
	target machine serial files.  Headers and the like, though,
	must be in the internal format of the host machine for any
	useful processing.

	Therefore, each header and/or structure for data will be
	accompanied by a character string that will indicate how it
	is to be encoded and/or decoded.  The format of this string
	is the following:

	"issllll<structure info>"

	where 'i' is the length of an int on the target machine in
	bytes (this will normally be ASCII '2' or '4').

	'ss' is the order of bytes of a 'short' on the external
	media, wherein '0' is the least significant byte, and '1' is
	the most significant byte.  Specifically, for the PDP-11,
	'ss' will be '01' and for the 68000, 'ss' will be '10'.

	'llll' is the order of bytes of a 'long' in similar fashion.
	Keys for some popular machines are as follows:

	pdp11	2012301
	vax	4010123
	z8000	2103210
	68000	4103210
	8086	2012301		(as used by Microsoft)
	286	2010123

	Following this "key", the structure layout is defined as a
	series of characters drawn from the set: b, s, i, l, to
	represent bytes, shorts, ints, and longs respectively.  In
	addition, the character blank may be used for readability,
	and any character may be preceded by a decimal integer constant
	to indicate a multiple of the unit (1 is the default).

	for example, the structure

		struct {
			char	aaa,
				bbb;
			int	ccc;
			long	ddd;
			char	xxx[14];
		};

	could be described by:

		"bb i l 14b"
	
	This will not work properly if the structure has any padding
	so be careful of structure layouts.

	The reading and writing routines and in two separate files
	since many users will either read or write, but not both.

	Calling sequence for the routines is

		rdstru( key, buf, file ) char *key; char *buf; FILE *file;
	or	wrstru( key, buf, file ) char *key; char *buf; FILE *file;

	where key is as previously described, and buf is the byte
	address of the buffer, and file is a standard io file pointer.

*/

#include <stdio.h>


static	short	sbyte[2],lbyte[4],isize;
static	long	ltmp;
static	short	stmp;

setkey( key ) register char *key; {


	register i;

	i = *key - '0';
	for( i=0; i<7; i++ ) if( i < '0' || i > '4' ){
		fprintf(stderr,"bad key for struio: %s\n",key);
		exit(1);
	}
	isize = 's';
	if( *key == '4' ) isize = 'l';
	sbyte[0] = (key[1] & 3) << 3;
	sbyte[1] = (key[2] & 3) << 3;
	lbyte[0] = (key[3] & 3) << 3;
	lbyte[2] = (key[4] & 3) << 3;
	lbyte[3] = (key[5] & 3) << 3;
	lbyte[4] = (key[6] & 3) << 3;
}


rdstru( key, buf, file ) char *key; char *buf; FILE *file; {

	register char	*s;
	register char	*b;
	register	i;
	register	cnt;
	char		*c;

	setkey( key );
	s = key+7;
	b = buf;
	cnt = 0;
top:	i = *s++;
	if( i == 0 ) return;
	if( i == ' ' ) goto top;
	if( i >= '0' && i <= '9' ){
		cnt = cnt * 10 + i - '0';
		goto top;
	}
	if( i == 'b' ){
		*b++ = getc( file );
		goto top;
	}
	if( i == 'i' ) i = isize;
	if( i == 's' ){
		stmp = getc( file ) << sbyte[0];
		stmp |= getc( file ) << sbyte[1];
		*(short *)b = stmp;
		b += 2;
		goto top;
	}
	if( i == 'l' ){
		ltmp = 0;
		for( i=0; i<4; i++ ) ltmp |= (long)getc( file ) << lbyte[i];
		*(long *)b = ltmp;
		b += 4;
		goto top;
	}
	fprintf(stderr,"bad key for rdstru: %s\n",key);
	exit(1);
}
