/************************************************************************
*									*
*	flw.c - fetch and store long words in C	VAX/32016 order		*
*									*
************************************************************************/

long
flw (lp) register char *lp; {
	/* lp is really a pointer to a long but the 32016 and the VAX
	 * always regards things as low byte first, so we cheat and pretend
	 *  it is a byte pointer */
	long	ll;

	ll = lp[3];
	ll = (ll << 8) | (lp[2] & 0xff);
	ll = (ll << 8) | (lp[1] & 0xff);
	ll = (ll << 8) | (lp[0] & 0xff);
	return ll;
}

slw (lp, ll) register char *lp; long ll; {      /* same game as before */
	register low,high;

	low = ll;
	high = ll >> 16;

	*lp++ = low;
	*lp++ = low >> 8;
	*lp++ = high;
	*lp++ = high >> 8;
}


fsw (wp) register char *wp; {
	/* wp is actually a ptr to a 32016 organized short */
	register i;

	i = wp[1];
	i = (i << 8) | (*wp & 0xff);
	return (short)i;
}

ssw (wp, n) register char *wp; {   /* ditto */

	*wp++ = n;
	*wp++ = n >> 8;
}
