/************************************************************************
*									*
*		decref.c - aux table readers				*
*									*
************************************************************************/

#include "standard.h"
#include "aaux.h"

extern AUXTAB	aux[];

#define ushort	unsigned short
#define reg	register

ushort
decrefa(typword) ushort typword; {

	/* return aux portion of decref */

	reg	t;

	t = (typword>>4) & 0xfff;
	if( t == 0 ) MSG( "2illegal dereference" );
	return aux[t].auxword;
}

ushort
decreft(typword) ushort typword;{
	/* return typ portion of decref */
	reg	t;

	t = (typword>>4) & 0xfff;
	if( t == 0 ) MSG( "2illegal dereference" );
	return aux[t].typword;
}

ushort
tdeca(typword) ushort typword; {

	while( (typword & TYMASK) == TYMORE ) typword = decreft(typword);
	return decrefa(typword);
}

ushort
tdect(typword) ushort typword; {

	while( (typword & TYMASK) == TYMORE ) typword = decreft(typword);
	return decreft(typword);
}
