*        DISKUT    PROGRAM CDISK
************************************************************************
*
*   THIS PROGRAM ALLOWS THE USER TO EXAMINE AND CHANGE ANYTHING ON
*   A DISK PACK.
*
*   ACTIVATION SEQUENCE:   TSM>CDISK
*
************************************************************************
         LIST      NODATA,NOMAC,NOREP
         PROGRAM   CDISK
         SPACE     1
         M.EQUS
         M.DFT.
         M.FCB.
         M.UDT.
         M.RR.TEQ
         EXT       AUTODISK,AUTOFLAG                           032991RLW
         SPACE     1
START    EQU       $
         SVC       1,X'4C'         GET PROGRAM OPTION WORD
         TBR       R7,31           CHECK FOR OPTION ONE
         BNS       ST1             NO SKIP
         SBM       3,FLAG          SET FLAG FOR ALOC/DEALOC SLO OUTPUT
ST1      EQU       $
         TBR       R7,30           CHECK FOR NO SUPPRESSION
         BNS       ST2             NO SKIP
         SBM       6,FLAG          SET FLAG FOR NO SUPPRESSION
ST2      EQU       $
         LW        R7,HELLOTCW     TCW FOR "TYPE ?" MESSAGE
         BL        OPCOM1          SEND MESSAGE TO 'UT'
NEXTCMND EQU       $
         LW        R7,CMDINTCW     TCW FOR 'COMMAND=' MESSAGE
         LW        R6,OPINTCW      ADDR & BYTE COUNT FOR OPER INPUT
         BL        OPCOM2          OUTPUT MESSAGE AND WAIT FOR INPUT
         M.TSCAN                   GET FIRST INPUT ARGUMENT
         TRR       R5,R5           ANY INPUT ?
         BEQ       NOCMD           NO, BRANCH TO BAD COMMAND LOGIC
         ZR        R1              INITIALIZE COMMAND TABLE INDEX
         SRL       R6,16           LOOK AT FIRST TWO CHARS INPUT
CMDCHECK EQU       $
         CAMW      R6,CMDTABL,X1   MATCH WITH ENTRY IN COMMAND TABLE ?
         BEQ       PROCCMD         YES, GO PROCESS COMMAND
         ABR       R1,29           NO, INCREMENT INDEX TO NEXT CMD IN TABL
         CI        R1,CMDTABLL     DID WE RUN OUT THE BOTTOM OF TABLE ?
         BLT       CMDCHECK        NO, GO BACK FOR ANOTHER TRY
NOCMD    EQU       $
         LW        R7,BADCMTCW     TCW FOR INVALID COMMAND MESSAGE
         BL        OPCOM1          TELL OPERATOR THE COMMAND WAS NO GOOD
         BU        ST2             START OVER AT 'TYPE ?'
PROCCMD  EQU       $
         BL        *CMDVECTR,X1    GO TO APPROPRIATE ROUTINE FOR THIS CMD
         BU        NEXTCMND        START OVER AT 'COMMAND='
         PAGE
************************************************************************
*               SUBROUTINE  DISPLAY
************************************************************************
*   THIS ROUTINE DISPLAYS THE CONTENTS OF THE HOLDING BUFFER ON
*   THE USER'S CRT.
*
*   INPUT REGS--  NONE
*
*   OUTPUT REGS-- NONE
************************************************************************
DISPLAY  EQU       $
         STW       R0,SAVER0
         TBM       2,FLAG          READ OR WRITE OCCURRED ON THIS UNIT ?
         BS        SECNUMOK        YES, THEN A SECTOR NUM HAS BEEN DEFINED
         LD        R6,UNKNOWN      NO, PUT 'UNKNOWN' IN DISPLAY TO OPER
         BU        SECTOUT         SKIP THE CONV TO ASCII
SECNUMOK EQU       $
         LW        R5,SECNUM       GET CURRENTLY ACTIVE SECTOR NUMBER
         M.CONBAH                  CONV SECTOR TO ASCII
         ANMW      R6,ZERTOBLK     CONV 2 MSB (BYTES) FROM ZERO TO BLANK
SECTOUT  EQU       $
         STD       R6,SECDISP      PUT SECTOR NUM IN ERROR MESSAGE
         LI        R7,X'0D'        CARRIAGE RETURN
         STB       R7,SECNM        PUT CARRIAGE CONTROL CHAR IN CRT MESG
         LW        R7,SECNMTCW     TCW FOR 'SECTOR NUMBER =' MESSAGE
         BL        OPCOM1          SEND INFO TO 'UT'
         ZR        R2              INITIALIZE OFFSET INTO HOLDING BUFFER
DOALINE  EQU       $
         BL        CLRLINE         CLEAR LINE BUFFER FOR NEXT LINE
         LA        R1,LINE         ADDR OF LINE TO RECEIVE ASCII
         LA        R3,LINE+52      PART OF LINE CONTAINING DUMP ANNOTATION
         LI        R4,-4           TELL BILDLINE TO MAKE DISPLAY 4 WIDE
         LW        R7,DISPTCW      TCW FOR DISPLAYING ONE LINE OF INFO
         BL        BILDLINE        BUILD ONE LINE OF DISPLAY FROM BUFF
         TBM       4,FLAG          IS SUPPRESSION FLAG SET ?
         BS        ENDTST          YES, SKIP LINE OUTPUT
         BL        OPCOM1          SEND THE LINE TO 'UT'
         TBM       7,FCB.SFLG,X1   DID OPER TERM AT 'ENTER CR FOR MORE' ?
         BS        DISPRTRN        YES, RETURN
ENDTST   EQU       $
         CAMW      R2,BUFFSIZE     FINISHED THE BUFFER ?
         BLT       DOALINE         NO, GO BACK AND DO ANOTHER LINE
DISPRTRN EQU       $
         BU        *SAVER0         RETURN
         PAGE
************************************************************************
*               SUBROUTINE  DUMP
************************************************************************
*   THIS ROUTINE DUMPS THE CONTENTS OF THE HOLDING BUFFER TO THE
*   SLO DEVICE. IF ANY ARGUMENT IS SUPPLIED, NO SUPPRESSION WILL OCCUR.
*
*   INPUT REGS-- NONE     OUTPUT REGS-- NONE
************************************************************************
DUMP     STW       R0,SAVER0       SAVE R0
         LI        R7,X'30'        FORM CONTROL CHAR
         STB       R7,SECNM        PUT IN MESSAGE TO LINE PRINTER
         ZBM       5,FLAG          CLEAR FIRST TIME FLAG FOR DUPLICATES
         TBM       3,FLAG          CHECK FLAG FOR SINGLE ALOCATION
         BNS       DU01            NO SKIP
         SBM       7,FLAG          SET ALLOCATED FLAG
         BS        DU02            YES ALLOCATED
DU01     EQU       $
         LI        R7,X'31'        TOP OF FORM CONTROL CHAR
         STB       R7,SECNM        PUT IN MESSAGE TO LINE PRINTER
         M.ASSN    SLORRS          ALLOC SLO FILE
         BS        ALOCERR         SKIP ON ERROR
         M.OPENR   LINEPFCB
DU02     EQU       $
         TBM       2,FLAG          READ OR WRITE OCCURRED ON THIS UNIT ?
         BS        SECVALOK        YES, BRANCH (USE SECTOR NUM AS IS)
         LD        R6,UNKNOWN      USE 'UNKNOWN' IN PLACE OF SECTOR VALUE
         BU        SECOUT          SKIP CONVERSION
SECVALOK EQU       $
         LW        R5,SECNUM       GET CURRENT SECTOR NUMBER
         M.CONBAH                  CONVERT TO ASCII
         ANMW      R6,ZERTOBLK     CONV 2 MSB (BYTES) FROM ZERO TO BLANK
SECOUT   EQU       $
         STD       R6,SECDISP      PUT ASCII IN OUTPUT MESSAGE
         LW        R7,SECNMTCW     TCW FOR 'SECTOR NUMBER =' MESSAGE
         LA        R1,LINEPFCB     ADDR FOR LINE PRINTER FCB
         STW       R7,FCB.TCW,X1   PUT TCW IN FCB
         SVC       1,X'32'         WRITE TO LINE PRINTER
         ZR        R2              INITIALIZE OFFSET INTO HOLDING BUFFER
NEXTLINE EQU       $
         BL        CLRLINE         CLEAR THE OUTPUT LINE
         LA        R1,LINE         ADDR OF BUFF TO RECEIVE ASCII
         LA        R3,LINE+88      PART OF LINE CONTAINING DUMP ANNOTATION
         LI        R4,-8           TELL BILDLINE TO MAKE PRINTOUT 8 WIDE
         LW        R7,LPTCW        TCW TO OUTPUT ONE LINE TO LINE PRINTER
         BL        BILDLINE        BUILD ONE LINE OF DISPLAY FROM BUFF
         TBM       4,FLAG          IS SUPPRESSION FLAG SET ?
         BS        ENDTEST         YES, SKIP LINE PRINTER OUTPUT
         LA        R1,LINEPFCB     ADDR FOR LINE PRINTER FCB
         STW       R7,FCB.TCW,X1   PUT TCW IN FCB
         SVC       1,X'32'         WRITE TO SLO
ENDTEST  CAMW      R2,BUFFSIZE     HIT THE END OF BUFFER ?
         BLT       NEXTLINE        NO, GO BACK TILL DONE
         TBM       3,FLAG          CHECK FOR NO DASSIGN
         BS        DUMPRTRN
         M.DASN    SLORRSP         DEASSSN SLO FILE
DUMPRTRN BU        *SAVER0         RETURN
ALOCERR  LW        R7,ALOERTCW     TCW FOR SLO ALLOCATION PROBLEM
         BL        OPCOM1          SEND ERROR MESSAGE TO OPERATOR
         BU        *SAVER0         RETURN
         SPACE     2
************************************************************************
*               SUBROUTINE   EXAMINE
************************************************************************
*   THIS ROUTINE DISPLAYS THE CONTENTS OF THE HOLDING BUFFER A WORD
*   AT A TIME AND ALLOWS THE USER TO MODIFY IT, IF DESIRED. THIS COMMAND
*   HAS AN OPTIONAL ARGUMENT SPECIFYING WHICH BUFFER WORD TO START WITH.
*
*   INPUT REGS--  NONE
*
*   OUTPUT REGS-- NONE
************************************************************************
EXAMINE  EQU       $
         STW       R0,SAVER0       SAVE R0
         M.TSCAN                   GET BUFF LOCATION, IF ANY INPUT
         TRR       R5,R3           ASSUME NO ARGUMENT
         BEQ       DISPWORD        IF NO ARGUMENT, BRANCH
         M.CONAHB                  CONVERT ARGUMENT TO BINARY
         TRR       R6,R6           BAD ARGUMENT INPUT ?
         BEQ       EXAMERR1        YES, INFORM OPER
         CAMW      R7,BUFFSIZE     IS ARGUMENT TO BIG?
         BGE       EXAMERR2        YES, BRANCH
         ZR        R6              CLEAR FOR UPCOMING DIVIDE
         DVI       R6,4            FORCE ADDRESS TO BE A
         MPI       R6,4                  MULTIPLE OF 4
         TRR       R7,R3           USE BUFFER OFFSET AS AN INDEX
DISPWORD EQU       $
         TRR       R3,R5           MOVE BUFFER OFFSET VALUE FOR CONV
         M.CONBAH                  CONV TO ASCII HEX
         STW       R7,EXADDR       PUT IN EXAMINE DISPLAY MESSAGE
         LW        R5,BUFF,X3      GET DATA VALUE AT THIS ADDR
         M.CONBAH                  CONV TO ASCII HEX
         STD       R6,EXVALU       PUT VALUE IN MESSAGE
         LI        R1,-4
DISP.1   EQU       $
         ZR        R4
         SLLD      R4,8
         CI        R4,G' '
         BLT       DISP.2
         CI        R4,X'7E'
         BLE       DISP.3
DISP.2   EQU       $
         LI        R4,G'_'
DISP.3   EQU       $
         STB       R4,DISPA+4,X1
         BIB       R1,DISP.1
DISPOUT  EQU       $
         LW        R7,EXDISTCW     TCW FOR EXAMINE DISPLAY
         LW        R6,EXINTCW
         BL        OPCOM2          DISPLAY ADDR & DATA, WAIT FOR NEW VALUE
         M.TSCAN                   GET CHANGE DATA, IF ANY
         TRR       R5,R5           ANY INPUT ?
         BEQ       CONTEXAM        NO, NO CHANGE DATA, GO TO NEXT ADDR
         LW        R6,FLAG+1W      GET DATA
         LW        R7,FLAG+2W
         TRR       R6,R5           PRESERVE OPER INPUT DURING CHECKS
         SRL       R5,16           POSITION FIRST TWO CHARS FOR COMPARISON
         CI        R5,G'C"''       EQUAL TO "C'" ?
         BNE       CHECKX          NO, GO CHECK FOR 'X'
         SRLD      R6,16           YES, PUT ALL 4 ASCII BYTES IN SAME REG
         BU        NEWVAL          GO PUT NEW VALUE IN BUFF
CHECKX   EQU       $
         CI        R5,X'5820'      EQUAL TO 'X ' ?
         BEQ       *SAVER0         YES, RETURN
         M.CONAHB                  NO, CONVERT TO BINARY
         TRR       R6,R6           VALID NUMERIC INPUT ?
         BNE       NEWVAL          YES, GO USE IT
         LW        R7,BADATTCW     TCW FOR BAD DATA MESSAGE
         BL        OPCOM1          SEND MESSAGE TO 'UT'
         BU        DISPOUT         GIVE HIM ANOTHER CHANCE
NEWVAL   EQU       $
         STW       R7,BUFF,X3      REPLACE VALUE IN BUFF
CONTEXAM EQU       $
         ABR       R3,29           INCR BUFF INDEX TO NEXT FULL WORD
         CAMW      R3,BUFFSIZE     HIT END OF BUFFER ?
         BLT       DISPWORD        NO, GO BACK AND DO NEXT LOC IN BUFFER
EXAMERR1 EQU       $
         LW        R7,INVADTCW     TCW FOR INVALID ADDRESS MESSAGE
         BL        OPCOM1          SEND MESSAGE TO 'UT'
         BU        *SAVER0         RETURN
EXAMERR2 EQU       $
         LW        R7,TOBIGTCW     TCW FOR ADDRESS TO BIG MESSAGE
         BL        OPCOM1          SEND MESSAGE TO 'UT'
         BU        *SAVER0         RETURN
         SPACE     2
************************************************************************
*              SUBROUTINE    FILL
************************************************************************
*   THIS ROUTINE ALLOWS THE USER TO FILL THE HOLDING BUFFER WITH ANY
*   BIT PATTERN DESIRED. THE ARGUMENT CONSISTS OF 1 TO 8 NUMERIC HEX
*   DIGITS (1,2FC,FFFFFFFF, ETC.) OR UP TO 4 ALPHA CHARACTERS
*   PROCEEDED BY "C'"(C'ABCD,C'XY, ETC.)
*
*   INPUT REGS--  NONE
*
*   OUTPUT REGS-- NONE
************************************************************************
FILL     EQU       $
         STW       R0,SAVER0       SAVE R0
         M.TSCAN                   GET THE FILL VALUE
         ZR        R3              ZERO FOR STORE INDEX
         TRR       R5,R7           DID OPER INPUT AN ARGUMENT ?
         BEQ       FILLOOP         NO FILL WITH ZEROS
         LW        R6,FLAG+1W      GET INPUT
         LW        R7,FLAG+2W
         TRR       R6,R5           PRESERVE INPUT DURING CHECKS
         SRL       R5,16           POSITION FIRST TWO CHARS FOR COMPARISON
         CI        R5,X'4327'      EQUAL TO "C'" ?
         BNE       FILLCONV        NO, GO DO CONVERSION
         SRLD      R6,16           YES, MOVE ALL 4 ASCII BYTES TO ONE REG
         BU        FILLOOP         GO STRAIGHT TO FILL LOOP
FILLCONV EQU       $
         M.CONAHB                  CONV INPUT TO HEX
         TRR       R6,R6           VALID NUMERIC INPUT ?
         BEQ       FILLERR1        NO, INFORM OPER
FILLOOP  EQU       $
         STW       R7,BUFF,X3      PUT FILL VALUE IN BUFF
         ABR       R3,29           INCR INDEX TO NEXT WORD IN BUFF
         CAMW      R3,BUFFSIZE     HIT END OF BUFFER ?
         BNE       FILLOOP         NO, GO FILL SOME MORE
         ZBM       2,FLAG          CLEAR READ OR WRITE DONE FLAG
         BU        *SAVER0         RETURN
FILLERR1 EQU       $
         LW        R7,BADATTCW     TCW FOR BAD DATA MESSAGE
         BL        OPCOM1          SEND MESSAGE TO 'UT'
         BU        *SAVER0         RETURN
         SPACE     2
************************************************************************
*              SUBROUTINE    READ (AND WRITE)
************************************************************************
*   THIS ROUTINE READS FROM DISK INTO THE HOLDING BUFFER (OR WRITES TO
*   THE DISK FROM THE BUFFER). THIS COMMAND REQUIRES ONE ARGUMENT
*   (IN HEX) TO SPECIFY THE DESIRED SECTOR.
*
*   INPUT REGS--  NONE
*
*   OUTPUT REGS-- NONE
************************************************************************
READ     EQU       $
         ZBM       1,FLAG          CLEAR READ/WRITE FLAG (0=READ)
         BU        COMMON          GO TO COMMON LOGIC
WRITE    EQU       $
         SBM       1,FLAG          SET READ/WRITE FLAG (1=WRITE)
COMMON   EQU       $
         STW       R0,SAVER0       SAVE R0
         TBM       0,FLAG          HAS A DISK BEEN SELECTED ?
         BNS       IOERR4          NO, INFORM OPERATOR
         M.TSCAN                   GET ARGUMENT (SECTOR NUMBER)
         TRR       R5,R5           DID OPERATOR SUPPLY AN ARGUMENT ?
         BEQ       IOERR1          NO, TELL OPERATOR TO MEND HIS WAYS
         TRR       R6,R5           PRESERVE OPERATOR INPUT DURING CHECKS
         SLC       R5,8            POSITION FIRST CHAR OF ARGUMENT
         ANMW      R5,SAVELSB      ISOLATE LEAST SIG BYTE
         LW        R4,SECNUM       GET CURRENT SECTOR VALUE
         CI        R5,X'4E'        FIRST CHAR OF INPUT EQUAL TO 'N' ?
         BNE       CKSAME          NO, GO CHECK FOR 'S'
         ADMW      R4,SECTINCR     INCR SECTOR NUM TO NEXT VAL (SEC OR TRK
         BU        SETSECNM        GO STORE NEW SECTOR VALUE
CKSAME   EQU       $
         CI        R5,X'53'        EQUAL TO 'S' ?
         BEQ       SETSECNM        GO STORE NEW SECTOR VALUE
         CI        R5,X'4C'        EQUAL TO 'L' ?
         BNE       RDWRCONV        NO, GO CONV INPUT
         SUMW      R4,SECTINCR     YES, BACK UP SECTOR VAL (SEC OR TRACK)
SETSECNM EQU       $
         TRR       R4,R7           NEED NEW SECTOR MOVED FOR LIMIT CHECKS
         BU        READTEST        GO VALIDATE NEW SECTOR VALUE
RDWRCONV EQU       $
         M.CONAHB                  CONV ASCII INPUT TO HEX
         TRR       R6,R6           VALID NUMERIC INPUT ?
         BEQ       IOERR2          NO, TELL OPERATOR
READTEST EQU       $
         CAMW      R7,ENDOFDSK     IS SECTOR VAL TOO BIG FOR THIS DISK ?
         BGE       IOERR3          YES, GO INFORM OPERATOR
         TRR       R7,R7           IS SECTOR VALUE BELOW ZERO ?
         BLT       IOERR3          YES, INFORM OPERATOR
         STW       R7,SECNUM       REPLACE OLD SECTOR VAL WITH NEW
         LA        R1,DISKFCB      ADDR OF DISK I/O FCB
         STW       R7,FCB.ERAA,X1  PUT NEW RANDOM ACCESS SECTOR IN FCB
         TBM       1,FLAG          ARE WE DOING A READ ?
         BS        DOWRITE         NO, BRANCH
         SVC       1,X'31'         DO A READ
         BU        CHEKSTAT        GO CHECK I/O STATUS
DOWRITE  EQU       $
         SVC       1,X'32'         DO A WRITE
CHEKSTAT EQU       $
         BL        STATCHEK        CHECK I/O STATUS
         BU        *SAVER0         RETURN
IOERR1   EQU       $
         LW        R7,NOADDTCW     TCW FOR NO ADDRESS SPECIFIED
         BU        ERRCOM          GO TO COMMON ERROR LOGIC
IOERR2   EQU       $
         LW        R7,INVADTCW     TCW FOR INVALID ADDRESS MESSAGE
         BU        ERRCOM          GO TO COMMON ERROR LOGIC
IOERR3   EQU       $
         LW        R7,TOBIGTCW     TCW FOR ADDR IS TOO BIG MESSAGE
         BU        ERRCOM          GO TO COMMON ERROR LOGIC
IOERR4   EQU       $
         LW        R7,NODSKTCW     TCW FOR NO DISK SPECIFIED MESSAGE
         BU        ERRCOM          GO TO COMMON ERROR LOGIC
IOERR5   EQU       $
         LW        R7,NOSIZTCW     TCW FOR NO SIZE SPECIFIED MESSAGE
         BU        ERRCOM          GO TO COMMON ERROR LOGIC
IOERR6   EQU       $
         LW        R7,INVSZTCW     TCW FOR INVALID SIZE MESSAGE
         BU        ERRCOM          GO TO COMMON ERROR LOGIC
IOERR7   EQU       $
         LW        R7,INVSNTCW     TCW FOR NEGATIVE SIZE MESSAGE
ERRCOM   EQU       $
         BL        OPCOM1          SEND MESSAGE TO 'UT'
         BU        *SAVER0         RETURN
         SPACE     2
************************************************************************
*              SUBROUTINE    SECTOR (TRACK)
************************************************************************
*   THIS ROUTINE CONTROLS THE LENGTH OF I/O OPERATIONS (SECTOR OR TRACK)
*   AND UPDATES INFO FOR STATUS MESSAGES.
*
*   INPUT REGS--  NONE
*
*   OUTPUT REGS-- NONE
************************************************************************
SECTOR   EQU       $
         LW        R3,SECSNDSK     NUMBER OF SECTORS ON WHOLE DISK
         LD        R4,SECT         ASCII FOR 'SECTOR'
         LI        R6,1            NUMBER OF SECTORS PER I/O
         LW        R7,SECTSIZE     NUMBER OF BYTES IN ONE SECTOR
         BU        STOREVAL        GO SET BUFFSIZE
TRACK    EQU       $
         LW        R3,SECSNDSK     NUMBER OF SECTORS ON WHOLE DISK
         SUMW      R3,SECSNTRK     BACK UP ONE TRACK
         ABR       R3,31           MAKE END OF DSK 1 PAST STRT OF LAST TRK
         LD        R4,TRAC         ASCII FOR 'TRACK'
         LW        R6,SECSNTRK     NUMBER OF SECTORS PER I/O
         LW        R7,TRAKSIZE     NUMBER OF BYTES IN ONE TRACK
STOREVAL EQU       $
         STW       R3,ENDOFDSK     STORE VALUE FOR END OF DISK TEST
         STD       R4,STATUS3      PUT I/O MODE IN STATUS MESSAGE
         STW       R6,SECTINCR     SET SECTOR INCREMENT TO PROPER VALUE
         STW       R7,BUFFSIZE     SET BUFFSIZE TO PROPER MODE
         LA        R1,DISKFCB      ADDR OF DISK I/O FCB
         STW       R7,FCB.EQTY,X1  PUT BYTE COUNT IN FCB
         TRSW      R0              RETURN
         NOP
         SPACE     2
         SPACE     2
************************************************************************
*              SUBROUTINE  SETSEC 
************************************************************************
*   THIS ROUTINE CONTROLS THE LENGTH OF I/O OPERATIONS FOR SECTOR
*
*   INPUT REGS--  NONE
*
*   OUTPUT REGS-- NONE
************************************************************************
SETSEC   EQU       $
         STW       R0,SAVER0       SAVE R0
         M.TSCAN                   GET ARGUMENT (SECTOR NUMBER)
         TRR       R5,R5           DID OPERATOR SUPPLY AN ARGUMENT ?
         BEQ       IOERR5          NO, TELL OPERATOR TO MEND HIS WAYS
         M.CONADB                  CONV ASCII DECIMAL INPUT TO HEX
         TRR       R6,R6           VALID NUMERIC INPUT ?
         BEQ       IOERR6          NO, TELL OPERATOR
         TRR       R7,R7           IS SECTOR VALUE BELOW ZERO ?
         BLT       IOERR7          YES, INFORM OPERATOR
         STW       R7,SECTSIZE     REPLACE OLD SECTOR VAL WITH NEW
         STW       R7,BUFFSIZE     USE THIS LENGTH
         BU        *SAVER0         RETURN
         SPACE     2
************************************************************************
*               SUBROUTINE CHECK
************************************************************************
*   THIS ROUTINE READ DISK FROM INPUT START SECTOR TO INPUT END SECTOR
*
*   INPUT REGS--  NONE
*
*   OUTPUT REGS-- NONE
************************************************************************
CHECK    EQU       $                                           061692RLW
         STW       R0,SAVER0       SAVE RETURN ADDRESS         061692RLW
         TBM       0,FLAG          HAS A DISK BEEN SELECTED ?  061692RLW
         BNS       IOERR4          NO, INFORM OPERATOR         061692RLW
         LA        R1,DISKFCB      GET DISK FCB ADDRESS        061692RLW
         LW        R3,FCB.EQTY,X1  SAVE TRANSFERR QUANTY       061692RLW
         M.TSCAN                   GET START SECTOR ADDRESS    061692RLW
         TRR       R5,R5           ANY INPUT                   061692RLW
         BEQ       IOERR1          NO ERROR                    061692RLW
         TRR       R6,R5                                       061692RLW
         SRL       R5,24           GET FIRST CHARACTER         061692RLW
         CI        R5,G'S'         CHECK FOR START             061692RLW
         BNE       CH.01           NO SKIP                     061692RLW
         ZR        R7              YES SET TO ZERO             061692RLW
         BU        CH.02                                       061692RLW
CH.01    EQU       $                                           061692RLW
         CI        R5,G'A'         CHECK FOR ALL               061692RLW
         BEQ       CH.20           YES SKIP                    061692RLW
         M.CONAHB                  CONVERT TO BINARY           061692RLW
         TRR       R6,R6           CHECK FOR ERROR             061692RLW
         BEQ       IOERR1          YES SKIP                    061692RLW
CH.02    EQU       $                                           061692RLW
         STW       R7,STSEC        SAVE STARTING SECTOR ADDRESS061692RLW
         M.TSCAN                   GET ENDING SECTOR ADDRESS   061692RLW
         TRR       R5,R5           ANY INPUT                   061692RLW
         BEQ       IOERR1          NO ERROR                    061692RLW
         TRR       R6,R5                                       061692RLW
         SRL       R5,24           GET FIRST CHARACTER         061692RLW
         CI        R5,G'E'         CHECK FOR END               061692RLW
         BNE       CH.03           NO SKIP                     061692RLW
         LW        R7,SECSNDSK     GET ENDING SECTOR OF DISK   061692RLW
         BU        CH.04                                       061692RLW
CH.03    EQU       $                                           061692RLW
         M.CONAHB                  CONVERT TO BINARY           061692RLW
         TRR       R6,R6           CHECK FOR ERROR             061692RLW
         BEQ       IOERR1          YES SKIP                    061692RLW
         CAMW      R7,STSEC        CHECK IF SECOND ARG LESS    070792RLW
         BGT       CH.04           THAN START SECTOR NUMBER    070792RLW
         ADMW      R7,STSEC        YES ADD START SEC NO        070792RLW
CH.04    EQU       $                                           061692RLW
         STW       R7,SPSEC        SAVE STOP SECTOR ADDRESS    061692RLW
         ZR        R6                                          061692RLW
         LW        R7,STSEC        GET STARTING SECTOR ADDRESS 061692RLW
         STW       R7,FCB.ERAA,X1  PUT IN FCB                  061692RLW
         DVMW      R6,SECSNTRK     DEVIDE BY SECTORS PER TRK   061692RLW
         TRR       R6,R5           REMAINDER                   061692RLW
         BEQ       CH.07           NONE SKIP                   061692RLW
         SUMW      R5,SECSNTRK                                 061692RLW
         LW        R7,SECTSIZE     GET BYTES PER SECTOR        061692RLW
         STW       R7,FCB.EQTY,X1  PUT IN FCB                  061692RLW
CH.06    EQU       $                                           061692RLW
         SVC       1,X'31'         READ                        061692RLW
         BL        STATCHEK        GO CHECK STATUS             061692RLW
         ABM       31,FCB.ERAA,X1  INCRMENT SECTOR ADDRESS     061692RLW
         BIB       R5,CH.06        LOOP TO END OF TRK          061692RLW
CH.07    EQU       $                                           061692RLW
         LW        R7,TRAKSIZE     GET BYTES PER TRACK         061692RLW
         STW       R7,FCB.EQTY,X1  PUT IN FCB                  061692RLW
         LW        R6,SECSNTRK     GET SECTORS PER TRACK       061692RLW
CH.08    EQU       $                                           061692RLW
         SVC       1,X'31'         READ                        061692RLW
         BL        STATCHEK        GO CHECK STATUS             061692RLW
         LW        R7,FCB.ERAA,X1  GET CURRENT SECTOR ADDR     061692RLW
         ADR       R6,R7           INCRMENT TO NEXT TRACK      061692RLW
         STW       R7,FCB.ERAA,X1  PUT IN FCB                  061692RLW
         CAMW      R7,SPSEC        CHECK FOR END               061692RLW
         BLT       CH.08           NO LOOP                     061692RLW
         STW       R3,FCB.EQTY,X1  RESTORE QUANITY             061692RLW
         BU        *SAVER0         RETURN                      061692RLW
CH.20    EQU       $                                           061692RLW
         ZMW       FCB.ERAA,X1     CLEAR STARTING SECTOR       061692RLW
         LW        R7,SECSNDSK     GET TOTAL NUMBER OF SECTORS 061692RLW
         STW       R7,SPSEC        SAVE                        061692RLW
         BU        CH.07                                       061692RLW
         SPACE     2
************************************************************************
*               SUBROUTINE  UNIT
************************************************************************
*   THIS ROUTINE VALIDATES THE DISK DRIVE ARGUMENT AND IF IT IS
*   OK, A FILE THE SIZE OF THE WHOLE DISK IS ALLOCATED AND OPENED.
*
*   INPUT REGS--  NONE
*
*   OUTPUT REGS-- NONE
************************************************************************
UNIT     EQU       $
         STW       R0,SAVER0       SAVE R0
         M.TSCAN                   GET UNIT ARGUMENT
         TRR       R5,R5           ARGUMENT PRESENT ?
         BEQ       UNITERR         NO, TELL OPERATOR
         STW       R6,UNITASCI     SAVE ASCII FOR UNIT
         M.CONAHB                  CONVERT ASCII TO HEX BINARY
         TRR       R6,R6           VALID NUMERIC INPUT ?
         BEQ       UNITERR         NO, TELL OPERATOR
         LW        R3,C.UDTA       ADDR OF FIRST UDT
         LNH       R4,C.UDTN       NUMBER OF UDTS LINKED TO SYSTEM
UDTCHECK EQU       $
         CAMH      R7,UDT.CHAN,X3  SEE IF OPER INPUT MATCHES CHAN & SUBADD
         BEQ       UDTMATCH        YES, GO DO FURTHER CHECKS
         ADI       R3,UDT.SIZE     ADJUST POINTER TO NEXT UDT
         BIB       R4,UDTCHECK     GO BACK TILL NO MORE UDTS
UNITERR  EQU       $
         LW        R7,INVALTCW     TCW FOR INVALID DEVICE
ASSIGNER EQU       $
         BL        OPCOM1          SEND MESSAGE TO OPERATOR
         BU        *SAVER0         RETURN
UDTMATCH EQU       $
         SBR       R7,16
         STH       R7,DISKRRS1+9H
         TBM       UDT.ONLI,UDT.STAT,X3
         BNS       OFFLINE         UNIT IS OFFLINE
         LB        R6,UDT.DTC,X3   GET DEVICE TYPE FROM UDT
         BEQ       UNITERR         LESS THAN 1 ?
         CI        R6,3            DISKS HAVE CODES 1 TO 3 INCLUSIVE
         BGT       UNITERR         IF NOT A DISK BRANCH
         LH        R7,UDT.UDTI,X3  GET ASSOCIATED UDT INDEX
         STW       R7,UDTI         STORE AWAY FOR ALLOCATION
         LW        R7,UDT.SECS,X3  TOTAL NUMBER OF SECTORS ON THIS DISK
         BNE       NOINIT          SKIP IF ALREADY INITIALIZED 032991RLW
         SRLD      R6,8            DEVICE TYPE CODE TO BYTE 0  032991RLW
         SBR       R7,0                                        032991RLW
         ORMH      R7,DISKRRS1+9H  OR IN DEVICE ADDRESS        032991RLW
         SBM       2,AUTOFLAG      SET FLAG FOR AUTODISK       032991RLW
         BL        AUTODISK        GET DISK INFORMATION        032991RLW
         BNS       DISKOK          GOOD RETURN                 041296RLW
         LI        R7,512          SET SECTOR SIZE TO 512      041296RLW
         STW       R7,SECTSIZE                                 041296RLW
         LW        R7,NOSEC512                                 041296RLW
         STW       R7,UDT.SECS,X3  SET UP UDT                  041296RLW
DISKOK   EQU       $                                           041296RLW
         LW        R7,UDT.SECS,X3  TOTAL NUMBER OF SEDTORS     032991RLW
NOINIT   EQU       $                                           032991RLW
         STW       R7,SECSNDSK     SAVE TOTAL SECTORS
         STW       R7,ENDOFDSK     SET END OF DISK SECTOR VALUE
***      LH        R7,UDT.SSIZ,X3  SIZE OF ONE SECTOR(IN WORDS) ON DISK
***      SLL       R7,2            NEED SIZE IN BYTES
***      STW       R7,SECTSIZE     SAVE SECTOR SIZE
         LW        R7,SECTSIZE     USE DEFAULT SECTOR SIZE     022196RLW
         LB        R5,UDT.SPT,X3   NUMBER OF SECTORS PER TRACK
         STW       R5,SECSNTRK     SAVE SECTORS PER TRACK
         MPR       R5,R6           CALCULATE TRACK SIZE IN BYTES
         STW       R7,TRAKSIZE     SAVE TRACK SIZE
         LH        R7,UDT.NHDS,X3  GET NUMBER OF HEADS         061192RLW
         MPR       R5,R6           GET NO. OF SECTORS PER CYL  061192RLW
         STW       R7,SECCYL       SAVE                        061192RLW
         LD        R4,STATUS3      GET CURRENT I/O MODE
         CAMD      R4,TRAC         EQUAL TO 'TRACK   ' ?
         BEQ       SETBUFSZ        YES, BRANCH
         LW        R7,SECTSIZE     NO, USE SECTOR SIZE FOR TRANSFER CNT
SETBUFSZ EQU       $
         STW       R7,BUFFSIZE     USE THIS UNIT'S LENGTHS
         SBM       0,FLAG          FIRST TIME TO PROCESS A UNIT COMMAND ?
         BNS       SKIPDEAL        YES, SKIP THE DEALLOCATE
         M.DASN    DISKRRSP        DEASSIGN DISK
SKIPDEAL EQU       $
         LW        R5,UDTI
         STB       R5,DISKRRS+RR.UDTI
         ZMW       DISKRRS+RR.STBLK
         LW        R7,SECSNDSK
         STW       R7,DISKRRS+RR.NBLKS
         M.ASSN    DISKRRS,IMEDCNP
         BNS       OKALOC
         M.ASSN    DISKRRS1,IMEDCNP
         BNS       OKALOC
         LW        R7,ASSERTCW     ASSIGN ERROR TCW
         BU        ASSIGNER
OKALOC   EQU       $
         M.OPENR   DISKFCB,IMEDCNP
         LW        R7,BUFFSIZE     GET SIZE OF TRANSFERS DESIRED
         STW       R7,FCB.EQTY,X1  PUT TRANSFER COUNT IN FCB
         LW        R7,UNITASCI     ASCII FOR NEW UNIT JUST SELECTED
         STW       R7,STATUS1      PUT IT IN STATUS MESSAGE
         STW       R7,SECUNIT      PUT IT IN DISPLAY AND DUMP HEADER
         ZBM       2,FLAG          CLEAR READ OR WRITE DONE FLAG
         BU        *SAVER0         RETURN
OFFLINE  EQU       $
         LW        R7,OFFTCW       GET OFFLINE MESSAGE TCW
         BU        ASSIGNERR
         SPACE     2
************************************************************************
*              SUBROUTINE    STATUS
************************************************************************
*   THIS ROUTINE DISPLAYS STATUS FOR THE USER. INFO CONSISTS OF CURRENT
*   DISK UNIT, CURRENT SECTOR VALUE AND CURRENT I/O MODE.
*
*   INPUT REGS--  NONE
*
*   OUTPUT REGS-- NONE
************************************************************************
STATUS   EQU       $
         STW       R0,SAVER0       SAVE R0
         TBM       0,FLAG          CHECK FOR DISK ASSIGNED
         BNS       STAT.EX         NO SKIP
         LA        R1,DISKFCB      GET ADDRESS OF DISK FCB
         BL        SKIPINOP        GO READ STATUS FROM DISK
STAT.EX  EQU       $
         BU        *SAVER0         RETURN
         PAGE
************************************************************************
*               SUBROUTINE  EXIT
************************************************************************
*   THIS ROUTINE CLOSES AND DEALLOCATES THE TEMPORARY DISK FILE, THEN
*   EXITS.
*
*   INPUT REGS--  NONE
*
*   REGISTERS MODIFIED-- R1,R2,R5,R7
*
*   OUTPUT REGS-- NONE
************************************************************************
EXIT     EQU       $
         TBM       0,FLAG          IS ANY DISK UNIT ACTIVE ?
         BNS       WEGONE          NO, SKIP DEALLOCATION
         M.DASN    DISKRRSP        DEASSIGN DISK
WEGONE   EQU       $
         M.EXIT                    EXIT
         SPACE     2
************************************************************************
*               SUBROUTINE  HELP
************************************************************************
*   THIS ROUTINE DISPLAYS ALL THE AVAILABLE COMMANDS TO THE USER.
*
*   INPUT REGS--  NONE
*
*   OUTPUT REGS-- NONE
************************************************************************
HELP     EQU       $
         STW       R0,SAVER0       SAVE R0
         LW        R4,TCWMASK      MASK TO CLEAR 12 MSBS
         LA        R5,HELPEND      ADDR OF END OF HELP MESSAGE
         LW        R7,HELPTCW      TCW FOR HELP MESSAGES
HELPOUT  EQU       $
         BL        OPCOM1          SEND ONE LINE OF HELP INFO TO 'UT'
         ADI       R7,80           INCR BUFFER ADDR BY ONE LINE
         TRRM      R7,R6           MOVE ADDR PART OF TCW
         CAR       R5,R6           RUN OUT OF HELP INFO ?
         BLT       HELPOUT         NO, KEEP SHOVELING IT OUT
         BU        *SAVER0         RETURN
         PAGE
************************************************************************
*               SUBROUTINE  BILDLINE
************************************************************************
*   THIS ROUTINE BUILDS AN OUTPUT LINE OF CHARACTERS FROM THE CONTENTS
*   OF THE HOLDING BUFFER. THE CALLING ROUTINE SPECIFIES THE NUMBER OF
*   COLUMNS AND IF THE OUTPUT IS FOR THE LINE PRINTER, SUPPRESSION OF
*   DUPLICATE DATA IS PROVIDED.
*
*   INPUT REGS--  R2 = OFFSET INTO HOLDING BUFFER
*                 R4 = NUMBER OF COLUMNS TO BUILD
*
*   REGISTERS MODIFIED-- NONE
*
*   OUTPUT REGS-- R2 = UPDATED OFFSET INTO HOLDING BUFFER
************************************************************************
BILDLINE EQU       $
         STF       R0,SAVEF1       SAVE ALL REGS
         STW       R4,NUMCOLS      SAVE NUMBER OF COLS OF DUMP FOR LATER
         TRN       R4,R4           MAKE POSITIVE
         TRR       R2,R5           GET CURRENT OFFSET IN BUFFER
         STB       R4,SAMECHK      SAVE
         M.CONBAH                  CONV TO ASCII
         STW       R7,0,X1         PUT ASCII FOR BUFF OFFSET IN OUT LINE
GETNXTWD EQU       $
         LW        R5,BUFF,X2      GET A DATA WORD FROM HOLDING BUFFER
         CAMW      R5,BUFF-1W,X2   EQUAL TO LAST DATA WORD ?
         BNE       DATACONV        NO, DON'T INCR COUNTER
         ABM       7,SAMECNT       YES, KEEP TRACK OF DUPLICATES
DATACONV EQU       $
         M.CONBAH                  CONV TO ASCII HEX
         ADI       R1,6            ADJUST INDEX IN LINE BUFF 6 BYTES
         LI        R4,-4           SET COUNTER TO DO 1 WORD (4 BYTES)
STUFAWRD EQU       $
         SLC       R6,8            MOVE A CHAR TO LEAST SIG BYTE
         SLC       R7,8            MOVE A CHAR TO LEAST SIG BYTE
         STB       R6,0,X1         PUT CHAR IN OUT LINE
         STB       R7,4,X1         PUT CHAR IN OUT LINE
         LB        R5,BUFF,X2      GET A BYTE FROM SAME DATA WORD
         CI        R5,X'20'        VALUE LESS THAN PRINTABLE ASCII ?
         BLT       UNDRLINE        YES, SUBSTITUTE AN UNDERLINE CHAR
         CI        R5,X'7E'        VALUE GREATER THAN PRINTABLE ASCII ?
         BLE       OKCHAR          NO, IT'S OK
UNDRLINE EQU       $
         LI        R5,X'5F'        CODE FOR ASCII UNDERLINE
OKCHAR   EQU       $
         STB       R5,0,X3         PUT ASCII IN DUMP ANNOTATION AREA OF LI
         ABR       R1,31           ADJUST LINE INDEX BY 1 BYTE
         ABR       R2,31           ADJUST BUFF INDEX BY 1 BYTE
         ABR       R3,31           ADJUST ANNOTATION INDEX BY 1 BYTE
         BIB       R4,STUFAWRD     GO BACK TILL 1 WORD (4 BYTES) IS DONE
         ABM       31,NUMCOLS      INCR NUM OF COLUMNS TO DO
         BNE       GETNXTWD        IF HAVEN'T DONE ALL COLS, GO BACK
         LW        R6,SAVEF1+7W    GET TCW IN SAVED REGS
         TBM       6,FLAG          IS NO SUPPRESSION FLAG SET ?
         BS        BILDRTRN        YES, RETURN
         LB        R7,SAMECNT      GET DUPLICATE COUNT
         CAMB      R7,SAMECHK      WHOLE LINE OF SAME STUFF ?
         BEQ       SUPPTEST        YES, GO TO SUPPRESSION LOGIC
         ZBM       4,FLAG          CLEAR OUTPUT SUPPRESSION FLAG
         ZBM       5,FLAG          CLEAR FIRST TIME FLAG
         BU        BILDRTRN        RETURN
SUPPTEST EQU       $
         LW        R7,SAMETCW      TCW FOR ' **SAME** ' MESSAGE
         STW       R7,SAVEF1+7W    PUT TCW IN SAVED REGS FOR RETURN
         SBM       5,FLAG          SET FIRST TIME FLAG
         BNS       BILDRTRN        IF FIRST TIME, SKIP SUPPRESSION LOGIC
         SBM       4,FLAG          SET SUPPRESSION FLAG
BILDRTRN EQU       $
         ZMB       SAMECNT         RESET DUPLICATE COUNTER
         STW       R2,SAVEF1+2W    RETURN NEW BUFF INDEX TO CALLING ROUTIN
         CAMW      R2,BUFFSIZE     LAST WORD OF BUFF ?
         BLT       SKPSUPCL        NO, DON'T RESET SUPPRESSION FLAG
         ZBM       4,FLAG          CLEAR SUPPRESSION FLAG
         STW       R6,SAVEF1+7W    PUT TCW IN SAVED REGS FOR RETURN
SKPSUPCL EQU       $
         LF        R0,SAVEF1       RESTORE ALL REGS
         TRSW      R0              RETURN
         NOP
         SPACE     1
************************************************************************
*               SUBROUTINE  CLRLINE
************************************************************************
*   THIS ROUTINE FILLS THE OUTPUT LINE BUFFER WITH BLANKS.
*
*   INPUT REGS--  NONE
*
*   REGISTERS MODIFIED-- NONE
*
*   OUTPUT REGS-- NONE
************************************************************************
CLRLINE  EQU       $
         STF       R0,SAVEF1       SAVE ALL REGS
         LI        R3,-132         INIT COUNTER TO DO 132 BYTES
         LI        R7,X'20'        ASCII BLANK
STUFBLNK EQU       $
         STB       R7,LINE+132,X3  PUT A BLANK IN NEXT BYTE OF LINE BUF
         BIB       R3,STUFBLNK     INCR INDEX TILL 132 BLANKS ARE STUFFED
         LF        R0,SAVEF1       RESTORE ALL REGS
         TRSW      R0              RETURN
         SPACE     2
************************************************************************
*               SUBROUTINE  OPCOM1 AND OPCOM2
************************************************************************
*   OPCOM1 SENDS A MESSAGE (DEFINED BY THE INPUT TCW ARGUMENT)
*   TO THE OPERATOR.
*
*   OPCOM2 SENDS A MESSAGE (DEFINED BY THE INPUT TCW ARGUMENT)
*   TO THE OPERATOR AND WAITS FOR HIS REPLY.
*
*   INPUT REGS--  R7= TCW FOR A MESSAGE TO GO TO THE OPERATOR
*
*   REGISTERS MODIFIED-- R1,R7
*
*   OUTPUT REGS-- NONE
************************************************************************
OPCOM1   EQU       $
         LA        R1,OPCOMFCB     OPERATOR COMMUNICATION FCB (LFC = UT)
         STW       R7,FCB.TCW,X1   PUT TCW IN FCB
         SVC       1,X'32'         SEND MESSAGE TO OPERATOR ('UT')
         BU        OPCOMRTN        RETURN
OPCOM2   EQU       $
         LA        R1,OPCOMFCB     OPERATOR COMMUNICATION FCB (LFC = UT)
         STW       R7,FCB.TCW,X1   PUT TCW IN FCB
         SVC       1,X'32'         SEND MESSAGE TO OPERATOR ('UT')
         STW       R6,FCB.TCW,X1   PUT TCW IN FCB
         SVC       1,X'31'         READ FROM UT
OPCOMRTN EQU       $
         TRSW      R0              RETURN
         NOP
         SPACE     2
************************************************************************
*              SUBROUTINE    STATCHEK
************************************************************************
* THIS ROUTINE CHECKS FOR BAD STATUS FOLLOWING DISK I/O
* COMPLETION. IF STATUS IS BAD THEN A SENSE COMMAND IS SENT TO THE DISK
* PROCESSOR TO OBTAIN DETAIL STATUS, WHICH IS PRESENTED TO THE OPERATOR
*
*   INPUT REGS--  R1 = ADDR OF ACTIVE FCB
*
*   REGISTERS MODIFIED--  NONE
*
*   OUTPUT REGS-- NONE
************************************************************************
STATCHEK EQU       $
         STW       R0,SAVEF1       SAVE R0
         TBM       1,FCB.SFLG,X1   ANY I/O ERROR ?
         BNS       NOERROR         NO, RETURN
         TBM       4,FCB.SFLG,X1   DEVICE INOPERABLE ?
         BNS       SKIPINOP        NO, SKIP INOP MESSAGE
         LW        R7,INOPTCW      TCW FOR DISK INOP MESSAGE
         BL        OPCOM1          SEND MESSAGE TO 'UT'
         BU        *SAVEF1         RETURN
SKIPINOP EQU       $
         STF       R0,SAVEF1       SAVE REGISTERS
         LD        R4,FCB.ERWA,X1  SAVE BUFFER ADDRESS AND BYTE COUNT
         LEAR      R7,SENSSTAR     ABSOLUTE ADDR OF WHERE TO PUT SENSE DAT
         LB        R6,SENSIOCD     SAVE OPCODE OUT OF SENSE IOCD
         STW       R7,SENSIOCD     PUT ABSOLUTE ADDR IN SENSE IOCD
         STB       R6,SENSIOCD     PUT OPCODE BACK
         LA        R7,SENSIOCD     GET SENSE IOCD ADDR
         STW       R7,FCB.ERWA,X1  PUT IT IN FCB
         SBM       2,FCB.GCFG,X1   SET PHYCIAL IOCD
         SVC       1,X'25'         GET SENSE DATA FROM DISK PROCESSOR
         ZBM       2,FCB.GCFG,X1
         STD       R4,FCB.ERWA,X1  RESTORE ORIGINAL BUFFER ADDR IN FCB
         LW        R5,SENSSTAR     GET SENSE STAR REG (CYL,TRK,SEC INFO)
         SVC       1,X'2B'         CONVERT TO ASCII HEX FOR DISPLAY
         STW       R6,BADSTAT1     PUT IT IN ERROR MESSAGE
         STW       R7,BADSTAT1+1W
         LW        R5,SENSSTAR+1W  GET SENSE BUFFER REG
         SVC       1,X'2B'         CONVERT TO ASCII HEX FOR DISPLAY
         STW       R6,BADSTAT2     PUT IT IN ERROR MESSAGE
         STW       R7,BADSTAT2+1W
         LW        R5,SENSSTAR+2W  GET SUBCHANNEL TARGET REGISTER
         SVC       1,X'2B'         CONVERT TO ASCII HEX FOR DISPLAY
         STW       R6,BADSTAT3     PUT IT IN ERROR MESSAGE
         STW       R7,BADSTAT3+1W
         LW        R5,SENSSTAR+3W  GET DRIVE ATTRIBUTE REGISTER
         SVC       1,X'2B'         CONVERT TO ASCII HEX FOR DISPLAY
         STW       R6,BADSTAT4     PUT IT IN ERROR MESSAGE
         TRR       R1,R2           SAVE FCB ADDRESS            061192RLW
         TBM       1,FCB.SFLG,X1   CHECK FOR ERROR
         BNS       STATONLY        NO SKIP
         LW        R7,BADSTTCW     TCW FOR CHAN PROG ERROR MESSAGE
         BL        OPCOM1          SEND MESSAGE TO 'UT'
STATONLY EQU       $
         LH        R5,SENSSTAR     GET CYL FIELD               061192RLW
         MPMW      R4,SECCYL                                   061192RLW
         LB        R7,SENSSTAR+1H  GET TRK FIELD               061192RLW
         MPMW      R6,SECSNTRK                                 061192RLW
         ADR       R7,R5                                       061192RLW
         ADMB      R5,SENSSTAR+3                               061192RLW
         TBM       1,FCB.SFLG,X2   CHECK FOR ERROR             061192RLW
         BS        NODEC           YES SKIP                    061192RLW
         TRR       R5,R5           CHECK FOR ZERO              061192RLW
         BEQ       NODEC                                       061192RLW
         SUI       R5,1            BACK UP ONE SECTOR          061192RLW
NODEC    EQU       $                                           061192RLW
         M.CONBAH                  CONVERT TO ASCII            061192RLW
         STD       R6,STATUS2      PUT SEC NUM IN STATUS MEG   061192RLW
         LW        R7,STATTCW      TCW FOR STATUS MESSAGE      061192RLW
         BL        OPCOM1          SEND STATUS MESSAGE TO 'UT' 061192RLW
         LW        R7,STATTCW1     GET TCW FOR STATUS MESSAGE
         BL        OPCOM1          OUTPUT MESSAGE
         LF        R0,SAVEF1       RESTORE REGISTERS           061692RLW
         BU        *SAVEF1         RETURN
NOERROR  EQU       $
         SBM       2,FLAG          SET READ OR WRITE DONE FLAG
         BU        *SAVEF1         RETURN
         PAGE
************************************************************************
*      DATA    DEFINITIONS
************************************************************************
         SPACE     1
SAVEF1   REZ       1F
OPCOMFCB GEN       32/G'UT ',224/0
DISKFCB  GEN       32/G'I/O',34/1,5/5,185/0,32/W(BUFF),224/0
DISKRRS  GEN       32/G'I/O',8/5,8/6,19/1,14/1,21/1,90/0
DISKRRS1 GEN       32/G'I/O',8/3,8/6,54/1,27/1,7/1,56/0
SLORRS   GEN       32/G'LPO',8/2,8/4,16/100,2/1,33/1,2/1,27/0
IMEDCNP  GEN       75/5,117/0
LINEPFCB GEN       32/G'LPO',12/DISPL,20/B(DISP),192/0
SECT     DATAD     C'SECTOR  '
TRAC     DATAD     C'TRACK   '
UNKNOWN  DATAD     C' UNKNOWN'
SAVER0   REZ       1W
DISKRRSP ACW       DISKRRS
SLORRSP  ACW       SLORRS
BUFFSIZE DATAW     768             USE STANDARD 192W SECTOR AS DEFAULT
NOSEC512 DATAW     4155984         NUMBER OF SECTORS WHEN USING 512 BYTES
BUFOFSET DATAW     0
CLRMSB   DATAW     X'FFFFFF'
CMDTABL  DATAW     G'CH'           CHECK DISK
         DATAW     G'DI'           DISPLAY HOLDING BUFF TO 'UT'
         DATAW     G'DU'           DUMP HOLDING BUFF TO LINE PRINTER
         DATAW     G'EX'           EXAMINE CONTENTS OF HOLDING BUFFER
         DATAW     G'FI'           FILL HOLDING BUFFER WITH A BIT PATTERN
         DATAW     G'RE'           READ FROM DISK
         DATAW     G'SE'           SET SECTOR MODE (I/O IN SECTOR INCREMEN
         DATAW     G'ST'           DISPLAY STATUS TO 'UT'
         DATAW     G'TR'           SET TRACK MODE (I/O IN TRACK INCREMENT)
         DATAW     G'UN'           DEFINE DISK UNIT FOR I/O
         DATAW     G'WR'           WRITE TO DISK
         DATAW     G'SS'           SET SECTOR SIZE
         DATAW     G'X '           EXIT
         DATAW     G'? '           HELP INFO
CMDTABLL EQU       $-CMDTABL
CMDVECTR EQU       $
         ACH       CHECK
         ACH       DISPLAY
         ACH       DUMP
         ACH       EXAMINE
         ACH       FILL
         ACH       READ
         ACH       SECTOR
         ACH       STATUS
         ACH       TRACK
         ACH       UNIT
         ACH       WRITE
         ACH       SETSEC
         ACH       EXIT
         ACH       HELP
ENDOFDSK DATAW     0
NONE     DATAW     C'NONE'
NUMCOLS  DATAW     0
SAVELSB  DATAW     X'FF'
SAVESECT DATAW     0
SECNUM   DATAW     0
SECSNDSK DATAW     0
SECSNTRK DATAW     0
SECCYL   DATAW     0                                           061192RLW
SECTINCR DATAW     1
SECTSIZE DATAW     768                                         022196RLW
STSEC    DATAW     0                                           061692RLW
SPSEC    DATAW     0                                           061692RLW
SENSIOCD DATAW     X'04000000'      SENSE IOCD,  NO CC
         DATAW     X'0000000E'
SENSSTAR DATAW     0,0,0,0
TCWMASK  DATAW     X'7FFFF'
TRAKSIZE DATAW     0
UDTI     DATAW     0
UNITASCI DATAW     C'NONE'
ZERTOBLK DATAW     X'EFEFFFFF'
FLAG     DATAB     0               *FLAG BITS 0= UNIT SELECTED FLAG
*                                  *          1= READ/WRITE FLAG (0=READ
*                                  *          2= I/O OCCURRED ON UNIT
*                                  *          3= OPTION ONE FLAG
*                                  *          4= DUPLICATE LINE MODE
*                                  *          5= 1ST PASS OF DUPLIC MODE
*                                  *          6= NO SUPPRES OF DUPL LINE
*                                  *          7= SLO FILE ASSIGNED
OPIN     REZ       20
SAMECNT  DATAB     0
SAMECHK  DATAB     0
         BOUND     1W
ALOERTCW GEN       12/ALPROBL,20/B(ALPROB)
BADATTCW GEN       12/BADATAL,20/B(BADATA)
BADCMTCW GEN       12/BADCMDL,20/B(BADCMD)
BADSTTCW GEN       12/BADSTATL,20/B(BADSTAT)
CMDINTCW GEN       12/CMDINL,20/B(CMDIN)
DISPTCW  GEN       12/80,20/B(DISP)
EXDISTCW GEN       12/EXDISPL,20/B(EXDISP)
HELLOTCW GEN       12/HELLOL,20/B(HELLO)
HELPTCW  GEN       12/80,20/B(HELPMES)
INOPTCW  GEN       12/INOPL,20/B(INOP)
INVADTCW GEN       12/INVADL,20/B(INVAD)
INVALTCW GEN       12/INVALL,20/B(INVAL)
LPTCW    GEN       12/133,20/B(DISP)
NOADDTCW GEN       12/NOADDL,20/B(NOADD)
NODSKTCW GEN       12/NODSKL,20/B(NODSK)
NOSIZTCW GEN       12/NOSIZL,20/B(NOSIZ)
INVSZTCW GEN       12/INVSZL,20/B(INVSZ)
INVSNTCW GEN       12/INVSNL,20/B(INVSN)
OPINTCW  GEN       12/20,20/B(OPIN)
EXINTCW  GEN       12/17,20/B(FLAG+1W)
SAMETCW  GEN       12/SAMEL,20/B(SAME)
SECNMTCW GEN       12/SECNML,20/B(SECNM)
STATTCW  GEN       12/STATL,20/B(STAT)
TOBIGTCW GEN       12/TOBIGL,20/B(TOBIG)
ASSERTCW GEN       12/ASSERL,20/B(ASSER)
STATTCW1 GEN       12/STAT1L,20/B(STAT1)
OFFTCW   GEN       12/OFFML,20/B(OFFM)
ALPROB   DATAB     C'"M"JCAN NOT ALLOCATE SLO FILE.'
ALPROBL  EQU       $-ALPROB
ASSER    DATAB     C'"M"JERROR IN ASSIGNING DISK UNIT'
ASSERL   EQU       $-ASSER
BADATA   DATAB     C'"M"JBAD DATA VALUE'
BADATAL  EQU       $-BADATA
BADCMD   DATAB     C'"M"JINVALID COMMAND'
BADCMDL  EQU       $-BADCMD
OFFM     DATAB     C'"M"JDEVICE IS OFFLINE'
OFFML    EQU       $-OFFM
         BOUND     1D
BADSTAT  DATAB     C'"M"JDISK I/O ERROR OCCURRED'
BADSTATL EQU       $-BADSTAT
STAT1    DATAW     C'"M"J SENSE DATA = '
BADSTAT1 DATAW     0,0
         DATAW     C' '
BADSTAT2 DATAW     0,0
         DATAW     C' '
BADSTAT3 DATAW     0,0
         DATAW     C' '
BADSTAT4 DATAW     0
STAT1L   EQU       $-STAT1
CMDIN    DATAB     C'"M"JCOMMAND = '
CMDINL   EQU       $-CMDIN
         BOUND     1W
         DATAB     C'   '
DISP     DATAB     C' '
LINE     REZ       132
DISPL    EQU       $-DISP
         BOUND     1D
EXDISP   DATAB     C'   "M'
EXADDR   DATAB     C'      =  '
DISPA    DATAB     C'      =  "@"@'
EXVALU   DATAB     C'         =  '
EXDISPL  EQU       $-EXDISP
HELLO    DATAB     C'"M"JFOR A LIST OF COMMANDS, TYPE "'?"''
HELLOL   EQU       $-HELLO
         BOUND     1W
HELPMES  DATAB     C'"M"J               COMMAND SUMMARY            '
         DATAB     C'               ARGUMENTS IN HEX     '
         DATAB     C' "'CH"'    CHECK READ DISK                    '
         DATAB     C'      2  ARG- START,END OR S,E OR A '
         DATAB     C'                                            '
         DATAB     C'              OR START,NUMBER       '
         DATAB     C' "'DI"'    DISPLAYS HOLDING BUFFER TO CRT     '
         DATAB     C'      NO ARGUMENT                   '
         DATAB     C' "'DU"'    DUMP HOLDING BUFFER TO LINE PRINTER'
         DATAB     C'      NO ARG (ANY ARG MEANS NO SUPP)'
         DATAB     C' "'EX"'    EXAMINE CONTENTS OF HOLDING BUFFER '
         DATAB     C'      1  ARG- BUFFER ADDR (OPTIONAL)'
         DATAB     C' "'FI"'    FILL HOLDING BUFF WITH BIT PATTERN '
         DATAB     C'      1  ARG- FILL VALUE (OPTIONAL) '
         DATAB     C' "'RE"'    READ FROM DISK TO HOLDING BUFFER   '
         DATAB     C'      1  ARG- SECTOR VALUE OR N,L,S '
         DATAB     C' "'SE"'    SET SECTOR MODE (I/O IN SECTORS)   '
         DATAB     C'      NO ARG                        '
         DATAB     C' "'ST"'    DISPLAY STATUS TO CRT              '
         DATAB     C'      NO ARG                        '
         DATAB     C' "'TR"'    SET TRACK MODE  (I/O IN TRACKS)    '
         DATAB     C'      NO ARG                        '
         DATAB     C' "'UN"'    CHOOSE DISK UNIT FOR I/O           '
         DATAB     C'      1  ARG- DISK DRIVE ID         '
         DATAB     C' "'WR"'    WRITE TO DISK FROM HOLDING BUFFER  '
         DATAB     C'      1  ARG- SECTOR VALUE OR N,L,S '
         DATAB     C' "'SS"'    SET SECTOR SIZE                    '
         DATAB     C'      1  ARG- SECTOR SIZE IN DECMIAL'
         DATAB     C' "'X "'    EXIT                               '
         DATAB     C'      NO ARG                        '
         DATAB     C' "'? "'    DISPLAYS LIST OF COMMANDS          '
         DATAB     C'      NO ARG                        '
HELPEND  EQU       $
INOP     DATAB     C'"M"JDISK IS INOPERABLE.'
INOPL    EQU       $-INOP
INVAD    DATAB     C'"M"JINVALID ADDRESS'
INVADL   EQU       $-INVAD
INVAL    DATAB     C'"M"JINVALID DEVICE'
INVALL   EQU       $-INVAL
NOADD    DATAB     C'"M"JNO ADDRESS SPECIFIED'
NOADDL   EQU       $-NOADD
NODSK    DATAB     C'"M"JNO DISK SPECIFIED'
NODSKL   EQU       $-NODSK
NOSIZ    DATAB     C'"M"JNO SIZE SPECIFIED'
NOSIZL   EQU       $-NOSIZ
INVSZ    DATAB     C'"M"JINVALID SIZE VALUE'
INVSZL   EQU       $-INVSZ
INVSN    DATAB     C'"M"JSIZE ENTERED IS NEGATIVE'
INVSNL   EQU       $-INVSN
SAME     DATAB     C'    ** SAME **'
SAMEL    EQU       $-SAME
         BOUND     1D
SECNM    DATAB     C'1SECTOR NUMBER ='
SECDISP  DATAB     C'        '
         DATAB     C'     UNIT = '
SECUNIT  DATAB     C'NONE'
SECNML   EQU       $-SECNM
STAT     DATAB     C'"M"JUNIT= '
STATUS1  DATAB     C'NONE'
         DATAB     C'    SECTOR= '
STATUS2  DATAB     C' UNKNOWN'
         DATAB     C'      I/O MODE= '
STATUS3  DATAB     C'SECTOR  '
STATL    EQU       $-STAT
TOBIG    DATAB     C'"M"JADDRESS TOO BIG (OR BELOW ZERO), TRY AGAIN'
TOBIGL   EQU       $-TOBIG
*  FCB  DEFINITIONS
         BOUND     1W
         BOUND     1F
BUFF     REZ       8640W
         END       START
