 #ident	"@(#)Make:XXXX/Makefile	1.0"

# Make parameters when running on MPX

DISK1 = system
DISK2 = nasa3

ROOT = /system/system
TARGET = /system/system
SOURCE = .
PREFIX = nb
INCLUDE = /system/$(PREFIX)include
SINCLUDE = $(INCLUDE)
SYSTEM = @SYSTEM
SBIN = /system/system
BIN = /system/bin
UBIN = /system/bin
LIB = /system/bin
YBIN = /system/bin
CPP = $(LIB)/$(PREFIX)cpp
CPFLAGS = -M -I/NASA3/CHEADERS
CC = $(UBIN)/$(PREFIX)cc
CFLAGS = -G
FFLAGS = -G
LD = $(UBIN)/$(PREFIX)nbcat
LDFLAGS = -YSEDMAP
YACC = $(YBIN)/$(PREFIX)yacc
YFLAGS =
MAKEFILE = make.sed

OBJECTS = sedlib.o\
	buffin.o\
	sed.o

HDRS =

SRCS = sedlib.f\
	buffin.s\
	sed.f

MAIN = SED.E

ALL:	all

all:	$(MAIN)
	$(BIN)/echo $(MAIN) is Re-Built

$(MAIN):	$(MAKEFILE) $(OBJECTS)  objs
	$(CC) $(LDFLAGS)  -rsed.cat -of $(MAIN) $(OBJECTS) \
	-tobjs -K/SYSTEM/SYSTEM/NH -K/SYSTEM/SYSTEM/MPX
objs:
	$(BIN)/mkfile -b 5000 objs

CLEAN:  clean

clean:
	$(BIN)/rm -f $(OBJECTS)

CLEANALL:  cleanall

cleanall:
	$(BIN)/rm -f $(OBJECTS)
	$(BIN)/rm -f $(SRCS)

CLEANRAM:  cleanram

cleanram:
	$(BIN)/rm -f $(OBJECTS)
	$(BIN)/rm -f $(SRCS)
	$(BIN)/rm -f sed.cat
	$(BIN)/rm -f sed.com
	$(BIN)/rm -f $(MAKEFILE)

CLOBBER: clobber

clobber: clean
	$(BIN)/rm -f $(MAIN)

DEPEND: depend

depend: $(SRCS) $(HDRS) $(MAKEFILE)
	$(BIN)/dodep $(CPFLAGS) $(MAKEFILE) $(SRCS) >dep.out
	$(BIN)/mv dep.out $(MAKEFILE)

RAM:	ram

ram:
	@for i in $(SRCS); do \
	$(BIN)/co /nasa3/com_source/$$i;  \
	done;
	@for i in $(SRCS); do \
	$(BIN)/mv /nasa3/com_source/$$i /RAM/com_source/$$i; \
	done;
	$(BIN)/cp /nasa3/com_source/make.sed /RAM/com_source;
	$(BIN)/cp /nasa3/com_source/sed.cat /RAM/com_source;
	$(BIN)/cp /nasa3/com_source/sed.com /RAM/com_source;


LOCAL: local

local:
	$(BIN)/rm -f sedfiles sedrlog
	$(BIN)/mkfile -b 16 sedfiles sedrlog
	$(BIN)/echo $(BIN)/rm -f sedlist >sedrlog
	$(BIN)/echo $(BIN)/mkfile -b 16 sedlist >>sedrlog
	echo "\$$DEFM DRNUM" >>sedfiles;
	@for i in $(SRCS); do \
	$(BIN)/co -l /nasa3/com_Source/$$i;  \
	echo $(SYSTEM)"(BIN)"MV $$i /nasa3/com_Source/$$i >>sedfiles; \
	echo $(SYSTEM)"(BIN)"CI -m%DRNUM /nasa3/com_Source/$$i >>sedfiles; \
	echo $(BIN)/rlog $$i ">>"sedlist >>sedrlog ;\
	done;
	echo $(SYSTEM)"(BIN)"MV sedrlog /nasa3/com_Source/sedrlog >>sedfiles;
	$(BIN)/echo "\$$DELE MAKE.SED" >>sedfiles;
	$(BIN)/echo "\$$ENDM" >>sedfiles;
	@for i in $(SRCS); do \
	$(BIN)/mv /nasa3/com_source/$$i $$i; \
	done;
	$(BIN)/cp /nasa3/com_Source/sed.cat .;
	$(BIN)/cp /nasa3/com_Source/sed.com .;

INSTALL: install

install:
	$(BIN)/cp $(MAIN) /NASA3/SYSTEM
	$(BIN)/mv $(MAIN) /SYSTEM/SYSTEM
	$(BIN)/echo $(MAIN) Installed on NASA3

# DO NOT DELETE THIS LINE -- the dependencies begin here
