*~!fpsub.s*/
* Name:  fpsub.s Part No.: _______-____r
*
* Copyright 1992 - J B Systems, Morrison, CO
*
* The recipient of this product specifically agrees not to distribute,
* disclose, or disseminate in any way, to any one, nor use for its own
* benefit, or the benefit of others, any information contained  herein
* without the expressed written consent of J B Systems.
*
*                     RESTRICTED RIGHTS LEGEND
*
* Use, duplication, or disclosure by the Government is  subject  to
* restriction  as  set forth in paragraph (b) (3) (B) of the Rights
* in Technical Data and Computer Software  Clause  in  DAR  7-104.9
* (a).
*/
* #ident	"@(#)nbclib:fpsub.c	1.1"
*
*       Floating Point Subroutines
*
*       written by J. Bevier
*       08/24/90
*	revised by J. Bevier
*       02/21/92
*
*********************************************************************
*
        program         fpsubs
*
*       cvtif   - converts from int to float
*       input   r1 = value to be converted
*       output  r1 = converted value
*
        csect
cvtif   equ     $
        zbr     r0,2            clear neg value flag
        trr     r1,r1           is value zero
        bgt     posi            br if positive
        beq     zero            br if zero
        trn     r1,r1           reg is negative
        sbr     r0,2            set neg flag
posi    scz     r1,r2           count leading zeros
        srl     r1,1            backup by 1 bit
        sbr     r1,0            set sign bit
        tbr     r2,30           was count mod 2?
        bns     test1           br if not
        srl     r1,2            yes, two more zeros
test1   tbr     r2,31           was count odd?
        bns     test2           br if not
        srl     r1,1            yes, one more bit
test2   srl     r2,2            normalize radix
        sui     r2,72           excess 64 notation
        trn     r2,r2           make positive
        src     r2,8            position in first byte
        srl     r1,8            make room for FP number
        orr     r2,r1           put exp & fraction together
        tbr     r0,2            was input neg
        bns     zero            br if not
        trn     r1,r1           yes, make neg then
zero    trsw    r0              return        
*
*       cvtfi   - converts from float to int
*       input   r1 = value to be converted
*       output  r1 = converted value
*
cvtfi   zbr     r0,2            clear neg flag
        trr     r1,r1           what is data
        bgt     posf            br if positive
        bz      fzero           br if zero
        trn     r1,r1           make neg into pos
        sbr     r0,2            set neg flag
posf    xcr     r0,r2           need r0
        zr      r0              clear for shift
        slld    r0,8            get exp
        sui     r0,64           take off excess notation
        ble     fmin            br if very small
        sui     r0,8            see if in range
        bgt     max             br if too big
        trn     r0,r0           back to pos for shift count
        sll     r0,2            make shift count
        ormh    r0,srli         or in srl instr
        exrr    r0              do the shift
        tbr     r0,0            see if overflow to neg
        bs      max             br if yes
        tbr     r2,2            original val neg
        bns     dret            return if not
        trn     r1,r1           put back to neg
dret    trsw    r2              return
fzero   trsw    r0              return zero
min     zr      r1              return min of zero
        trsw    r2
max     li      r1,-1           get all ones
        zbr     r1,0            max pos value now
        trsw    r2              return
srli    srl     r1,0
*
*       cvtld   - converts from 64 bit int to double
*       cvtdl   - converts from double to 64 bit int
*       input   r6&r7 = value to be converted
*       output  r6&r7 = converted value
*
_l.zero  datad     0
allfs    datad     x'ffffffffffffffff'
*
cvtld    sbr       r0,4         this is long to double entry
         bu        beg          merge code
cvtdl    zbr       r0,4         this is double to long entry
beg      zbr       r0,2         clear neg flag
*
         trr       r6,r6        arg in r6, r7
         bgt       pos          number is positive
         blt       neg          number is negative
         trr       r7,r7        zero, is it all zero
         bz        zero         number is zero
         bu        pos          small positive number
neg      eomd      r6,allfs     negative number
         sumd      r6,allfs     make it positive
         sbr       r0,2         set neg flag
         trr       r6,r4        float part to r4
pos      tbr       r0,4         what are we doing
         bs        c.ld         go conv long to double
*
* convert double to long
* arg in r4, r7
*
c.dl     srl       r4,24        get just exponent in r4
         slld      r6,8         pure fraction
         sui       r4,64        remove excess 64 notation
         ble       dzero        too small, return zero
         sui       r4,16        see if in range
         bgt       dmax         too big, return max
         trn       r4,r4        make positive shift count
         sll       r4,2         r2 = 4 * (16 - exp)
         zbr       r4,26        see if shift count is >= 32
         bns       nos32        no, do double reg shift
         trr       r6,r7        yes, do trr to shift by 32 bits
         zr        r6           clear the shifted reg
nos32    ormh      r4,srldi     generate shift instruction
         exrr      r4           shift r6, r7
         tbr       r6,0         did we go negative, overflow
         bs        dmax         yes, set to max
tret     tbr       r0,2         see if input was negative
         bns       dret         br if not
         eomd      r6,allfs     was negative, put
         sumd      r6,allfs     back negative
dret     trsw      r0           return value
dzero    zr        r6           return zeros
         zr        r7
         bu        dret         get out
dmax     li        r6,-1        too big, return max
         trr       r6,r7        value of all 1's
         zbr       r6,0         less the sign bit
         bu        dret         get out
*
srldi    srld      r6,0
*
* convert long to double
* arg in r6, r7    (r4 == r6)
* arg > 0
*
c.ld     zr        r5           for exponent
         anmw      r4,=x'ff000000'  just get exponent
         beq       lda          br if space for exp
         srld      r6,8         very large, make room for exp
         li        r5,-2        set initial exponent
lda      trr       r6,r4        copy hi order part
         anmw      r4,=x'00f00000'  see if already normalized
         bne       ldd          br if normalized
         slld      r6,4         not yet, shift in next nibble
         abr       r5,31        add 1 more power of 16 to exp
         bu        lda          keep going until normalized
ldd      trn       r5,r5        prep for excess 64 notation
         adi       r5,x'4e'     make excess 64 exponent
         src       r5,8         put in hi order byte
         orr       r5,r6        merge with fraction
         bu        tret         see if we need to make neg & ret
         end
