/* Runtime library error when files opened in append mode */
/* i.e. fopen() */

/* spr6.c */
#include <stdio.h>

void main() {
      FILE *errlog;
      long num,i;

      if ((errlog=fopen("junk.lis","a"))==NULL) {
        fprintf(stderr,"??? Cant open errlog.\n");
        abort();
      }

      do {
        printf("#? ");
        scanf("%ld",&num);
        printf("using %ld\n",num);
        if (-1 == num)
          break;
        i = fprintf(errlog,"%ld\n",num);
        fprintf(stderr,"wrote %d chars.\n",i);
      } while (i);

      fclose(errlog);
}

/*
TSM>dele junk.lis
TSM>spr6
#? 1
using 1

wrote 2 chars.
#? 2
using 2
wrote 2 chars.
#? 3
using 3
wrote 2 chars.
#? 4
using 4
wrote 2 chars.
#? -1
using -1
 
TSM>spr6
#? 5
using 5

wrote 2 chars.
#? 6
using 6
wrote 2 chars.
#? 7
using 7
wrote 2 chars.
#? 8
using 8
wrote 2 chars.
#? -1
using -1
 
TSM>list junk.lis
1
2
3
*NOTE 4 is missing
5
6
7
8

*/

/* 
 * I was also able to duplicate the problem using the DCAT sample program.
 * Doing DCAT >file and then entering:
1
2
3
<CTRL>D
gives me a file with 1 2 and 3 in it. If I then do a DCAT >>file and
enter:
4
5
6
<CTRL>D
it gives me a file as 1 2 4 5 6 in it.
*/
/*
 * The problem is in the advance to EOF routine in the unixio.c
 * library function.  It was incorrectly testing the wrong bit
 * for the EOF marker, and would always backspace over the EOF
 * to the previous record instead of leaving the file positioned
 * at the EOF.  I have corrected unixio.c to fix this error.
 * There is not any workaround for the problem.
 */
