*       UNIX SIGNAL SIMULATION                18-NOV-86 HEADER  SIGNAL.S
************************************************************************
*
*        RESTRICTED RIGHTS LEGEND
*
*        USE, DUPLICATION, OR DISCLOSURE IS SUBJECT TO THE RESTRICTIONS
*        STATED IN ISC'S LICENSE AGREEMENT (FORM NO. 1218) OR, FOR
*        GOVERNMENT CUSTOMERS, DAR 7-104.9A.
*
************************************************************************
         SPACE     2
         PROGRAM   SIGNAL          FILE:  SIGNAL.S
         DEF       VER.SIGN
         DEF       PRG.SIGN
VER.SIGN EQU       X'A000'
PRG.SIGN EQU       X'3860'
************************************************************************
*                                                                      *
*                   SIGNAL  CHANGE HISTORY                             *
*                                                                      *
************************************************************************
*   VER       DATE      BY             DESCRIPTION.                    *
************************************************************************
*                                                                      *
*  A000      11/18/86   JCB           GENERATE INITIAL VERSION         *
*                                                                      *
************************************************************************
         SPACE      5
         LIST      ON,NOMAC,NOREP
************************************************************************
*        DEFINE ENTRIES                                                *
************************************************************************
         SPACE     2
         DEF       _signal         SIGNAL PROCESSING
         SPACE     2
************************************************************************
*   REGISTER EQUATES
************************************************************************
         SPACE     1
AP       EQU       1              ARGUMENT POINTER
X1       EQU       1
X2       EQU       2              GENERAL INDEX NUMBER 1
SP       EQU       3              STACK POINTER
X3       EQU       3
         SPACE     1
R0       EQU       0              GENERAL REGISTER EQUATES
R1       EQU       1
R2       EQU       2
R3       EQU       3
R4       EQU       4
R5       EQU       5
R6       EQU       6
R7       EQU       7
************************************************************************
*   SIGNAL EQUATES
************************************************************************
SIGHUP  EQU 1   /* hangup */
SIGINT  EQU 2   /* interrupt */
SIGQUIT EQU 3   /* quit */
SIGILL  EQU 4   /* illegal instruction (not reset when caught) */
SIGTRAP EQU 5   /* trace trap (not reset when caught) */
SIGIOT  EQU 6   /* IOT instruction */
SIGEMT  EQU 7   /* EMT instruction */
SIGFPE  EQU 8   /* floating point exception */
SIGKILL EQU 9   /* kill (cannot be caught or ignored) */
SIGBUS  EQU 10  /* bus error */
SIGSEGV EQU 11  /* segmentation violation */
SIGSYS  EQU 12  /* bad argument to system call */
SIGPIPE EQU 13  /* write on a pipe with no one to read it */
SIGALRM EQU 14  /* alarm clock */
SIGTERM EQU 15  /* software termination signal from kill */
NSIG    EQU     17      /* maximum signal number */
         PAGE
************************************************************************
*   LOCAL MACROS
************************************************************************
         SPACE     1
ENTER    DEFM
         TRR       SP,R1           STACK PTR FOR CALLING FUNCTION
         ADI       SP,-8W          DECREMENT SP FOR CALLED ROUTINE A001
         STD       R0,2W,SP        STORE RETURN ADDR IN STACK & PREV. SP
         STF       R4,4W,SP        STORE REGS 4 THROUGH 7 IN STACK
         LA        AP,8W,R1        PUT ARG AREA ADDR IN AP
         STW       SP,SPSAVE      SAVE STACK POINTER
         STW       AP,APSAVE      SAVE COPY OF AP
         ENDM
         SPACE     1
RETURN   DEFM
         LW        SP,SPSAVE      RESTORE OLD STACK PTR FROM SPSAVE
         LF        R2,2W,SP        RESTORE REGISTERS FROM STACK
         TRR       SP,R3           RESTORE OLD STACK PTR TO R3
         TRSW      R2              RETURN TO CALLING ROUTINE
         BOUND     1W
         ENDM
         SPACE     2
************************************************************************
*   REGISTER SAVE AREA
************************************************************************
         SPACE     1
         DSECT
         BOUND     1F
REG.SAV  RES       1F              REG SAVE AREA
STACK    RES       32W             TEMP STACK FOR CALL
STK.ADR  EQU       $               BOTTOM OF STACK ADDR
SPSAVE   DATAW     0               STACK POINTER SAVE
APSAVE   DATAW     0               ARG POINTER SAVE
SP.ABRT  DATAW     0               SP FOR ABORT RECEIVER
FUNCTION REZ       NSIG*1W         FUNCTION ADDRESS
         SPACE     2
************************************************************************
*
*   PROGRAMMING CONVENTIONS
*
*   1) THE ARGUMENT POINTER IS MAINTAINED IN REGISTER AP.  AP IS SAVED
*   AROUND CODE THAT MAY DESTROY IT, IN PARTICULAR, SVC'S.
*
*   2) ALL ENTRIES INTO THIS PACKAGE ARE FUNCTIONS, THAT IS, THEY RETURN
*   A VALUE.  THE VALUE IS RETURNED IN R0.  ERRORS ARE GENERALLY
*   INDICATED BY -1.  SUCCESS IS GENERALLY INDICATED BY 0.  CREAT AND
*   OPEN RETURN THE FILE DESCRIPTOR TO SHOW SUCCESS.  WRITE RETURNS 0
*   TO INDICATE EOF DETECTED AND N(>0) TO INDICATE THE NUMBER OF
*   CHARACTERS ACTUALLY TRANSFERRED.
*
*   3) UTILITY SUBROUTINES EXPECT AP AND X2 TO BE PROPERLY INITIALIZED.
*   RESULTS ARE RETURNED IN R7.  ERRORS ARE GENERALLY INDICATED BY -1.
*   SUCCESS IS GENERALLY INDICATED BY 0.
*
************************************************************************
         PAGE
         CSECT
************************************************************************
*   GET SIGNAL HANDLING ROUTINE ADDRESS
************************************************************************
         SPACE     1
_signal  EQU       $               get signal processing address
         ENTER                    SAVE REGISTERS ON STACK
         LW        R6,0W,AP       PICK UP SIGNAL NUMBER
         BLT       ERRETURN       IF < 1, ERROR
         CI        R6,NSIG        COMPARE TO MAXIMUM SIGNAL NUMBER
         BGE       ERRETURN       IF > MAX, ERROR
         CI        R6,SIGINT      IS THIS SIGNAL FOR INT (BREAK)
         BEQ       SIG.BRK        BR IF YES
         CI        R6,SIGKILL     IS THIS ABORT RECEIVER
         BNE       OKRETURN       IF NOT RETURN, O.K.
SIG.KIL  LW        R7,1W,AP       GET FUNCTION ADDRESS
         LA        R2,FUNCTION    ARRAY ADDRESS
         SLL       R6,2           MAKE WORD OFFSET
         ADR       R6,R2          OFFSET TO FUNCTION LOC
         STW       R7,0W,X2       SAVE ADDRESS
         STF       R0,REG.SAV     SAVE OUR REGS
         STW       SP,SP.ABRT     SAVE STACK POINTER FOR LATER
         LA        R7,ABORT       GET ABORT RECEIVER ADDRESS
         SVC       1,X'60'        SET ABORT RECEIVER ADDR
         BU        OKRETURN       RETURN O.K.
SIG.BRK  LW        R7,1W,AP       GET FUNCTION ADDRESS
         LA        R2,FUNCTION    ARRAY ADDRESS
         SLL       R6,2           MAKE WORD OFFSET
         ADR       R6,R2          OFFSET TO FUNCTION LOC
         STW       R7,0W,X2       SAVE ADDRESS
         STF       R0,REG.SAV     SAVE OUR REGS
         LA        R7,BREAK       GET BREAK RECEIVER ADDRESS
         SVC       1,X'6E'        SET BREAK RECEIVER ADDR
OKRETURN ZR        R0             CLEAR FOR RETURN
         RETURN                   RETURN ADDRESS TO CALLER
ERRETURN LI        R0,-1          RETURN -1
         RETURN                   EXIT
************************************************************************
* MPX BREAK RECEIVER
************************************************************************
BREAK    LA        SP,STK.ADR     SET TEMP STACK ADDRESS
         LW        R2,FUNCTION+2W GET FUNCTION ADDRESS
         BLE       BREXIT         EXIT IF NON
         SEA                      EXTENDED
         BL        0W,X2          GO TO FUNCTION
BREXIT   SVC       1,X'70'        BREAK EXIT
*
************************************************************************
* MPX ABORT RECEIVER
************************************************************************
ABORT    LW        SP,SP.ABRT     SET TEMP STACK ADDRESS
         LW        R2,FUNCTION+9W GET FUNCTION ADDRESS
         BLE       ABEXIT         EXIT IF NON
         SEA                      EDT IS EXTENDED
         BL        0W,X2          GO TO FUNCTION
ABEXIT   SVC       1,X'55'        EXIT TO MPX
*
         END
