/* *********************************************************************
 * 
 * $Header:  001  11-OCT-88 13:19  GANN      GANN                      $
 * $Log:   @ISCSRC^(DV.EDT.INC)SCIO.H                                  $
 * 
 *      Rev  001  11-OCT-88 13:19  GANN      GANN     
 *  Version control header added                                        
 */
/* 
 */

#define ERAEOL(row, col) SCSCR(0, row, col, row, sccolmax)
#define ERABOL(row, col) SCSCR(0, row, 1, row, col)
#define ERAEDSP(row, col) SCSCR(0, row, col, scerrrow, sccolmax)
#define ERABDSP(row, col) SCSCR(0, 1, 1, row, col)

#define DEFSCROW 23
#define DEFSCCOL 80

#define MAXSCROW 100
#define MAXSCCOL MAXLINE

#define ADDFLAG  ((long)(MAXBUFLINES + 2))
#define BOB  -(ADDFLAG<<1)
#define EOB  ((ADDFLAG<<2) | ADDFLAG)

/* scSetCur flags */

#define USEBUF  ( 1) /* Use buffer stuff (like line length) */
#define NOBUF  ( 2) /* Keep it simple. "Ignore" the buffer stuff */
#define ABSADDR  (-1) /* Row and column given are absolute buffer */
#define NOSCR  (-2) /* Don't try to move screen around */

#define ADDREL(x) (ADDFLAG | (long)(x))

#ifndef EDTGLB
/* Subroutine definitions */

#define scsetcur(b, r, c) scSetCur((int)(b), (long)(r), (long)(c))

Line *scSetCur();

/* Compare two vectors.  Return:
 *
 * -1 if [row1,col1] <  [row2,col2]
 *  0 if [row1,col1] == [row2,col2]
 *  1 if [row1,col1] >  [row2,col2]
 */

#define VECCMP(r1,c1,r2,c2) veccmp((long)r1,(int)c1,(long)r2,(int)c2)

/* Definitions for screen update queue */

#define SC_NULL 0  /* Nada */

#define SC_START 1

#define SC_SCR  1  /* Scroll up/down */
#define SC_OPC  2  /* Open/Close lines */
#define SC_REF  3  /* Refresh n lines */

#define SC_END  SC_REF+1
#endif /* !EDTGLB */
