/*
 *      ISCIO.C
 *
 *      UNIX I/O emulation routines - by JCB
 *      001       Increase PNB size          - gc 01/23/91
 */

/* this version opens mode 1 as mpx update.   */
/* This is because write mode in MPX is not   */
/* sufficiently similar to write mode on UNIX */

#include <errno.h>
#include "lio.h"
#undef WHY

/*    data transfer routines */

/* write primitive */

int write (fd, buf, n)
int fd;
char *buf;
int n;
{
	register int mode;
	register int dev;

	BADFD (fd, EOF);
	INIT;
	mode = curfprm->mode;
	dev =  curfprm->device;
	if (mode == NOTUSED) {
		errno = E010;
		return (EOF);
	}
	if (mode == READMODE) {
		errno = E011;
		return (EOF);
	}
	if (dev == NULLFILE) return (n);

	return (curfprm->block ? _wbl (buf, (n>254) ? 254 : n)
		: _wub (buf, n));
}

/* read primitive */

int read (fd, buf, n)
int fd;
char *buf;
int n;
{
	register int mode;
	register int dev;

	BADFD (fd, EOF);
	INIT;
	mode = curfprm->mode;
	dev =  curfprm->device;
	if (mode == NOTUSED) {
		errno = E012;
		return (EOF);
	}
	if (mode == WRITMODE) {
		errno = E013;
		return (EOF);
	}
	if (dev == NULLFILE) {
		curfprm->eof = 1;
		return (0);
	}
	if (!n) return (0);

	return ((curfprm->block ? _rbl : _rub) (buf, n));
}

/* seek primitive */

int seek (fd, off, rel)
int  fd, rel;
long off;
{

	BADFD (fd, 0);
	INIT;
	if ((rel > 2) || (rel < 0)) {
		errno = E014;
		return (EOF);
	}

	if (curfprm->mode == NOTUSED) {
		errno = E015;
		return (EOF);
	}
	if (curfprm->device == NULLFILE) return (0);
	if (curfprm->block && (rel==1 || off)) {
		errno=E016;
		return (EOF);
	}
	if (curfprm->device != DISCFILE && curfprm->device != TERMINAL) {
		if (rel==1 || off) {
			errno = E016;
			return (EOF);
		}
		else {
			return (_skdv (rel));
		}
	}
	else {
		return ((curfprm->block?_skbl:_skub) (off, rel));
	}
}

static int _wbl (buf, n)
char *buf;
int n;
{
	register int count = 0;
	char *linadrs;
	int i;

	/* version of wbl for buffered blocked records */
	linadrs = curfil->line;

	if (curfprm->device == TERMINAL || curfprm->device == SPOOLFILE) {
		if (carcont) {
			/* put correct carriage control for terminal or SLO*/
			if (*buf == 0x0c) {
				buf++;
				*linadrs++ = '1';
				count++;
			}
			else{
				*linadrs++ = ' ';
			}
		}
	}
	while (count < n) {
		*linadrs++ = *buf++;
		count++;
	}

	if (! (curfprm->linptr=linadrs-curfil->line)) {
	/* MPX does'nt support zero length records, so we write a space */
		curfprm->linptr = 1;
		curfil->line [0] = ' ';
	}
	return (i = _putrec (curfprm->linptr, curfil->line) ? i : count);
}

static int _rbl (buf, n)
char *buf;
int n;
{
	register int count = 0;
	register char *cp;
	int i;
	char *linadrs = curfil->line;

	if (!curfprm->cmpop) {		/* see if we tested for compressed */
		curfprm->cmpop = 1; 		/* set comp tested flag */
		/* read in the first record */
		if ((i = _getrec ()) == -1) return (EOF);  /* this means error */
		if (i == -2) return (0);                  /* this means eof */
		linadrs = curfil->line;
		if (*linadrs == 0xbf) {	/* is this file compressed */
			curfprm->cmpflg = 1; /* set comp data flag */
			curfprm->bcnt = linadrs[1];			/* set record count */
			curfprm->bptr = &linadrs[6];			/* set data address */
		} else goto re00;
	}

	if (curfprm->cmpflg) {			/* reading compressed data? */
		if (curfprm->bcnt == 0) {	/* any data left in buffer */
re18:
			/* read in a data record */
			if ((i = _getrec ()) == -1) return (EOF);  /* this means error */
			if (i == -2) return (0);                /* this means eof */
			linadrs = curfil->line;
			if ((*linadrs & 0xdf) != 0x9f)		/* is this valid rec */
				return (EOF);					/* error if not */
			curfprm->bcnt = linadrs[1];			/* set record count */
			curfprm->bptr = &linadrs[6];			/* set data address */
		}
re20:
		/* see if any blanks */
		if (i = *curfprm->bptr++) {				/* next buffer pointer */
			if (i == 0xff)goto re60;			/* if eol, get out */
			while (i--) {
				if(count < n) {
					*buf++ = ' ';				/* put blank in buffer */
					count++;
				}
			}
		}
	    if (--curfprm->bcnt <= 0)goto re18;	/* read next record */

		if (i = *curfprm->bptr++) {				/* next buffer pointer */
			while (i--) {
				if(count < n)
					*buf++ = *curfprm->bptr;	/* put char in buffer */
			    curfprm->bcnt--;				/* decr count */
				curfprm->bptr++;				/* next buffer pointer */
				count++;
			}
		}
	    if (--curfprm->bcnt <= 0)goto re18;	/* read next record */
		goto re20;

re60:
	    curfprm->bcnt--;			/* decr count */
		if ((*--buf == ' ') && (count == 1)) {
			*buf = '\n';			/* put new line at eol */
		} else {
			*++buf = '\n';			/* put new line at eol */
			count++;
		}

	} else {

		/* non compressed read here */

#ifdef WHY
		curfprm->linptr = 0;
#endif
		/* read the next record */
		if ((i = _getrec ()) == -1) return (EOF);  /* this means error */
		if (i == -2) return (0);                  /* this means eof */

re00:
		/* here we need to strip off blank put in during write */
		/* this is because mpx does not support zero length blocks */
		if ((curfcb->recl == 1) && (*linadrs == ' ')) curfcb->recl = 0;
		/* now append new line to end of buffer */
		* (cp=linadrs+curfcb->recl) = '\n';       /* point to last char */
	
		/* copy this layer buffer to upper caller's buffer */

		while (count < n) {
			if (linadrs > cp) break;
			*buf++ = *linadrs++;
			count++;
		}
	}

	return (count);

}

/*  getrec function   */

static int _getrec () {

	int reg [8];

	ZREG (reg, 8);
	curfcb->bufaddr = curfil->line;
	curfcb->excount = (curfprm->block?254:BLKSIZ);
	curfcb->exracc = curfprm->blkptr;
	reg [1] = (int) curfcb;
	mpxsvc (0x1031, reg, reg);

	if (curfcb->devstat & 0x40000000) {
		errno = E017;
		return (EOF);  /* error encountered */
	}
	if (curfcb->devstat & 0x01000000) {
		errno = E018;
		return (-2);  /* eom   encountered */
	}
	if (curfcb->devstat & 0x02000000) {  /* eof encountered */
		errno = E019;
		curfprm->eof = 1;
		return (-2);
	}
	return (0);
}

/*  putrec function  */

static int _putrec (count, plinad)
int count;
char *plinad;
{

	int reg [8];

	ZREG (reg, 8);

	curfcb->excount = count;
	curfcb->bufaddr = plinad;
	curfcb->exracc = curfprm->blkptr;
	reg [1] = (int) curfcb;
	mpxsvc (0x1032, reg, reg);
	if (curfcb->devstat & 0x40000000) {
		errno = E020;
		return (EOF);  /* error */
	}
	if (curfcb->devstat & 0x02000000) {
		errno = E021;
		return (EOF);  /* eof  */
	}

	curfprm->linptr = 0;
	if (curfcb->devstat & 0x01000000) {
		errno = E022;
		return (-2);   /* eom   encountered */
	}
	return (0);
}

/*    data transfer unblocked routines
_wub() and _rub */

static int _wub (buf, n)
char *buf;
int n;
{
	int i;
	register int count = 0;
	register int mode = curfprm->mode;    /* should be 1 or 2 */
	long l, m;
	char *linadrs;

	linadrs = curfprm->linptr + curfil->line;

	if (!BUFVALID && (mode==READWRIT)) GETR
	  BUFVALID = 1;

	while (count <n) {

		if (curfprm->linptr >= BLKSIZ) {
			if (BUFALTER) PUTR
			  curfprm->blkptr++;
			l = (BLKSIZ * curfprm->blkptr);
			if ((mode == READWRIT) || (l <= curfprm->eofptr)) {
				int i = 0;
				if ((i=_getrec ()) == EOF) return (i);
				if (i == EOM) {
				/* EOM is OK here, read is not allowed to extend file */
					for (i=0;i<BLKSIZ;i++)curfil->line [i]=0;
					BUFALTER = 0;
				}
			}
			else{
				int i;
				for (i=0;i<BLKSIZ;i++)curfil->line [i]=0;
				BUFALTER = 0;
			}
			linadrs = curfil->line;
			curfprm->linptr = 0;
		}
		*linadrs++ = *buf++;
		BUFALTER = 1;
		count++;
		curfprm->linptr++;
	}

	l = curfprm->linptr + (BLKSIZ * curfprm->blkptr);
	if ((mode == READWRIT) || (mode == WRITMODE)) {
		/* update mode, eofpos is max of previous and current */
		if (l > curfprm->eofptr) curfprm->eofptr = l;
	}
	else {
		/* write mode, eofpos is current */
		curfprm->eofptr = l;
	}
	return (count);

}

static int _rub (buf, n)
char *buf;
int n;
{
	register int count = 0;
	char *linadrs;

	if (curfprm->eof) {
		errno = E023;
		return (-1);
	}
	linadrs = curfprm->linptr + curfil->line;

	if (!BUFVALID) GETR
	  BUFVALID = 1;

	while (count <n) {

		if (curfprm->linptr >= BLKSIZ) {
			if (BUFALTER) PUTR    /* mode presumed to be READWRIT here */
			curfprm->blkptr++;
			GETR
			  linadrs = curfil->line;
			curfprm->linptr = 0;
		}
		*buf++ = *linadrs++;
		count++;
		curfprm->linptr++;
		if (BLKSIZ*curfprm->block+curfprm->linptr>=curfprm->eofptr) {
			curfprm->eof = 1;
			break;
		}
	}

	return (count);
}

/*    seek unblocked function */

static int _skub (off, type)
int type;
long off;
{

	register int mode, despos;
	int curpos, desoff, desblk;
	int curblk, i;
	int ebl;

	mode = curfprm->mode;    /* should be 0 or 1 or 2 */

	/* evaluate to where seek is desired */

	curpos = curfprm->blkptr*BLKSIZ + curfprm->linptr;

	despos = off;
	if (type == 1) despos += curpos;
	if (type == 2) despos += curfprm->eofptr;
	if (despos < 0) {
		errno = E024;
		return (EOF);
	}
	desoff = despos % BLKSIZ;
	desblk = despos / BLKSIZ;

	/* check eof validity */
	if (despos > curfprm->eofptr) {
		if (mode == READMODE) {   /* read mode can't go beyond eof */
			curfprm->eof = 1;
			despos = curfprm->eofptr;
		}
	}
	else {
		curfprm->eof = 0;           /* clear eof flag */
	}

	curblk = curfprm->blkptr;
	if (BUFVALID && BUFALTER && (mode!=READMODE)) {
		/* need to write out the current buffer */
		PUTR
	}
	BUFALTER = 0;

	curfprm->blkptr = desblk;

	/* ebl is the current EOF block  */
/*	if (mode == WRITMODE && ((ebl=curfprm->eofptr/BLKSIZ) < desblk)) */
	if (mode != READMODE && ((ebl=curfprm->eofptr/BLKSIZ) < desblk))
		/* write mode, seeking into a block
		that we haven't written to before */
		for (i=0;i<BLKSIZ;i++) curfil->line [i] = 0;
	else
		if (!BUFVALID || (desblk != curblk)) GETR

		BUFVALID = 1;
	curfprm->linptr = desoff;

	if (mode != READMODE && despos>curfprm->eofptr)
		curfprm->eofptr = despos;

	return (despos);
}

/*    seek blocked function */

static int _skbl (off, mode)
long off;
int mode;
{
	int reg [8];

	if (curfprm->device == TERMINAL) return (0);
	if (curfprm->mode!=READMODE && curfprm->linptr) {
		/* chars left in buff and write mode */
		curfcb->excount = curfprm->linptr;
		curfcb->bufaddr = curfil->line;
		ZREG (reg, 8);
		reg [1] = (int) curfcb;
		mpxsvc (0x1032, reg, reg);
	}

	ZREG (reg, 8);
	reg [1] = (int) curfcb;
	if (mode) {
		/* goto end of file */
		mpxsvc (0x1034, reg, reg);
		mpxsvc (0x1035, reg, reg);
	}
	else
		/* goto beginning of file */
		mpxsvc (0x1037, reg, reg);
}

/* seek on non-disc device */

static int _skdv (rel)
int rel;
{
	int reg [8];

	ZREG (reg, 8);
	reg [1] = (int) curfcb;
	if (rel)
		mpxsvc (0x1034, reg, reg);   /* goto end of file */
	else
		mpxsvc (0x1037, reg, reg);   /* goto beginning of file */
}

int readraw (fd, buf, n)
int fd;
char *buf;
int n;
{
	register int mode, dev;
	int reg [8];

	BADFD (fd, EOF);
	INIT;
	mode = curfprm->mode;
	dev =  curfprm->device;
	if (mode == NOTUSED) {
		errno = E012;
		return (EOF);
	}
	if (mode == WRITMODE) {
		errno = E013;
		return (EOF);
	}
	if (dev == NULLFILE) {
		curfprm->eof = 1;
		return (0);
	}
	if (!n) return (0);

	ZREG (reg, 8);
	curfcb->bufaddr = buf;
	curfcb->excount = n;
	reg [1] = (int) curfcb;
	mpxsvc (0x1031, reg, reg);

	if (curfcb->devstat & 0x40000000) {
		errno = E017;
		return (EOF);  /* error encountered */
	}
	if (curfcb->devstat & 0x01000000) {
		errno = E018;
		return (-2);  /* eom   encountered */
	}
	if (curfcb->devstat & 0x02000000) {  /* eof   encountered */
		errno = E019;
		curfprm->eof = 1;
		return (-2);
	}
	return (curfcb->recl);
}

/*  writraw function  */

int writraw (fd, buf, n)
int fd;
char *buf;
int n;
{
	register int mode, dev;
	int reg [8];

	BADFD (fd, EOF);
	INIT;
	mode = curfprm->mode;
	dev =  curfprm->device;
	if (mode == NOTUSED) {
		errno = E010;
		return (EOF);
	}
	if (mode == READMODE) {
		errno = E011;
		return (EOF);
	}
	if (dev == NULLFILE) return (n);

	ZREG (reg, 8);

	curfcb->excount = n;
	curfcb->bufaddr = buf;
	reg [1] = (int) curfcb;
	mpxsvc (0x1032, reg, reg);
	if (curfcb->devstat & 0x40000000) {
		errno = E020;
		return (EOF);  /* error */
	}
	if (curfcb->devstat & 0x02000000) {
		errno = E021;
		return (EOF);  /* eof  */
	}

	if (curfcb->devstat & 0x01000000) {
		errno = E022;
		return (-2);   /* eom   encountered */
	}
	return (curfcb->recl);
}

/*    open function     */

int open (pname, mode)
char *pname;
int mode;
{
	int fd;
	struct rrstag *rptr = &_rrs;

	fd = getfd ();
	BADFD (fd, EOF);

	INIT;

	if (_cassg (pname)) {
		errno = E025;
		return (EOF);      /*parse pathname and build RRS */
	}

	if (assn (mode)) return (EOF);	/* assign with correct acc rghts */
	if (cnpo (mode)) return (EOF);	/* open */

	if ((mode == READWRIT) &&
	  ((curfprm->device == TERMINAL) || (curfprm->device == SPOOLFILE)))
	{
		errno = E001;
		return (EOF);
	}

	curfil->line = bufrsio+ (BLKSIZ*fd);
	curfprm->mode = mode;              /* mark table entry open */

	if ((curfprm->block) && (curfprm->device == DISCFILE) &&
	  (ieofbl == 0) && (mode == WRITMODE)) {
		/* we assume here that the file was created by TSM or Volmgr
		but has had nothing written into it: hence it has no end of
		file markers in it, and a subsequent seek to end of file
		would give IO06 errors without this. */

		int reg [8];
		ZREG (reg, 8);
		reg [1] = (int) curfcb;
		mpxsvc (0x1038, reg, reg);	/* write EOF on file */
		mpxsvc (0x1035, reg, reg);	/* and backspace over the EOF */
	}

	return (fd);
}

/* place for storing default access rights */
static	int	fileacc[3];
/* place for storing default file sizes */
static	int	orgs = 0;
static	int	minx = 0;
static	int	maxx = 0;

/*  setsiz - set default sizes for created files */
int	setsiz (ssiz, mini, maxi)
int	ssiz, mini, maxi;
{
	orgs = ssiz;	/* starting size */
	minx = mini;	/* minimum increment */
	maxx = maxi;	/* maximum increment */
	return (0);				/* return o.k. */
}

/*  setacc - set default access for created files */
int	setacc (owner, group, other)
int	owner, group, other;
{
	fileacc[0] = owner;		/* set owner rights */
	fileacc[1] = group;		/* set group rights */
	fileacc[2] = other;		/* set other rights */
	return (0);				/* return o.k. */
}

/* getacc - get access rights of file */

int * getacc(pname)
char *pname;
{
	int reg [8];
	int rdu[192];
	int pnblk [30];                                                 /*001*/
	int pnbvec;

	if (prspn (pname, pnblk, &pnbvec)) return ((int *) -1);
	ZREG (reg, 8);
	reg [1] = pnbvec;
	reg [6] = (int) rdu;
	mpxsvc (0x202c, reg, reg);		/* log resource */
	if (reg [7]) return ((int *) -1);
	return (&rdu[30]);				/* return pointer to access rights */
}

/*    creat function    */

int creat (pname, perm)
char *pname;
int perm;                                 /* permissions */
{
	int reg [8];
	int mode;
	int fd;
	int hadtocreate = 0;

	struct rrstag *rptr = &_rrs;
	struct rcbtag rcb;

	fd = getfd ();
	BADFD (fd, EOF);

	INIT;

	if (_cassg (pname)) {
		errno = E026;
		return (EOF);      /*parse pathname and build RRS */
	}

	if ((rptr->type == 1) &&
	  !prspn (pname, curfil->_pnb, &PNBWRDX) && exist (PNBWRDX)) {
		/* it's a type 1 RRS, so a permanent file,
		it can make a pathname block, and it doesn't currently exist */

		ZINT (&rcb, (sizeof (rcb) /sizeof (int)));
		/* set defaults in rcb */
		rcb._owri = fileacc[0];
		rcb._ugri = fileacc[1];
		rcb._otri = fileacc[2];
		rcb._osiz = orgs;	/* starting size */
		rcb._mnei = minx;	/* minimum increment */
		rcb._mxei = maxx;	/* maximum increment */

		if (perm) {
			char own, pro, oth;
			/* MPX access rights R W M U A D done here */
			/* UNIX are R W X */
			/* if perm & ~0x1ff is not zero, them MPX, else */
			/* assume UNIX flags given and translate to MPX */

			if ((perm & ~0x1ff) == 0) {
				/* simulate UNIX */
				if ((oth = (perm & 7) << 4) && 0x10) oth &= 0x3f;
				if ((pro = ((perm >> 3) & 7) << 4) && 0x10) pro &= 0x3f;
				if ((own = ((perm >> 6) & 7) << 4) && 0x10) own &= 0x3f;
			}
			else {
				oth = perm&63;
				pro = (perm >> 8) &63;
				own = (perm >> 16) &63;
			}
			if (oth) {
				if (oth&1) rcb._otri = 0x400000;
				oth &= 62;
				rcb._otri |= (oth << 26);
			}
			if (pro) {
				if (pro&1) rcb._ugri = 0x400000;
				pro &= 62;
				rcb._ugri |= (pro << 26);
			}
			if (own) {
				if (own&1) rcb._owri = 0x400000;
				own &= 62;
				rcb._owri |= (own << 26);
			}
			if (!rcb._otri) rcb._opts = 0x20000000;
			if (!rcb._ugri) rcb._opts |= 0x40000000;
			if (!rcb._owri) rcb._opts |= 0x80000000;
		}

		ZREG (reg, 8);
		reg [1] = PNBWRDX;
		reg [2] = (int) &rcb;
		if (rptr->opts.unblk) rcb._flags._eofm = 1;
		mpxsvc (0x2020, reg, reg);
		if (reg [7]) {
			errno = E002;
			return (mpxerr=reg [7]);
		}
		hadtocreate = 1;
	}

	mode = WRITMODE;				/* creat opens in write mode */
	if (assn (mode)) return (EOF);	/* assign with correct acc rghts */

	if (cnpo (mode)) return (EOF);	/* open */
	curfprm->eofptr = 0;			/* all creatted files have 0 len */
	curfil->line = bufrsio+ (BLKSIZ*fd);

	curfprm->mode = mode;			/* mark table entry open */

	if (curfprm->block && (curfprm->device == DISCFILE)) {
		ZREG (reg, 8);
		reg [1] = (int) curfcb;
		mpxsvc (0x1038, reg, reg);	/* write EOF on file */
		mpxsvc (0x1035, reg, reg);	/* and backspace over the EOF */
	}

	return (fd);
}

/*  close function  */

int close (fd)
int   fd;
{
	int reg [8];
	double dumbound;
	int usrrd [32];
	register int mode, dev;

	BADFD (fd, EOF);
	INIT;
	PNBWRDX = curfil->pnbw;

	if ((mode=curfprm->mode) == NOTUSED) return (EOF);

	if (mode!=READMODE) {         /* write or update */
		curfcb->bufaddr = curfil->line;
		ZREG (reg, 8);
		reg [1] = (int) curfcb;
		if (curfprm->block) {
			curfcb->excount = curfprm->linptr;
			if (curfprm->linptr) {
				mpxsvc (0x1032, reg, reg);
				curfprm->linptr = 0;
			}
		}
		else {
			curfcb->excount = BLKSIZ;
			if (BUFVALID && BUFALTER) {
				curfcb->exracc = curfprm->blkptr;
				mpxsvc (0x1032, reg, reg);
			}
		}
	}

	/* write back the eof position  */
	if ((dev==DISCFILE) && mode!=READMODE) {
		ZREG (reg, 8);
		reg [1] = curfil->_pnb [8];   /* keeping the RID here */
		reg [6] = (int) usrrd;
		mpxsvc (0x2031, reg, reg);
		if (!reg [7]) {
			if (curfprm->block) {
				/* try to type the file as CBLFIL */
				usrrd [CUBFL1 - CUBFUS] = CBLFIL;		/* type it */
			}
			else {
				usrrd [CUBFL1 - CUBFUS] = CUBFIL;		/* type it */
				usrrd [CUBFL2 - CUBFUS] = curfprm->eofptr;	/* length it */
			}
			ZREG (reg, 8);
			reg [6] = (int) usrrd;
			mpxsvc (0x2032, reg, reg);
		}
	}

	if (curfprm->block&& (curfprm->device==DISCFILE) && (mode==WRITMODE))
		{

		/* The purpose of this code here is to more completely emulate
		the UNIX write mode of file operation. If no data was written
		to the file, then an EOF should be written at the beginning.
		Here, an EOF is written to the current position (which will be
		at the start of the file if no data has been written). To avoid
		potential problems when two streams are opened to the same file,
		we backspace over the EOF after writing it. */

		int reg [8];
		ZREG (reg, 8);
		reg [1] = (int) curfcb;
		mpxsvc (0x1038, reg, reg);	/* write EOF on file */
		mpxsvc (0x1035, reg, reg);	/* and backspace over the EOF */
	}

	ZREG (reg, 8)
		reg [1] = (int) curfcb;
	mpxsvc (0x2053, reg, reg);		/* deassign the file */
	if (reg [7]) {
		errno = E003;
		mpxerr = reg [7];
		return (EOF);
	}

	curfprm->mode = NOTUSED;
	curfprm->linptr = curfprm->blkptr = curfprm->block =
		curfprm->eofptr = curfprm->eof = curfprm->device = 0;
	BUFVALID = BUFALTER = 0;   /* Version G Fix */

	return (0);
}

/* assign function */
static int assn (mode)
int mode;
{
	int i, reg [8];
	struct rrstag *rptr = &_rrs;

	for (i = 0; i < 3; i++)
		rptr->lfc [i] = curfcb->lfc [i]; /* put LFC in RRS */

	if (mode!=READMODE) rptr->accs.updat = 1;
	else     rptr->accs.read  = 1;

	curfcb->cntl.exp = 1;              /* ensure expanded fcb */

	if (rptr->type == 4) {
		rptr->accs.read = 0;
		rptr->accs.write = 0;
		rptr->accs.modfy = 0;
		rptr->accs.updat = 0;
		rptr->accs.appnd = 0;
	}

	ZREG (reg, 8);
	reg [1] = (int) rptr;
	mpxsvc (0x2052, reg, reg);            /* assign */

	if (reg [7]) {
		mpxerr = reg [7];
		errno = E004;
	}
	return (reg [7]);
}

static int cnpo (mode)
int mode;
{
	int reg [8], i;
	int *parinq [8];
	struct fattag *fatptr;
	double dumb1;
	int rd [192];
	struct cnptag cnp;
	struct rrstag *rptr = &_rrs;
	int sgofil = 0;

	ZREG (reg, 8);
	for (i=0;i<3;i++) {
		reg [4] <<= 8;
		reg [4] |= curfcb->lfc [i];
	}
	reg [1] = (int) parinq;
	mpxsvc (0x2048, reg, reg);            /* resource inquiry service */

	fatptr = (struct fattag *) parinq [1];
	if (!fatptr) {
		errno = E005;
		return (EOF);
	}

	/* set device info */
	if (fatptr->null) {                 /* null device */
		curfprm->device = NULLFILE;
		return (0);
	}
	else if ((fatptr->acf & 0x7) ==3)
		curfprm->device = SPOOLFILE;    /* SLO */
	else if (fatptr->tsm)
		curfprm->device = TERMINAL;     /* terminal */
	else  curfprm->device = DISCFILE;     /* file */

	sgofil = ((fatptr->acf&0x7) == 2);

	/* get correct blocking info */
	curfprm->block = ((fatptr->attr & UNBLASS) ?0:1);
	/* set blocked bits */
	/* ensure terminals are opened blocked */
	if (curfprm->device == TERMINAL ||
	  curfprm->device == SPOOLFILE) curfprm->block = 1;

	cnp.abrtn = cnp.status = cnp.resvd[0] = cnp.resvd[1] =
		cnp.resvd[2] = cnp.timeout = 0;
	cnp.options = 0;
	if (curfprm->block) {
		cnp.options = OBL;
		curfcb->cntl.bl = 1;
	}
	else{
		cnp.options = OUB;
		curfcb->cntl.bl = 0;
	}

	/* fudge blocking and access rights for
	some special files */
	if (rptr->type ==4) {
		if (mode!=READMODE) {
			/* mode is write or update */
			if (((fatptr->acf & 0x7) ==3) || fatptr->tsm) {
				curfprm->block = 1;
				cnp.options &= ~ (OBL|OUB);	/* clear blocking info */
				cnp.options |= OBL;
			}
			else if (sgofil) {				/* open in default mode */
			}
			else {
				cnp.options |= OUPD;		/* open in update mode */
			}
		}
	}

	curfcb->cntl.ran = (curfprm->block ? 0 : 1);
	ZREG (reg, 8);
	reg [7] = (int) &cnp;
	reg [1] = (int) curfcb;
	mpxsvc (0x2042, reg, reg);            /* open resource */

	if (cnp.status) {
		errno = E006;
		return (mpxerr=cnp.status);
	}
	curfprm->blkptr = 0;
	curfprm->linptr = 0;
	curfprm->eof    = 0;
	curfprm->cmpop   = 0; 		/* clear tested for compressed flag */
	curfprm->cmpflg  = 0; 		/* clear compressed file flag */
	ZREG (curfil->_pnb, 9);              /* for the RID */

	curfprm->eofptr = 0x7FFFFFFF;
	if (curfprm->device == DISCFILE) {	/* file */
		ZREG (reg, 8);
		reg [1] = (int) curfcb;
		reg [6] = (int) rd;
		mpxsvc (0x202c, reg, reg);
		ieofbl = -1;
		if (!reg [7]) {
			int i;         /* save RID */
			for (i = 0; i < 8; i++)
				curfil->_pnb [i] = rd [i];  /* RID copy */
			curfil->_pnb [8] = (32 << 24) | (int) curfil->_pnb;
			if ((rd [7]&0x0000ffff) == 12)
				/* it's a TEMP file, so length is zero */
				curfprm->eofptr = 0;
			else if (rd [CUBFL1] == CUBFIL)
				/* if the file has been previously typed by
					the C library, it will have been lengthed */
				curfprm->eofptr = rd [CUBFL2];
			else
				curfprm->eofptr = BLKSIZ * rd [69] -1;
			/* if no value in RD, try to work out a value */
			ieofbl = rd [REOFBL];
		}
	}
	return (0);
}

/* pathname parse */

static int prspn (pname, pnblk, pnbvec)
char *pname;
int  *pnblk;
int *pnbvec;
{
	struct rrstag *rptr = &_rrs;
	char name [54], *nam = name, c;
	int reg [8];
	register int l;

	*pnbvec = 0;
	while (c = *pname++) {
		if (c>='a' && c<='z') c -= ('a' - 'A');
		*nam++ = c;
	}
	*nam = '\0';

	if ((l = strlen (name)) > 52) {
		errno = E007;
		return (1);
	}
	else if (!l) {
		errno = E008;
		return (-1);
	}

	ZREG (reg, 8);
	reg [1] = l;
	reg [1] <<= 24;
	reg [1] |= (int) name;
	reg [4] = 30 * sizeof (int);                                    /*001*/
	reg [4] <<= 24;
	reg [4] |= (int) pnblk;
	mpxsvc (0x202e, reg, reg);		/* make pathname block */

	if (reg [7]) {
		mpxerr = reg [7];
		errno = E009;
		return (-1);
	}
	*pnbvec = reg [4];
	return (0);
}

/*    exist internal function */

static int exist (pnbvec)
int pnbvec;
{
	int reg [8];
	int rdu [192];

	ZREG (reg, 8);
	reg [1] = pnbvec;
	reg [6] = (int) rdu;
	mpxsvc (0x202c, reg, reg);
	return (reg [7]);
}

/*   getfd function     */

static int getfd ()
{
	int fd;

	for (fd=0;fd<FILECNT;fd++)
		if (filtabl [fd].filparm.mode == NOTUSED) return (fd);
	return (EOF);
}

/*  __isblk function */

int __isblk (fd)
int fd;
{
	struct flprmtag  *p;

	BADFD (fd, EOF);
	p = & (filtabl [fd].filparm);
	if (p->mode == NOTUSED) return (-1);
	return (p->block);
}

/* isatty function */

int  isatty (fd)
int fd;
{
	struct flprmtag  *p;

	BADFD (fd, 0);
	p = & (filtabl [fd].filparm);
	if (p->mode == NOTUSED) return (-1);
	return (p->device == TERMINAL);
}

/*  fcbadr function   */

struct fcbtag *fcbadr (fd)
int fd;
{
	BADFD (fd, 0);
	if (filtabl [fd].filparm.mode == NOTUSED) return (0);
	return (& (filtabl [fd].fcb));
}

/*    access function (not currently used, if required,
	  will be converted to use MPX access modes like creat does).
	  Currently not compiled */

#ifdef INCACCESS

int access (name, amode)
char *name;
int amode;
{
	int reg [8];
	int rdu [192];
	int ow, pr, ot;
	register int acc=0;
	int owr, prr, otr;
	int wacc = 0X40000000;             /* write access */
	int uacc = 0X20000000;             /* update access */
	int pnblk [30];                                                 /*001*/
	int pnbvec;

	if (prspn (name, pnblk, &pnbvec)) return (-1);
	ZREG (reg, 8);
	reg [1] = pnbvec;
	reg [6] = (int) rdu;
	mpxsvc (0x202c, reg, reg);
	if (reg [7]) return (-1);
	ow = rdu [30];
	pr = rdu [31];
	ot = rdu [32];
	owr = ow<0;
	prr = pr<0;
	otr = ot<0;
	acc |= owr;      /* owner read access */
	acc <<= 1;
	acc |= (ow&wacc && ow&uacc);       /* owner write access */
	acc <<= 1;
	acc |= 1;        /* owner assumed execute access */
	acc <<= 1;
	acc |= prr;      /* project read access */
	acc <<= 1;
	acc |= (pr&wacc && pr&uacc);       /* project write access */
	acc <<= 1;
	acc |= 1;        /* project assumed execute access */
	acc <<= 1;
	acc |= otr;      /* other read access */
	acc <<= 1;
	acc |= (ot&wacc && ot&uacc);       /* other write access */
	acc <<= 1;
	acc |= 1;        /* other assumed execute access */

	return acc;
}

#endif

/* delete function (unlink if you insist) */

int delete (pname)
char *pname;
{
	int reg [8];
	int pnblk [30];                                                 /*001*/
	int pnbvec;

	if (prspn (pname, pnblk, &pnbvec)) return (-1);
	if (exist (pnbvec)) return (0);
	ZREG (reg, 8);
	reg [1] = pnbvec;
	mpxsvc (0x2024, reg, reg);
	if (reg [7]) {
		errno = E029;
		return (-1);
	}
	return (0);
}

/* carriage control toggler */
void mpxccset (tog)
int tog;
{
	carcont = tog;
}
