/* *********************************************************************
 *
 * $Header:  003  20-JAN-89 16:14  GANN      GANN                      $
 * $Log:   @ISCSRC^(DV.EDT)SETSHOW.C                                   $
 * 
 *      Rev  003  20-JAN-89 16:14  GANN      GANN                       
 * Fixed SHOW OVERWRITE, SPR 10*381.                                    
 *
 *      Rev  002  20-JAN-89 09:32  GANN      GANN
 * Changed to not try to print the output file spec if one
 * was not specified (== NULL). This is part of the fix to
 * spr 10*337.
 *
 *      Rev  001  11-OCT-88 14:11  GANN      GANN
 *  Version control header added
 */
/*
 */

#include "edt.h"
#include "scio.h"
#include "tokens.h"

static byte *valaddr;
static char nodef[] = {
    "No Definition"};
static char invalsetshow[] = {
    "Invalid parameter for SET or SHOW"};

extern long lines_typed;
extern byte working;

void setcol();
extern Pchar dclfile();

/* show the user selectable options */

qqshow()

{
    int  tokval;
    register int ind;
    register LINEREC *nk;
    extern int qoverwr;                                          /*003*/

    tokval = -1;
    for( nk = &lw[0]; nk->kl; nk++)
        if( nk->sl && isword( nk->kw, nk->sl & 0x7f))
        {
            tokval = nk - &lw[0];
            break;
        }

    nk = lw + tokval;
    if ((nk->sl & 0x80) && (valaddr = (byte *)nk->func) != NULL)
        show1(*valaddr, tokval);
    else
        switch( tokval)
        {
        case S_BUFFER:
            showmem();
            break;

        case S_COLOR:
            showcol( "Text", qcolor);
            showcol( "Select", qscolor);
            showcol( "Error", qecolor);
            break;

        case S_COMMAN:
            if (cmndfile == NULL)lm1printf("No command file assigned");
            else lmprintf("Command file name: %s", dclfile(cmndfile));
            break;

        case S_CURSOR:
            lmprintf("%d:%d", (int)qtop-1, (int)qbottom-1);
            break;

        case S_EDTOLD:
            if (qold)
                lmprintf("Old file name in EDTOLD.EDT");
            else
                lmprintf("No edtold file");
            break;

        case S_ENTITY:
            if (isword(lw[S_WORD].kw, 1))
                lm1printf( qeword);
            else if (isword(lw[S_SENTEN].kw, 1))
                lm1printf(qesent);
            else if (isword(lw[S_PARAGR].kw, 3))
                lm1printf(qepara);
            else if (isword(lw[S_PAGE].kw, 3))
                lm1printf(qepage);
            break;

        case S_FILES:
            lmprintf("Input  File: %s", dclfile(infile));
            if (outfile == NULL)                                 /*002*/
               lmprintf ("Output File: none");                   /*002*/
            else                                                 /*002*/
               lmprintf("Output File: %s", dclfile(outfile));    /*002*/
            break;

        case S_HELP:
            lmprintf("Help file name: %s", dclfile(helpfile));
            break;

        case S_JOURNA:
            if(qjournal)
                lmprintf("Journal every %d characters.", qjournal);
            else
                lmprintf("NOJOURNAL");
            break;

        case S_KEY:
            ind = whichkey();
            if (ind > 0)
                lm1printf(funs[ind] ? funs[ind] : nodef);
            else
                for (ind = 0; ind < FUNSIZE; ind++)
                    lmprintf("%d = %s", ind, funs[ind] ? funs[ind] : nodef);
            break;

        case S_LINES:
            lmprintf("%d", scrowmax);
            break;

        case S_MODE:
            lm1printf(qmode ? lw[S_CHANGE].kw : lw[S_LINES].kw);
            break;

        case S_OUTPUT:
            if (outfile == NULL)                                 /*002*/
               lmprintf ("Output File: none");                   /*002*/
            else                                                 /*002*/
               lmprintf("Output File: %s", dclfile(outfile));    /*002*/
            break;

        case S_OVERWRITE:                                        /*003*/
            show1 (qoverwr, S_OVERWRITE);                        /*003*/
            break;                                               /*003*/

         case S_PARAGR:
            show1(qparawps, S_WPS);
            break;

        case S_PROMPT:
            if (isword(lw[S_LINES].kw, 4))
                lm1printf(qprolin);
            if (isword("NOKEYPAD", 8))
                lm1printf(qpronok);
            if (isword(lw[S_QUERY].kw, 5))
                lm1printf(qproque);
            break;

        case S_SCREEN:
            lmprintf("%d", sccolmax);
            break;

        case S_SEARCH:
            if ((qseagen == S_CASE) || ( qseagen == S_DIACRI))
                lmprintf("%s-%s %s %s", lw[qseagen].kw,
                lw[S_INSENS].kw, lw[qseabeg].kw, lw[qseabou].kw);
            else
                lmprintf("%s %s %s", lw[qseagen].kw,
                lw[qseabeg].kw, lw[qseabou].kw);
            cprintf(" %sSTAY", (qseanostay ? "NO" : ""));
            break;

        case S_TAB:
            if (qtab == 0)
                lm1printf("NOTAB");
            else
                lmprintf("tab size %d; indent level %d", qtab, qindent);
            break;

#ifdef TERM
        case S_TERMIN:
            lmprintf("%s %s %s %s", lw[qttkind].kw, lw[qttscrl].kw,
            lw[qtteight].kw, lw[qttedit].kw);
            break;
#endif

        case S_TEXT:
            if (isword(lw[S_END].kw, 3))
                lm1printf(qtxtend);
            else if (isword(lw[S_PAGE].kw, 3))
                lm1printf(qtxtpage);
            break;

        case S_VERSIO:
            dispvers();
            break;

        case S_WORD:
            show1(qworddem, S_DELIMI);
            break;

        case S_WORKING:
            show1(working, S_WORKING);
            break;

        case S_WRAP:
            if (qwrap == (MAXLINE + 1))
                lm1printf("NOWRAP");
            else
                lmprintf("%d", qwrap);
            break;

        default:
            cmnderr(invalsetshow);
        } /* end of switch */

    return;
}

/* set the user selectable options */
qqset()

{
    int  tokval, itop, ibot;
    register int no_or_tmp;
    register Lnrec *nk;
    Pchar oldfile = OLDFILE;
    extern int coloff;
    extern int qoverwr;
    extern int numstate;
    extern byte qdmode;  /* Set when mode changes */
    FILE *tmpfp;
    FILE *ostdwhat;

    stpblkcd();
    if (!(no_or_tmp = isno()) && (cmndbuf[cmndptr] == '~'))
    {
        no_or_tmp = -1;
        cmndptr++;
    }

    tokval = -1;
    for (nk = &lw[0]; nk->kl; nk++)
        if( nk->sl && isword( nk->kw, nk->sl & 0x7f))
        {
            tokval = nk - &lw[0];
            break;
        }

    nk = lw + tokval;
    if ((nk->sl & 0x80) && (valaddr = (byte *)nk->func) != NULL)
        *valaddr = ((no_or_tmp >= 0) ? no_or_tmp : *valaddr) ^ 1;

    switch (tokval)
    {

    case S_COLOR:
        setcol();
        break;

    case S_COMMAN:
        ostdwhat = stdwhat;
        if ((cmndfile != NULL) && (((cmndfile = filecmnd()) == NULL) ||
            ((stdwhat = freopen(cmndfile, readbin, stdwhat)) == NULL)))
            stdwhat = fopen(nulldev, readbin);
/*              stdwhat = ostdwhat; */
        cmndptr = cmndend;
        break;

    case S_CURSOR:
        if (((itop = (int)isnum()) >= 0) && (itop <= 22) &&
            ((ibot = (int)isnum()) > 0) && (itop <= ibot))
        {
            qtop = ++itop;
            qbottom = ++ibot;
        }
        else
            cmnderr("Illegal cursor pair");
        break;

    case S_EDTOLD:
        if (no_or_tmp)
            qold = NO;
        else
            qold = YES;

        /* save the file name for next time */

        if (qold) {
            /* make sure the file is there */
            close(creat(oldfile,0));

            if ((tmpfp = fopen(oldfile, "w")) != NULL)
            {
                fwrite(infile, 1, strlen(infile), tmpfp);
                fclose(tmpfp);
            } else
                lmprintf("No edtold file created");

        } else unlink(oldfile);
        break;


    case S_ENTITY:
        if (isword( lw[S_WORD].kw, 1))
            newstr( &qeword);
        else if (isword(lw[S_SENTEN].kw, 1))
            newstr( &qesent);
        else if (isword(lw[S_PARAGR].kw, 3))
            newstr( &qepara);
        else if (isword(lw[S_PAGE].kw, 3))
            newstr( &qepage);
        else
            cmnderr("Illegal entity type");
        break;

    case S_HELP:
        helpfile = filecmnd();
        break;

    case S_JOURNA:
        if (no_or_tmp)
            qjournal = 0;
        else if (((no_or_tmp = (int)isnum()) >= 0) &&
            (no_or_tmp <= 256))
            qjournal = no_or_tmp;
        break;

    case S_LINES:
        if (((no_or_tmp = (int)isnum()) > 1) && (no_or_tmp <= 22))
        {
            scrowmax = no_or_tmp;
            qtop = 5;
            qbottom = scrowmax - 4;
            if (qtop > scrowmax)
                qtop = scrowmax;
            if (qbottom < qtop)
                qbottom = qtop;
            scmsgrow = scrowmax + 1;
            scerrrow = scrowmax + 2;
            redraw = YES;
        }
        break;

    case S_MODE:
        if (qdmode = isword(lw[S_CHANGE].kw, 1))
            qmode = YES;
        else if (qdmode = isword(lw[S_LINES].kw, 1))
            qmode = NO;
        break;

    case S_NUMLOCK:
        numstate = numstate << 5;
        if (no_or_tmp < 0)
            numstate |= 0x8000;
        shift();
        break;

    case S_OUTPUT:
        outfile = filecmnd();
        break;

    case S_OVERWRITE:
        if (no_or_tmp)
            qoverwr = NO;      /* turn off overstrike */
        else
            qoverwr = YES;     /* turn on overstrike */
        break;

    case S_PARAGR:
        no_or_tmp = isno();
        if (isword(lw[S_WPS].kw, 3))
            qparawps = !no_or_tmp;
        break;

    case S_PROMPT:
        if (isword(lw[S_LINES].kw, 4))
            newstr(&qprolin);
        if (isword("NOKEYPAD", 8))
            newstr(&qpronok);
        if (isword(lw[S_QUERY].kw, 5))
            newstr(&qproque);
        break;

    case S_SCREEN:
        if (((no_or_tmp = (int)isnum()) > 0) && (no_or_tmp <= 132))
        {
            ERAEDSP(1, 1);
            sccolmax = coloff + (realcolmax = no_or_tmp) - 1;
            SETWID(realcolmax);
            redraw = YES;
        }
        break;

    case S_SEARCH:
        stpblkcd();
        no_or_tmp = cmndptr;
        if (isword(lw[S_EXACT].kw, 2))
            qseagen = S_EXACT;
        if (isword(lw[S_GENERA].kw, 1))
            qseagen = S_GENERA;
        if (isword(lw[S_WPS].kw, 3))
            qseagen = S_WPS;
        if (isword(lw[S_CASE].kw, 1))
            if (isword(lw[S_INSENS].kw,1))
                qseagen = S_CASE;
            else
                goto badsopt;
        if (isword(lw[S_DIACRI].kw ,1))
            if (isword(lw[S_INSENS].kw,1))
                qseagen = S_DIACRI;
            else
                goto badsopt;
        if (isword(lw[S_BOUNDE].kw, 2))
            qseabou = S_BOUNDE;
        if (isword(lw[S_UNBOUN].kw, 1))
            qseabou = S_UNBOUN;
        if (isword(lw[S_BEGIN].kw , 1))
            qseabeg = S_BEGIN;
        if (isword(lw[S_END].kw, 1))
            qseabeg = S_END;

        tokval = isno();
        if (isword(lw[S__STAY].kw + 1, 2))
            qseanostay = tokval;

        if (cmndptr != no_or_tmp)
            break;

badsopt:
        cmnderr("Illegal search option");
        break;

    case S_TAB:
        if (no_or_tmp)
            qtab = 0;
        else if ((no_or_tmp = (int)isnum()) > 0)
            qtab = no_or_tmp;
        break;

    case S_TABC:
        if (no_or_tmp)
            qtabc = NO;      /* turn off tab char */
        else
            qtabc = YES;     /* turn on tab char */
        break;

#ifdef TERM
    case S_TERMIN:
        if (isword( lw[S_HCPY].kw, 4)) qttkind = S_HCPY;
        else if (isword(lw[S_VT100].kw, 5)) qttkind = S_VT100;
        else if (isword(lw[S_VT52].kw, 4)) qttkind = S_VT52;
        else if (isword(lw[S_NOSCRO].kw, 8))qttscrl = S_NOSCRO;
        else if (isword(lw[S_SCROLL].kw, 6))qttscrl = S_SCROLL;
        else if (isword(lw[S_NOEIGH].kw, 7))qtteight= S_NOEIGH;
        else if (isword(lw[S_EIGHT].kw, 5)) qtteight= S_EIGHT;
        else if (isword(lw[S_NOEDIT].kw, 6))qttedit = S_NOEDIT;
        else if (isword(lw[S_EDIT].kw, 4)) qttedit = S_EDIT;
        break;
#endif

    case S_TEXT:
        if (isword(lw[S_END].kw, 2))
            newstr(&qtxtend);
        else if (isword(lw[S_PAGE].kw, 2))
            newstr(&qtxtpage);
        break;

    case S_WORD:
        no_or_tmp = isno();
        if (isword(lw[S_DELIMI].kw, 2))
            qworddem = !no_or_tmp;
        break;

    case S_WORKING:
        if (no_or_tmp)
        {
            dowork(NO);
            working = NO;
        }
        else
            dowork(working = YES);
        break;

    case S_WRAP:
        if (no_or_tmp)
            qwrap = MAXLINE + 1;
        else if (((no_or_tmp = (int)isnum()) > 0) &&
            (no_or_tmp < MAXLINE))
            qwrap = no_or_tmp;
        break;

    default:
        if (valaddr == NULL)
            cmnderr(invalsetshow);
    } /* end of switch */

    return;
}

static int isno()

{
    int no1;

    stpblkcd();
    if (no1 = strnicmp(cmndbuf + cmndptr, "NO", 2) == 0)
        cmndptr += 2;

    return(no1);
}

lm1printf(arg1)

Pchar arg1;

{
    lmprintf("%s", arg1);
}

newstr(d)

register Pchar *d;

{
    register Pchar p;

    if ((p = getstr()) != NULL)
        mestrcpy(d, p);
}

show1(i, i1)

int i, i1;

{
    lmprintf("%s%s", i ? "" : "NO", lw[i1].kw);
}

void setcol()

{
       int isel, ierr;
       int i, ind;

       ind = 0;
       isword("TEXT", 4);
       isel = isword(lw[S_SELECT].kw, lw[S_SELECT].kl);
       ierr = isword(lw[S_ERROR].kw, lw[S_ERROR].kl);
       if (isword(lw[S_FLASHI].kw, lw[S_FLASHI].kl))ind = 0x80;

       for (i = 0; i < 16; i++)
           if (isword(lw[S_BLACK+i].kw, lw[S_BLACK+i].kl))
               break;

/*     if ((i < 16) && isword("ON", 2)) */
       if (i < 16)
           {
           ind = i;
/*         ind += i;
           for (i = 0; i < 8; i++)
               if (isword(lw[S_BLACK+i].kw, lw[S_BLACK+i].kl))
               {
                   ind += i *0x10; */
                   if (isel)qscolor = ind;
                   else if (ierr)qecolor = ind;
                   else {
                       qcolor = qdcolor = ind;
/*                     setborder(i); */
                   }
               redraw = YES;
          /*   } */
           }

       return;
}

showcol(atype, ind)

Pchar atype;
int ind;

{
/*
       lmprintf("%s is %s %s on %s", atype,
           ((ind >= 0x80) ? lw[S_FLASHI].kw : (char *)""),
               lw[S_BLACK+(ind % 0x10)].kw,
               lw[S_BLACK+(ind % 0x80)/0x10].kw);
 */
       lmprintf("%s is %s (%x)", atype, lw[S_BLACK+(ind % 0x10)].kw, ind);
}

