/* *********************************************************************
 *
 * $Header:  002  09-APR-91 13:45  GANN      GANN                      $
 * $Log:   @ISCSRC^(DV.EDT)NOKEY.C                                     $
 *
 *      Rev  002  09-APR-91 13:45  GANN      GANN
 * Added a line to qqchgc to indicate that the current buffer
 * has been modified.  
 *
 *      Rev  001  11-OCT-88 14:09  GANN      GANN
 *  Version control header added
 */
/*
 *
 * Revision 3.14  87/03/15  22:53:05  user
 * Force bottom lines to be wiped out on a REF.
 *
 * Revision 3.13  87/02/20  21:14:09  user
 * Fix insert action when qindent==0.  Should be no-op.
 * qqtop lost when bottom of file was not in memory and was near-by.
 * Wrapping didn't occur if screen hadn't been updated recently.
 * Calculate truecol explicitly.
 *
 * Revision 3.12  87/02/15  22:28:29  user
 * Preserve macro flag in buffer across cuts and pastes.  Changes
 * for new arguments to winkey.  Fill still was not right.  Should
 * use sccolmax-1 when no wrap is set.  Compatibility changes.
 *
 * Revision 1.6  86/10/21  19:44:01  user
 * Lint changes. Signal learn stuff with comtok == -1 in qqdefk.
 * Changes in qqlrn for new stropen.  XENIX changes.
 *
 * Revision 1.5  86/09/11  23:16:25  user
 * qqcircum inserted the character even if there was an "nkerr".
 * Now it doesn't.
 *
 * Revision 1.4  86/08/17  23:19:05  user
 * registerize defk.  Change clearlrn action after reset.
 *
 * Revision 1.3  86/07/07  00:45:39  user
 * Change clearlrn().  If arg is zero and learning, don't do anything.
 *
 * Revision 1.2  86/07/02  23:54:07  user
 * Add clearlrn() as a convenient way to clear out all learn mode
 * paraphenalia.
 *
 * Revision 1.1  86/06/29  23:19:04  user
 * First RCS Revision
 */

#include "edt.h"
#include "scio.h"
#include "tokens.h"

#define ENTCALL ((func = nokey[enttok].keyfun) == NULL) || (int)(*func)

Pchar (*func)();

extern int 		ignore_learn;
extern int        qoverwr;
extern long       chars1, lines, chars2;
static char       Done[] = {""};
extern byte       nkerr;	/* was int C.F. */
extern byte       *sea_buf;
extern int        truecol;

extern Pchar      lrn_key;        /* Key we are learning with when > 0 */
extern FILE       *lrn_fp;        /* Dummy FP pointing to learn buffer */
extern int        lrn_rep;        /* Repeat count for learn key */

extern byte       zcount;         /* TRUE when preceding count was zero (was int) */
extern LINE       char_buf, line_buf, word_buf;

void              qqiself();
void              bufcop();
void              scshft();
void              clearlrn();
BUFCTRL           *getbname();
Pchar             fixat();

static char      selrangeact[] = {"Select range is already active"};

/*ARGSUSED*/
Pchar qqadv(p)

Pchar  p;

{
qdir = 1;

return(p);
}

/*ARGSUSED*/
Pchar qqasc(p, rep)

Pchar  p;
int     rep;

{
bytebuf = zcount ? 0 : rep;
scinsc(&bytebuf, -1);
return(p);
}

/*ARGSUSED*/
Pchar qqback(p)

Pchar  p;

{
qdir = -1;

return(p);
}

/*ARGSUSED*/
Pchar qqbell(p)

Pchar  p;

{
if (!quiet)
    BELL1(200);

return(p);
}

/*ARGSUSED*/
Pchar qqchgc(p, rep, comtok, enttok)

register int      enttok;
int               comtok, rep;
Pchar             p;

{
register Pchar    q;
long              dir;
long              begrow;
int               begcol;
extern char       noselrangeact[];

current->modified = 1; /* set current buffer modified */         /*002*/

chars1 = lines = chars2 = 0;

nkerr = ENTCALL(rep, ((enttok != E_SR) ? enttok : (enttok = -1)));

begrow = absrow, begcol = col;

if (nkerr && (enttok < 0))
  nkerr = movSimple(rep, enttok = E_C);

if ((chars1 | lines | chars2) > 0)
  dir = 1;
else
  dir = -1;

if ((lines < 0) && ((chars1 < 0) || (chars2 < 0)))
  {
  lines--;
  if (chars2 < 0)
    chars2++;
  }

while (chars1 | lines | chars2)
  {
  if (dir < 0)
    scsetcur(USEBUF, 0, dir);

  q = (Pchar)here->lin + sccol - 1;
  if (isalpha(*q))
    switch (comtok)
      {
      case C_CHGC:
        *q ^= 'a' - 'A';
        break;

      case C_CHGU:
        *q &= ~('a' - 'A');
        break;

      case C_CHGL:
        *q |= 'a' - 'A';
        break;
      }

  if (dir > 0)
    scsetcur(USEBUF, 0, ADDREL(dir));

  if (chars1)
    chars1 -= dir;
  else if (lines)
    lines -= lines_rel;
  else if (chars2)
    chars2 -= dir;
  }

if (begrow <= current->sctopl)
  begrow = 1, begcol = 1;
else
  begrow -= current->sctopl;

if (dir > 0)
  scqref((int)begrow, begcol, scrow, sccol); /*C.F.*/
else
  scqref(scrow, sccol, (int)begrow, begcol); /*C.F.*/

if ((enttok < 0) && (abs(rep) > 1))
  errorout(noselrangeact);

return(p);
}

/*ARGSUSED*/
Pchar qqcircum(p, rep)

int              rep;
register Pchar    p;

{
register int      ch;
int               oqoverwr;

if (!nkerr)
  {
  if ((ch = *p - ('A' - 1)) == 0)
    return(fixat(p - 1, 1));

  oqoverwr = qoverwr;
  qoverwr = NO;
  qqiself(rep, (char)((*p <= 'a') ? ch : ch - ('a' - 'A')));
  qoverwr = oqoverwr;
  }

return(++p);
}

/*ARGSUSED*/
Pchar qqclss(p)

Pchar  p;

{
sea_buf[0] = '\000';

return(p);
}

/*ARGSUSED*/
Pchar qqcutpasta(p, rep, comtok, enttok)

int               comtok, enttok;
register int      rep;
Pchar             p;

{
byte              macroflag; /*C.F.*/
register Bufctl   *bp;

if (nkerr = ((bp = getbname(&p, 2)) == (BUFCTRL *)NULL))
  return(p);
else if (bp == current)
  {
  if (comtok != C_PASTE)
    errorout("Attempt to cut or append to current buffer");
  else
    errorout("Attempt to PASTE to current buffer");
  return(p);
  }

macroflag = bp->macro;  /* Preserve macro flag */ /*C.F.*/
chars1 = chars2 = lines = 0;

if (enttok == -1)
  func = NULL, rep = abs(rep);
else
  func = nokey[enttok].keyfun;

while (((func == NULL) ? rep-- : rep) && !nkerr)
  {
  if ((enttok >= 0) && (func != NULL))
    {
    nkerr = (byte)((*func)(rep, enttok)); /*C.F. was int */
    rep = 0;                             /*C.F.*/
    }

  if (!nkerr)
    bufcop(bp, (comtok != C_PASTE), (comtok == C_CUT));
  }

bp->macro = macroflag; /*C.F.*/
return(p);
}

/*ARGSUSED*/
Pchar qqd(p, rep, comtok, enttok)

register int     enttok;
int               comtok, rep;
Pchar             p;

{
Pchar             movWSEN(), movLine();

chars1 = lines = chars2 = 0;

nkerr = ENTCALL(rep, enttok);

if (chars1 || lines || chars2)
  if (func == movLine)
    scdel(chars1, lines, chars2, &line_buf);
  else if ((func == movWSEN) && (enttok < E_SEN))
    scdel(chars1, lines, chars2, &word_buf);
  else if (enttok == E_C)
    scdel(chars1, lines, chars2, &char_buf);
  else
    scdel(chars1, lines, chars2, LNULL);

return(p);
}

/*ARGSUSED*/
Pchar qqdate(p)

Pchar  p;

{
long              ltime;
register Pchar    atime;
static char       dash = '-';
Pchar             ctime();
long              time();

ltime = time(NULL);
atime = ctime(&ltime);

scinsc(atime + 8, 2);
scinsc(&dash, 1);
scinsc(atime + 4, 3);
scinsc(&dash, 1);
scinsc(atime + 20, 4);
scinsc(atime + 10, 9);

return(p);
}

/*ARGSUSED*/
Pchar qqdefk(p, the_key, comtok)

Pchar             p;
register int      the_key;  /* This is really "rep".  Use for storage */
int               comtok;

{
register Pchar    key_def;
byte              alpha;
int               msgRow, promRow, jkey;

if (qterm == 1) {		/* If televideo */
	msgRow = scerrrow;
	promRow = scmsgrow;
}
else {
	msgRow = scmsgrow;
	promRow = scerrrow;
}

scprintf(msgRow, 1, qecolor, "Press the key you wish to %s",
         (comtok < 0) ? "use for learn" : "define");

the_key = winkey (-1);
jkey = the_key & 0x1ff;	/* Mask off golded bit for first two checks */
if (((jkey >= FUNCT_OFF)    && (jkey < (FUNCT_OFF+128)))   ||
	((jkey >= ESC_OFF)      && (jkey < (ESC_OFF+128)))     ||
	((the_key >= GOLD_OFF)  && (the_key < (GOLD_OFF+128))) ||
    (the_key < 0x7f)) {
    if (((the_key & 0x7f) >= 'a') && ((the_key & 0x7f) <= 'z')) {
		the_key -= 32;	/* upper case it */
	}
}
if (((the_key >= 'A') && (the_key <= 'Z')) ||
    ((the_key >= '0') && (the_key <= '9')) ||
    (the_key == DEL)   || (the_key == CTRLC) ||
    (the_key == CTRLQ) || (the_key == CTRLS)) {
	 errorout("That key is not definable");
	 return(p);
}

key_def = funs[the_key];

if (comtok < 0) {
	if (key_def != NULL)FREE(key_def); /*C.F.*/
	key_def = lrn_key;
	lrn_key = NULL;
}
else {
	scprintf(msgRow, 1, qecolor,
        "Now enter the definition terminated by enter");
	ERAEOL(promRow, 1);
	scmovcur(promRow, 1);

	getcmnd(ENTER);  /* Terminate by ENTER only */ /*C.F.*/
	botclr = YES;
	clrlines = NO;

	if (key_def != NULL)
		FREE(key_def);

	if ((key_def = strdup(cmndbuf)) == NULL)
		errorout("Couldn't perform key definition");
}

funs[the_key] = key_def;

jkey = the_key & 0x1ff;	/* Mask off golded bit for first two checks */
if (((jkey >= FUNCT_OFF)    && (jkey < (FUNCT_OFF+128)))   ||
	((jkey >= ESC_OFF)      && (jkey < (ESC_OFF+128)))     ||
	((the_key >= GOLD_OFF)  && (the_key < (GOLD_OFF+128)))) {
	if (((the_key & 0x7f) >= 'A') && ((the_key & 0x7f) <= 'Z')) {
		funs[the_key+32] = key_def; 	/* if letter, do lowercase too */
	}
}

return(p);
}

/*ARGSUSED*/
Pchar qqdesel(p)

Pchar  p;

{
long              scrowsel;
int               last2here;
extern long       lastmrow;
extern short      lastmcol;

if (rowsel < 0)
  return(p);

if ((scrowsel = rowsel - current->sctopl) > scrowmax)
  scrowsel = scerrrow;
else if (scrowsel < 1)
  scrowsel = 1;

if ((last2here = VECCMP((int)scrowsel, colsel, scrow, sccol)) < 0)
  scqref((int)scrowsel, colsel, scrow, sccol); /*C.F.*/
else if (last2here > 0)
  scqref(scrow, sccol, (int)scrowsel, colsel); /*C.F.*/

rowsel = lastmrow = -1;
colsel = lastmcol = -1;

return(p);
}

/*ARGSUSED*/
Pchar qqex()

{
dowork(NO);
qmode = NO;
qdmode = YES;

return(Done);
}

/*ARGSUSED*/
Pchar qqext(p)

register Pchar   p;

{
register int      len;

len = strlen(p = stpblk(p));

if (p[--len] == '.') /*C.F.*/
  p[len] = '\000';   /*C.F.*/
else                 /*C.F.*/
  len++;             /*C.F.*/

strnzcpy(cmndbuf, p, len);
/* cmndptr = 0; */ /*C.F.*/
scposcur(scmsgrow, 1);
linecmnd(len);
frccur(current, 0, 0);

if (qhit)
    {
    qdcolor = qecolor;
    cprintf("\r\nPress return to continue");
    qdcolor = qcolor;
    winkey(NO);
    botclr = redraw = YES;
    qhit = clrlines = NO;
    }

threez = 0;

return(Done); /*C.F.*/
}

/*ARGSUSED*/
Pchar qqfill(p, rep, comtok, enttok)

int     comtok, enttok, rep;
Pchar   p;

{
byte              force;
int               c, c1;
int               hlen, totchars;
register Pchar    a;
register Pchar    lastsp;
register Pchar    q;
Pchar             lastnsp;
long              fill_lines;

nkerr = ENTCALL(rep, enttok);

mkpos();

if ((chars1 | lines | chars2) == 0)
  return(p);

fill_lines = lines + (chars1 != 0) + (chars2 != 0);
scsetcur(USEBUF, 0, 1);

while (fill_lines != 0)
    {
    c1 = 0;
    totchars = 0;
    lastsp = NULL;
    a = lastnsp = (Pchar)tmplin - 1;

    while (fill_lines != 0)
        {
        force = NO;
        lastnsp = NULL;

       if (here == LNULL)
            force = nkerr = (byte)(fill_lines = 1);
        else if ((hlen = here->len) != 0)
            {
            for (q = (Pchar)here->lin - 1, c = 1; hlen > 0; hlen--, c++)
                  if ((fillcmp(++a) > 0) && (lastsp != NULL))
                      goto out;
                  else if ((*a = *++q) != ' ')
                      lastnsp = a;
                  else
                      {
                      c1 = c;
                      lastsp = a;
                      }

           totchars -= here->len + 1;  /* Delete this line through EOL */
            }
        else if (totchars != 0)
            break;                     /* Force last line out */

       c1 = 0;
        fill_lines--;
        scsetcur(USEBUF, ADDREL(1), 1);
        if (lastnsp == NULL)
            goto blank;
        if (force || (fillcmp(a = lastsp = lastnsp + 1) >= 0))
            break;

       *a = ' ';
        }

out:
    if (lastsp == NULL)
        continue;

    *lastsp = '\r';
    if (c1 != 0)
        scsetcur(USEBUF, 0, ADDREL(c1));
    totchars -= c1;
    scdel((long)totchars, 0L, 0L, (LINE *)NULL);
    scinsc(tmplin, ++lastsp - (Pchar)tmplin);  /* Add in the new line */
blank:;
    }

return(p);
}

static int fillcmp(a)

Pchar  a;

{
register int      tmpcol = 1 + a - (Pchar)tmplin;
register int      scrnwid;
extern int        coloff;

scrnwid = (qwrap != (MAXLINE + 1)) ? qwrap : sccolmax - coloff; /*C.F.*/

return(spccol(scrow, tmpcol, tmplin) - scrnwid);
}

/*ARGSUSED*/
Pchar qqhelp(p)

Pchar  p;

{
register int      i;
register int      ind;

dowork(NO);

if (helpscreen())
    return(p);

scmovcur(0, 0); /* Kludge to force cursor positioning later */ /*C.F.*/

while(YES) {
    scprintf(scerrrow, 1, qecolor,
        "Strike any key for help, or space to return");

    if ((ind = winkey (-2)) == ' ')
        break;

	if (funs [ind])
	    sprintf(cmndbuf, "KEYPAD %s.", funs[ind]);
	else
		sprintf(cmndbuf, "KEY CODE %3x (hex).", ind);
    cmndptr = 0;
    cmndend = strlen(cmndbuf);
    ERAEDSP(1, 1);
    scmovcur(1, 1); /*C.F.*/
    qlhelp();
}

ERAEDSP(1, 1);
scmovcur(1, 1); /*C.F.*/
botclr = redraw = YES;
clrlines = NO;
dowork(YES);

return(p);
}

/*ARGSUSED*/
Pchar qqi(p, rep)

register int     rep;
register Pchar    p;

{
Pchar   phere = p;

for (phere = p; *p != '\0'; p++)
  if ((*p == CTRLZ) || ((*p == '^') && (toupper(p[1]) == 'Z')))
    break;

if (!nkerr)
  while (rep--)
    scinsc(phere, p - phere);

if (*p == '\0')
  return(p);             /* Was never terminated. Naughty. */

if (*p == CTRLZ)
  return(++p);           /* Ended with CTRLZ */

return(p + 2);           /* Ended '^' 'Z' */
}

/*ARGSUSED*/
Pchar qqks(p)

Pchar  p;

{
extern int last_tokval;
extern long pasterow;
extern byte pastecol;

if (last_tokval == C_PASTE)
  if (qdir < 0)
    scsetcur(ABSADDR, pasterow, pastecol);

scsetcur(USEBUF, 0, ADDREL(-qdir));

return(p);
}

/*ARGSUSED*/
Pchar qqlrn(p, rep, comtok, enttok)

register Pchar   p;
int     comtok, enttok, rep;

{
	Pchar q;

	if ((stdwhat != stdin) && (stdwhat != jfp) &&
	   (*((char *)stdwhat) == 0Xff)) {		/* doing learn? */
		if (--lrn_rep > 0) {				/* yes, was there a count? */
			q = (char *) stdwhat;			/* yes, do it again			*/
			q[2] = 3;						/* start another pass		*/
		}
		else {
			stdwhat = stdin;	
		}
	}
	else if (ignore_learn) {
		ignore_learn--;
	}
	else if (lrn_key == NULL)    {
	    lrn_key = (char *) reallmem(LRNBUFSIZ + LRNBAG);
	    lrn_fp = (FILE *)lrn_key;
	    lrn_key[0] = 0xff; /* learn flag */
	    lrn_key[1] = 3;    /* chars in learn buffer */
	    lrn_key[2] = 3;    /* 1st learn char */
	    scprintf(scmsgrow, 1, qecolor, "Beginning learn mode");
	}
	else  {
	    lrn_key = REALLOC(lrn_key, lrn_key[1]);
	    qqdefk(p, 0, -1);  /* -1 Flags learn stuff */
	    qqbell(p), qqbell(p);
	    scprintf(scmsgrow, 1, qecolor, "Ending learn mode");
	    clearlrn(0);
	}

	return(p);
}

/*ARGSUSED*/
Pchar qqov(p) /* toggle overstrike mode cntrl/o */

Pchar  p;

{
qoverwr = !qoverwr;
return(p);
}

/*ARGSUSED*/
Pchar qqquit()

{
qldone(lw[S_QUIT].kw, S_QUIT); /*C.F.*/
/* Never returns */
}

/*ARGSUSED*/
Pchar qqref(p)

Pchar  p;

{
clrlines = NO;         /*C.F.*/
botclr = redraw = YES; /*C.F.*/

return(p);
}

/*ARGSUSED*/
Pchar qqs(p, rep, comtok, enttok)

Pchar  p;
int     comtok, enttok, rep;

{
register Pchar    pend;
char              delim;
register int      rpl_len;
extern byte       rpl_buf[];
Pchar             qqsn();

(void)fixat(p, 2);
issea(&p, (delim = *p));

if ((pend = strchr(p, delim)) != NULL)
  rpl_len = pend - p;
else
  {
  rpl_len = strlen(p);
  pend = p + rpl_len - 1;
  }

if (!nkerr)
  {
  strnzcpy(rpl_buf, p, rpl_len);
  qqsn(p, rep, comtok);
  }

return(++pend);
}

/*ARGSUSED*/
Pchar qqsel(p)

Pchar  p;

{
extern long lastmrow;
extern short lastmcol;

if (rowsel >= 0)
  {
  errorout(selrangeact);
  return(p);
  }

rowsel = lastmrow = absrow;
colsel = lastmcol = col;

return(p);
}

/*ARGSUSED*/
Pchar qqshl(p, rep)

int    rep;
Pchar   p;

{
scshft(-8 * rep);

return(p);
}

/*ARGSUSED*/
Pchar qqshr(p, rep)

int    rep;
Pchar   p;

{
scshft(8 * rep);

return(p);
}

/*ARGSUSED*/
Pchar qqsn(p, rep, comtok)

register int     rep;
int               comtok;
Pchar             p;

{
int               rpl_len;
register int      dir;
byte              oldqseabeg = qseabeg;
extern byte       rpl_buf[];

qseabeg = S_BEGIN;
rpl_len = strlen(rpl_buf);

if (rep > 0)
  dir = 1;
else
  {
  rep = -rep;
  dir = -1;
  }

while (rep--)
  {
  if ((comtok >= 0) && (nkerr = movSEA(dir, 0)))
    break;
  scdel((long)strlen(sea_buf), 0L, 0L, LNULL);
  scinsc(rpl_buf, rpl_len);
  }

qseabeg = oldqseabeg;
return(p);
}

/*ARGSUSED*/
Pchar qqssel(p, rep, comtok, enttok)

Pchar  p;
int     comtok, enttok, rep;

{
if (rowsel >= 0)
  {
  errorout(selrangeact);
  return(p);
  }

if (nkerr = qqmove(rep, E_SEA))
  return(p);

qqsel(p, rep, C_SEL, enttok);
scsetcur(USEBUF, 0, ADDREL(strlen(sea_buf)));

return(p);
}

/*ARGSUSED*/
Pchar qqtab(p, rep)

Pchar             p;
register int      rep;

{
register int      count;

if (rep == 0)
  return(p);

if ((sccol == 1) && (qtab != 0))
  {
  count = rep * qtab * qindent;
if (!qtabc)
	/* just position with rt arrow */
  if(qoverwr)scsetcur(USEBUF, 0, ADDREL(count));
  else qqiself (count, ' ');    /* insert blanks for tabs */
else {
  qqiself((count / qtab), '\t');
  qqiself((count % qtab), ' ');
}
  }
else
if (!qtabc) {
  if (qtab == 0) {
	  count = (rep * 8) + 1 - sccol % 8;
  } else {
	  count = (rep * qtab) + 1 - sccol % qtab;
  }
	/* just position with rt arrow */
  if(qoverwr)scsetcur(USEBUF, 0, ADDREL(count));
  else qqiself (count, ' ');    /* insert blanks for tabs */
} else {
  qqiself(rep, '\t');
}

return(p);
}

/*ARGSUSED*/
Pchar qqtadj(p, rep, comtok, enttok, tokrep)

int     comtok, enttok, rep, tokrep;
Pchar   p;

{
nkerr = ENTCALL(tokrep, enttok);

mkpos();

bbctemp->l0 = absrow;

bbctemp->l1 = absrow + lines + (chars1 > here->len)
        + (lines && (chars2 != 0));

bbctemp->bp = current;
dotabadj(bbctemp, rep);

scsetcur(ABSADDR, bbctemp->l1, 1);

if (bbctemp->l0 <= current->sctopl)
  bbctemp->l0 = 1;
else
  bbctemp->l0 -= current->sctopl;

scqref((int)bbctemp->l0, 1, scrow, MAXLINE); /*C.F.*/

return(p);
}

/*ARGSUSED*/
Pchar qqtc(p)

Pchar  p;

{
if (qtab != 0)
    qindent = (spccol(scrow, sccol, NULL) / qtab);
else
    qindent = (spccol(scrow, sccol, NULL) / 8);
return(p);
}

/*ARGSUSED*/
Pchar qqtd(p, rep)

int    rep;
Pchar   p;

{
qindent = max(0, ((int)qindent - rep));
return(p);
}

/*ARGSUSED*/
Pchar qqti(p, rep)

int    rep;
Pchar   p;

{
qindent = max(0, (int)qindent + rep);
return(p);
}

/*ARGSUSED*/
Pchar qqtgsel(p)

Pchar  p;

{
if (rowsel >= 0)
  qqdesel(p);
else
  qqsel(p);

return(p);
}

/*ARGSUSED*/
Pchar qqtgtab(p) /* toggle tab char cntrl/b */

Pchar  p;

{
qtabc = !qtabc;
return(p);
}

/*ARGSUSED*/
Pchar qqtop(p)

Pchar  p;

{
register Bufctl   *bp = current;       /*C.F.*/
long    osctopl = bp->sctopl;          /*C.F.*/

bp->sctopl += scrow - 1;               /*C.F.*/
scsetcur(USEBUF, 1, 0);                /*C.F.*/

if ((2 + current->totlines - absrow) < (long)scrowmax)
    {
    bp->sctopl = osctopl;              /*C.F.*/
    scsetcur(ABSADDR, 0, 0);           /*C.F.*/
    }

return(p);
}

/*ARGSUSED*/
Pchar qqund(p, rep, comtok, enttok)

int    comtok, enttok, rep;
Pchar   p;

{
long              hererow = absrow;
int               herecol = col;
extern char       invalsubcommand[];

while (rep--)
  switch (enttok)
    {
    case E_C:
      scinsc(&char_buf.lin[char_buf.len - 1], 1);
      break;

    case E_L:
      scinsc(line_buf.lin, line_buf.len);
      break;

    case E_W:
      scinsc(word_buf.lin, word_buf.len);
      break;

    default:
      errorout(invalsubcommand);
      return(p);
    }

scsetcur(ABSADDR, hererow, herecol);

return(p);
}

/* QQRESET the user has backed out of some action */
qqreset()

{

gold = 0;
qqdesel(0, 0, 0, NULL);
qdir = 1;                         /* Change direction to forward */

clearlrn(1);

rst_all();                       /* Never returns */
}

void clearlrn(arg)

int    arg;

{
if ((arg == 0) && (lrn_key != NULL))
  return;

if ((lrn_key) != NULL)
	FREE(lrn_key); /*C.F.*/

lrn_key = NULL;
lrn_fp = NULL;

if (stdwhat != jfp)  {
  stdwhat = stdin;
}

lrn_rep = 0;
return;
}

void qqiself(rep, c)

register int      rep;
register int      c;

{
Pchar             toinsert;
int               eolcol;
byte			 onoscreen;
static char       buf[80];

if (rep == 0)
  return;

if (((truecol = spccol(scrow, sccol, NULL)) > qwrap) && /*C.F.*/
    (c != '\t') && (c != '\r') && dowrap(c))
  return;

onoscreen = noscreen;

if (!(noscreen = qoverwr))
    noscreen = onoscreen;
else if (c != '\r')
    {
    eolcol = spccol(scrow, here->len, NULL);
    scdocdel(rep, &char_buf);
    }
else
    {
    noscreen = onoscreen;
    qqmove(rep, E_L);
    return;
    }

rep = (int) scinsc(toinsert = MEMSET(((rep <= 80) ? buf :
        (char *) reallmem(rep)), c, rep), rep);

if (toinsert != buf)
  FREE(toinsert);

if (qoverwr & ~(noscreen = onoscreen))
    scqref(scrow, sccol - rep, scrow,  /*C.F.*/
           (eolcol == spccol(scrow, here->len, NULL)) ?
                sccol - 1 : MAXSCCOL);

return;
}

static dowrap(c)

register int     c;

{
long              oabsrow = absrow;
int               osccol = sccol;
byte              oqworddem = qworddem;
register int      notdelim;

qworddem = YES;
if (notdelim = !ISDELIM(here->lin[sccol - 2], qeword)
       && !ISDELIM(c, qeword)) qqmove(1, E_BW);
qworddem = oqworddem;
if ((absrow != oabsrow) || (sccol == 1))
  scsetcur(ABSADDR, oabsrow, osccol);   /* Sorry, can't wrap */
else
  {
  scopenl();
  if (notdelim)
    scsetcur(USEBUF, 0, ADDREL(-chars2));
  else if (c == ' ')
    return(YES);
  }

return(NO);
}

void mkpos()

{
long cchars2;

if ((chars1 >= 0) && (lines >= 0) && (chars2 >= 0))
  return;

scsetcur(USEBUF, 0, chars1);

if (lines < 0)
  scsetcur(USEBUF, lines, 1);

scsetcur(USEBUF, 0, chars2);
cchars2 = (chars1 < 0) ? -chars1 : 0;
chars1 = (chars2 < 0) ? -chars2 : 0;
lines =  (lines < 0) ? -lines : 0;
chars2 = cchars2;

return;
}

void bufcop(bp, cut, realit)

register BUFCTRL *bp;
int cut, realit;

{
register int      len;
BUFCTRL           *ocurrent = current;
BUFCTRL           *acurrent;
long              clines;

if (setjmp(to_here) == -1)
  {
  if (current != ocurrent)
    {
    frccur(ocurrent, 0, 0);
    redraw = YES;
    }
  return;
  }

if (!cut)
  {
  extern long pasterow;
  extern byte pastecol;

  pasterow = absrow;
  pastecol = col;

  if (bp->totlines <= 0)
    return;

  frccur(bp, BOB, 1);
  bp = ocurrent;

  chars1 = here->len + ((current->totlines > 1) || !current->nolastcr);
  if ((lines  = current->totlines - 1 - current->nolastcr) < 0)
    lines = 0;
  chars2 = (current->nolastcr && (chars1 > here->len)) ?
           linelen(current->totlines) : 0;
  }

acurrent = current;    /* Current active current buffer */

if (realit)
  initbuf(REALIT, bp, bp->bufnam);
else if (cut)         /* if moving to other buffer, move to EOB */
  {
  frccur(bp, EOB, 1);
  scsave(-1);
  if (bp->nolastcr)
    scsetcur(NOSCR, 0, -1);
  frccur(acurrent, 0, 0);
  }

mkpos();

clines = lines;

if (cut)
  scsave(YES);

/* If chars1 > 0 copy partial line */

noscreen = cut;       /* Cut: turn off screen until almost done */

if (chars1)
  {
  MEMCPY(tmplin, &here->lin[sccol - 1],
         len = min(1 + here->len - sccol, chars1));

  frccur(bp, 0, 0);
  scinsc(tmplin, len);

  if (chars1 != len)
    if ((absrow == current->totlines) && (sccol > here->len))
      scsetcur(NOSCR, ADDREL(1), 1);
    else
      scopenl();

  frccur(acurrent, 0, ADDREL(chars1));
  }

while (clines--)
  {
  MEMCPY(tmplin, here->lin, len = here->len);
  frccur(bp, 0, 0);
  scinsc(tmplin, len);

  if ((absrow == current->totlines) && (sccol > here->len))
    scsetcur(USEBUF, ADDREL(1), 1);
  else
    scopenl();

  frccur(acurrent, ADDREL(1), 1);

  if (here == LNULL)
    break;                        /* At end */
  }

/* If chars2 != 0 copy beginning of line */

if (!chars2)
  bp->nolastcr = !lines && (chars1 == len);
else
  {
  MEMCPY(tmplin, &here->lin[sccol - 1],
         len = min(1 + here->len - sccol, chars2));

  frccur(bp, 0, 0);
  scinsc(tmplin, len);

  frccur(acurrent, 0, 0);
  bp->nolastcr = chars2 == len;
  }

noscreen = NO;

#ifdef DDcutpasta
scprintf(25,1,10,"[%d,%d] - <%ld>-<%ld>-<%ld>",
       scrow,sccol,chars1,lines,chars2);
#endif

if (cut)
  {
  scsave(NO);
  scdel(chars1, lines, chars2, LNULL);     /* Now delete it */
  }
else
  frccur(ocurrent, 0, 0);

((int *)to_here)[0] = 0; /*C.F.*/
return;
}

