/* *********************************************************************
 * 
 * $Header:  001  11-OCT-88 14:09  GANN      GANN                      $
 * $Log:   @ISCSRC^(DV.EDT)NKPARSE.C                                   $
 * 
 *      Rev  001  11-OCT-88 14:09  GANN      GANN     
 *  Version control header added                                        
 */
/* 
 */

#include "edt.h"
#include "tokens.h"
#include "scio.h"

static jmp_buf nkout;
static Pchar lastp;

extern byte nkerr, zcount;
Pchar  ispoplev();
Pchar  fixat();

/*
 ----------------------------------------------------------------------
 *  QQNOKEY is the entry into the parser for KEYPAD subcommands
 */

qqnokey(p, nkcommand)

register Pchar p;
byte  nkcommand;

{
    int count;
    extern char repstore[];
    extern char *repcount;
    extern int criterr;  /* Flag that critical error has occurred */
    Pchar promsub(), gonokey();
    void qqiself();
    void BELL1();

    lastp = NULL;

    dowork(keep_alive = YES);
    /* eraworking = NO; */

    if (clrlines)
        clearbot(clrlines);

    if (setjmp(nkout) == 0)
    {
        if (nkcommand)
        {
            p = promsub(p);
            count = getcount(&repcount, qdir);/* Translate repeat count */
            lastp = p;
            ispoplev(p, count, '\000'); /* Kick off the whole thing */
        }
        else
        {
            /* Translate repeat count */
            count = abs(getcount(&repcount, qdir));
            /* ignore cntrl chars except f/f, cr, and tab (with qtabc set) */
            if ((*p < ' ') &&
                !((*p == '\r') || (*p == '\014') || ((*p == '\t') && qtabc)))
                    BELL1();
            else qqiself(max(count, 1), *p); /* Insert a character */
        }
    }

    *(repcount = repstore) = '\000';

    if (redraw || criterr)
        scref(-1);

    if (botclr || criterr)
        clearbot(!clrlines);

    dowork(NO);
    keep_alive = NO;
    qhit = botclr = redraw = nkerr = criterr = NO; /* jcb */

    return;
}

/*
 ----------------------------------------------------------------------
 *  PROMSUB replaces occurrences of ?'string' or ?"string" in nokey
 commands
 *  with user supplied input
 */

Pchar promsub(p)

Pchar p;

{
    static char holdholder[MAXLINE+1];
    Pchar  holder;
    register Pchar q, start;
    register int marker;
    int  oqdcolor = qdcolor;
    int  len;

    p = stpblk(p);
    comprom = 0;

    for (holder = holdholder; *p; p = ++q, holder = strend(holder))
    {
        if ((start = strchr(p, '?')) == NULL)
            break;

        if (start[1] == '?')
        {
            q = start + 1;
            strnzcpy(holder, p, q - p);
            continue;
        }

        if ((start[1] == '*') || (start[1] == '&'))
            start++;

        if (start[1] == '"')
            marker = '"';  /* double quote */
        else if (start[1] == '\'')
            marker = '\'';  /* single quote */
        else
            marker = NO;  /* no prompt string */

        if (holder == holdholder)
            scposcur(scmsgrow, 1);

        if (!marker)
            q = start;
        else
        {
            if ((q = strchr(start + 2, marker)) != NULL)
                *q = '\000';
            else
                q = strend(p) - 1, marker = *q;

            qdcolor = qecolor;
            cprintf("%s", start + 2);
            qdcolor = oqdcolor;

            if (comprom == 0)
                comprom = truecol - 1;

            *q = marker;
        }

        if (*start == '&')
            start--;
        else if (*start != '*')
            getcmnd(0);
        else
        {
            getcmnd(EOL);
            start--;
        }

        if (len = start - p)
            strnzcpy(holder, p, len);
        else
            *holder = '\000';

        strcat(holder, cmndbuf);
    }

    if (holder == holdholder)
        return(p);

    if (*p != '\000')
        strcat(holder, p);

    return(holdholder);
}

/*---------------------------------------------------------------------
 * ispoplev - Process (nested) commands
 *
 * Arguments:
 * p - Pointer into command line
 * count - User supplied repeat count (if any)
 * term - Terminating character
 *
 *---------------------------------------------------------------------
 */

Pchar ispoplev(p, count, term)

register Pchar p;
register int count;
char  term;

{
    int  dir;
    Pchar  lastp;
    extern byte zcount;

    while ((*p != term) && (*p != '\000'))
    {
        nkerr = NO;

        if (*p != '(')
            p = gonokey(p, count, term);
        else
        {
            if (count >= 0)
                dir = 1;
            else
            {
                dir = -1;
                count = -count;
            }

            for (p++; !nkerr && (count > 0); count--)
                nkerr = (zcount > 1), lastp = gonokey(p, dir, ')');

            p = ++lastp;
            count = 1;
        }
    }

    return(p);
} /* end ispoplev */

/*---------------------------------------------------------------------
 * GONOKEY repeatedly parses/eats change commands.  Recursively called
 * via ispoplev when a left parenthesis is encountered.
 *
 * Arguments:
 * Pchar p  - The input string containing change commands
 * int incount - Current count/direction
 * char term - The terminating character ')' or '\000'
 *
 * Returns:
 * a pointer to the terminating character.  Commands after the
 * first error are parsed but not interpreted
 *---------------------------------------------------------------------
 */

Pchar gonokey(p, incount, term)

Pchar p;
int incount;
char term;

{
    int  tokval, enttok;
    int  count, tokcount, maxlen, dfltdir;
    Pchar  (*func)();
    register NOKEYREC *nk, *max_nk;
    extern int last_tokval;
    extern char invalsubcommand[];
    int  qqmove();

    dfltdir = (term == ')') ? incount : qdir;
    for (count = incount; ;count = dfltdir)
    {
        if (setjmp(to_here) != 0)
            longjmp(nkout, -1);  /* Process a CTRL-C */

        count = getcount(&p, count);

        while( *p == '.' )
            p++;

        if (*p == term)
            break;

        if (*p == '(')
        {
            p = ispoplev(p, count, term);
            continue;
        }

        if (*p == '\000')
        {
            nkerr = NO;
            errorout("Parenthesis mismatch");
            goto bye;
        }

        /* Scan nokey array for maximal match */

        for (nk = &nokey[0], maxlen = 0, max_nk = NULL; nk->keyword; nk++)
            if ((nk->keylen >= maxlen) && !strnicmp(p, nk->keyword,
            nk->keylen))
                max_nk = nk, maxlen = nk->keylen;

        if ((max_nk != NULL) && (!(max_nk->argtype & NAN) ||
            !isalnum(p[1])))
        {
            tokval = max_nk - &nokey[0]; /* This is the token value */
            func = max_nk->keyfun;  /* The function to call */
            p += maxlen;   /* Step over it */
        }
        else if ((tokval = isentity(&p)) < 0)
        {
            p++;
            errorout(invalsubcommand);/* Not an entity: give error */
            continue;
        }

        if (tokval >= E_BEG)
            nkerr = nkerr || qqmove(count, tokval);
        else
        {        /* Good change-mode command */
            if (!(max_nk->argtype & ENT))
                enttok = -1;  /* Doesn't take an entity */
            else
            {    /* Needs an entity */
                if (max_nk->argtype & SEP)
                    tokcount = getcount(&p, sign(dfltdir));
                else
                    count = getcount(&p, count);
                if (((enttok = isentity(&p)) < 0) ||
                    ((max_nk->argtype & SEA) && (enttok != E_SEA)))
                {
                    p++;
                    errorout("Invalid entity");
                    continue;
                }
            }

            /*
             * Call appropriate NOKEY routine if there
             * is no error or more than just
             * an entity needs to be parsed.
             */

            if (!nkerr || (max_nk->argtype & ~(ENT|SEA)))
            {
                p = (*func)(p, (max_nk->argtype & ABS) ? abs(count) :
                        count, tokval, enttok, tokcount);
                last_tokval = tokval;
                if ((tokval == C_ADV) || (tokval == C_BACK))
                    dfltdir = qdir;
            }
        } /* End else */
    }  /* End for(;;) */

bye:
    to_here[0] = 0;
    return(p);
}

int getcount(p, qdir)

register Pchar *p;
int  qdir;

{
    register int size;
    int  firstdigit;
    Pchar  q;
    int  count;
    byte  inzcount = zcount;

    *p = stpblk(*p);
    firstdigit = isdigit(**p);
    count = (int)strtol(*p, &q, 10);

    size = q - *p;

    if (!firstdigit && (size == 1))
        count = (**p == '-') ? -1 : 1;
    else if (count != 0)
    {
        int  size1;
        register char *p1;

        if (firstdigit)
            p1 = *p, size1 = size;
        else  /* Must have been signed */
        p1 = *p + 1, size1 = size - 1;

        if ((count != 0) && ((size1 > 5) || ((size1 == 5) &&
            (atoi(p1 + 1) != abs(count - (10000 * (count / 10000)))))))
        {
            nkerr = NO;
            errorout("Numeric value illegal");
            longjmp(nkout, -1);
        }
    }

    if (zcount = (count == 0))
    {
        count = qdir;
        zcount = size + 1;
    }
    else if (firstdigit)
        count = count * qdir;
    else  /* Must have been signed */
    count = count * abs(qdir);

    if ((*p = stpblk(q)) == lastp)
        zcount = inzcount; /* Kludge, but it is getting late */
    else
        lastp = *p;  /* Hey! I couldn't think of any other way */

    return(count);
}

int isentity(instr)

Pchar *instr;

{
    register NOKEYREC *nk;
    register Pchar c;

    *instr = stpblk(*instr);
    c = *instr;

    if ((*c == '"') || (*c == '\'') || ((byte)*c == (byte)'\200') ||
        ((c = fixat(*instr, 1)) != NULL))
        return(issea(instr, *c));

    for (nk = &nokey[E_BEG]; nk->keyword; nk++)
        if (strnicmp(nk->keyword, *instr, nk->keylen) == 0)
        {
            *instr += nk->keylen;
            return(nk - &nokey[0]);
        }

    /* Didn't find it.  Wasn't an entity. */
    return(-1);
}

int issea(instr, c)

register Pchar *instr;
char c;

{
    register int i;
    Pchar  newinstr;
    extern Pbyte sea_buf;

    (*instr)++;  /* Point beyond token */

    if (**instr == c)  /* Make sure not null-string (find next) */
        i = 0;
    else if ((newinstr = strchr(*instr, c)) == NULL)
    {
        errorout("Illegal search string");
        i = strlen(*instr);
    }
    else
    {
        i = newinstr - *instr;
        if (!nkerr)
            strnzcpy(sea_buf, *instr, min(MAXLINE, i));
    }

    *instr += ++i;  /* Point beyond token */

    return(E_SEA);  /* Valid closing character */
}

Pchar fixat(p, i)

register Pchar p;

{
    register Pchar q;
    Pchar  oldp = p;

    if ((*p != '^') || (p[1] != '@'))
        return(NULL);

    *p++ = (char)'\200';
    MEMCPY(q = p, p + 1, strlen(p + 1) + 1);/* Shift it all over */

    while ((*q != '\000') && (i != 0))  /* Look for terminating ^@ */
        if ((*q++ == '^') && (*q == '@'))
        {
            q[-1] = (char)'\200';
            p = q++;
            MEMCPY(p, q, strlen(q) + 1);
            i--;
        }

    return(oldp);
}
