/* *********************************************************************
 * 
 * $Header:  001  11-OCT-88 14:07  GANN      GANN                      $
 * $Log:   @ISCSRC^(DV.EDT)ENTMOV.C                                    $
 * 
 *      Rev  001  11-OCT-88 14:07  GANN      GANN     
 *  Version control header added                                        
 */
/*
 */
/* ENTMOV.C
 *
 * Revision 1.4  86/10/21  12:08:31  user
 * Lint fixes for unsigned/signed char pointers
 *
 * Revision 1.3  86/09/11  22:49:28  user
 * movLine wasn't popping the sc stack when beeping at EOB.
 *
 * Revision 1.2  86/07/07  01:06:22  user
 * Default search string "\r" has to be NULL terminated on both sides or
 * backwards searches don't work.  Use a register variable in movSEA for
 * bbctemp.
 *
 * Revision 1.1  86/06/29  23:15:42  user
 * First RCS Revision
 *
 * 05/26/86 (cgf) Release 3.0, out the door.
 *
 * 05/19/86 (cgf) When moving, just stay where findstr places you, don't
 *     come back to qqmove and move there all over again.  Tremendous
 *     time saver.
 *
 * 06/18/85 (cgf) Broke out entity routines from nokey
 */

#include "edt.h"
#include "scio.h"
#include "tokens.h"

long  lines, chars1, chars2;
/* static byte moving = NO; */

extern byte *sea_buf;

int qqmove(rep, enttok)

int  rep;
register int enttok;

{
byte  err = NO;
register Pchar (*func)();

noscreen = YES; /* C.F. */

if (moving = (enttok >= 0) && ((func = nokey[enttok].keyfun) != NULL))
  err = (int)(*func)(rep, enttok);

noscreen = NO;	 /* C.F. */

if (chars1)
  scsetcur(USEBUF, 0, ADDREL(chars1));

if (lines) {
  scsetcur(USEBUF, ADDREL(lines), (enttok != E_V));
  }

if (chars2)
  scsetcur(USEBUF, 0, ADDREL(chars2));

moving = NO;
/* noscreen = NO; */  /* turn screen back on */

return(err);
}

int movSimple(rep, enttok)

register int rep;
int  enttok;

{
int inrep = rep;

chars1 = lines = chars2 = 0;

switch (enttok)
  {
  case E_C:
    scsave(YES);
    scsetcur(USEBUF, 0, ADDREL(rep));
    rep = chars_rel;
    chars1 = chars_rel;
    scsave(NO);
    break;

  case E_V:
    lines = rep;
    break;

  case E_BR:
    lines = -absrow + 1;
    chars1 = -sccol + 1;
    break;

  case E_ER:
    if (current->totlines >= MAXBUFLINES)
      {
      chars1 = 2 + here->len - sccol;
      lines = EOB;
      }
    else if ((lines = (current->totlines - absrow)) < 0)
      lines = 0;
    else
      chars1 = 2 + here->len - sccol;
    break;
  }

return(rep != inrep);
}

int movLine(rep, enttok)

register int rep, enttok;

{
if ((rep = fixrep(rep, enttok, E_L)) == 0)
  return(0);

if (enttok == E_NL)
  rep = abs(rep);

scsave(YES);
/* noscreen = YES; */ /* turn off screen */

if (rep > 0)
  {
  if (here == LNULL)
    {
    scsetcur(USEBUF, ADDREL(1), 1); /* Beep! */
    goto bye;
    }

  chars1 = 2 + here->len - sccol;

  rep--;

  if (enttok == E_EL)
    if (chars1 == 1)
      rep++;
    else if (chars1 > 1)
      if (rep == 0)
        chars1--;
      else if (rep == 1)
        rep--;

  if (rep)
    {
    scsetcur(USEBUF, ADDREL(rep), 1);
    if (rep == lines_rel)
      lines = lines_rel;
    else if (lines_rel > 0)
      lines = lines_rel - 1;
    }
  else
    scsetcur(USEBUF, 0, ADDREL(chars1));

  if ((enttok == E_EL) && (here != LNULL))
    {
    if (lines)
      lines--, rep--;
    chars2 = 1 + here->len - sccol;
    }
  }
else
  {
  if (here != LNULL)
    chars1 = -sccol + 1;

  if ((chars1 < 0) || (enttok == E_EL))
    rep++;

  if (rep)
    scsetcur(USEBUF, rep, 1);

  lines = lines_rel;

  if ((enttok == E_EL) && (absrow > 1))
    chars2 = -1;
  }

bye:
/* noscreen = NO;  */ /* turn screen back on */
scsave(NO);
return(rep != lines);
}

int movParPage(rep, enttok)

register int rep;
int  enttok;

{
register int baseent;
Pchar  sstr;
int  dir;
byte  oldqseabeg = qseabeg;

if (enttok < E_PAGE)
  baseent = E_PAR, sstr = qepara;
else
  baseent = E_PAGE, sstr = qepage;

if ((rep = fixrep(rep, enttok, baseent)) == 0)
  return(0);

dir = rep;

qseabeg = ((enttok - baseent) != 2) ? S_END : S_BEGIN;

if (rep = movSEA(rep, -2, sstr))
  {
  movSimple(1, ((dir > 0) ? E_ER : E_BR));
  rep -= (chars1 | lines | chars2) != 0;
  }

qseabeg = oldqseabeg;

return(errbeep(rep, dir));
}

int movSEA(rep, enttok, sstr)

register int rep;
int  enttok;
byte  *sstr;

{
register Range *bt = bbctemp;
char  dir;
long  l0;
register int c0;
Pbyte  sea_for;
static byte defsea[] = {0, '\r', 0};
extern char stringnotfound[];

#ifdef JUNK
/* old code for ISC */
dir = (rep > 0) ? (chars1 = (1 + here->len - sccol), '+') :
    ((rep = -rep), (chars1 = (1 - sccol),  '-'));
#else JUNK
if (rep > 0)
	{
	dir = '+';
	chars1 = (here == LNULL) ? 0 : 1 + here->len - sccol;
	}
else
	{
	dir = '-';
	rep = -rep;
	chars1 = 1 - sccol;
	}
# endif JUNK

bt->bp = current;
chars2 = lines = l0 = c0 = bt->l0 = bt->c0 = bt->l1 = 0;

if (enttok >= 0)
  {
  if (*(sea_for = sea_buf) == '\000')
    sea_for = defsea + 1;
  bt->c1 = (enttok == 0);
  }
else if (*(sea_for = sstr) == '\000')
  return(rep);
else
  bt->c1 = -(enttok == -1);

bt->next = (RANGESTR *)NULL;

for ( ; rep > 0; rep--)
  if (findstr(bt, sea_for, dir))
    {
    c0 = col = bt->c0;
    chkshft(current, l0 = bt->l0);
    bt->l0 = 0;
    }
  else
    {
    if (enttok >= 0)
      errorout(stringnotfound);
    break;
    }

if (moving || (enttok == 0))
    {
/* C.F. */
	if (moving)
		noscreen = NO;
/* end of C.F. */
    scsetcur(ABSADDR, l0, c0);
    chars1 = 0;
    }
else
    {
    scsetcur(USEBUF, 0, 0);

    if (c0 == 0)
 chars1 = 0;
    else if ((lines = (l0 - absrow)) == 0)
 chars1 = (c0 - sccol);
    else if (lines > 0)
 {
 chars1++;
 chars2 = (c0 - 1);
 lines--;
 }
    else
 {
 chars2 = (c0 - linelen(l0)) - 2;
 lines++;
 }
    }

return(rep);
}

int movSR(rep, enttok)

int rep, enttok;

{
extern char noselrangeact[];

if (rowsel < 0)
  {
  if ((abs(rep) == 1) && !movSEA(1, -1, sea_buf))
    return(0);

  if (enttok != -1)
    errorout(noselrangeact);
  return(1);
  }

lines = rowsel - absrow;
if (lines > 0)
  {
  chars1 = 2 + here->len - sccol;
  chars2 = colsel - 1;
  }
else if (lines < 0)
  {
  chars1 = -sccol + 1;
  chars2 = colsel - (2 + linelen(rowsel));
  }
else
  {
  chars1 = colsel - sccol;
  chars2 = 0;
  }

if (lines > 0)
  lines--;
else if (lines < 0)
  lines++;

(void)qqdesel(NULL, 1);

return(0);
}

int movWSEN(rep, enttok)

int rep;
int enttok;

{
int  dir, n, r, r2;
byte  haseol, hasspace, isSEN, repchanged,inbuf, nodelim, newline;
register Pchar p;
Pchar  delims;
register Line *here1;
char  ch;
int  fndntok();

if (enttok < E_SEN)
  delims = qeword, isSEN = NO, nodelim = !qworddem;
else
  delims = qesent, isSEN = YES, nodelim = NO;

if ((rep = fixrep(rep, enttok, (enttok < E_SEN) ? E_W : E_SEN)) == 0)
  return(0);

if (rep >= 0)
  dir = 1;
else
  {
  dir = -1;
  rep = -rep;
  }

haseol   = ISDELIM('\r', delims);
hasspace = isSEN || ISDELIM(' ', delims);

scsave(YES);

for (repchanged = newline = NO, here1 = here;
     rep && (inbuf = (dir > 0) ?
      (here1 != LNULL) :
      ((absrow | col) > 1));
     newline = (((r | r2) == 0) && chars2), chars2 += chars_rel)
  {
  if (repchanged)
    {
    chars1 += chars2;
    chars2  = 0;
    }

  p = (Pchar)here1->lin + sccol - 1;
  r = r2 = (dir > 0) ? (1 + here1->len - sccol) : (p--, (-sccol + 1));

/* Eat spaces: they "belong" to the previous word */

  if (hasspace)
    while ((r < 0) && (*p == ' '))
      p--, sccol--, chars2--, r++;

  p += (n = fndntok(p, delims, r));

  if (repchanged = ((n != r) || haseol) &&
      (!isSEN || (((n != 0) || newline) && *p && (!p[1] ||
          (p[1] == ' ')))))
    rep--;

  if ((n == 0) && (r == r2))
    {
    n = dir;
    if (*p)
      p++;
    }

  if ((dir > 0) && hasspace)
    while (*p++ == ' ')
      n++;

  if (((here1 = scsetcur(USEBUF, 0, ADDREL(n))) != NULL) && nodelim &&
      repchanged && (ch = here1->lin[sccol - 1],
       (ISDELIM(ch, delims) || (haseol && !ch))))
    repchanged = NO, rep++; /* Sorry, I was wrong */
  }

if (!inbuf && !repchanged && (chars1 || chars2))
  rep--;  /* Fix up */

if (inbuf && isSEN && (here1 != LNULL) && (enttok != E_ESEN))
  do
    chars2++;
  while (((here1 = scsetcur(USEBUF, 0, ADDREL(1))) != LNULL) &&
  (((ch = here1->lin[sccol - 1]) == ' ') || (ch == '\000')));

scsave(NO);

return(errbeep(rep, dir));
}

static int fixrep(rep, enttok, baseent)

register int rep;
int  enttok;
register int baseent;

{
chars_rel = lines_rel = chars1 = chars2 = lines = 0;

if (rep == 0)
  return(0);

switch (enttok - baseent)
  {
  case 0:   /* Whole entity (e.g. "PAR") */
    if (!moving)
      {
      if (absrow <= current->totlines)
 scsetcur(USEBUF, 0, ADDREL(1));
      qqmove(1, baseent + 1); /* Align on beginning of entity boundary
 */
      chars_rel = lines_rel = chars1 = chars2 = lines = 0;
      }
    break;

  case 1:   /* Beginning of entity (e.g. "BL") */
    rep = -abs(rep);
    break;

  case 2:   /* End of entity (e.g. "EW") */
    if (enttok != E_EL)
      rep = abs(rep);
    break;
  }

return(rep);
}

static int errbeep(rep, dir)

register int rep;
int  dir;

{
extern char toofarback[], pastend[];

if (rep != 0)
  if (dir < 0)
{
    errorout(toofarback);
}
  else
    errorout(pastend);

return(rep);
}
