/* *********************************************************************
 *
 * $Header:  023  27-FEB-92 08:38  GANN      GANN                      $
 * $Log:   @ISCSRC^(DV.EDT)EDTGLB.C                                    $
 * 
 *      Rev  023  27-FEB-92 08:38  GANN      GANN                       
 * Modified to change version for release E.5D.                         
 *
 *      Rev  022  25-NOV-91 10:31  GANN      GANN
 * New version for changes in EDT.C.
 *
 *      Rev  021  30-OCT-91 10:09  GANN      GANN
 * Update version for changes to line.c
 *
 *      Rev  020  17-SEP-91 10:17  GANN      GANN
 * New version for changes to EDT.C and LINE.C.
 *
 *      Rev  019  21-AUG-91 12:11  GANN      GANN
 * Update version for another attempt at Ontario Hydro stuff.
 *
 *      Rev  018  29-JUL-91 14:50  GANN      GANN
 * Update version number for changes to EDT and LINE.  This is more
 * Ontario Hydro stuff.
 *
 *      Rev  017  12-JUL-91 14:45  GANN      GANN
 * Increment version for changes to LINE.C
 *
 *      Rev  016  02-JUL-91 19:03  GANN      GANN
 * Added new mode where the output file has a version number.
 * This is controlled by command line option /VNUMBER.
 * Also added command BYE, which is like EXIT except it writes
 * over the inpur file instead of creating a new version.
 *
 *      Rev  015  29-APR-91 07:43  GANN      GANN
 * Changed copyright message to include years up through 1991.
 *
 *      Rev  014  09-APR-91 13:40  GANN      GANN
 * Made changes so that if you quit while your main buffer is
 * modified, EDT asks you if that is really what you want to do.
 * Also added SET [NO]QMC so that this mode can be toggled.
 *
 *      Rev  013  19-DEC-90 16:07  GANN      GANN
 * Change version to reflect post E.5 optimizations.
 *
 *      Rev  012  26-OCT-90 09:19  GANN      GANN
 * Change version to e.5.
 *
 *      Rev  011  09-MAY-90 12:45  GANN      GANN
 * Changed version for changes to ANSI and KEYLIB so that we can use
 * command line recall when in line mode.
 *
 *      Rev  010  08-NOV-89 10:17  GANN      GANN
 * Changed greeting to say E.4B.
 *
 *      Rev  009  24-JUL-89 15:17  GANN      GANN
 * Update version number for change in line.c. Fix was for
 * define key gold function on vt220 terms.
 *
 *      Rev  008  13-APR-89 09:12  GANN      GANN
 * Change version to E.4 in greeting.
 *
 *      Rev  007  09-FEB-89 17:20  GANN      GANN
 * Swapped the key definition ranges for ESC keys and Televideo
 * FUNCTION keys. This puts the FUNCTION keys in the same range
 * as the VT220 multi-national character set (128-255). Since
 * Televideo FUNCTION keys are never used with a VT220, we can
 * then NULL out all Televideo FUNCTION key definitions and
 * allow the user to use un-American keyboards that use the
 * multi-national characters, when a VT220 is being used.
 * Also added parameter /MULTI_NATIONAL.
 *
 *      Rev  006  09-FEB-89 08:56  GANN      GANN
 *
 * Update version for change in iscio.
 *
 *      Rev  005  30-JAN-89 13:47  GANN      GANN
 * Update version number. The change was in ansi.c to fix vt220
 * function key processing to bail out if no tilde found.
 *
 *      Rev  004  20-JAN-89 16:13  GANN      GANN
 * Fixed SHOW OVERWRITE.
 * SPR 10*381
 *
 *      Rev  003  20-JAN-89 09:30  GANN      GANN
 * Added support for qualifiers /NOOUTPUT.
 * Fix for SPR's 10*337 and 10*430.
 *
 *      Rev  002  16-NOV-88 10:55  GANN      GANN
 * Changed version. This version includes fixes to malloc and goldin.
 *
 *      Rev  001  11-OCT-88 14:06  GANN      GANN
 *  Version control header added
 */
/* EDTGLB.C
 *
 * Edit History
 *
 * 01/25/88 version e3.03 correct file sizing for temp file allocation.
 * 02/16/88 version e3.04 correct line mode substitute command to
 *			not delete 31 lines from buffer erroniously.
 * 02/17/88 version e3.05 test for 4 hex chars on input line
 *			instead of just 7e??.  Error in mpx 3.2b and mpx 2.3.
 *			Also output bad arg when edt aborts.
 * 02/17/88 version e3.06 correct MAXUSERS to be 4 for the maximum
 *			number of user buffers to be open at one time.
 * 02/17/88 version e3.07 get terminal type from tie.  If option 10
 *			is specified and a terminal number is deleted from the
 *			args (see e3.05) it is printed and wait for c/r.
 * 02/17/88 version e3.08 replace mem error msg in in2buf with warning
 *			message, and continue processing.
 * 02/19/88 version e3.09 allow tab in overstrike mode to just move
 *  		currsor to tab stop.
 * 03/10/88 version e3.10 default to vt100 if tie not on system.
 * 04/13/88 version e3.11 clean up tv921, add tv950 and tv 955,
 *			temp fix in isc.io to not output characters > x'7f'
 * 04/21/88 version 3e.12 complete TV950 support and fix problem in
 *          iscio where fcb's contain junk.
 * 05/02/88 version e3.13 change the way defkey works to allow addition
 *          of any new keyboard desired. Added defkey keywords ESC and
 *			SCS. Also "fixed" display of control characters. Put in code to
 *          only allow key repeats on VT100 compatibles when read is active.
 *			On Televideo and dumber, can't turn off key repeat, so I lock the
 *			keyboard after each control character until next read is done.
 *			This helps a little but is a little dangerous, we'll see how it
 *			works.
 * 05/03/88 Versio E3.14. Fix ADV and BACK and tv950 ENTER.
 * 05/11/88 Version E3.15. Fix DEFINE KEY GOLD CONTROL and GOLD arrow for
 *			televideo
 * 05/18/88 Version E3.16 Fix graphics character handling so it doesn't
 *		    overflow screen output array. Also tweek televideo scrolling
 *			once again.
 * 06/01/88 Version E3A.01 Changed to fix LEARN. It was broken since new
 *			defkey changes. Changed strategy a bit. Now a learn key sequence
 *			is always terminated with a learn key. This results in a call
 *			to qqlrn who then processes repeat count and terinates the learn
 *			sequence if nesecary. Also fixed several bugs in keyin affecting
 *			journalling of learn sequences. Changed fkeyin to process learn
 *			sequences properly, he used to only retrieve a byte per keystroke
 *			which explains why learn only processed printable keys and control
 *			characters. Also fixed several bugs with recovery of a learn
 *			sequence from the journal file. I had many problems with malloc
 *			pointers. Although these problems turned out to be learn problems,
 *			I added some defensive code to malloc and free. free now checks
 *			not only the memory returned but where it points before it really
 *			does a free. malloc will abort instead of going into an infinite
 *			loop if one of the memory pointers has been stomped on.
 * 06/15/88 Version E3A.02 fix bug found by JW during release testing. Bug
 *			was that when defining keypad keys, upper and lower case of the
 *			defined key sequence were both defined. For example, when defining
 *			HELP (SCS/Q), WORD (SCS/q) was also defined. Fixed to not do
 *			lower/upper stuff on SCS key defines. Also found that keypad DEFK
 *			did not work right if defined key was lower case.
 *
 */

#define EDTGLB    /* Turn off extern defs in edt.h */

#include "edt.h"
#include "scio.h"
#include "tokens.h"

char whitesp[] = " \t\r\n\014";

jmp_buf to_here = {
    0};
jmp_buf cmd_loop = {
    0};

Pchar shell;   /* Pointer to shell to run */

int criterr;  /* No special critical errors on UNIX */
char dir_sep[]   = {
    ")"};
#ifdef ISC
char switch_char = '/';
#else
char switch_char = '-';
#endif
int holdit;   /* Simulated interrupt flag */
int qchmod     = 0; /* Mode of output file */
Pchar readbin     = "r";
Pchar readwritebin= "r+";
Pchar writebin    = "w";
Pchar nulldev     = "DEV=NU";

byte bytebuf = 0;

int ctrlc_hit = NO; /* YES if user hit CTRL-C */
byte loadflag = NO; /* YES if loading file, now */

BUFCTRL *maine;  /* pointer to main buffer */
BUFCTRL *paste;  /* pointer to paste text */
BUFCTRL *user[MAXUSERS+1];/* array of pointers to all buffers */
BUFCTRL *lastbuf; /* equals one of the above */
BUFCTRL *current = NULL;/* equals one of the above */

BUFFER inbuf  = {
    NULL}; /* Buffer for file input */
BUFFER outbuf = {
    NULL}; /* Buffer for file output */
BUFFER incbuf = {
    NULL}; /* Buffer for includes */

int userbufs = 0;
int comprom = 1;

int keep_alive = 0; /* != zero when actually working */

/*
 * the beginnings of command common area.  This variables are all
 * related in the parsing and channelling of user inputs
 */

char repstore[10] = "\000";  /* Place to store repeat count */
char *repcount = repstore;  /* Index into repstore */

byte gold = NO;  /* 1 if gold state is active */
int asciival = 0; /* ascii value last key. 0 if keypad or function */
Pchar lrn_key = NULL; /* Current key we are learning with */
int lrn_rep = 0;      /* Repeat count for a learn key */
Pchar lrn_fp = NULL;  /* Dummy FP for writing to learn buffer */

int qjournal=16; /* journal every N chars. 0 = no journalling */
int journext=0; /* next space in journal buffer */
short jourbuf[MAXLINE + 6];/* journal buffer */

/*
 *  define file name arrays.  not all files are always used
 */
Pchar infile=  NULL; /* the file to be edited */
Pchar orgfile=  NULL; /* the original file name */
Pchar incfile=  NULL; /* the include file name */
Pchar outfile= NULL; /* the file edits are written to */
Pchar cmndfile= NULL; /* the command file name */
Pchar cmndsys = NULL; /* the system command file name*/
Pchar helpfile= NULL; /* help file. */
Pchar jrnlfile= NULL; /* the journal file */
Pchar temppref= NULL; /* Temporary file prefix */
Pchar inflpref= NULL; /* Input filename prefix */
FILE *jfp = NULL;
FILE *stdwhat= stdin; /* changed for recovery and command files */

char qversion[]=
" Copyright (C) 1986-1991 International Software Corp ";

Pchar qqmore;   /* Pointer to message following serial number */
char qqserial[] = "EDT Release E5D.023";            /*         36 $VER
*/
/* edt flags: from DEC some make no sense on the IBM */

int qdir = 1;  /* which direction? +(down+right) -(up+left) */

long qtop=5;   /* top cursor line <= qbottom <= qline */
long qbottom=DEFSCROW - 4; /* bottom cursor line <= qline */

byte qbanner= YES;  /* display help as first page */
byte qnumber=1;  /* edt number flag ? */
byte qtab=0;   /* column for first tab stop */
byte qtabc=NO; /* do not insert tab char, use spaces */
int qtrunc=MAXLINE;  /* column to truncate lines at. max = 255 */
byte quiet=NO;  /* call to qqbell results in no sound */
byte qverify=0;  /* display macros and command files */
byte qparawps=0;  /* WPS mode paragraph stuff */
byte zcount;   /* True when preceeded by zero count */
int qwrap = MAXLINE + 1; /* create new lines when line reachs N */
int threez = 0;  /* Count number of times ^Z hit in line mode */
byte working = YES;  /* TRUE if working display wanted */

int qcolor  = 0x07;  /* pick a color */
int qscolor = 0x70;  /* pick a color for select ranges */
int qecolor = 0x0f;  /* pick a color for errors */
int qdcolor = 0x07;  /* default color for cprintf */

Pchar qeword= " \011\012\013\014\015";
/* pointer to first word    break character */
Pchar qesent= ".?!";  /*      sentence */
Pchar qepara= "\r\r";  /*      paragraph*/
Pchar qepage= "\014";  /*      page     */

byte qread = NO;   /* true if in readonly mode */
byte qindent=1;  /* current multiple for first tab stop */

/* cursor, display, and buffer management flags */
byte redraw = NO;   /* screen refresh flag */
byte botclr = NO;   /* YES if clear last line immediately */

/* scio stuff */

int scrow = 0;  /* Current row on screen */
int sccol = 0;  /* Current column on screen */
long absrow = 0;  /* Current column on screen */

long pasterow = -1;  /* Row/col where I last pasted */
byte pastecol = -1;
int coloff = 1;   /* Column offset (for shift left/right) */
int colpreserve = 0; /* Preserve column numbers across vert. move */

LINE **screen = (LINE **)NULL;/* The screen itself */
LINE *here  = LNULL; /* The current line */

int last_tokval = -1; /* Last token found by nkparse */

byte noscreen = NO;
byte moving = NO;      /* for entmove routines */
byte clrlines = NO;  /* Need to clear lines 24 & 25 */
int sccolmax = DEFSCCOL;
int scrowmax = DEFSCROW; /* Maximum row on screen */
int scmsgrow = DEFSCROW + 1;/* Where messages go */
int scerrrow = DEFSCROW + 2;/* Where error message go */
int realcolmax = 80;

int realcur = 0;       /* Current real column occupied by cursor */

long lasttopl = 0;  /* Last top line I knew of */

byte EOBonscr = NO;  /* True if it is */
int eralinmax[MAXSCROW + 1];/* Maximum column erased per line */

/* Error messages */

char toofarback[] = "Backup past top of buffer";
char pastend[] = "Advance past bottom of buffer";
char noselrangeact[] = "No select range active";
char toobigline[] = "Line exceeded 254 characters, truncated";
char stringnotfound[]= "String was not found";
char invalsubcommand[]= "Invalid subcommand";

byte actlin[MAXLINE+2]; /* temporary buffer for active line changes */
byte tmplin[MAXLINE+1]; /* temporary buffer for active line changes */

long lines_typed;  /* Number of lines put on screen for qmode */
char cmndbuf[MAXLINE+1]; /* input area for cmd and search strings */
int cmndptr = 0; /* current position in command line */
int cmndend = 0; /* manage tracking of command line processing */

/* Various "invisible" buffers */
static byte holdsea_buf[MAXLINE+2] = {
    '\000', '\000', '\000'};

byte *sea_buf = holdsea_buf + 1; /* Search buffer */
byte rpl_buf[MAXLINE+1] = {
    '\000'};  /* Replace buffer */
LINE char_buf = {
    0, "\000"}; /* Character buffer */
LINE word_buf = {
    0, "\000"}; /* Word buffer */
LINE line_buf = {
    0, "\000"}; /* The Larch.  The Larch? */


/* if alpha is selected all characters with ascii values less than
 *   space have a multi-character sequence typed out instead
 *
 *Pchar ctrltext[32] = { "<NULL>", "<SOH>", "<STX>", "<ETX>", "<EOT>",
  "<ENQ>", "<ACK>", "<BEL>", "<BS>", "<HT>", "<LF>", "<VT>", "<FF>",
  "<CR>", "<SO>", "<SI>", "<DLE>", "<DC1>", "<DC2>", "<DC3>",
  "<DC4>", "<NAK>", "<SYN>", "<ETB>", "<CAN>", "<EM>", "<SUB>",
  "<ESC>", "<FS>", "<GS>", "<RS>", "<US>" };
 */


Range r0store = {
    0}
, r1store = {
    0}
, bbcstore = {
    0};

/* Select Stuff */

long lastmrow = -1;  /* Last row I marked */
short lastmcol = -1;  /* Last col I marked */

byte qcz = NO;  /* Don't write ^Z at end */
byte qfnf = YES;  /* If true, show "Input file does not exist" */
byte qqmc = YES;  /* If True, prompt if QUIT with modified buffer  MOD*/
byte qkeypad = YES;  /* Toggles Keypad/Nokeypad editing */
byte qhit = NO;
byte qmacro = NO;
byte qmode = YES;  /* If true then change mode; else line mode */
byte qdmode = NO;  /* YES if mode changed */
Pchar qprolin="*";
Pchar qpronok="C*";
Pchar qproque="? ";
int qrecover = 0;  /* true if /RECOVER used in command line */
int qvers = 1;  /* use versioning if 1, else use .bak file */
int qvnum = 0;  /* new version does not have version number */
int qold = 0;  /* use edtold.edt if 1, else do not create file */
int qterm = 0;     /* terminal type, 0=vt100, 1=tv921, etc. */
int qkeybrd = 0;   /* Televideo keyboard type, 921 or 950 */
int qmaxcol = MAXLINE;  /* maximum characters per line */
byte qseagen=S_GENERA; /* 0-4 in order exact/general/wps/case
 insen/diacrit */
byte qseabeg=S_BEGIN; /* stop at beginning or end of search string */
byte qseabou=S_UNBOUN; /* if true searchs confined to current page */
byte qseanostay=NO;  /* Stay there when search terminates */
byte qsummary= YES;  /* if true output filename and number of lines at
 exit */
Pchar qtxtend="[EOB]"; /* text showing end of file. */
Pchar qtxtpage="\014"; /* text showing end of page. */
byte qworddem= YES;  /* if false; word boundaries are words */

#ifdef TERM
byte qttkind=S_VT100; /* DEC only VT52/VT100/HDCY */
byte qttscrl=S_SCROLL; /* DEC only scroll/noscroll */
byte qtteight=S_EIGHT; /* DEC only eight/noeight */
byte qttedit=S_EDIT;  /* DEC only edit/noedit */
#endif

/* NOKEY tokens, stuff */

extern Pchar qqadv(), qqasc(), qqback(), qqbell(),
qqchgc(), qqcircum(), qqclss(), qqcutpasta(),
qqd(),  qqdate(), qqdefk(), qqdesel(),
qqex(),  qqext(), qqmove(), qqiself(),
qqfill(), qqhelp(), qqi(),  qqks(),
qqlrn(), qqov(), qqquit(), /*qqr(),*/ qqref(),
qqs(),  qqsel(), qqshl(), qqshr(),
qqsn(),  qqssel(), qqtab(), qqtadj(),
qqtc(),  qqtd(), qqtgsel(), qqtgtab(), qqti(),
qqtop(), qqund();

extern Pchar movLine(), movSEA(), movSR(), movWSEN(),
movSimple(), movParPage();

byte nkerr = NO;

NOKEYREC nokey[] = {
    {
        "ADV",  NULL,  {
            3, 0        }
    }
    ,
    {
        "APPEND", NULL, {
            6, ENT|BUF      }
    }
    ,
    {
        "ASC",  NULL,  {
            3, ABS      }
    }
    ,
    {
        "BACK", NULL,  {
            4, 0        }
    }
    ,
    {
        "BELL", NULL,  {
            4, 0        }
    }
    ,
    {
        "CHGC", NULL,  {
            4, ENT      }
    }
    ,
    {
        "CHGL", NULL,  {
            4, ENT      }
    }
    ,
    {
        "CHGU", NULL,  {
            4, ENT      }
    }
    ,
    {
        "^",  NULL, {
            1, ABS      }
    }
    ,
    {
        "CLSS", NULL,  {
            4, 0        }
    }
    ,
    {
        "CUT",  NULL, {
            3, ENT|BUF      }
    }
    ,
    {
        "DATE", NULL,  {
            4, 0        }
    }
    ,
    {
        "DEFK", NULL,  {
            4, 0        }
    }
    ,
    {
        "DESEL", NULL, {
            5, 0        }
    }
    ,
    {
        "D",  NULL,  {
            1, ENT      }
    }
    ,
    {
        "EXT",  NULL,  {
            3, OTH      }
    }
    ,
    {
        "EX",  NULL,  {
            2, 0        }
    }
    ,
    {
        "FILL", NULL,  {
            4, ENT      }
    }
    ,
    {
        "HELP", NULL,  {
            4, 0        }
    }
    ,
    {
        "I",  NULL,  {
            1, ABS|OTH      }
    }
    ,
    {
        "KS",  NULL,  {
            2, 0        }
    }
    ,
    {
        "LEARN", NULL,  {
            5, 0        }
    }
    ,
    {
        "OV", NULL,  {
            2, 0        }
    }
    ,
    {
        "PASTE", NULL, {
            5, BUF      }
    }
    ,
    {
        "QUIT", NULL,  {
            4, 0        }
    }
    ,
    {
        "REF",  NULL,  {
            3, 0        }
    }
    ,
    {
        "R",  NULL,  {
            1, ENT      }
    }
    ,
    {
        "SEL",  NULL,  {
            3, 0        }
    }
    ,
    {
        "SHL",  NULL,  {
            3, ABS      }
    }
    ,
    {
        "SHR",  NULL,  {
            3, ABS      }
    }
    ,
    {
        "SN",  NULL,  {
            2, 0        }
    }
    ,
    {
        "SSEL", NULL,  {
            4, ENT|SEA      }
    }
    ,
    {
        "S",  NULL,  {
            1, OTH|NAN      }
    }
    ,
    {
        "TAB",  NULL,  {
            3, ABS      }
    }
    ,
    {
        "TADJ", NULL,  {
            4, ENT|SEP      }
    }
    ,
    {
        "TC",  NULL,  {
            2, ABS      }
    }
    ,
    {
        "TD",  NULL,  {
            2, ABS      }
    }
    ,
    {
        "TGSEL", NULL, {
            5, 0        }
    }
    ,
    {
        "TGTAB", NULL, {
            5, 0        }
    }
    ,
    {
        "TI",  NULL,  {
            2, ABS      }
    }
    ,
    {
        "TOP",  NULL,  {
            3, 0        }
    }
    ,
    {
        "UND",  NULL,  {
            3, ENT|ABS      }
    }
    ,
    {
        "ISELF ", NULL, {
            4, ABS      }
    }
    ,

    /*  Entities  */

    {
        "C",  NULL, {
            1, 0        }
    }
    ,
    {
        "W",  NULL, {
            1, 0        }
    }
    ,
    {
        "BW",  NULL, {
            2, 0        }
    }
    ,
    {
        "EW",  NULL, {
            2, 0        }
    }
    ,
    {
        "L",  NULL, {
            1, 0        }
    }
    ,
    {
        "BL",  NULL, {
            2, 0        }
    }
    ,
    {
        "EL",  NULL, {
            2, 0        }
    }
    ,
    {
        "NL",  NULL, {
            2, 0        }
    }
    ,
    {
        "SEN",  NULL, {
            3, 0        }
    }
    ,
    {
        "BSEN", NULL, {
            4, 0        }
    }
    ,
    {
        "ESEN", NULL, {
            4, 0        }
    }
    ,
    {
        "PAR",  NULL, {
            3, 0        }
    }
    ,
    {
        "BPAR", NULL, {
            4, 0        }
    }
    ,
    {
        "EPAR", NULL, {
            4, 0        }
    }
    ,
    {
        "PAGE", NULL, {
            4, 0        }
    }
    ,
    {
        "BPAGE", NULL, {
            5, 0        }
    }
    ,
    {
        "EPAGE", NULL, {
            5, 0        }
    }
    ,
    {
        "SR",  NULL,  {
            2, 0        }
    }
    ,
    {
        "BR",  NULL, {
            2, 0        }
    }
    ,
    {
        "ER",  NULL, {
            2, 0        }
    }
    ,
    {
        "V",  NULL, {
            1, 0        }
    }
    ,
    {
        NULL,  NULL,  {
            0, 0        }
    }
};

/* Line mode tokens and stuff */

extern int qlchange(), qlclear(), qlcopy(), qldefine(),
qldelete(), qldone(), qldos(), qlfill(),
qlfind(), qlhelp(), qlinclud(), qlinrep(),
qqset(), qqshow(), qlsub(), qltabadj(),
qltype( ), qlwrite();

extern int numstate, qoverwr;

LINEREC lw[] = {
    {
        "ADJUST",  {
            2, 0        }
    }
    ,
    {
        "BEGIN",  {
            2, 0        }
    }
    ,
    {
        "BOUNDED",  {
            2, 0        }
    }
    ,
    {
        "BUFFER",  {
            2, 2        }
    }
    ,
    {
        "CASE",  {
            2, 2        }
    }
    ,
    {
        "CHANGE",  {
            1, 0        }
        , NULL  }
    ,
    {
        "CLEAR",  {
            2, 0        }
        , NULL  }
    ,
    {
        "COMMAND",  {
            7, 7        }
    }
    ,
    {
        "CONTROL_Z",  {
            3, 3 | 0x80 }
        , NULL  }
    ,
    {
        "COPY",  {
            1, 0        }
        , NULL  }
    ,
    {
        "CURSOR",  {
            2, 1        }
    }
    ,
    {
        "DEFINE",  {
            3, 0        }
        , NULL  }
    ,
    {
        "DELETE",  {
            1, 0        }
        , NULL  }
    ,
    {
        "DELIMITER",  {
            4, 0        }
    }
    ,
    {
        "DIACRITICAL",  {
            2, 0        }
    }
    ,
    {
        "END",   {
            3, 0        }
    }
    ,
    {
        "ENTITY",  {
            2, 2        }
    }
    ,
    {
        "EXACT",  {
            3, 0        }
    }
    ,
    {
        "BYE",  {                                            /*016*/
            2, 0        }
        , NULL  }
    ,
    {
        "EXIT",  {
            2, 0        }
        , NULL  }
    ,
    {
        "FILES",  {
            4, 2        }
    }
    ,
    {
        "FILL",  {
            3, 0        }
        , NULL  }
    ,
    {
        "FNF",   {
            3, 3 | 0x80 }
        , NULL  }
    ,
    {
        "FIND",  {
            1, 0        }
        , NULL  }
    ,
    {
        "HELP",  {
            1, 1        }
/*          1, 0x80|1       } */
        ,NULL   }
    ,
    {
        "GENERAL",  {
            2, 0        }
    }
    ,
    {
        "GOLD",  {
            4, 0        }
    }
    ,
    {
        "INCLUDE",  {
            3, 0        }
        , NULL  }
    ,
    {
        "INSENSITIVE",  {
            5, 0        }
    }
    ,
    {
        "INSERT",  {
            1, 0        }
        , NULL  }
    ,
    {
        "KEYPAD",  {
            4, 4 | 0x80 }
        , NULL  }
    ,
    {
        "KEY",   {
            1, 1        }
    }
    ,
    {
        "LINES",  {
            2, 1        }
    }
    ,
    {
        "MACRO",  {
            3, 0        }
    }
    ,
    {
        "MODE",  {
            3, 1        }
    }
    ,
    {
        "MOVE",  {
            1, 0        }
        , NULL  }
    ,
    {
        "NEXT",  {
            2, 0        }
        , NULL  }
    ,
    {
        "NONE",  {
            3, 0        }
    }
    ,
    {
        "NUMBERS",  {
            2, 2 | 0x80 }
        , NULL  }
    ,
    {
        "NUMLOCK",  {
            7, 4 | 0x80 }
        , NULL  }
    ,
    {
        "OVERWRITE",  {
            4, 1        }                                        /*004*/
        , NULL  }
    ,
    {
        "PARAGRAPH",  {
            3, 2        }
    }
    ,
    {
        "PAGE",  {
            3, 0        }
    }
    ,
    {
        "PROMPT",  {
            2, 1        }
    }
    ,
    {
        "PRINT",  {
            1, 0        }
        , NULL  }
    ,
    {
        "QUERY",  {
            3, 0        }
    }
    ,
    {
        "QUIET",  {
            4, 1 | 0x80 }
        , NULL  }
    ,
    {
        "QUIT",  {
            4, 0        }
        , NULL  }
    ,
    {
        "REPLACE",  {
            3, 0        }
        , NULL  }
    ,
    {
        "SCREEN",  {
            2, 2        }
    }
    ,
    {
        "TEXT",  {
            4, 3        }
    }
    ,
    {
        "SEARCH",  {
            3, 2        }
    }
    ,
    {
        "SENTENCE",  {
            3, 0        }
    }
    ,
    {
        "SET",   {
            2, 0        }
        , NULL  }
    ,
    {
        "SHOW",  {
            2, 0        }
        , NULL  }
    ,
    {
        "SUMMARY",  {
            3, 2 | 0x80 }
        , NULL  }
    ,
    {
        "SUBSTITUTE",  {
            1, 0        }
        , NULL  }
    ,
    {
        "TAB",   {
            2, 2        }
/*          2, 0x80|2       } */
        , NULL  }
    ,
    {
        "TRUNCATE",  {
            2, 2 | 0x80 }
        , NULL  }
    ,
    {
        "TYPE",  {
            1, 0        }
        , NULL  }
    ,
    {
        "UNBOUNDED",  {
            2, 0        }
    }
    ,
    {
        "UPPER",  {
            1, 0        }
    }
    ,
    {
        "VERSION",  {
            4, 4        }
    }
    ,
    {
        "VERIFY",  {
            4, 2 | 0x80 }
        , NULL  }
    ,
    {
        "WORD",  {
            3, 2        }
    }
    ,
    {
        "WORKING",  {
            4, 4        }
    }
    ,
    {
        "WPS",   {
            2, 0        }
    }
    ,
    {
        "WRAP",  {
            3, 1        }
    }
    ,
    {
        "WRITE",  {
            1, 0        }
        , NULL  }
    ,
    {
        "/BRIEF",  {
            2, 0        }
    }
    ,
    {
        "/DUPLICATE",  {
            2, 0        }
    }
    ,
    {
        "/NOTYPE",  {
            2, 0        }
    }
    ,
    {
        "/SAVE",  {
            3, 0        }
    }
    ,
    {
        "/SEQUENCE",  {
            3, 0        }
    }
    ,
    {
        "/STAY",  {
            3, 0        }
    }
    ,
    {
        "/QUERY",  {
            2, 0        }
    }
    ,
    {
        "ALPHA",  {
            5, 0        }
    }
    ,
    {
        "JOURNAL",  {
            3, 7        }
    }
    ,
    {
        "NOJOURNAL",  {
            4, 0        }
    }
    ,
    {
        "FUNCTION",  {
            2, 0        }
    }
    ,

    {
        "SHELL",  {
            3, 0        }
        , NULL  }
    ,

    {
        "BEFORE",  {
            6, 0        }
    }
    ,
    {
        "REST",  {
            4, 0        }
    }
    ,
    {
        "WHOLE",  {
            5, 0        }
    }
    ,
    {
        "LAST",  {
            4, 0        }
    }
    ,
    {
        "SELECT",  {
            6, 0        }
    }
    ,
    {
        "ALL",   {
            3, 0        }
    }
    ,
    {
        "FLASHING",  {
            3, 0        }
    }
    ,
    {
        "BANNER",  {
            3, 2 | 0x80 }
        , NULL  }
    ,
    {
        "COLOR",  {
            3, 5        }
    }
    ,
    {
        "ERROR",  {
            3, 0        }
    }
    ,
    {
        "BLACK",  {
            3, 0        }
    }
    ,
    {
        "BLUE",  {
            3, 0        }
    }
    ,
    {
        "GREEN",  {
            3, 0        }
    }
    ,
    {
        "CYAN",  {
            3, 0        }
    }
    ,
    {
        "RED",   {
            3, 0        }
    }
    ,
    {
        "MAGENTA",  {
            3, 0        }
    }
    ,
    {
        "BROWN",  {
            3, 0        }
    }
    ,
    {
        "LIGHT_GREY",  {
            9, 0        }
    }
    ,
    {
        "DARK_GREY",  {
            8, 0        }
    }
    ,
    {
        "LIGHT_BLUE",  {
            9, 0        }
    }
    ,
    {
        "LIGHT_GREEN",  {
            9, 0        }
    }
    ,
    {
        "LIGHT_CYAN",  {
            9, 0        }
    }
    ,
    {
        "LIGHT_RED",  {
            9, 0        }
    }
    ,
    {
        "LIGHT_MAGENTA", {
            9, 0        }
    }
    ,
    {
        "YELLOW",  {
            3, 0        }
    }
    ,
    {
        "WHITE",  {
            3, 0        }
    }
    ,
    {
        "OUTPUT",  {
            6, 2        }
    }
    ,
    {
        "NOCOMMAND",  {
            6, 0        }
    }
    ,
    {
        "READ_ONLY",  {
            6, 0        }
    }
    ,
    {
        "RECOVER",  {
            6, 0        }
    }
    ,
    {
        "VT100",  {
            5, 0        }
    }
    ,
    {
        "TV921",  {
            5, 0        }
    }
    ,
    {
        "MAXIMUM_COLUMN",  {
            3, 0        }
    }
    ,
    {
        "ASCII",  {
            4, 0        }
    }
    ,
    {
        "NOVERSION",  {
            5, 0        }
    }
    ,
    {
        "NOEDTOLD",  {
            3, 0        }
    }
    ,
    {
        "EDTOLD",  {
            3, 2        }
    }
    ,
    {
        "OVERSTRIKE",  {
            4, 1 | 0x80 }
        , NULL  }
    ,
    {
        "TABCHAR",  {
            4, 2 | 0x80 }
        , NULL  }
    ,
    {
        "ESC",  {
            3, 0	}
    }
    ,
    {
        "SCS",  {
            3, 0	}
    }
    ,
    {
        "VT220",  {
            5, 0        }
    }
    ,
    {
        "TV950",  {
            5, 0        }
    }
    ,
    {                                                            /*003*/
        "NOOUTPUT",  {                                           /*003*/
            5, 0        }                                        /*003*/
    }                                                            /*003*/
    ,                                                            /*003*/
    {                                                            /*007*/
        "MULTI_NATIONAL",  {                                     /*007*/
            5, 0        }                                        /*007*/
    }                                                            /*007*/
    ,                                                            /*007*/
    {                                                            /*014*/
        "QMC",   {                                               /*014*/
            3, 3 | 0x80 }                                        /*014*/
        , NULL  }                                                /*014*/
    ,                                                            /*014*/
    {                                                            /*014*/
        "VNUMBER",   {                                           /*016*/
            4, 0        }                                        /*016*/
    }                                                            /*016*/
    ,                                                            /*016*/
    {                                                            /*016*/
        "NOVNUMBER",   {                                         /*016*/
            6, 0        }                                        /*016*/
    }                                                            /*016*/
    ,                                                            /*016*/
    {
        "",   {
            0, 0        }
    }

};

/*    --- Keyboard stuff ---    */
/* int keymap[] =
 * {
 *    284, 281, 282, 283, 277, 278, 279, 273, 274, 275,
 *    271, 272, 265, 269, 268, 267, 285, 286, 257, 276,
 *    256, 280, 261, 262, 263, 264, 266, 270,  27};
 */

/*int pckeyremap[] = {
 *    -10, 258, 259, -19, 260, 361, -28, 256,
 *    -10, 272, 276, -17, 262, 264, 266, 271, 0};
 */

#define KP_FIND      "\200?'Search for: '\200"
#define KP_REPLC     "CUTSR=DELETE PASTE"
#define KP_SUBS      "(CUTSR=DELETE PASTEKS'')"
#define KP_CMND      "EXT?'Command: '."

char * funs[] = {
/* Normal ASCII codes */
NULL,"TC","TGTAB",NULL,"TD","TI",NULL,NULL,"BL","TAB",          /*000*/
"DBW","DEFK","LEARN",NULL,NULL,"OV",NULL,NULL,"REF",NULL,       /*010*/
"TADJSR","DBL","+V","REF","BL",NULL,"EX","ESC",NULL,NULL,       /*020*/
NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,              /*030*/
NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,              /*040*/
NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,              /*050*/
NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,              /*060*/
NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,              /*070*/
NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,              /*080*/
NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,              /*090*/
NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,              /*100*/
NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,              /*110*/
NULL,NULL,NULL,NULL,NULL,NULL,NULL,"D-C",                       /*120*/
/* Function keys */
                                         NULL,NULL,
NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,              /*130*/
NULL,".",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,               /*140*/
NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,              /*150*/
NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,              /*160*/
NULL,NULL,"D+C","DEW","SEL",NULL,"L","W","EL","C",              /*170*/
"ADV","BACK","CUTSR","PAGETOP","(16L)","APPENDSR",NULL,NULL,NULL,NULL,  /*180*/
NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,              /*190*/
NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,              /*200*/
NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,              /*210*/
NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,              /*220*/
NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,              /*230*/
NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,              /*240*/
NULL,NULL,NULL,NULL,NULL,NULL,                                  /*250*/
/* Escaped keys */
                              NULL,NULL,NULL,NULL,
NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,".",               /*260*/
NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,              /*270*/
NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,              /*280*/
NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,              /*290*/
"D+C","DEW","SEL",NULL,"L","W","EL","C","ADV","BACK",           /*300*/
"CUTSR","PAGETOP","(16L)","APPENDSR",NULL,NULL,NULL,NULL,NULL,NULL,     /*310*/
NULL,NULL,NULL,NULL,NULL,NULL,"\"\"","GOLD","HELP",NULL,        /*320*/
NULL,"D+NL","D+NL",NULL,NULL,"SCS",NULL,NULL,"HELP",NULL,       /*330*/
NULL,NULL,NULL,"GOLD",NULL,"\"\"",NULL,"SCS",NULL,NULL,         /*340*/
NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"\"\"","GOLD",          /*350*/
"HELP",NULL,NULL,NULL,"D+NL",NULL,NULL,NULL,NULL,NULL,          /*360*/
NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,              /*370*/
NULL,NULL,NULL,NULL,                                            /*380*/
/* Special escape keys (CSI and SS3) */
                    NULL,KP_FIND,"PASTE","CUTSR","SEL","(-16L)",
"(+16L)",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,          /*390*/
NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,              /*400*/
NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,              /*410*/
NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,              /*420*/
NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,              /*430*/
NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"-V",              /*440*/
"+V","+C","-C",NULL,NULL,NULL,NULL,NULL,NULL,NULL,              /*450*/
NULL,".",NULL,NULL,"GOLD","HELP","\"\"","D+NL",NULL,NULL,       /*460*/
NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,              /*470*/
NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,              /*480*/
NULL,NULL,"D+C","DEW","SEL",NULL,"L","W","EL","C",              /*490*/
"ADV","BACK","CUTSR","PAGETOP","(16L)","APPENDSR",NULL,NULL,NULL,NULL,  /*500*/
NULL,NULL,                                                      /*510*/
/* GOLDED Normal ASCII codes */
          NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,
"SHL",NULL,NULL,NULL,"SHR",NULL,NULL,NULL,NULL,NULL,            /*520*/
NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,              /*530*/
NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,              /*540*/
NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,              /*550*/
NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,              /*560*/
NULL,NULL,NULL,NULL,NULL,NULL,NULL,"TC","TGTAB",NULL,           /*570*/
"TD","TI",NULL,NULL,"BL",NULL,"DBW","DEFK","LEARN",NULL,        /*580*/
NULL,NULL,NULL,NULL,"REF",NULL,"TADJSR","DBL",NULL,"REF",       /*590*/
"EXTDO",NULL,"EX",NULL,NULL,NULL,NULL,NULL,NULL,"TC",           /*600*/
"TGTAB",NULL,"TD","TI",NULL,NULL,"BL","TAB","DBW","DEFK",       /*610*/
"LEARN",NULL,NULL,NULL,NULL,NULL,"REF",NULL,"TADJSR","DBL",     /*620*/
NULL,"REF","EXTDO",NULL,"EX",NULL,NULL,NULL,NULL,NULL,          /*630*/
/* GOLDED Function keys */
NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,              /*640*/
NULL,NULL,NULL,KP_SUBS,NULL,NULL,NULL,NULL,NULL,NULL,           /*650*/
NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,              /*660*/
NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,              /*670*/
NULL,NULL,NULL,NULL,"UNDC","UNDW","RESET",NULL,"(^M-C)","CHGCSR",       /*680*/
"D+EL","ASC","ER","BR","PASTE",KP_CMND,"FILLSR",KP_REPLC,NULL,NULL,     /*690*/
NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,              /*700*/
NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,              /*710*/
NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,              /*720*/
NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,              /*730*/
NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,              /*740*/
NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,              /*750*/
NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,                        /*760*/
/* GOLDED Escaped keys */
                                        NULL,NULL,
NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,              /*770*/
NULL,KP_SUBS,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,           /*780*/
NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,              /*790*/
NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,              /*800*/
NULL,NULL,"UNDC","UNDW","RESET",NULL,"(^M-C)","CHGCSR","D+EL","ASC",    /*810*/
"ER","BR","PASTE",KP_CMND,"FILLSR",KP_REPLC,NULL,NULL,NULL,NULL,        /*820*/
NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,KP_FIND,NULL,           /*830*/
"HELP",NULL,NULL,"UNDL","UNDL",NULL,NULL,NULL,NULL,NULL,        /*840*/
"HELP",NULL,"HELP",NULL,NULL,NULL,NULL,KP_FIND,NULL,NULL,       /*850*/
NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,              /*860*/
KP_FIND,NULL,"HELP",NULL,NULL,NULL,NULL,NULL,NULL,NULL,         /*870*/
NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,              /*880*/
NULL,NULL,NULL,NULL,NULL,NULL,                                  /*890*/
/* GOLDED Special escape keys (CSI and SS3) */
                              NULL,NULL,NULL,NULL,
NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,              /*900*/
NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,              /*910*/
NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,              /*920*/
NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,              /*930*/
NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,              /*940*/
NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,              /*950*/
NULL,NULL,NULL,"SHR","SHL",NULL,NULL,NULL,NULL,NULL,            /*960*/
NULL,NULL,NULL,KP_SUBS,NULL,NULL,NULL,"HELP",KP_FIND,"UNDL",    /*970*/
NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,              /*980*/
NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,              /*990*/
NULL,NULL,NULL,NULL,"UNDC","UNDW","RESET",NULL,"(^M-C)","CHGCSR",       /*1000*/
"D+EL","ASC","ER","BR","PASTE",KP_CMND,"FILLSR",KP_REPLC,NULL,NULL,     /*1010*/
NULL,NULL,NULL,NULL};                                           /*1020*/

initfuncs()
{
    register Nkrec *nk;
    register Lnrec *ln;
    register int i;

    for (i = 0, nk = nokey; i <= E_SEA; i++, nk++)
        switch (i)
        {
        case  0:
            nk->keyfun = qqadv;
            break;
        case  1:
            nk->keyfun = qqcutpasta;
            break;
        case  2:
            nk->keyfun = qqasc;
            break;
        case  3:
            nk->keyfun = qqback;
            break;
        case  4:
            nk->keyfun = qqbell;
            break;
        case  5:
            nk->keyfun = qqchgc;
            break;
        case  6:
            nk->keyfun = qqchgc;
            break;
        case  7:
            nk->keyfun = qqchgc;
            break;
        case  8:
            nk->keyfun = qqcircum;
            break;
        case  9:
            nk->keyfun = qqclss;
            break;
        case 10:
            nk->keyfun = qqcutpasta;
            break;
        case 11:
            nk->keyfun = qqdate;
            break;
        case 12:
            nk->keyfun = qqdefk;
            break;
        case 13:
            nk->keyfun = qqdesel;
            break;
        case 14:
            nk->keyfun = qqd;
            break;
        case 15:
            nk->keyfun = qqext;
            break;
        case 16:
            nk->keyfun = qqex;
            break;
        case 17:
            nk->keyfun = qqfill;
            break;
        case 18:
            nk->keyfun = qqhelp;
            break;
        case 19:
            nk->keyfun = qqi;
            break;
        case 20:
            nk->keyfun = qqks;
            break;
        case 21:
            nk->keyfun = qqlrn;
            break;
        case 22:
            nk->keyfun = qqov;
            break;
        case 23:
            nk->keyfun = qqcutpasta;
            break;
        case 24:
            nk->keyfun = qqquit;
            break;
        case 25:
            nk->keyfun = qqref;
            break;
        case 26:
            nk->keyfun = qqref;
            break;
        case 27:
            nk->keyfun = qqsel;
            break;
        case 28:
            nk->keyfun = qqshl;
            break;
        case 29:
            nk->keyfun = qqshr;
            break;
        case 30:
            nk->keyfun = qqsn;
            break;
        case 31:
            nk->keyfun = qqssel;
            break;
        case 32:
            nk->keyfun = qqs;
            break;
        case 33:
            nk->keyfun = qqtab;
            break;
        case 34:
            nk->keyfun = qqtadj;
            break;
        case 35:
            nk->keyfun = qqtc;
            break;
        case 36:
            nk->keyfun = qqtd;
            break;
        case 37:
            nk->keyfun = qqtgsel;
            break;
        case 38:
            nk->keyfun = qqtgtab;
            break;
        case 39:
            nk->keyfun = qqti;
            break;
        case 40:
            nk->keyfun = qqtop;
            break;
        case 41:
            nk->keyfun = qqund;
            break;
        case 42:
            nk->keyfun = qqiself;
            break;
        case 43:
            nk->keyfun = movSimple;
            break;
        case 44:
            nk->keyfun = movWSEN;
            break;
        case 45:
            nk->keyfun = movWSEN;
            break;
        case 46:
            nk->keyfun = movWSEN;
            break;
        case 47:
            nk->keyfun = movLine;
            break;
        case 48:
            nk->keyfun = movLine;
            break;
        case 49:
            nk->keyfun = movLine;
            break;
        case 50:
            nk->keyfun = movLine;
            break;
        case 51:
            nk->keyfun = movWSEN;
            break;
        case 52:
            nk->keyfun = movWSEN;
            break;
        case 53:
            nk->keyfun = movWSEN;
            break;
        case 54:
            nk->keyfun = movParPage;
            break;
        case 55:
            nk->keyfun = movParPage;
            break;
        case 56:
            nk->keyfun = movParPage;
            break;
        case 57:
            nk->keyfun = movParPage;
            break;
        case 58:
            nk->keyfun = movParPage;
            break;
        case 59:
            nk->keyfun = movParPage;
            break;
        case 60:
            nk->keyfun = movSR;
            break;
        case 61:
            nk->keyfun = movSimple;
            break;
        case 62:
            nk->keyfun = movSimple;
            break;
        case 63:
            nk->keyfun = movSimple;
            break;
        case 64:
            nk->keyfun = movSEA;
            break;
        }

    for (i = 0, ln = lw; ln->kw != NULL; ln++, i++)
        switch (i)
        {
        case S_ADJUST:
        case S_BEGIN:
        case S_BOUNDE:
        case S_BUFFER:
        case S_CASE:
            ln->func = NULL;
            break;
        case S_CHANGE:
            ln->func = qlchange;
            break;
        case S_CLEAR:
            ln->func = qlclear;
            break;
        case S_COMMAN:
            ln->func = NULL;
            break;
        case S_CONTROL:
            ln->func = (int (*)())&qcz;
            break;
        case S_COPY:
            ln->func = qlcopy;
            break;
        case S_CURSOR:
            ln->func = NULL;
            break;
        case S_DEFINE:
            ln->func = qldefine;
            break;
        case S_DELETE:
            ln->func = qldelete;
            break;
        case S_DELIMI:
        case S_DIACRI:
        case S_END:
        case S_ENTITY:
        case S_EXACT:
            ln->func = NULL;
            break;
        case S_EXECUT:
            ln->func = qldone;
            break;
        case S_EXIT:
            ln->func = qldone;
            break;
        case S_FILES:
            ln->func = NULL;
            break;
        case S_FILL:
            ln->func = qlfill;
            break;
        case S_FNF:
            ln->func = (int (*)())&qfnf;
            break;
        case S_FIND:
            ln->func = qlfind;
            break;
        case S_HELP:
            ln->func = qlhelp;
            break;
        case S_GENERA:
            ln->func = NULL;
            break;
        case S_GOLD:
            ln->func = NULL;
            break;
        case S_INCLUD:
            ln->func = qlinclud ;
            break;
        case S_INSENS:
            ln->func = NULL;
            break;
        case S_INSERT:
            ln->func = qlinrep;
            break;
        case S_KEYPAD:
            ln->func = (int (*)())&qkeypad;
            break;
        case S_KEY:
        case S_LINES:
        case S_MACRO:
        case S_MODE:
            ln->func = NULL;
            break;
        case S_MOVE:
            ln->func = qlcopy;
            break;
        case S_NEXT:
            ln->func = qlsub;
            break;
        case S_NONE:
            ln->func = NULL;
            break;
        case S_NUMBER:
            ln->func = (int (*)())&qnumber;
            break;
        case S_NUMLOCK:
            ln->func = (int (*)())&numstate;
            break;
        case S_OVERWRITE:
            ln->func = (int (*)())&qoverwr;
            break;
        case S_PARAGR:
        case S_PAGE:
        case S_PROMPT:
        case S_PRINT:
        case S_QUERY:
            ln->func = NULL;
            break;
        case S_QMC:                                              /*014*/
            ln->func = (int (*)())&qqmc;                         /*014*/
            break;                                               /*014*/
        case S_QUIET:
            ln->func = (int (*)())&quiet;
            break;
        case S_QUIT:
            ln->func = qldone;
            break;
        case S_REPLAC:
            ln->func = qlinrep;
            break;
        case S_SCREEN:
        case S_TEXT:
        case S_SEARCH:
        case S_SENTEN:
            ln->func = NULL;
            break;
        case S_SET:
            ln->func = qqset;
            break;
        case S_SHOW:
            ln->func = qqshow;
            break;
        case S_SUMMAR:
            ln->func = (int (*)())&qsummary;
            break;
        case S_SUBSTI:
            ln->func = qlsub;
            break;
        case S_TAB:
            ln->func = qltabadj;
            break;
        case S_TRUNCA:
            ln->func = (int (*)())&qtrunc;
            break;
        case S_TYPE:
            ln->func = qltype;
            break;
        case S_UNBOUN:
        case S_UPPER:
        case S_VERSIO:
            ln->func = NULL;
            break;
        case S_VERIFY:
            ln->func = (int (*)())&qverify;
            break;
        case S_WORD:
        case S_WORKING:
        case S_WPS:
        case S_WRAP:
            ln->func = NULL;
            break;
        case S_WRITE:
            ln->func = qlwrite;
            break;
        case S__BRIEF:
        case S__DUPLI:
        case S__NOTYP:
        case S__SAVE:
        case S__SEQUE:
        case S__STAY:
        case S__QUERY:
        case S_ALPHA:
        case S_JOURNA:
        case S_NOJOUR:
        case S_FUNCTION:
        case S_ESC:
        case S_SCS:
            ln->func = NULL;
            break;
        case S_DOS:
            ln->func = qldos;
            break;
        case S_BEFORE:
        case S_REST:
        case S_WHOLE:
        case S_LAST:
        case S_SELECT:
        case S_ALL:
        case S_FLASHI:
            ln->func = NULL;
            break;
        case S_BANNER:
            ln->func = (int (*)())&qbanner;
            break;
        case S_COLOR:
        case S_ERROR:
        case S_BLACK:
        case S_BLUE:
        case S_GREEN:
        case S_CYAN:
        case S_RED:
        case S_MAGENT:
        case S_BROWN:
        case S_LGREY:
        case S_DGRAY:
        case S_LBLUE:
        case S_LGREEN:
        case S_LCYAN:
        case S_LRED:
        case S_LMAGEN:
        case S_YELLOW:
        case S_WHITE:
        case S_OUTPUT:
        case S_NOOUTPUT:                                         /*003*/
        case S_MULTINAT:                                         /*007*/
        case S_NOCOMM:
        case S_READO:
        case S_RECOVE:
        case S_VT100:
		case S_VT220:
        case S_TV921:
		case S_TV950:
        case S_MAXCOL:
        case S_ASCII:
        case S_NOVERS:
        case S_NOEDTOLD:
        case S_EDTOLD:
        case S_NOVNUM:
        case S_VNUMBR:
            ln->func = NULL;
            break;
        case S_OVERSTRIKE:
            ln->func = (int (*)())&qoverwr;
            break;
        case S_TABC:
            ln->func = (int (*)())&qtabc;
            break;
#ifdef TERM
        case S_EDIT:
            ln->func = NULL;
            break;
        case S_EIGHT:
            ln->func = NULL;
            break;
        case S_HCPY:
            ln->func = NULL;
            break;
        case S_SCROLL:
            ln->func = NULL;
            break;
        case S_TERM:
            ln->func = NULL;
            break;
        case S_VT100:
            ln->func = NULL;
            break;
        case S_VT52:
            ln->func = NULL;
            break;
#endif
        }

}
