          PROGRAM  CTSCAN
************************************************************************
*                                                                      *
*        SYNTAX SCANNER FOR ONLINE USERS                               *
*                                                                      *
*        GET STRING OF N BYTES FROM LINE BUFFER AT CURRENT             *
*        CURSOR POSITION                                               *
*                                                                      *
*        T.LINBUF : ADDRESS OF BUFFER TO BE SCANNED                    *
*                                                                      *
*        BYTE 17: CURRENT SCAN POSITION                                *
*                                                                      *
*        REG 5  : CHARACTER COUNT IN T.FIELD                           *
*                                                                      *
*        REG 4   : LAST PROCESSED DELIMITER                            *
*                                                                      *
************************************************************************
R0       EQU       0
R1       EQU       1
R2       EQU       2
R3       EQU       3
R4       EQU       4
R5       EQU       5
R6       EQU       6
R7       EQU       7
C.TSAD   EQU       X'A80'          ADDR OF TSA
T.LINBUF EQU       X'738'
         SPACE     2
************************************************************************
*   LOCAL MACROS
************************************************************************
         SPACE     1
ENTER    DEFM
         TRR       SP,R1           STACK PTR FOR CALLING FUNCTION
         SUI       SP,8W           DECREMENT SP FOR CALLED ROUTINE
         STD       R0,2W,SP        STORE RETURN ADDR IN STACK
         STF       R4,4W,SP        STORE REGS 4 THROUGH 7 IN STACK
         STW       SP,SPSAVE      SAVE STACK POINTER
         ENDM
         SPACE     1
RETURN   DEFM
         LW        SP,SPSAVE      RESTORE THE STACK POINTER
         LF        R2,2W,SP        RESTORE REGISTERS FROM STACK
         TRSW      R2              RETURN TO CALLING ROUTINE
         ENDM
SP       EQU       3
         DEF       _tscan
         CSECT
         BOUND     1W
_tscan   EQU       $
         ENTER
         LW        R6,16W,R3       PICK UP TOKEN BUFFER ADDRESS
         LW        R7,17W,R3       PICK UP TOKEN BUFFER LENGTH
         LW        R1,C.TSAD       TSA LOC
         LW        R1,T.LINBUF,R1  BUFFER INPUT LOCATION
SCANNER  TRR       R1,R0           SAVE LINEBUFFER ADDRESS
         LI        R4,X'0D'        DUMMY TERMINATOR FOR E.O.B   24OCT80A
         ZR        R5              STRING COUNTER FLAG
         TRR       R1,R2           SET UP BUFFER INDEX
         BZ        STR.3           DO NOTHING
         ZBM       31,BLNKS        CLEAR BLANKS ACTIVE FLAG
         ZBM       30,BLNKS        CLEAR ' IN PROGRESS FLAG
         TRR       R6,R3           SET UP OUTPUT ADDRESS
*        ZBR       R3,12           CLEAR F BIT
         LW        R6,CHARPOS      GET CHARPOS
         BNE       STRING0         INITIALIZED, SKIP AHEAD
         LB        R6,17B,R1       GET CHARACTER POINTER
         STW       R6,CHARPOS      SAVE LOCALLY
STRING0  LB        R6,16B,R1       GET LENGTH OF LBUF IN WORDS
         SLL       R6,2            MAKE BYTES
         TRN       R6,R6           MAKE NEGATIVE
         ADMW      R6,CHARPOS      COMPUTE NEG REMAINING BYTE COUNT
         BGE       STRING4         DONE ...
         ADMW      R2,CHARPOS      ADD CURSOR POSITION
STRING1  EQU       $
         LB        R4,0B,R2        GET BYTE FROM LINE BUFFER
         LI        R1,0
STRING1A EQU       $
         CAMB      R4,DELIMS,R1    CHECK AGAINST KNOWN DELIMS
         BNE       STRING1B        OK
         SLL       R1,2            WORD ALIGN INDEX
         BU        *ACTIONS,R1     DISPATCH ROUTINE
STRING1B EQU       $
         ADI       R1,1
         CI        R1,DELIM#       AT END
         BLT       STRING1A        NOT YET
STRING1C CAR       R7,R5           AMASSED ENTIRE STRING YET
         BGE       NEXTCHAR        YES
         STB       R4,0B,R3        MOVE TO WORK BUFFER
         SBM       31,BLNKS        SET BLANKS NO LONGER ACTIVE FLAG
         ABR       R2,31           INPUT STRING BYTE ADDRESS
         ABR       R3,31           OUTPUT STRING BYTE ADDRESS
         ABR       R5,31           BUMP THIS STRING COUNTER
NEXTCHAR BIB       R6,STRING1      SCAN TILL E.O.B.
         BU        STRING2A
STRING2  EQU       $
         TBM       30,BLNKS        ARE WE PASSING TEXT
         BS        STRING1C        YES, PUT CHAR IN OUTPUT
STRING2A TRR       R0,R1           RESTORE ADDRESS OF LINEBUFFER
         ADI       R2,1B           BUMP PAST DELIMITER
         SUR       R1,R2           DISTANCE TRAVELED
STR.2    STW       R2,CHARPOS      AND SAVE AS CURSOR NOW
STR.3    TRR       R5,R0           RETURN ACTUAL COUNT
         RETURN                    RETURN
*
*
*        SKIP LEADING BLANKS
*
STRING3  EQU       $
         TBM       30,BLNKS        ARE WE PASSING TEXT
         BS        STRING1C        YES, PUT CHAR IN OUTPUT
         TBM       31,BLNKS        ARE WE TRAVELING ACROSS LEAD BLANKS ?
         BS        STRING2         NOPE-> THATS A DELIMITER
         ADI       R2,1B           YES--> BUMP OVER THEM
         BIB       R6,STRING1      KEEP SCANNING TIL EOB
         BU        STRING2         DONE AT EOB
*
STRING4  TRR       R0,R1           RESTORE ADDRESS OF LINEBUFFER
         LI        R2,255          FORCE END OF MEDIUM FOR NEXT CALL
         BU        STR.2           TAKE NORMAL RETURN
*
STRING6  EQU       $
         TRR       R0,R1           RESTORE LINEBUFFER ADDRESS
         LB        R1,CHARPOS      GET INITIAL CURSOR POSITION
         CI        R1,5W           IS THIS THE FIRST FIELD
         BEQ       STRING5         IF SO, TREAT LIKE DOLLAR SIGN
         BU        STRING4         ELSE, TREAT AS END OF LINE
*
STRING5  CI        R5,0            FIRST CHARACTER IN FIELD
         BNZ       STRING1C        NO
         STB       R4,0B,R3        SAVE THIS CHARACTER
         ABR       R5,31           BUMP CHARACTERS IN FIELD
         BU        STRING2         COMMON EXIT
*
*        PASS TEXT UNTIL CR OR NEXT ' ARE FOUND
*
STRING7  EQU       $
         ZBM       30,BLNKS        ARE WE PASSING TEXT?
         BS        STRING2A        YES WE ARE AT END, USE AS A DELIMITER
         SBM       30,BLNKS        SHOW WE ARE PASSING TEXT
         ADI       R2,1B           SKIP OVER ' CHAR IN TEXT
         BIB       R6,STRING1      KEEP SCANNING TIL EOB
         BU        STRING2A        DONE AT EOB
         PAGE
*
*        CONSTANTS AND JUNK
*
*
*
CR       EQU       X'0D'           ASCII CARRAIGE RETURN
NL       EQU       X'0A'           ASCII NEW LINE
*
*        DELIMITER WIDGETS
*
         BOUND     1W
DELIMS   EQU       $
         DATAB     X'20'           00 - BLANK CHAR
         DATAB     C','            02 - COMMAN CHAR
         DATAB     CR              04 - CARRAIGE RETURN
         DATAB     C'"''           12 - APOS
DELIM#   EQU       $-DELIMS        COUNT IN TABLE
         DATAB     C'='            03 - EQUAL SIGN
         DATAB     NL              05 - NEW LINE
*        DATAB     C'('            06 - LEFT PAREN
*        DATAB     C')'            07 - RIGHT PAREN
         DATAB     C'";'           08 - SEMI-COLON
         DATAB     C'!'            09 - EXCLAMATION POINT
         DATAB     C'"%'           10 - PERCENT
         DATAB     C'$'            11 - DOLLAR SIGN
         BOUND     1W
*
*        ROUTINES TO HANDLER ABOVE DELIMITERS
*
ACTIONS  EQU       $
         ACH       STRING3         00 - BLANKS
         ACH       STRING2         02 - COMMAS
         ACH       STRING4         04 - CARRAIGE RETURNS
         ACH       STRING7         12 - APOS
         ACH       STRING2         03 - EQUAL SIGNS
         ACH       STRING2         05 - NEW LINES
*        ACH       STRING2         06 - LEFT PAREN
*        ACH       STRING2         07 - RIGHT PAREN
         ACH       STRING2         08 - SEMI-COLON
         ACH       STRING6         09 - EXCLAMATION POINT
         ACH       STRING2         10 - PERCENT
         ACH       STRING5         11 - DOLLAR SIGN
         REL
         BOUND     1W
SPSAVE   REZ       1W
CHARPOS  REZ       1W
BLNKS    REZ       1W              LEADING BLANKS FLAG
         END
