  @  /*~!username.c*/  ,/* Name:  username.c Part No.: _______-____r ,  *  - * Copyright 1992 - J B Systems, Morrison, CO -  *  G * The recipient of this product specifically agrees not to distribute, G G * disclose, or disseminate in any way, to any one, nor use for its own G G * benefit, or the benefit of others, any information contained  herein G 8 * without the expressed written consent of J B Systems. 8  *  / *                     RESTRICTED RIGHTS LEGEND /  *  D * Use, duplication, or disclosure by the Government is  subject  to D D * restriction  as  set forth in paragraph (b) (3) (B) of the Rights D D * in Technical Data and Computer Software  Clause  in  DAR  7-104.9 D  * (a).   */     "#ident	"@(#)nbclib:username.c	1.0" "        @  #ifdef MPX1X     #include <finfo.h>  #include <limits.h>  #include <string.h>     (/* these routines only used in MPX 1X */ (    
/* setuser 
 8 * will set current username to that specified by caller 8 ; * old username and key will be saved so it can be restored ; $ * by restuser routine defined below $ " * returns 0 for O.K., 1 for error "  */  @static int tmpuser[2];	/* where we save username for restuser */ @ 0    			/* if tmpuser[0] == 0:  -> no username */ 0 3    			/* if tmpuser[0] != 0:  -> ascii username */ 3 7static short tmpkey;	/* where we save compressed key */ 7 :static short chgun;	/* set non zero if username changed */ :    /extern short userkey;	/* defined in mpxini.c */ /                                               @  /extern int curwdir[];	/* defined in mpxini.c */ /    setuser(un, ky)  #int * un;	/* new username to set */ # )    		/* if un[0] == 0: -> no username */ ) :    		/* if un[0] and un[1] == 'SYSTEM': -> no username */ : <    		/* if un[0] and un[1] == all blanks: -> no username */ < +    		/* if un[0] != 0: -> have username */ +    "int * ky;	/* new userkey to set */ " 7    		/* if ky[0] == 0 and ky[1] == val: -> comp key */ 7 3    		/* if ky[0] == 0 and ky[1] == 0: -> no key */ 3 :    		/* if ky[0] and ky[1] are ascii blanks: -> no key */ : '    		/* if ky[0] != 0: -> ascii key */ ' {      int tempuser[2];      int tempkey[2];      int reg[8];     0    getcwvd();			/* get current username info */ 0                                          @  /    chgun = 0;			/* username not changed yet */ / 5    tmpuser[0] = curwdir[0];	/* save curr username */ 5 5    tmpuser[1] = curwdir[1];	/* save curr username */ 5 2    tmpkey = userkey;   	/* save compressed key */ 2    >    /* if curwdir is null, no username associated with task */ > 9    /* i.e., it is system.  Userkey would also be null */ 9 2    /* set up new username, assume system fisrt */ 2 .    tempuser[0] = 0;		/* assume no username */ . .    tempuser[1] = 0;		/* assume no username */ . ,    tempkey[0] = 0;		/* assume no userkey */ , ,    tempkey[1] = 0;		/* assume no userkey */ ,        if (un[0] != 0) {  6      /* we have a name, check for system or blanks */ 6 4      if (strnicmp ((char *)un, "SYSTEM  ", 8) == 0) 4     	;          @  8      else if (strncmp ((char *)un, "        ", 8) == 0) 8     	;  4      /* not system or blanks, must have username */ 4 5      else strncpy ((char *)tempuser, (char *)un, 8); 5     }     E    /* tempuser now has null or username, check if the same as old */ E $    /* see if using same username */ $ E    if ((tempuser[0] != tmpuser[0]) || (tempuser[1] != tmpuser[1])) { E ;      /* we need to change username, first determine key */ ; 3      if (strncmp ((char *)ky, "        ", 8) == 0) 3     	;  <      /* not blanks, copy userkey, could be null or ascii */ <       else {  *    	tempkey[0] = ky[0]; /* set userkey */ * *    	tempkey[1] = ky[1]; /* set userkey */ *       }           /* set key in r4 & r5 */                                @        reg[4] = tempkey[0];        reg[5] = tempkey[1];     #      /* set username in r6 & r7 */ #       reg[6] = tempuser[0];        reg[7] = tempuser[1];  ?      mpxsvc (0x1074, reg, reg);	/* set new username, m.user */ ? <      if (reg[6] != tempuser[0])	/* if changed, not valid */ < (        return (1);			/* return error */ ( '      /* we have valid username, key */ ' 1      chgun = 1;			/* show we changed username */ 1     }       return (0);				/* success */   }     /* resetuser  @ * will reset the username to what it was before calling setuser @ # * only reset if chgun flag was set #  */  resetuser()  {      int reg[8];         if (chgun == 0)  )      return;			/* not changed, return */ )                            @       /* set old key in r4 & r5 */       reg[4] = 0;      reg[5] = tmpkey;     %    /* set old username in r6 & r7 */ %     reg[6] = tmpuser[0];      reg[7] = tmpuser[1];     ;    mpxsvc (0x1074, reg, reg);	/* reset username, m.user */ ; %    /* we have reset username, key */ % /    chgun = 0;			/* show we changed username */ / }     C/* the following finfo is used by pn2fib to store converted path */ C $/* it's definition is in unixio.h */ $    static struct finfo fibx;     6/* pn2fib converts a pathname to file infomation block 6 G * path has following forms: @SYSTEM(USERNAME,USERKEY)FILENAME,PASSWORD G 1 *           ^(USERNAME,USERKEY)FILENAME,PASSWORD 1  *           (USERNAME)FILENAME   *           FILENAME                  @  G * Note: USERNAME, USERKEY, or PASSWORD can be blanks to represent NULL G  *  4 * address of fibx above is returned if O.K., else 0 4  */     &/* set l chars in array p to blanks */ & '#define SETBLK(p,l) memset((p),' ',(l)) ' char * xt8ch();     struct finfo *  pn2fib(path)  char * path;  {  
    int i; 
     char *p = path;  
    char *tp; 
    0    ZINT ((int *)&fibx,9);		/* clear temp fib */ 0     if ( !p || !(*p))  ,      return(NULL);			/* error if no path */ ,    3    /* set current username as default directory */ 3 '    getcwvd();		/* get current stuff */ ' "    fibx.username[0] = curwdir[0]; " "    fibx.username[1] = curwdir[1]; "     fibx.userkey[1] = userkey;                                                     @  E    /* see if pseudo volume name present, if so, strip path to '(' */ E     if (*p == '@' || *p == '^')  '      if ((p = strchr(p, '(')) == NULL) '     	return(NULL);     E    /* see if username present, if so, copy up to ',' or ')' found */ E     if (*p == '(') {  !      p++;				/* skip over '(' */ ! !      tp = (char *)fibx.username; !    0      /* extract username, stop on ',' or ')' */ 0 *      if ((p = xt8ch(p, tp, ')')) == NULL) *     	return(NULL);        if (!(*p))  2    	return(NULL);			/* if no more chars, error */ 2    /      /* if we have a ',' userkey is present */ /       if (*p == ',') {  #        p++;				/* skip over ',' */ #     	tp = (char *)fibx.userkey;     .    	/* extract userkey, stop on ',' or ')' */ .     @  )    	if ((p = xt8ch(p, tp, ')')) == NULL) )     	  return(NULL);      	if (!(*p))  4    	  return(NULL);			/* if no more chars, error */ 4     	if (*p == ',')  *    	  return(NULL);			/* bad delimiter */ *       }     >      /* here, we should be pointing at a ')'. Skip over it */ >       ++p;  /* skip over ')' */      }     8    /* now we can process filename and maybe password */ 8     tp = (char *)fibx.filename;      if (!(*p)) {  D      /* We will let this be O.K. when just the username is given */ D .      SETBLK(tp,8);			/* blank the filename */ . )      return (&fibx);			/* return O.K. */ ) 5/*      return(NULL);			/* if no more chars, error */ 5     }     .    /* extract filename, stop on ',' or EOL */ .                 @  )    if ((p = xt8ch(p, tp, '\0')) == NULL) )       return(NULL);     .    /* if we have a ',' password is present */ .     if (*p == ',') {  !      p++;				/* skip over ',' */ ! !      tp = (char *)fibx.password; !    0      /* extract password, stop on ',' or EOL */ 0 +      if ((p = xt8ch(p, tp, '\0')) == NULL) +     	return(NULL);        if (*p == ',')  (    	return(NULL);			/* bad delimiter */ (     }     :    /* now we are at end of line, exit if no more chars */ : 
    if ((*p)) 
 0      return(NULL);			/* if more chars, error */ 0     return (&fibx);  }     7/* extract an 8 char name and blank fill if required */ 7 /* ignore any characters past 8  B/* NOTE: we may also want to do translation of filename characters B       @  9/* return updated pointer on sucess or NULL on failure */ 9    char *  xt8ch(p, tp, tc)  "char * p;		/* input char string */ " $char * tp;		/* output char string */ $ 2char   tc;		/* secondary delimiter to check for */ 2     			/* for none, use ' ' */  ,    			/* if EOL ('\0') allowed, use '\0' */ , {  
    int i; 
        for (i=0; i < 8; i++) {  #      /* char must be 0x20 -> 5f */ # $      /* blanks will specify null */ $ ,      if (!(*p) || (*p < 0x20 || *p > 0x5f)) ,     	if (tc != '\0')      	  return(NULL);        if(*p == ',' || *p == tc)      	break;        *tp++ = *p++;      }     /    /* error if no chars found, report error */ / F    /* if tc is ')' then '()' sequence is ok, null username defined */ F            p@      if (tc != ')')        if (i == 0)      	return (NULL);     *    /* if less than 8 chars, blank fill */ *     if (i < 8)        SETBLK(tp,(8-i));     :    /* if username is > 8 chars, skip over unused chars */ : '    while (*p && *p != ',' && *p != tc) ' 
      ++p; 
    -    return(p);			/* return updated pointer */ - }     #endif                                                                                                                                                                                                                                                                                                                                                                                                                 