  @  /*~!stat.c*/  (/* Name:  stat.c Part No.: _______-____r (  *  - * Copyright 1992 - J B Systems, Morrison, CO -  *  G * The recipient of this product specifically agrees not to distribute, G G * disclose, or disseminate in any way, to any one, nor use for its own G G * benefit, or the benefit of others, any information contained  herein G 8 * without the expressed written consent of J B Systems. 8  *  / *                     RESTRICTED RIGHTS LEGEND /  *  D * Use, duplication, or disclosure by the Government is  subject  to D D * restriction  as  set forth in paragraph (b) (3) (B) of the Rights D D * in Technical Data and Computer Software  Clause  in  DAR  7-104.9 D  * (a).   */     #ident	"@(#)nbclib:stat.c	1.1"                     @  #include <types.h>  #include <limits.h>  #include <stat.h>  #include <string.h>  #include <errno.h>     #ifdef MPX1X  #include <finfo.h>  #endif     
#ifndef MPX1X 
 5/* do not move this definition, must be 2w bounded */ 5 asm (" bound 1d");  Cstatic int rdbuf[192];		/* resource descriptor buffer 2w bounded */ C #else  asm (" bound 1d");  2static unsigned int smd[8];	/* SMD entry buffer */ 2 8static struct finfo * foo;	/* file info block pointer */ 8 #endif     &/* test for the existance of a file */ & "/* returns -1 if file not found */ " "/*   else returns status buffer */ "    int  'stat(pname, sb)			/* get file status */ ' char *pname;  -struct stat *sb;		/* status buffer pointer */ - {      int reg[8];       @      char path[PATH_MAX];      int modft, readt, acc;     $    if (pname == 0 || *pname == 0) { $ 3      errno=ENOENT;		/* set file not found error */ 3 +      return(-1);		/* error return value */ +     }     0    strcpy(path, pname);	/* make a local copy */ 0 .    unix2mpx(path);		/* convert to MPX path */ .    #ifdef MPX1X  '    if ((foo = pn2fib(path)) == NULL) { ' 3      errno=ENOENT;		/* set file not found error */ 3 +      return(-1);		/* error return value */ +     }     .    /* set username for this file, save old */ . 7    if (setuser(foo->username, foo->userkey) != NULL) { 7 3      errno=ENOENT;		/* set file not found error */ 3 +      return(-1);		/* error return value */ +     }                                          @  )    ZINT (smd, 8);		/* clear SMD entry */ )     reg[4] = 0;  2    reg[5] = (int)smd;		/* where SMD entry goes */ 2 ;    reg[6] = foo->filename[0];	/* first part of filename */ ; <    reg[7] = foo->filename[1];	/* second part of filename */ < 2    mpxsvc (0x1073, reg, reg);	/* m.log service */ 2    *    /* if r5 returned 0, file not found */ *     if (reg[5] == 0) {  7      resetuser();		/* reset username to what it was */ 7 3      errno=ENOENT;		/* set file not found error */ 3 +      return(-1);		/* error return value */ +     }  3    /* must reset username to what it before log */ 3 5    resetuser();		/* reset username to what it was */ 5    #else /* MPX1X */     (    reg[1] =  (int) path;		/* get pnv */ (                               @  1    reg[1] |= (strlen(path) << 24);	/* get pnv */ 1 1    reg[6] = (int)rdbuf;		/* rd buffer address */ 1     reg[7] = 0;				/* no cnp */  3    mpxsvc (0x202c, reg, reg);		/* m.loc service */ 3     if (reg[7] != 0) {  4      errno=ENOENT;			/* set file not found error */ 4 ,      return(-1);			/* error return value */ ,     }  #endif     #ifdef MPX1X  4    /* simulate status buffer info from SMD entry */ 4 =    sb->st_dev = smd[5] & 0xffff;	/* use udt index for dev */ = F    sb->st_ino = smd[2] & 0xffffff;	/* use starting blk # for inode */ F F    sb->st_blocks = smd[2] & 0xffffff;	/* above is 16 bits, need 24 */ F $    /* use file type for link cnt */ $ 7    sb->st_nlink = ((unsigned int)smd[2] >> 24) & 0xff; 7                              @      /* use uid for file inds */  5    sb->st_uid = ((unsigned int)smd[3] >> 24) & 0xff; 5 )    sb->st_gid = 0;			/* unused fields */ )     /* password for file */  8    sb->st_rdev = ((unsigned int)smd[6] >> 16) & 0xffff; 8 D    sb->st_size = (smd[3] & 0xffffff) * 768; /* eof size in bytes */ D    ,    /* no time are available, set to zero */ , 5    sb->st_ctime = time(0);		/* create time is now */ 5 ;    sb->st_atime = sb->st_ctime;	/* last access was read */ ; 7    sb->st_mtime = sb->st_ctime;	/* last modify time */ 7 8    sb->st_mode = 0666;			/* assume r/w for everybody */ 8 4    if (sb->st_nlink == 0 || sb->st_nlink == 0xed || 4 3      sb->st_nlink == 0xee || sb->st_nlink == 0x40) 3 7      sb->st_mode |= S_IFCHR;		/* set char file type */ 7  @      else  8      sb->st_mode |= S_IFREG;		/* set to regular file */ 8    #else /* MPX1X */     #    sb->st_dev=0;			/* no device */ # 5    sb->st_ino=rdbuf[6];		/* use block # for inode */ 5 1    sb->st_nlink=rdbuf[34];		/* use link count */ 1 C    sb->st_uid = sb->st_gid = sb->st_rdev = 0;  /* unused fields */ C :    sb->st_size = rdbuf[68] * 768;	/* eof size in bytes */ : H    readt = ((rdbuf[12] - 3653)*86400) + (rdbuf[13] / 10000); /* secs */ H H    modft = ((rdbuf[14] - 3653)*86400) + (rdbuf[15] / 10000); /* secs */ H     if  (modft > readt) {  E      sb->st_atime = sb->st_ctime = modft;  /* last access was mod */ E     } else {  F      sb->st_atime = sb->st_ctime = readt;  /* last access was read */ F     }                           @  1    sb->st_mtime = modft;		/* last modify time */ 1    +    /* convert mpx access to unix access */ + A    acc = (rdbuf[30] & 0xf00000) ? 1 : 0;	/* get delete access */ A ?    acc |= ((unsigned)rdbuf[30] >> 26);		/* make into RWMUAD */ ?     if (acc & 0xf)  .      acc |=0x10;			/* if MUAD, allow write */ . ;    acc = ((acc & 1) | (acc >> 3));	/* set UNIX RWX bits */ ; :    sb->st_mode |= (acc << 6);		/* put in correct place */ :    A    acc = (rdbuf[31] & 0xf00000) ? 1 : 0;	/* get delete access */ A >    acc |= ((unsigned)rdbuf[31] >> 26);	/* make into RWMUAD */ >     if (acc & 0xf)  .      acc |=0x10;			/* if MUAD, allow write */ . ;    acc = ((acc & 1) | (acc >> 3));	/* set UNIX RWX bits */ ;                                                   @  :    sb->st_mode |= (acc << 3);		/* put in correct place */ :    A    acc = (rdbuf[32] & 0xf00000) ? 1 : 0;	/* get delete access */ A ?    acc |= ((unsigned)rdbuf[32] >> 26);		/* make into RWMUAD */ ?     if (acc & 0xf)  .      acc |=0x10;			/* if MUAD, allow write */ . ;    acc = ((acc & 1) | (acc >> 3));	/* set UNIX RWX bits */ ; 4    sb->st_mode |= acc;			/* put in correct place */ 4        /* now set type of file */  *    acc = rdbuf[7] & 0x1f;		/* get type */ * 6    if (acc == 1 || acc == 11)		/* see if directory */ 6 7      sb->st_mode |= S_IFDIR;		/* set directory flag */ 7 =    if (acc == 10 || acc == 12)		/* see if file (tmp/perm) */ = 2      sb->st_mode |= S_IFREG;		/* set file flag */ 2 #endif                                        @  0    /* no flag means it is partition or other */ 0 $    return (0);				/* return o.k. */ $ }     #ifdef MPX1X  #/* get SMD entry for mpx1x files */ #    int  4stat1x(pname, usmd)		/* get file status */ /* MAC */ 4 char *pname;  7unsigned int *usmd;		/* SMD buffer pointer */ /* MAC */ 7 {  6    struct finfo * foo;		/* file info block pointer */ 6     int reg[8], i;				/* MAC */      char path[PATH_MAX];     $    if (pname == 0 || *pname == 0) { $ 3      errno=ENOENT;		/* set file not found error */ 3 +      return(-1);		/* error return value */ +     }     0    strcpy(path, pname);	/* make a local copy */ 0 .    unix2mpx(path);		/* convert to MPX path */ .    '    if ((foo = pn2fib(path)) == NULL) { '                           @  3      errno=ENOENT;		/* set file not found error */ 3 +      return(-1);		/* error return value */ +     }     .    /* set username for this file, save old */ . 7    if (setuser(foo->username, foo->userkey) != NULL) { 7 3      errno=ENOENT;		/* set file not found error */ 3 +      return(-1);		/* error return value */ +     }     )    ZINT (smd, 8);		/* clear SMD entry */ )     reg[4] = 0;  2    reg[5] = (int)smd;		/* where SMD entry goes */ 2 ;    reg[6] = foo->filename[0];	/* first part of filename */ ; <    reg[7] = foo->filename[1];	/* second part of filename */ < 2    mpxsvc (0x1073, reg, reg);	/* m.log service */ 2    9    /* copy our smd entry to user smd buffer */	/* MAC */ 9 $    for (i=0; i<8; i++)				/* MAC */ $                  @  "    	usmd[i] = smd[i];			/* MAC */ "    *    /* if r5 returned 0, file not found */ *     if (reg[5] == 0) {  7      resetuser();		/* reset username to what it was */ 7 3      errno=ENOENT;		/* set file not found error */ 3 +      return(-1);		/* error return value */ +     }     3    /* must reset username to what it before log */ 3 5    resetuser();		/* reset username to what it was */ 5    #    return (0);			/* return o.k. */ # }  #endif                                                                                                                                                                                                                                                                                                            