  @  /*~!lsearch.c*/  +/* Name:  lsearch.c Part No.: _______-____r +  *  - * Copyright 1992 - J B Systems, Morrison, CO -  *  G * The recipient of this product specifically agrees not to distribute, G G * disclose, or disseminate in any way, to any one, nor use for its own G G * benefit, or the benefit of others, any information contained  herein G 8 * without the expressed written consent of J B Systems. 8  *  / *                     RESTRICTED RIGHTS LEGEND /  *  D * Use, duplication, or disclosure by the Government is  subject  to D D * restriction  as  set forth in paragraph (b) (3) (B) of the Rights D D * in Technical Data and Computer Software  Clause  in  DAR  7-104.9 D  * (a).   */     !#ident	"@(#)nbclib:lsearch.c	1.1" !    /*   @  E * Linear search algorithm, generalized from Knuth (6.1) Algorithm Q. E  *  F * This version no longer has anything to do with Knuth's Algorithm Q, F H * which first copies the new element into the table, then looks for it. H H * The assumption there was that the cost of checking for the end of the H L * table before each comparison outweighed the cost of the comparison, which L O * isn't true when an arbitrary comparison function must be called and when the O 4 * copy itself takes a significant number of cycles. 4 D * Actually, it has now reverted to Algorithm S, which is "simpler." D  */     typedef char *POINTER;  extern POINTER memcpy();     POINTER  'lsearch(key, base, nelp, width, compar) '                                           I@  .register POINTER key;		/* Key to be located */ . 0register POINTER base;		/* Beginning of table */ 0 5unsigned *nelp;			/* Pointer to current table size */ 5 :register unsigned width;	/* Width of an element (bytes) */ : +int (*compar)();		/* Comparison function */ + {  A	register POINTER next = base + *nelp * width;	/* End of table */ A    $	for ( ; base < next; base += width) $  		if ((*compar)(key, base) == 0)   !			return (base);	/* Key found */ ! )	++*nelp;			/* Not found, add to table */ ) ?	return (memcpy(base, key, (int)width));	/* base now == next */ ? }                                                                                                                                                                                        