  @  /*~!fwrite.c*/  */* Name:  fwrite.c Part No.: _______-____r *  *  - * Copyright 1992 - J B Systems, Morrison, CO -  *  G * The recipient of this product specifically agrees not to distribute, G G * disclose, or disseminate in any way, to any one, nor use for its own G G * benefit, or the benefit of others, any information contained  herein G 8 * without the expressed written consent of J B Systems. 8  *  / *                     RESTRICTED RIGHTS LEGEND /  *  D * Use, duplication, or disclosure by the Government is  subject  to D D * restriction  as  set forth in paragraph (b) (3) (B) of the Rights D D * in Technical Data and Computer Software  Clause  in  DAR  7-104.9 D  * (a).   */      #ident	"@(#)nbclib:fwrite.c	1.1"      /*      @  J * This version writes directly to the buffer rather than looping on putc. J B * Ptr args aren't checked for NULL because the program would be a B G * catastrophic mess anyway.  Better to abort than just to return NULL. G  *  F * This version does buffered writes larger than BUFSIZ directly, when F  * the buffer is empty.   */     #include <stdio.h>  #include "stdiom.h"  #include <sys/types.h>     '#define MIN(x, y)       (x < y ? x : y) '    extern char *memcpy();     int  fwrite(ptr, size, count, iop)  
char *ptr; 
 
int count; 
 	int size; 	 register FILE *iop;  {  	register long nleft;  	register int n;  '	register unsigned char *cptr, *bufend; ' 	int bufsiz = BUFSIZ;      	if (count <= 0 || _WRTCHK(iop))      @  	        return (0);     	bufend = _bufend(iop);  0	nleft = (long) count * size;	/* may overflow */ 0 :	if (nleft < count || nleft < size)	/* overflow occured */ : 
		return (0); 
       H	/* if the file is unbuffered, or if the iop->ptr = iop->base, and there H :	   is > BUFSZ chars to write, we can do a direct write */ : I	if (iop->_base >= iop->_ptr)  {	/*this covers the unbuffered case, too*/ I ;		if (((iop->_flag & _IONBF) != 0) || (nleft >= bufsiz))  { ; 1			if ((n=write(fileno(iop),ptr,nleft)) != nleft) 1 			    {  				iop->_flag |= _IOERR;  				n = (n >= 0) ? n : 0;  			}  			return n/size;  		}  	}  #	/* Put characters in the buffer */ # >	/* note that the meaning of n when just starting this loop is >                   @  -	   irrelevant.  It is defined in the loop */ - 	for (; ; ptr += n) {  G	        while ((n = bufend - (cptr = iop->_ptr)) <= 0)  /* full buf */ G *	                if (_xflsbuf(iop) == EOF) * B	                        return (count - (nleft + size - 1)/size); B 	        n = MIN(nleft, n);  .	        (void) memcpy((char *) cptr, ptr, n); . 	        iop->_cnt -= n;  	        iop->_ptr += n;  	        _BUFSYNC(iop);  2		/* done; flush if linebuffered with a newline */ 2 "	        if ((nleft -= n) == 0)  { " (			if (iop->_flag & (_IOLBF | _IONBF)) { ( <	               		if ((iop->_flag & _IONBF) || (memchr(cptr, < $					'\n',count * size) != NULL))  { $ 				     	(void) _xflsbuf(iop);  				}  			}   	                return (count);          !@  
	        } 
 	}  }                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                