  @  
/*~!frexp.c*/ 
 )/* Name:  frexp.c Part No.: _______-____r )  *  - * Copyright 1992 - J B Systems, Morrison, CO -  *  G * The recipient of this product specifically agrees not to distribute, G G * disclose, or disseminate in any way, to any one, nor use for its own G G * benefit, or the benefit of others, any information contained  herein G 8 * without the expressed written consent of J B Systems. 8  *  / *                     RESTRICTED RIGHTS LEGEND /  *  D * Use, duplication, or disclosure by the Government is  subject  to D D * restriction  as  set forth in paragraph (b) (3) (B) of the Rights D D * in Technical Data and Computer Software  Clause  in  DAR  7-104.9 D  * (a).   */     #ident	"@(#)nbclib:frexp.c	1.1"     /*         @   * frexp(value, eptr)  9 * returns a double x such that x = 0 or 0.5 <= |x| < 1.0 9 7 * and stores an integer n such that value = x * 2 ** n 7  * indirectly through eptr.   *   */  #include <nan.h>     double  frexp(value, eptr)  ?double value;	/* don't declare register, because of KILLNan! */ ? register int *eptr;  {  	register double absvalue;     @	KILLNaN(value); /* raise exception on Not-a-Number (3b only) */ @ 	*eptr = 0;  /	if (value == 0.0) /* nothing to do for zero */ / 		return (value);  +	absvalue = (value > 0.0) ? value : -value; + *	for ( ; absvalue >= 1.0; absvalue *= 0.5) * 
		++*eptr; 
 .	for ( ; absvalue < 0.5; absvalue += absvalue) . 
		--*eptr; 
 -	return (value > 0.0 ? absvalue : -absvalue); - }     