  @  /*~!fmod.c*/  (/* Name:  fmod.c Part No.: _______-____r (  *  - * Copyright 1992 - J B Systems, Morrison, CO -  *  G * The recipient of this product specifically agrees not to distribute, G G * disclose, or disseminate in any way, to any one, nor use for its own G G * benefit, or the benefit of others, any information contained  herein G 8 * without the expressed written consent of J B Systems. 8  *  / *                     RESTRICTED RIGHTS LEGEND /  *  D * Use, duplication, or disclosure by the Government is  subject  to D D * restriction  as  set forth in paragraph (b) (3) (B) of the Rights D D * in Technical Data and Computer Software  Clause  in  DAR  7-104.9 D  * (a).   */     #ident	"@(#)nbclib:fmod.c	1.1"     /*            r@  : *	fmod(x, y) returns the remainder of x on division by y, :  *	with the same sign as x,  + *	except that if |y| << |x|, it returns 0. +  */     #include <math.h>     double  
fmod(x, y) 
 register double x, y;  {  =	double d; /* can't be in register because of modf() below */ =    	/*  B	 * The next lines determine if |y| is negligible compared to |x|, B A	 * without dividing, and without adding values of the same sign. A 	 */  
	d = _ABS(x); 
 	if (d - _ABS(y) == d)  
		return (x); 
 E	(void) modf(x/y, &d); /* now it's safe to divide without overflow */ E 	return (x - d * y);  }                                                                                                                                               