  @  /*~!bsearch.c*/  +/* Name:  bsearch.c Part No.: _______-____r +  *  - * Copyright 1992 - J B Systems, Morrison, CO -  *  G * The recipient of this product specifically agrees not to distribute, G G * disclose, or disseminate in any way, to any one, nor use for its own G G * benefit, or the benefit of others, any information contained  herein G 8 * without the expressed written consent of J B Systems. 8  *  / *                     RESTRICTED RIGHTS LEGEND /  *  D * Use, duplication, or disclosure by the Government is  subject  to D D * restriction  as  set forth in paragraph (b) (3) (B) of the Rights D D * in Technical Data and Computer Software  Clause  in  DAR  7-104.9 D  * (a).   */     !#ident	"@(#)nbclib:bsearch.c	1.1" !    /*   @  G * Binary search algorithm, generalized from Knuth (6.2.1) Algorithm B. G  *   */     typedef char *POINTER;     POINTER  &bsearch(key, base, nel, width, compar) & &POINTER	key;			/* Key to be located */ & (POINTER	base;			/* Beginning of table */ ( 5unsigned nel;			/* Number of elements in the table */ 5 3unsigned width;			/* Width of an element (bytes) */ 3 +int	(*compar)();		/* Comparison function */ + {  	int two_width = width + width;  E	POINTER last = base + width * (nel - 1); /* Last element in table */ E    	while (last >= base) {     @		register POINTER p = base + width * ((last - base)/two_width); @ '		register int res = (*compar)(key, p); '    		if (res == 0)  			return (p);	/* Key found */  		if (res < 0)       |@  			last = p - width;  		else  			base = p + width;  	}  +	return ((POINTER) 0);		/* Key not found */ + }                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     