  @  /*~!unixio.c*/  */* Name:  unixio.c Part No.: _______-____r *  *  - * Copyright 1990 - J B Systems, Morrison, CO -  *  G * The recipient of this product specifically agrees not to distribute, G G * disclose, or disseminate in any way, to any one, nor use for its own G G * benefit, or the benefit of others, any information contained  herein G 8 * without the expressed written consent of J B Systems. 8  *  / *                     RESTRICTED RIGHTS LEGEND /  *  D * Use, duplication, or disclosure by the Government is  subject  to D D * restriction  as  set forth in paragraph (b) (3) (B) of the Rights D D * in Technical Data and Computer Software  Clause  in  DAR  7-104.9 D  * (a).   */      #ident	"@(#)nbclib:unixio.c	1.0"      /*      @   *      unixio.c   *  , *      UNIX I/O emulation routines - by JCB ,  *  : *	Most of the functions in this file simulate UNIX svc's. : : *	They have been modified to follow System V conventions. :  */     0/* this version opens mode 1 as mpx update.   */ 0 0/* This is because write mode in MPX is not   */ 0 0/* sufficiently similar to write mode on UNIX */ 0    #define _ERRNODEF  #include <types.h>  #include <limits.h>  #include <errno.h>  #include "unixio.h"  #include <stat.h>  #include <string.h>  #include <fcntl.h>     #ifndef	min  ;#define	min(x,y)	((x)<(y)?(x):(y))	/* Lesser of two args */ ; #endif  #ifndef max  <#define	max(x,y)	((x)>(y)?(x):(y))	/* Greater of two args */ < #endif                           @  +#define ERROR (-1)	/* error return value */ + -#define IOEND (-2)      /* this is EOF/EOM */ - &#define IOEOF (0)	/* this is an EOF */ & (#define GOOD (0)	/* good return value */ (    /*    data transfer routines */     /* write primitive */     int write (fd, buf, n)  int fd;  
char *buf; 
 int n;  {    register int mode;    register int dev;    int count = 0;    int i;       BADFD (fd, ERROR);    INIT;    if (n <= 0) {      errno = EINVAL;      mpxerr = E010;      return (ERROR);    }    mode = curfprm->mode;    dev =  curfprm->device;    if (mode & NOTUSED) {      errno = EBADF;      mpxerr = E010;      return (ERROR);    }  &  if (!(mode & (O_WRONLY | O_RDWR))) { &     errno = EACCES;       @      mpxerr = E011;      return (ERROR);    }     "  if (dev == NULLFILE) return (n); "    =  if (curfprm->eof || curfprm->eom) {	/* see if at eof/eom */ = %  curfprm->eof = 0;			/* reset EOF */ % %  curfprm->eom = 0;			/* reset EOM */ % .    return (IOEOF);			/* this means eof/eom */ .   }       if (curfprm->block) {      int zz;      int yy;         if (!curfprm->binary) {        char *p, *bp, *lp;     =      /* we only do this after a linefeed char or 1st time */ =       if (dev == TERMINAL)  	if (curfprm->crlf != 1) {  +	  curfcb->cntl.dfi = 0;		/* allow cr/lf */ + A          i = _putrec (1, " ");		/* force c/r l/f to be output */ A 	  curfcb->cntl.dfi = 1;  	  curfprm->crlf = 1;                                    @  =          if (i != GOOD) return (i == ERROR ? ERROR : IOEOF); = 	        } 	       lp = curfil->line;  *      bp = &curfil->line[curfprm->linptr]; *       p = buf;           for (i=0; i<n; i++) {  +        if (lp == bp && dev == SPOOLFILE) { +           if (carcont) {  A            /* put correct carriage control for terminal or SLO*/ A             if (*p == 0x0c) {                 *bp++ = '1';                 p++;      	       count++;              } else {                 *bp++ = ' ';  
            } 
             curfprm->linptr++;            }  	        } 	            if (*p == '\n') {             if (dev != TERMINAL) {               if (bp == lp) {                *bp++ = ' ';                 curfprm->linptr++;    @  
            } 
 		    p++; 	             count++;            } else {  	    if (curfprm->linptr) {  1              yy = _putrec (curfprm->linptr, lp); 1               if (yy != GOOD)  =    		return (count ? count : (yy == ERROR ? ERROR : IOEOF)); = 
    	    } 
 ,	    curfcb->cntl.dfi = 0;	/* allow cr/lf */ , C            yy = _putrec (1, " ");	/* force c/r l/f to be output */ C 4	    curfcb->cntl.dfi = 1;	/* restore user status */ 4 -	    curfprm->crlf = 1;		/* don't do again */ - #            bp = lp = curfil->line; #              curfprm->linptr = 0;               p++;              if (yy != GOOD)  B    	      return (count ? count : (yy == ERROR ? ERROR : IOEOF)); B             count++;            }      	  yy = GOOD;             @            zz = bp - lp;  D          while ((zz > 254) && ((yy = _putrec (254, lp)) == GOOD)) { D             zz -= 254;              lp += 254;            }            if (yy != GOOD)  @    	    return (count ? count : (yy == ERROR ? ERROR : IOEOF)); @ (          if (zz) yy = _putrec (zz, lp); (           if (yy != GOOD)  @    	    return (count ? count : (yy == ERROR ? ERROR : IOEOF)); @ !          bp = lp = curfil->line; !           curfprm->linptr = 0;          } else {            *bp++ = *p++;            curfprm->linptr++;            count++;  	        } 	       }  6      if ((lp != bp) && curfprm->device == TERMINAL) { 6     	yy = GOOD;          zz = bp - lp;  &        if (zz) yy = _putrec (zz, lp); &                    @          bp = lp = curfil->line;          curfprm->linptr = 0;          if (yy != GOOD)  >    	  return (count ? count : (yy == ERROR ? ERROR : IOEOF)); >       }        return (n);      }  %    /* process blocked binary file */ %     yy = GOOD;      zz = n;  =    while ((zz > 254) && (( yy = _wbl (buf, 254)) == GOOD)) { =       zz -= 254;        buf += 254;        count += 254;      }      if (yy != GOOD)  =      return (count ? count : (yy == ERROR ? ERROR : IOEOF)); =      if (zz) yy = _wbl (buf, zz);       if (yy != GOOD)  =      return (count ? count : (yy == ERROR ? ERROR : IOEOF)); =     count += zz;      return (n);    }    /* process unblocked file */    return( _wub (buf, n));  }                        @  /* read1line primitive */  /* reads only until an EOL */  int read1ln (fd, buf, n)  int fd;  
char *buf; 
 int n;  {  8    return(readcom (fd, buf, n, 1));	/* read one line */ 8 }     /* read primitive */  int read (fd, buf, n)  int fd;  
char *buf; 
 int n;  {  7    return(readcom (fd, buf, n, 0));	/* read n chars */ 7 }     /* read primitive */  int readcom (fd, buf, n, one)  int fd;  
char *buf; 
 int n;  int one;  {    register int mode;    register int dev;       BADFD (fd, ERROR);    INIT;    curfprm->oneln = one;    mode = curfprm->mode;    dev =  curfprm->device;    if (mode & NOTUSED) {      errno = EBADF;      mpxerr = E012;      return (ERROR);    }                           @    if (mode & O_WRONLY) {      errno = EACCES;      mpxerr = E013;      return (ERROR);    }    if (dev == NULLFILE) {      curfprm->eof = 1;      curfprm->eom = 1;  %    return (IOEOF);		/* return EOF */ %   }  
  if (n <= 0) 
     return (IOEOF);     3  return ((curfprm->block ? _rbl : _rub) (buf, n)); 3 }     /* seek primitive */     int seek (fd, off, rel)  
int  fd, rel; 
 	long off; 	 {       BADFD (fd, ERROR);    INIT;    if ((rel > 2) || (rel < 0)) {      errno = EINVAL;      mpxerr = E014;      return (ERROR);    }     if (curfprm->mode & NOTUSED) {       errno = EBADF;      mpxerr = E015;      return (ERROR);    }  "  if (curfprm->device == NULLFILE) "     return (IOEOF);            @  *  if (curfprm->block && (rel==1 || off)) { *     errno = EINVAL;      mpxerr = E016;      return (ERROR);    }  C  if (curfprm->device != DISCFILE && curfprm->device != TERMINAL) { C     if (rel==1 || off) {        errno = EINVAL;        mpxerr = E016;        return (ERROR);      }  
    else { 
       return (_skdv(rel));      }    }    else {  8    return ((curfprm->block ? _skbl : _skub)(off, rel)); 8   }  }     static int _wbl (buf, n)  
char *buf; 
 int n;  {  /*  register int count = 0; */    char *linadrs;    int i;     /  /* version of wbl for binary blocked files */ /   linadrs = curfil->line;     .  memcpy(linadrs, buf,n);	/* move the bytes */ . #ifdef JUNK    while (count < n) {          @      *linadrs++ = *buf++;      count++;    }  #endif       curfprm->linptr = n;       /* write the data record */     return (_putrec (n, linadrs));   }     static int _rbl (buf, n)  
char *buf; 
 int n;  {    register int count = 0;    register char *cp;    int i, j;    char *linadrs;     ?  if (!curfprm->cmpop) {		/* see if we tested for compressed */ ? 4    curfprm->cmpop = 1;			/* set comp tested flag */ 4 "    /* read in the first record */ " !    if ((i = _getrec()) == ERROR) ! .      return (ERROR);			/* this means error */ . 8    if (i == IOEND) return (IOEOF);	/* this means eof */ 8     linadrs = curfil->line;  3    curfprm->charcnt = 0;		/* no chars going out */ 3                                            @  3    curfprm->blanks = 0;		/* no blanks to output */ 3 :    if (*linadrs == 0xbf) {		/* is this file compressed */ : 4      curfprm->cmpflg = 1;		/* set comp data flag */ 4 8      curfprm->bcnt = linadrs[1];	/* set record count */ 8 >      curfprm->bptr = &linadrs[6];      /* set data address */ > ;      curfprm->state = CBLANKS;		/* next state is blanks */ ;     } else goto re00;    }     8  if (curfprm->cmpflg) {		/* reading compressed data? */ 8 ;    /* this code has been changed to fill the entire buffer ; )     * like the normal System V Unix code )      */  re10:  <    if (curfprm->bcnt == 0) {		/* any data left in buffer */ < re18:  ;      curfprm->state = CBLANKS;		/* next state is blanks */ ;                                         @  -      if (curfprm->eof)			/* see if at eof */ - .        return (IOEOF);			/* this means eof */ . !      /* read in a data record */ ! $      if ((i = _getrec ()) == ERROR) $ ;    	return (count ? count : ERROR);	/* this means error */ ;       if (i == IOEND)  9    	return (count ? count : IOEOF);	/* this means eof */ 9       linadrs = curfil->line;  ?      if ((*linadrs & 0xdf) != 0x9f)    /* is this valid rec */ ? :        return (count ? count : ERROR);	/* error if not */ : 8      curfprm->bcnt = linadrs[1];	/* set record count */ 8 9      curfprm->bptr = &linadrs[6];	/* set data address */ 9 5      curfprm->charcnt = 0;		/* no chars going out */ 5 5      curfprm->blanks = 0;		/* no blanks to output */ 5                                          @  ;      curfprm->state = CBLANKS;		/* next state is blanks */ ;     }  re20:  7    /* 1st thing after a read is to check for blanks */ 7 A    if (curfprm->state == CBLANKS) {	/* see if state is blanks */ A    ?      /* see if any blanks left to output from previous call */ ?       if (curfprm->blanks) {     !        while (curfprm->blanks) { !     	  if(count < n) {  1    	    *buf++ = ' ';		/* put blank in buffer */ 1     	    count++;  -    	    curfprm->blanks--;		/* decr count */ -     	  } else {  9    	    return (count);		/* that's all the user wants */ 9     	  }      	}  7    	curfprm->state = CCHARS;	/* next state is chars */ 7          } else {                                                                           @  I        /* check for any blanks to output, this is 1st time after read */ I H    	if (curfprm->blanks = *curfprm->bptr++) { /* next buffer pointer */ H    /    	  /* see if this is the end of the line */ / %    	  if (curfprm->blanks == 0xff) { % 7    	    curfprm->blanks = 0;	/* no blanks to output */ 7     	    /* if eol, get out */  +    	    curfprm->bcnt--;		/* decr count */ + /    	    if ((*--buf == ' ') && (count == 1)) { / 2    	      *buf = '\n';		/* put new line at eol */ 2     	    } else {  4    	      *++buf = '\n';		/* put new line at eol */ 4     	      count++;  
    	    } 
 *    	    buf++;			/* next open position */ * 6    	    if (curfprm->oneln)		/* just 1 line wanted */ 6                                                   @  6    	      return (count);		/* return 1 lines worth */ 6     	    if (count < n)  0    	      goto re10;		/* keep filling buffer */ 0 .    	    return (count);		/* return for now */ .     	  }     ,    	  /* not at EOL and blanks to output */ ,      	  while (curfprm->blanks) {       	    if(count < n) {  3    	      *buf++ = ' ';		/* put blank in buffer */ 3     	      count++;  .    	      curfprm->blanks--;	/* decr count */ .     	    } else {  ;    	      return (count);		/* that's all the user wants */ ; 
    	    } 
     	  } /* end of while */             } /* end if blanks */     $      } /* end of else for blanks */ $ 6    curfprm->state = CCHARS;	/* next state is chars */ 6    #    } /* end if in CBLANKS state */ #      @      	       /* see if state is CCHARS */   #    if (curfprm->state == CCHARS) { #    (      /* we are processing characters */ ( !      /* see if any chars left */ !       if (curfprm->charcnt) {     "        while (curfprm->charcnt) { "     	  if(count < n) {  :    	    *buf++ = *curfprm->bptr;	/* put char in buffer */ : +    	    curfprm->bcnt--;		/* decr count */ + 4    	    curfprm->bptr++;		/* next buffer pointer */ 4     	    count++;  .    	    curfprm->charcnt--;		/* decr count */ . 
    	  } else 
 9    	    return (count);		/* that's all the user wants */ 9     	}  9    	curfprm->state = CBLANKS;	/* next state is blanks */ 9          } else {     4        /* if nothing left in buffer, go get next */ 4                       @  3    	/* state will go to CBLANKS when we do read */ 3     	if (--curfprm->bcnt <= 0)  *    	  goto re18;			/* read next record */ *    (    	/* get number of chars to output */ ( I    	if (curfprm->charcnt = *curfprm->bptr++) { /* next buffer pointer */ I    !    	  while (curfprm->charcnt) { !     	    if(count < n) {  <    	      *buf++ = *curfprm->bptr;	/* put char in buffer */ < -    	      curfprm->bcnt--;		/* decr count */ - 6    	      curfprm->bptr++;		/* next buffer pointer */ 6     	      count++;  /    	      curfprm->charcnt--;	/* decr count */ /     	    } else  ;    	      return (count);		/* that's all the user wants */ ;     	  }      	}  9    	curfprm->state = CBLANKS;	/* next state is blanks */ 9          }        @      }         if (--curfprm->bcnt <= 0)  )      goto re18;			/* read next record */ ) )    goto re20;				/* go process blanks */ )    
  } else { 
    "    /* non compressed read here */ "        /* see if data left */  .    if (curfprm->charcnt >= curfprm->blanks) { . +    	if (curfprm->eof)		/* see if at eof */ + .    	    return (IOEOF);		/* this means eof */ . *    	/* none left, read the next record */ * #    	if ((i = _getrec ()) == ERROR) # 0    	    return (ERROR);		/* this means error */ 0     	if (i == IOEND)  .    	    return (IOEOF);		/* this means eof */ . re00:      	/* 1st read merges here */  @    	linadrs = curfil->line;		/* start at beginning of buffer */ @                                                            @  7    	curfprm->charcnt = 0;		/* nothing processed yet */ 7 A    	curfprm->blanks = curfcb->recl;	/* save num of chars read */ A    >    	/* here we need to strip off blank put in during write */ > B    	/* this is because mpx does not support zero length blocks */ B 8    	/* if reading in binary mode, leave buffer alone */ 8     	if(!curfprm->binary) {  :    	    if((curfprm->blanks == 1) && (*linadrs == ' ') && : )    	      (curfprm->device != TERMINAL)) )     		curfprm->blanks = 0;  3    	    /* now append new line to end of buffer */ 3 0    	    /* if we have not read a full buffer */ 0 &    	    if (curfprm->blanks != 254) { & -    		/* point to 1 char position past end */ - #    		/* and count added newline */ #                              @  (    		linadrs[curfprm->blanks++] = '\n'; ( 
    	    } 
     	}      }  7    /* copy this layer buffer to upper caller's buffer. 7 :     * start from where we left off and keep reading until : 3     * the request has been completed or eof found. 3      */         while (count < n) {  -    	/* determine the number of chars left */ - /    	linadrs = curfil->line + curfprm->charcnt; / ,    	i = curfprm->blanks - curfprm->charcnt; ,     	if (i <= 0) {  0    	    if (curfprm->eof)			/* see if at eof */ 0 :    		return (count ? count : IOEOF);	/* this means eof */ : .    	    /* none left, read the next record */ . '    	    if ((i = _getrec ()) == ERROR) ' <    		return (count ? count : ERROR);	/* this means error */ <                           @      	    if (i == IOEND)  :    		return (count ? count : IOEOF);	/* this means eof */ : -    	    goto re00;			/* go process buffer */ -     	}  1    	j = min(i, n-count);		/* how many to move */ 1 2    	memcpy(buf, linadrs, j);	/* move the bytes */ 2 ,    	buf += j;			/* update buffer address */ , /    	curfprm->charcnt += j;		/* update count */ / %    	count += j;			/* update total */ % ;    	/* if terminal read or mpx 1 line read, we are done */ ; ;    	if ((curfprm->device == TERMINAL) || (curfprm->oneln)) ;     	    break;      }    }       return (count);     }     /*  getrec function   */     static int _getrec () {     /*  int reg [8]; */     !  curfcb->bufaddr = curfil->line; !                                    @  4  curfcb->excount = (curfprm->block ? 254 : BUFSIZ); 4 #  curfcb->exracc = curfprm->blkptr; #      asm(" lw r1,_curfcb");    asm(" svc 1,x'31'");  #ifdef JUNK    reg [1] = (int) curfcb;    mpxsvc (0x1031, reg, reg);  #endif     %  if (curfcb->devstat & 0x40000000) { %     errno = EACCES;      mpxerr = E017;  +    return (ERROR);	/* error encountered */ +   }  %  if (curfcb->devstat & 0x01000000) { %     errno = EFBIG;      mpxerr = E018;      curfprm->eom = 1;  )    return (IOEND);	/* eom encountered */ )   }  <  if (curfcb->devstat & 0x02000000) {  /* eof encountered */ <     errno = 0;      mpxerr = E019;      curfprm->eof = 1;  )    return (IOEND);	/* eof encountered */ )   }    return (GOOD);  }          @  /*  putrec function  */     "static int _putrec (count, plinad) " 
int count; 
 
char *plinad; 
 {  /*  int reg [8]; */       curfcb->excount = count;    curfcb->bufaddr = plinad;  #  curfcb->exracc = curfprm->blkptr; #      asm(" lw r1,_curfcb");    asm(" svc 1,x'32'");  #ifdef JUNK    reg [1] = (int) curfcb;    mpxsvc (0x1032, reg, reg);  #endif     %  if (curfcb->devstat & 0x40000000) { %     errno = EACCES;      mpxerr = E020;       return (ERROR);	 /* error */     }  %  if (curfcb->devstat & 0x02000000) { %     errno = EFBIG;      mpxerr = E021;      curfprm->eof = 1;      return (IOEND);	/* eof */    }    curfprm->linptr = 0;  %  if (curfcb->devstat & 0x01000000) { %     errno = EFBIG;             @      mpxerr = E022;      curfprm->eom = 1;  )    return (IOEND);	/* eom encountered */ )   }    return (GOOD);  }     /*  $    data transfer unblocked routines $     _wub() and _rub   */     static int _wub (buf, n)  
char *buf; 
 int n;  {    int i;    register int count = 0;  >  register int mode = curfprm->mode;    /* should be 1 or 2 */ >   long l, m;    char *linadrs;     +  linadrs = curfprm->linptr + curfil->line; +    %  if (!BUFVALID && (mode & O_RDWR)) { %     /* read in a data record */  "    if ((i = _getrec ()) == ERROR) " .      return (ERROR);			/* this means error */ .     if (i == IOEND) {  >      /* EOM is OK here, read is not allowed to extend file */ >                                          @  )      curfprm->eof = 0;			/* reset eof */ ) )      curfprm->eom = 0;			/* reset eom */ ) =      memset (curfil->line, 0, BUFSIZ);	/* clear the block */ =     }      BUFALTER = 0;      BUFVALID = 1;    }       while (count <n) {     $    if (curfprm->linptr >= BUFSIZ) { $       if (BUFALTER) {      	/* write out the record */  ,    	if (curfprm->eof)			/* see if at eof */ , ;    	  return (count ? count : IOEOF);	/* this means eof */ ; 7    	if ((i = _putrec (BUFSIZ, curfil->line)) == ERROR) 7 =    	  return (count ? count : ERROR);	/* this means error */ =     	if (i == IOEND)  ;    	  return (count ? count : IOEOF);	/* this means eof */ ;       }        curfprm->blkptr++;  %      l = (BUFSIZ * curfprm->blkptr); %             @  6      if ((mode & O_RDWR) || (l <= curfprm->eofptr)) { 6 #        /* read in a data record */ # &        if ((i = _getrec ()) == ERROR) & =    	  return (count ? count : ERROR);	/* this means error */ =         if (i == IOEND){  B          /* EOM is OK here, read is not allowed to extend file */ B -          curfprm->eof = 0;			/* reset eof */ - -          curfprm->eom = 0;			/* reset eom */ - >    	  memset (curfil->line, 0, BUFSIZ);	/* clear the block */ >           BUFALTER = 0;  	        } 	       } else {  <    	memset (curfil->line, 0, BUFSIZ);	/* clear the block */ <         BUFALTER = 0;        }        linadrs = curfil->line;        curfprm->linptr = 0;      }      *linadrs++ = *buf++;      BUFALTER = 1;      count++;    @      curfprm->linptr++;    }     3  l = curfprm->linptr + (BUFSIZ * curfprm->blkptr); 3 -  if ((mode & O_RDWR) || (mode & O_WRONLY)) { - <    /* update mode, eofpos is max of previous and current */ < 1    if (l > curfprm->eofptr) curfprm->eofptr = l; 1 
  } else { 
 '    /* write mode, eofpos is current */ '     curfprm->eofptr = l;    }    return (count);     }     static int _rub (buf, n)  
char *buf; 
 int n;  {    register int count = 0;    int i;    char *linadrs;       if (curfprm->eof) {      errno = 0;      mpxerr = E023;      return (IOEOF);    }  +  linadrs = curfprm->linptr + curfil->line; +      if (!BUFVALID) {  )    /* none left, read the next record */ )                                        @  *    if (curfprm->eof)		/* see if at eof */ * +      return (IOEOF);		/* this means eof */ + "    if ((i = _getrec ()) == ERROR) " -      return (ERROR);		/* this means error */ -     if (i == IOEND)  +      return (IOEOF);		/* this means eof */ + )    /* otherwise we have a good buffer */ )     BUFALTER = 0;      BUFVALID = 1;    }       while (count <n) {     $    if (curfprm->linptr >= BUFSIZ) { $       if (BUFALTER) {  *    	/* mode presumed to be O_RDWR here */ *     	/* write out the record */  ,    	if (curfprm->eof)			/* see if at eof */ , ;    	  return (count ? count : IOEOF);	/* this means eof */ ; 7    	if ((i = _putrec (BUFSIZ, curfil->line)) == ERROR) 7 =    	  return (count ? count : ERROR);	/* this means error */ =     @      	if (i == IOEND)  ;    	  return (count ? count : IOEOF);	/* this means eof */ ;       }        curfprm->blkptr++;  -      if (curfprm->eof)			/* see if at eof */ - 9    	return (count ? count : IOEOF);	/* this means eof */ 9 +      /* none left, read the next record */ + $      if ((i = _getrec ()) == ERROR) $ ;    	return (count ? count : ERROR);	/* this means error */ ;       if (i == IOEND)  9    	return (count ? count : IOEOF);	/* this means eof */ 9       BUFALTER = 0;        linadrs = curfil->line;        curfprm->linptr = 0;      }      *buf++ = *linadrs++;      count++;      curfprm->linptr++;  G    if (BUFSIZ * curfprm->block + curfprm->linptr >= curfprm->eofptr) { G       curfprm->eof = 1;        break;          @      }    }    return (count);  }      /*    seek unblocked function */      static int _skub (off, type)  	int type; 	 	long off; 	 {       register int mode, despos;    int curpos, desoff, desblk;    int curblk, i;  
  int ebl; 
    6  mode = curfprm->mode;    /* should be 0 or 1 or 2 */ 6    )  /* evaluate to where seek is desired */ )    4  curpos = curfprm->blkptr*BUFSIZ + curfprm->linptr; 4   /* clear error status */     curfcb->devstat &= 0x00ffffff;        despos = off;  "  if (type == 1) despos += curpos; " +  if (type == 2) despos += curfprm->eofptr; +   if (despos < 0) {      errno = EINVAL;      mpxerr = E024;      return (ERROR);    }    desoff = despos % BUFSIZ;                                @    desblk = despos / BUFSIZ;       /* check eof validity */  !  if (despos > curfprm->eofptr) { ! '    /* read mode can't go beyond eof */ ' (    if (!(mode & (O_WRONLY | O_RDWR))) { (       curfprm->eof = 1;        despos = curfprm->eofptr;      }  
  } else { 
 4    curfprm->eof = 0;           /* clear eof flag */ 4 4    curfprm->eom = 0;           /* clear eom flag */ 4   }       curblk = curfprm->blkptr;  =  if (BUFVALID && BUFALTER && (mode & (O_WRONLY | O_RDWR))) { = .    /* need to write out the current buffer */ .     /* write out the record */  6    if ((i = _putrec (BUFSIZ, curfil->line)) == ERROR) 6 -      return (ERROR);		/* this means error */ -     if (i == IOEND)  +      return (ERROR);		/* this means eof */ +        @    }    BUFALTER = 0;       curfprm->blkptr = desblk;     %  /* ebl is the current EOF block  */ % N  if ((mode & (O_WRONLY | O_RDWR)) && ((ebl=curfprm->eofptr/BUFSIZ) < desblk)) N '    /* write mode, seeking into a block ' (    that we haven't written to before */ ( ;    memset (curfil->line, 0, BUFSIZ);	/* clear the block */ ; #ifdef JUNK      for (i=0; i<BUFSIZ; i++)        curfil->line [i] = 0;  #endif    else  -    if (!BUFVALID || (desblk != curblk)) GETR -        BUFVALID = 1;    curfprm->linptr = desoff;     =  if ((mode & (O_WRONLY | O_RDWR)) && despos>curfprm->eofptr) =     curfprm->eofptr = despos;       return (despos);  }     /* seek blocked function */     static int _skbl (off, mode)             @  	long off; 	 	int mode; 	 {    int reg [8];       /* clear error status */     curfcb->devstat &= 0x00ffffff;   1  if (curfprm->device == TERMINAL) return (GOOD); 1 A  if ((curfprm->mode & (O_WRONLY | O_RDWR)) && curfprm->linptr) { A +    /* chars left in buff and write mode */ + &    curfcb->excount = curfprm->linptr; & #    curfcb->bufaddr = curfil->line; #     asm(" lw r1,_curfcb");      asm(" svc 1,x'32'");  #ifdef JUNK      reg [1] = (int) curfcb;      mpxsvc (0x1032, reg, reg);  #endif    }     /*  reg [1] = (int) curfcb; */  
  if (mode) { 
     /* goto end of file */      asm(" lw r1,_curfcb");      asm(" svc 1,x'34'");      asm(" svc 1,x'35'");  #ifdef JUNK  .    mpxsvc (0x1034, reg, reg);		/* seek eof */ .  @  6    mpxsvc (0x1035, reg, reg);		/* backspace record */ 6 #endif  
  } else { 
      /* goto beginning of file */   ,    curfprm->eof = 0;			/* clear eof flag */ , ,    curfprm->eom = 0;			/* clear eom flag */ , 3    curfprm->charcnt = 0;		/* no chars going out */ 3 3    curfprm->blanks = 0;		/* no blanks to output */ 3 7    curfprm->bcnt = 0;			/* set record count to zero */ 7     asm(" lw r1,_curfcb");      asm(" svc 1,x'37'");  #ifdef JUNK      mpxsvc (0x1037, reg, reg);  #endif    }    return(GOOD);  }     /* seek on non-disc device */     static int _skdv (rel)  int rel;  {  /*  int reg [8]; */     #ifdef JUNK    reg [1] = (int) curfcb;  #endif    if (rel) {      asm(" lw r1,_curfcb");                    @      asm(" svc 1,x'34'");  #ifdef JUNK  7    mpxsvc (0x1034, reg, reg);   /* goto end of file */ 7 #endif  
  } else { 
     asm(" lw r1,_curfcb");      asm(" svc 1,x'37'");  #ifdef JUNK  =    mpxsvc (0x1037, reg, reg);   /* goto beginning of file */ = #endif    }  }     int readraw (fd, buf, n)  int fd;  
char *buf; 
 int n;  {    register int mode, dev;  /*  int reg [8]; */       BADFD (fd, ERROR);    INIT;    mode = curfprm->mode;    dev =  curfprm->device;    if (mode & NOTUSED) {      errno = EBADF;      mpxerr = E012;      return (ERROR);    }    if (mode & O_WRONLY) {      errno = EACCES;      mpxerr = E013;      return (ERROR);    }    if (dev == NULLFILE) {                          @      curfprm->eof = 1;      return (IOEOF);    }    if (n <= 0) return (IOEOF);     )/* insure sequential write, not random */ )   curfcb->cntl.ran = 0;  /* clear error status */     curfcb->devstat &= 0x00ffffff;        curfcb->bufaddr = buf;    curfcb->excount = n;       asm(" lw r1,_curfcb");    asm(" svc 1,x'31'");  #ifdef JUNK    reg [1] = (int) curfcb;    mpxsvc (0x1031, reg, reg);  #endif     %  if (curfcb->devstat & 0x40000000) { %     errno = EACCES;      mpxerr = E017;  +    return (ERROR);	/* error encountered */ +   }  %  if (curfcb->devstat & 0x01000000) { %     errno = EFBIG;      mpxerr = E018;      curfprm->eom = 1;  )    return (IOEND);	/* eom encountered */ )   }                         @  ;  if (curfcb->devstat & 0x02000000) {	/* eof encountered */ ;     errno = 0;      mpxerr = E019;      curfprm->eof = 1;  )    return (IOEND);	/* eof encountered */ )   }    return (curfcb->recl);  }     /*  writraw function  */     int writraw (fd, buf, n)  int fd;  
char *buf; 
 int n;  {    register int mode, dev;  /*  int reg [8]; */       BADFD (fd, ERROR);    INIT;    mode = curfprm->mode;    dev =  curfprm->device;    if (mode & NOTUSED) {      errno = EBADF;      mpxerr = E010;      return (ERROR);    }  &  if (!(mode & (O_WRONLY | O_RDWR))) { &     errno = EACCES;      mpxerr = E011;      return (ERROR);    }  "  if (dev == NULLFILE) return (n); "                                       @  )/* insure sequential write, not random */ )   curfcb->cntl.ran = 0;  /* clear error status */     curfcb->devstat &= 0x00ffffff;        curfcb->excount = n;    curfcb->bufaddr = buf;       asm(" lw r1,_curfcb");    asm(" svc 1,x'32'");  #ifdef JUNK    reg [1] = (int) curfcb;    mpxsvc (0x1032, reg, reg);  #endif     %  if (curfcb->devstat & 0x40000000) { %     errno = EACCES;      mpxerr = E020;       return (ERROR);	 /* error */     }  %  if (curfcb->devstat & 0x02000000) { %     errno = EFBIG;      mpxerr = E021;      curfprm->eof = 1;      return (IOEND);	/* eof */    }     %  if (curfcb->devstat & 0x01000000) { %     errno = EFBIG;      mpxerr = E022;      curfprm->eom = 1;                          @  )    return (IOEND);	/* eom encountered */ )   }    return (curfcb->recl);  }     -/* place for storing default access rights */ - 3static  unsigned int fileacc[3]={0x3f, 0x3f, 0x20}; 3    */* place for storing default file sizes */ * 
#ifndef MPX1X 
 static  int orgs = 0;  static  int minx = 0;  static  int maxx = 0;  #else  static  int orgs = 100;  static  int minx = 100;  static  int maxx = 300;  #endif     3/*  setsiz - set default sizes for created files */ 3 int setsiz (ssiz, mini, maxi)  int ssiz, mini, maxi;  {  #  orgs = ssiz;		/* starting size */ # '  minx = mini;		/* minimum increment */ ' '  maxx = maxi;		/* maximum increment */ ' "  return (GOOD);	/* return o.k. */ " }                                   @  4/*  setacc - set default access for created files */ 4  int setacc (owner, group, other)   int owner, group, other;  {  .  fileacc[0] = owner;   /* set owner rights */ . .  fileacc[1] = group;   /* set group rights */ . .  fileacc[2] = other;   /* set other rights */ . "  return (GOOD);	/* return o.k. */ " }     (/* getacc - get access rights of file */ (    int * getacc(pname)  char *pname;  {  
#ifndef MPX1X 
   int reg [8];    int rdu[192];    int pnblk [18];  
  int pnbvec; 
   char path[PATH_MAX];     -  strcpy (pname, path);   /* copy pathname */ - /  unix2mpx(pname);      /* make u/c mpx name */ /    <  if (prspn (pname, pnblk, &pnbvec)) return ((int *) ERROR); <   ZREG (reg, 8);    reg [1] = pnbvec;              @    reg [6] = (int) rdu;  2  mpxsvc (0x202c, reg, reg);    /* log resource */ 2 &  if (reg [7]) return ((int *) ERROR); & A  return (&rdu[30]);        /* return pointer to access rights */ A #else  $  if (access (pname, 0666) == ERROR) $     return ((int *)(ERROR));  B  return((int *)fileacc);	/* return default 3X type of accesses */ B #endif  }     /*    open function     */     int open (path, mode, perm)  char *path;  int mode, perm;  {  	  int fd; 	   struct rrstag *rptr = &_rrs;  #ifdef MPX1X  5  extern struct finfo * _fib;	/* defined in _cassg */ 5 #else    struct rcbtag rcb;  #endif  
  int reg[8]; 
   char pname [PATH_MAX];        if (path == 0 || *path == 0) {       errno = EINVAL;      mpxerr = E025;    @  &    return (ERROR);	/* bad pathname */ &   }  -  strcpy (pname, path);   /* copy pathname */ - /  unix2mpx(pname);      /* make u/c mpx name */ /      fd = getfd ();    BADFD (fd, ERROR);       INIT;       if (_cassg (pname)) {      errno = EINVAL;      mpxerr = E025;  7    return (ERROR);		/* parse pathname and build RRS */ 7   }       if (mode & O_UNBLK) {  #ifdef MPX1X  >    rptr->flags |= 0x04;	/* show assignment to be unblocked */ > (    curfprm->block = 0;		/* unblocked */ ( #else      rptr->opts.unblk = 1;      rptr->opts.blk = 0;  #endif    }    if (mode & O_BIN) {  5    curfprm->binary = 1;	/* user wants binary mode */ 5   }  #ifdef MPX1X  .  if ((mode & O_CREAT) && (rptr->flags & 0x80) .            @  &    && (access (pname, 0) == ERROR)) { &     /* create perminate file */     .    /* set username for this file, save old */ . 9    if (setuser(_fib->username, _fib->userkey) != NULL) { 9 5      errno = EACCES;			/* can't creat file, error */ 5 9      mpxerr = E002;			/* show RM09 err, invalid usage */ 9 :      return (ERROR);			/* show RM09 err, invalid usage */ :     }      ZREG (reg, 8);  .    reg[1] = 0xee;			/* filetype will be EE */ . <    if (mode & O_UNBLK)			/* if unblocked, assume type CA */ < /    	reg[1] = 0xca;			/* filetype will be CA */ / ?    if ((strncmp((char*)_fib->username, "SYSTEM  ", 8) == 0) || ? =      (strncmp((char*)_fib->username, "        ", 8) == 0) || =                                                               @  =      ((_fib->username[0] == 0) && (_fib->username[1] == 0))) = 2      reg[1] |= 0x80000000;		/* set system file */ 2 7    reg[2] = rptr->size;		/* get file size to create */ 7 1    if (reg[2] == 0)			/* see if no size given */ 1 -      reg[2] = orgs;			/* set default size */ - 6    reg[3] = rptr->wd2 & 0x8000ffff;	/* get chan/sa */ 6 B    reg[3] |= ((rptr->wd2 & 0x7f000000) >> 8);  /* get dev type */ B =    if ((reg[3] & 0x00ff0000) == 0)	/* see if device given */ = 7      reg[3] |= 0x00010000;		/* set any disk will do */ 7 1    if (_fib->password[0] || _fib->password[1]) { 1 2      /* we have a password, set password req'd */ 2 4      reg[2] |= 0x01000000;		/* set password flag */ 4 4      reg[4] = _fib->password[0];	/* set password */ 4             @  4      reg[5] = _fib->password[1];	/* set password */ 4     }  >    reg[6] = _fib->filename[0];  	/* first part of filename */ > ?    reg[7] = _fib->filename[1];  	/* second part of filename */ ? 7    mpxsvc (0x1075, reg, reg); 		/* m.create service */ 7 *    /* if r6 returned 0, file not found */ *     if (reg[6] == 0) {  8      resetuser();			/* reset username to what it was */ 8 5      errno = EACCES;			/* can't creat file, error */ 5 9      mpxerr = E002;			/* show RM09 err, invalid usage */ 9 :      return (ERROR);			/* show RM09 err, invalid usage */ :     }  A    /* must reset username to what it was before file creation */ A 6    resetuser();			/* reset username to what it was */ 6   }  #else                                            @  /  if ( (mode & O_CREAT) && (rptr->type == 1) && / @    !prspn (pname, curfil->_pnb, &PNBWRDX) && exist (PNBWRDX)) { @ .    /* it's a type 1 RRS, so a permanent file, . C    it can make a pathname block, and it doesn't currently exist */ C    .    ZINT (&rcb, (sizeof (rcb) /sizeof (int))); .     /* set defaults in rcb */  E    rcb._owri = ((fileacc[0] << 26) | ((fileacc[0] & 1)?0x400000:0)); E E    rcb._ugri = ((fileacc[1] << 26) | ((fileacc[1] & 1)?0x400000:0)); E E    rcb._otri = ((fileacc[2] << 26) | ((fileacc[2] & 1)?0x400000:0)); E )    rcb._osiz = orgs; /* starting size */ ) -    rcb._mnei = minx; /* minimum increment */ - -    rcb._mxei = maxx; /* maximum increment */ -        if (perm) {        char own, pro, oth;                      @  3      /* MPX access rights R W M U A D done here */ 3       /* UNIX are R W X */  8      /* if perm & ~0x1ff is not zero, them MPX, else */ 8 8      /* assume UNIX flags given and translate to MPX */ 8    !      if ((perm & ~0x1ff) == 0) { !         /* simulate UNIX */  9        if ((oth = (perm & 7) << 3) && 0x10) oth |= 0x3f; 9 @        if ((pro = ((perm >> 3) & 7) << 3) && 0x10) pro |= 0x3f; @ @        if ((own = ((perm >> 6) & 7) << 3) && 0x10) own |= 0x3f; @       }        else {          oth = perm&63;          pro = (perm >> 8) &63;          own = (perm >> 16) &63;        }        if (oth) {  (        if (oth&1) rcb._otri = 0x400000; (         oth &= 62;  +        rcb._otri |= ((unsigned)oth << 26); +       }             @        if (pro) {  (        if (pro&1) rcb._ugri = 0x400000; (         pro &= 62;  +        rcb._ugri |= ((unsigned)pro << 26); +       }        if (own) {  (        if (own&1) rcb._owri = 0x400000; (         own &= 62;  +        rcb._owri |= ((unsigned)own << 26); +       }  -      if (!rcb._otri) rcb._opts = 0x20000000; - .      if (!rcb._ugri) rcb._opts |= 0x40000000; . .      if (!rcb._owri) rcb._opts |= 0x80000000; .     }         ZREG (reg, 8);      reg [1] = PNBWRDX;      reg [2] = (int) &rcb;  /    if (rptr->opts.unblk) rcb._flags._eofm = 1; /     mpxsvc (0x2020, reg, reg);      if (reg [7]) {  5      errno = EACCES;			/* can't creat file, error */ 5 9      mpxerr = E002;			/* show RM09 err, invalid usage */ 9           @  :      return (ERROR);			/* show RM09 err, invalid usage */ :     }    }  #endif /* MPX1X */     #ifdef MPX1X  ,  /* set username for this file, save old */ , 4  if (rptr->flags & 0x80) {		/* this means a file */ 4 9    if (setuser(_fib->username, _fib->userkey) != NULL) { 9 5      errno = EACCES;			/* can't creat file, error */ 5 9      mpxerr = E002;			/* show RM09 err, invalid usage */ 9 :      return (ERROR);			/* show RM09 err, invalid usage */ :     }    }  #endif /* MPX1X */    if (assn (mode)) {  #ifdef MPX1X  6    if (rptr->flags & 0x80) {		/* this means a file */ 6 8      resetuser();			/* reset username to what it was */ 8     }  #endif /* MPX1X */  9    return (ERROR);			/* assign with correct acc rghts */ 9   }    @  #ifdef MPX1X  4  if (rptr->flags & 0x80) {		/* this means a file */ 4 6    resetuser();			/* reset username to what it was */ 6   }  #endif /* MPX1X */  -  if (cnpo (mode)) return (ERROR);	/* open */ - #ifdef MPX1X  4  if (rptr->flags & 0x80) {		/* this means a file */ 4 6    filtabl[fd].fib = *_fib;		/* set the file stuff */ 6   }  #endif /* MPX1X */       if ((mode & O_RDWR) &&  F    ((curfprm->device == TERMINAL) || (curfprm->device == SPOOLFILE))) F   {  3    errno = EACCES;			/* can't creat file, error */ 3 7    mpxerr = E001;			/* show RM09 err, invalid usage */ 7 8    return (ERROR);			/* show RM09 err, invalid usage */ 8   }    if (mode & O_CREAT)  ;    curfprm->eofptr = 0;	/* all created files have 0 len */ ;            @  '  curfil->line = bufrsio + (BUFSIZ*fd); ' 4  curfprm->mode = mode;		/* mark table entry open */ 4    :  if ((curfprm->block) && (curfprm->device == DISCFILE) && : )    (ieofbl == 0) && (mode & O_WRONLY)) { ) @    /* we assume here that the file was created by TSM or Volmgr @ ?    but has had nothing written into it: hence it has no end of ? <    file markers in it, and a subsequent seek to end of file < +    would give IO06 errors without this. */ +        asm(" lw r1,_curfcb");      asm(" svc 1,x'38'");  #ifdef MPX1X      asm(" svc 1,x'37'");  #else      asm(" svc 1,x'35'");  #endif  #ifdef JUNK      reg [1] = (int) curfcb;  7    mpxsvc (0x1038, reg, reg);  /* write EOF on file */ 7 #ifdef MPX1X                                 @  7    mpxsvc (0x1037, reg, reg);  /* and rewind to BOF */ 7 #else  @    mpxsvc (0x1035, reg, reg);  /* and backspace over the EOF */ @ #endif  #endif    }  #ifdef MAKE_SMALLER  8  /* if blocked disk file, use large blocking buffers */ 8 :  if ((curfprm->block) && (curfprm->device == DISCFILE)) { : 3#define NUMB 8			/* use 8 sector blocking buffer */ 3 ?#define BIGBLOCK NUMB*BUFSIZ	/* use 8 sector blocking buffer */ ?     int * bbufp;  1    if ((bbufp = (int *)malloc(BIGBLOCK)) != 0) { 1 C    curfcb->blkbuff = (int *)(((unsigned)NUMB << 24) | (int)bbufp); C     }    }  #endif       return (fd);  }     /*    creat function    */     int creat (path, perm)  char *path;  ,int perm;                  /* permissions */ , {   @  "  int mode = (O_CREAT | O_WRONLY); " 8  return (open(path, mode, perm));	/* let open handle */ 8 }     ./*    creatd function  -  create directory  */ .    int creatd (path, perm)  char *path;  ;int perm;                                 /* permissions */ ; {    int reg [8];    int mode;  	  int fd; 	      struct rrstag *rptr = &_rrs;  
#ifndef MPX1X 
   struct rcbtag rcb;  #endif    char pname [PATH_MAX];        if (path == 0 || *path == 0) {   2    errno = EACCES;		/* can't creat file, error */ 2 6    mpxerr = E026;		/* show RM09 err, invalid usage */ 6 7    return (ERROR);		/* parse pathname and build RRS */ 7   }  ,  strcpy (pname, path);		/* copy pathname */ , +  unix2mpx(pname);		/* make u/c mpx name */ +           @    fd = getfd ();    BADFD (fd, ERROR);       INIT;       if (_cassg (pname)) {  2    errno = EACCES;		/* can't creat file, error */ 2 6    mpxerr = E026;		/* show RM09 err, invalid usage */ 6 6    return (ERROR);		/*parse pathname and build RRS */ 6   }     #ifdef MPX1X  =/* MPX1X uses USERNAME for directory, anyone is o.k., so lets =  * just return o.k. here   */    return (GOOD);  #else /* MPX1X */       if ((rptr->type == 1) &&  @    !prspn (pname, curfil->_pnb, &PNBWRDX) && exist (PNBWRDX)) { @ .    /* it's a type 1 RRS, so a permanent file, . C    it can make a pathname block, and it doesn't currently exist */ C    .    ZINT (&rcb, (sizeof (rcb) /sizeof (int))); .     /* set defaults in rcb */                      @      rcb._owri = 0xf8f00000;      rcb._ugri = 0xf8f00000;      rcb._otri = 0xf8f00000;  '    rcb._osiz = 0;  /* starting size */ ' +    rcb._mnei = 0;  /* minimum increment */ + +    rcb._mxei = 0;  /* maximum increment */ +    #ifdef JUNK      if (perm) {        char own, pro, oth;  3      /* MPX access rights R W M U A D done here */ 3       /* UNIX are R W X */  8      /* if perm & ~0x1ff is not zero, them MPX, else */ 8 8      /* assume UNIX flags given and translate to MPX */ 8    !      if ((perm & ~0x1ff) == 0) { !         /* simulate UNIX */  9        if ((oth = (perm & 7) << 4) && 0x10) oth &= 0x3f; 9 @        if ((pro = ((perm >> 3) & 7) << 4) && 0x10) pro &= 0x3f; @                                                           @  @        if ((own = ((perm >> 6) & 7) << 4) && 0x10) own &= 0x3f; @       }        else {          oth = perm&63;          pro = (perm >> 8) &63;          own = (perm >> 16) &63;        }        if (oth) {  (        if (oth&1) rcb._otri = 0x400000; (         oth &= 62;  !        rcb._otri |= (oth << 26); !       }        if (pro) {  (        if (pro&1) rcb._ugri = 0x400000; (         pro &= 62;  !        rcb._ugri |= (pro << 26); !       }        if (own) {  (        if (own&1) rcb._owri = 0x400000; (         own &= 62;  !        rcb._owri |= (own << 26); !       }  -      if (!rcb._otri) rcb._opts = 0x20000000; - .      if (!rcb._ugri) rcb._opts |= 0x40000000; . .      if (!rcb._owri) rcb._opts |= 0x80000000; .     }    @     #endif /* JUNK */         ZREG (reg, 8);      reg [1] = PNBWRDX;      reg [2] = (int) &rcb;      mpxsvc (0x2023, reg, reg);      if (reg [7]) {  5      errno = EACCES;			/* can't creat file, error */ 5 9      mpxerr = E002;			/* show RM09 err, invalid usage */ 9 :      return (ERROR);			/* show RM09 err, invalid usage */ :     }    }       return (GOOD);  #endif /* MPX1X */  }     /*  close function  */     int close (fd)  	int   fd; 	 {    int reg [8];    double dumbound;    int usrrd [32];    register int mode, dev;       BADFD (fd, ERROR);    INIT;  
#ifndef MPX1X 
   PNBWRDX = curfil->pnbw;  #endif     5  if ((mode=curfprm->mode) & NOTUSED) return (ERROR); 5                              @    /* write or update */  %  if ((mode & (O_WRONLY | O_RDWR))) { % #    curfcb->bufaddr = curfil->line; #    #ifdef JUNK      reg [1] = (int) curfcb;  #endif      if (curfprm->block) {  (      curfcb->excount = curfprm->linptr; (       if (curfprm->linptr) {          asm(" lw r1,_curfcb");          asm(" svc 1,x'32'");  #ifdef JUNK  "        mpxsvc (0x1032, reg, reg); " #endif          curfprm->linptr = 0;        }      } else {        curfcb->excount = BUFSIZ;  !      if (BUFVALID && BUFALTER) { ! )        curfcb->exracc = curfprm->blkptr; )         asm(" lw r1,_curfcb");          asm(" svc 1,x'32'");  #ifdef JUNK  "        mpxsvc (0x1032, reg, reg); " #endif        }      }    }     
#ifndef MPX1X 
        @  >  /* there is no user rd area in MPX1X, so just delete code */ >    $  /* write back the eof position  */ $ D  if ((curfprm->device==DISCFILE) && (mode & (O_WRONLY | O_RDWR))) { D     ZREG (reg, 8);  <    reg [1] = curfil->_pnb [8];   /* keeping the RID here */ <     reg [6] = (int) usrrd;      mpxsvc (0x2031, reg, reg);      if (!reg [7]) {        if (curfprm->block) {  ,        /* try to type the file as CBLFIL */ , 9        usrrd [CUBFL1 - CUBFUS] = CBLFIL;   /* type it */ 9       }        else {  9        usrrd [CUBFL1 - CUBFUS] = CUBFIL;   /* type it */ 9 C        usrrd [CUBFL2 - CUBFUS] = curfprm->eofptr;  /* length it */ C       }        ZREG (reg, 8);        reg [6] = (int) usrrd;         mpxsvc (0x2032, reg, reg);        @      }    }  #endif /* MPX1X */     I  if (curfprm->block && (curfprm->device==DISCFILE) && (mode & O_WRONLY)) I     {     B    /* The purpose of this code here is to more completely emulate B A    the UNIX write mode of file operation. If no data was written A @    to the file, then an EOF should be written at the beginning. @ B    Here, an EOF is written to the current position (which will be B C    at the start of the file if no data has been written). To avoid C D    potential problems when two streams are opened to the same file, D 2    we backspace over the EOF after writing it. */ 2    /*    int reg [8]; */           asm(" lw r1,_curfcb");        asm(" svc 1,x'38'");  
#ifndef MPX1X 
       asm(" svc 1,x'35'");  #else    @        asm(" svc 1,x'37'");  #endif  #ifdef JUNK      reg [1] = (int) curfcb;  8    mpxsvc (0x1038, reg, reg);  	/* write EOF on file */ 8 
#ifndef MPX1X 
 @    mpxsvc (0x1035, reg, reg);		/* and backspace over the EOF */ @ #else  5    mpxsvc (0x1037, reg, reg);		/* rewind the file */ 5 #endif  #endif    }       reg[1] = (int) curfcb;    reg[7] = 0;			/* no CNP */     #ifdef MPX1X  D  if ((curfprm->device==DISCFILE) && (mode & (O_WRONLY | O_RDWR))) { D #ifdef TRYTHIS  7    mpxsvc (0x1038, reg, reg);		/* write EOF on file */ 7 5    mpxsvc (0x1037, reg, reg);		/* rewind the file */ 5 #endif    }  2  mpxsvc (0x1039, reg, reg);		/* close the file */ 2 :  reg [5] = (int)(*(int*)curfcb) & 0xffffff; /* get lfc */ :               @  7  mpxsvc (0x1041, reg, reg);		/* deallocate the file */ 7 #else  5  mpxsvc (0x2053, reg, reg);		/* deassign the file */ 5   if (reg [7]) {  3    errno = EACCES;			/* can't creat file, error */ 3     mpxerr = E003;  8    return (ERROR);			/* show RM09 err, invalid usage */ 8   }  #endif       curfprm->mode = NOTUSED;  H  curfprm->linptr = curfprm->blkptr = curfprm->block = curfprm->binary = H 9    curfprm->eofptr = curfprm->eof = curfprm->device = 0; 9 0  BUFVALID = BUFALTER = 0;   /* Version G Fix */ 0      return (GOOD);  }     #ifdef MPX1X  static int reg5, reg6, reg7;  #endif     /* assign function */  static int assn (mode)  	int mode; 	 {    int i, reg [8];    struct rrstag *rptr = &_rrs;  #ifdef MPX1X    @  5  extern struct finfo * _fib;	/* defined in _cassg */ 5    (  reg5 = *(int *)(curfcb);	/* get LFC */ ( (  reg5 &= 0xffffff;		/* clean the LFC */ ( 9  curfcb->cntl.exp = 1;         /* ensure expanded fcb */ 9 .  reg5 |= 0x20000000;		/* wait for resource */ .   if (rptr->flags & 0x04)  ,    reg5 |= 0x40000000;		/* set unblocked */ ,   if (rptr->flags & 0x02)  ,    reg5 |= 0x80000000;		/* set inhib mnt */ , +  if (rptr->flags & 0x80) {	/* perm file */ + )    reg5 |= 0x01000000;		/* type 1 rrs */ ) :    reg6 = (int)_fib->filename;	/* set filename address */ : /    if (_fib->password[0] || _fib->password[1]) / <      reg7 = (int)_fib->password;	/* set password address */ <   }  3  if (rptr->flags & 0x60) {     /* sys file code */ 3                  @  )    reg5 |= 0x02000000;		/* type 2 rrs */ ) ,    reg6 = (int)&rptr->wd2;	/* slo or sbo */ , ,    reg7 = (int)&rptr->size;	/* file size */ ,   }  1  if (rptr->flags & 0x10) {     /* device code */ 1 )    reg5 |= 0x03000000;		/* type 3 rrs */ ) -    reg6 = (int)&rptr->wd2;	/* type, ch, sa*/ - 7    reg7 = (int)&rptr->size;	/* file size or reel id */ 7   }  0  if (rptr->flags & 0x08) {     /* as lfc=lfc */ 0 )    reg5 |= 0x04000000;		/* type 4 rrs */ ) /    reg6 = (int)&rptr->wd2;	/* lfc to assign */ /     reg7 = 0;			/* zero */    }  1  asm (" la 1,altret");		/* set error ret addr */ 1 ,  asm (" lw 5,_reg5");		/* get type & LFC */ , +  asm (" lw 6,_reg6");		/* get chan & sa */ + &  asm (" lw 7,_reg7");		/* get size */ &                            @  &  asm (" svc 1,x'40'");		/* M.ALOC	 */ & '  asm (" li 6,-1");		/* o.k. return	 */ ' 3  asm ("altret stw 6,_reg6");	/* save error code */ 3 /  if (reg6 == -1) return(GOOD);	/* return ok */ / 0  errno = EACCES;		/* can't creat file, error */ 0 %  mpxerr = E004;		/* invalid usage */ % $  return (reg6);		/* return error */ $    #else /* MPX1X */       for (i = 0; i < 3; i++)  9    rptr->lfc [i] = curfcb->lfc [i]; /* put LFC in RRS */ 9    9  if ((mode & (O_WRONLY | O_RDWR))) rptr->accs.updat = 1; 9    else     rptr->accs.read  = 1;      >  curfcb->cntl.exp = 1;              /* ensure expanded fcb */ >      if (rptr->type == 4) {      rptr->accs.read = 0;      rptr->accs.write = 0;      rptr->accs.modfy = 0;                            @      rptr->accs.updat = 0;      rptr->accs.appnd = 0;    }       ZREG (reg, 8);    reg [1] = (int) rptr;  4  mpxsvc (0x2052, reg, reg);            /* assign */ 4      if (reg [7]) {  2    errno = EACCES;		/* can't creat file, error */ 2 '    mpxerr = E004;		/* invalid usage */ '   }    return (reg [7]);  #endif /* MPX1X */  }     static int cnpo (mode)  	int mode; 	 {    int reg [8], i;  
#ifndef MPX1X 
   int *parinq [8];    struct fattag *fatptr;    double dumb1;    int rd [192];    struct cnptag cnp;  #else    int diskfile=0;  #endif    struct rrstag *rptr = &_rrs;    int sgofil = 0;       ZREG (reg, 8);  #ifdef MPX1X    for (i=0;i<3;i++) {      reg [5] <<= 8;                               @      reg [5] |= curfcb->lfc [i];    }  <  mpxsvc (0x1042, reg, reg);            /* device inquiry */ < =  if (!reg[6]) {                        /* error if r6 = 0 */ = 3    errno = EACCES;			/* can't creat file, error */ 3 '    mpxerr = E005;			/* no FAT space */ ' 3    return (ERROR);			/* can be zero for console */ 3 D  }                                     /* so we test r6 for zero */ D H  sgofil = (reg[7] & 0x00070000) >> 16;   /* get sys file type if any */ H C  switch ((reg[7] >> 24) & 0xff) {      /* switch on device type */ C     case 0:     /* console */      case 0x0c:  /* tty */       case 0x0d:  /* console ct */   0      curfprm->device = TERMINAL;	/* terminal */ 0       break;      case 0x01:  /* disk */                          @      case 0x02:  /* disk */      case 0x03:  /* disk */        diskfile = 1;      default:  ,      curfprm->device = DISCFILE;	/* file */ ,       break;  !    case 0x0f:  /* null device */ ! !      curfprm->device = NULLFILE; !       return (GOOD);  !    case 0x0a:  /* lineprinter */ ! ,      curfprm->device = SPOOLFILE;	/* SLO */ ,   }    if (sgofil == 3)  *    curfprm->device = SPOOLFILE;	/* SLO */ *    !  /* get correct blocking info */ ! J  curfprm->block = ((reg[7] & 0x00800000) ? 1 : 0);	/* set blocked bits */ J    +  /* ensure terminals are opened blocked */ + $  if (curfprm->device == TERMINAL || $ 5    curfprm->device == SPOOLFILE) curfprm->block = 1; 5    ?  /* fudge blocking and access rights for some special files */ ?  @    if (rptr->flags & 0x08) {  %    if (mode & (O_WRONLY | O_RDWR)) { % #      /* mode is write or update */ # 9      if ((sgofil == 3) || curfprm->device == TERMINAL) { 9         curfprm->block = 1;        }  4      else if (sgofil) {		/* open in default mode */ 4         curfprm->block = 1;        }      }    }  #else    for (i=0;i<3;i++) {      reg [4] <<= 8;      reg [4] |= curfcb->lfc [i];    }    reg [1] = (int) parinq;  F  mpxsvc (0x2048, reg, reg);            /* resource inquiry service */ F    (  fatptr = (struct fattag *) parinq [1]; (   if (!fatptr) {  3    errno = EACCES;			/* can't creat file, error */ 3 '    mpxerr = E005;			/* no FAT space */ ' 3    return (ERROR);			/* can be zero for console */ 3   }       @  #endif     
#ifndef MPX1X 
   /* set device info */  )  if (fatptr->null) {			/* null device */ )     curfprm->device = NULLFILE;      return (GOOD);    }  #  else if ((fatptr->acf & 0x7) ==3) # *    curfprm->device = SPOOLFILE;	/* SLO */ *   else if (fatptr->tsm)  /    curfprm->device = TERMINAL;		/* terminal */ / .  else  curfprm->device = DISCFILE;	/* file */ .    $  sgofil = ((fatptr->acf&0x7) == 2); $    !  /* get correct blocking info */ ! 6  curfprm->block = ((fatptr->attr & UNBLASS) ? 0 : 1); 6   /* set blocked bits */  +  /* ensure terminals are opened blocked */ + $  if (curfprm->device == TERMINAL || $ 5    curfprm->device == SPOOLFILE) curfprm->block = 1; 5                                                                @  8  cnp.abrtn = cnp.status = cnp.resvd[0] = cnp.resvd[1] = 8 #    cnp.resvd[2] = cnp.timeout = 0; #   cnp.options = 0;    if (curfprm->block) {      cnp.options = OBL;      curfcb->cntl.bl = 1;    }    else{      cnp.options = OUB;      curfcb->cntl.bl = 0;    }     )  /* fudge blocking and access rights for )   some special files */    if (rptr->type == 4) {  %    if (mode & (O_WRONLY | O_RDWR)) { % #      /* mode is write or update */ # 5      if (((fatptr->acf & 0x7) ==3) || fatptr->tsm) { 5         curfprm->block = 1;  =        cnp.options &= ~ (OBL|OUB); /* clear blocking info */ =         cnp.options |= OBL;        }  :      else if (sgofil) {        /* open in default mode */ :       }        else {               @  9        cnp.options |= OUPD;    /* open in update mode */ 9       }      }    }  #endif  .  curfcb->cntl.ran = (curfprm->block ? 0 : 1); . #ifdef MPX1X    if (curfprm->block) {      curfcb->cntl.bl = 1;    }    else{      curfcb->cntl.bl = 0;    }    reg [1] = (int) curfcb;  4  if ((mode & (O_WRONLY | O_RDWR)) && (sgofil != 1)) 4 <    reg[1] |= 0x40000000;               /* set read/write */ < ;  mpxsvc (0x1030, reg, reg);            /* open resource */ ; #else    ZREG (reg, 8);    reg [7] = (int) &cnp;    reg [1] = (int) curfcb;  ;  mpxsvc (0x2042, reg, reg);            /* open resource */ ;      if (cnp.status) {  3    errno = EACCES;			/* can't creat file, error */ 3 %    mpxerr = E006;			/* open error */ %        @  3    return (ERROR);			/* can be zero for console */ 3   }  #endif    curfprm->blkptr = 0;    curfprm->linptr = 0;    curfprm->eof    = 0;  B  curfprm->cmpop   = 0;     /* clear tested for compressed flag */ B <  curfprm->cmpflg  = 0;     /* clear compressed file flag */ < 
#ifndef MPX1X 
 8  ZREG (curfil->_pnb, 9);              /* for the RID */ 8 #endif       curfprm->eofptr = 0x7FFFFFFF;  #ifdef MPX1X  =  if (curfprm->device == DISCFILE && diskfile ) {  /* file */ = ,    curfprm->eofptr = (BUFSIZ * reg[5]) - 1; , 4    /* if no value in RD, try to work out a value */ 4     ieofbl = 0;    }  #else  0  if (curfprm->device == DISCFILE) {  /* file */ 0     ZREG (reg, 8);      reg [1] = (int) curfcb;                             @      reg [6] = (int) rd;      mpxsvc (0x202c, reg, reg);      ieofbl = EOF;      if (!reg [7]) {  #      int i;         /* save RID */ #       for (i = 0; i < 8; i++)  2        curfil->_pnb [i] = rd [i];  /* RID copy */ 2 9      curfil->_pnb [8] = (32 << 24) | (int) curfil->_pnb; 9 $      if ((rd [7]&0x0000ffff) == 12) $ 1        /* it's a TEMP file, so length is zero */ 1         curfprm->eofptr = 0;  %      else if (rd [CUBFL1] == CUBFIL) % 3        /* if the file has been previously typed by 3 6          the C library, it will have been lengthed */ 6 &        curfprm->eofptr = rd [CUBFL2]; & 
      else 
 /        curfprm->eofptr = BUFSIZ * rd [69] - 1; / 6      /* if no value in RD, try to work out a value */ 6                            @        ieofbl = rd [REOFBL];        }    }  #endif    return (GOOD);  }     
#ifndef MPX1X 
 /* pathname parse */     'static int prspn (pname, pnblk, pnbvec) ' char *pname;  int  *pnblk;  int *pnbvec;  {    struct rrstag *rptr = &_rrs;    int reg [8];    register int l;       *pnbvec = 0;     "  if ((l = strlen (pname)) > 52) { "     errno = EINVAL;      mpxerr = E007;      return (ERROR);    }    else if (!l) {      errno = EINVAL;      mpxerr = E008;      return (ERROR);    }       ZREG (reg, 8);    reg [1] = l;    reg [1] <<= 24;    reg [1] |= (int) pname;    reg [4] = 18 * sizeof (int);    reg [4] <<= 24;    reg [4] |= (int) pnblk;                                                @  9  mpxsvc (0x202e, reg, reg);    /* make pathname block */ 9      if (reg [7]) {      errno = EINVAL;      mpxerr = E009;      return (ERROR);    }    *pnbvec = reg [4];    return (GOOD);  }  #endif     
#ifndef MPX1X 
  /*    exist internal function */      static int exist (pnbvec)  int pnbvec;  {    int reg [8];    int rdu [192];       ZREG (reg, 8);    reg [1] = pnbvec;    reg [6] = (int) rdu;    mpxsvc (0x202c, reg, reg);    return (reg [7]);  }  #endif     /*   getfd function     */     static int getfd ()  {  	  int fd; 	    !  for (fd = 0; fd < _NFILE; fd++) ! 9    if (filtabl [fd].filparm.mode & NOTUSED) return (fd); 9   return (EOF);  }     /*  __isblk function */         @  int __isblk (fd)  int fd;  {    struct flprmtag  *p;       BADFD (fd, IOEOF);    p = &(filtabl[fd].filparm);  (  if (p->mode & NOTUSED) return (IOEOF); (   return (p->block);  }     /* isatty function */     int isatty (fd)  int fd;  {    struct flprmtag *p;       BADFD (fd, IOEOF);    p = &(filtabl[fd].filparm);  (  if (p->mode & NOTUSED) return (IOEOF); ( #ifdef TRY_THIS_AT_VISTA  ?  return ((p->device == TERMINAL) || (p->block && !p->binary)); ? #else  !  return (p->device == TERMINAL); ! #endif  }     /*  fcbadr function   */     struct fcbtag *fcbadr (fd)  int fd;  {    BADFD (fd, IOEOF);  :  if (filtabl [fd].filparm.mode & NOTUSED) return (IOEOF); :    return (& (filtabl [fd].fcb));      @  }     7/*    access function (not currently used, if required, 7 ?    will be converted to use MPX access modes like creat does). ?     Currently not compiled */     #ifdef INCACCESS     int access (name, amode)  char *name;  
int amode; 
 {    int reg [8];    int rdu [192];    int ow, pr, ot;    register int acc=0;    int owr, prr, otr;  7  int wacc = 0X40000000;             /* write access */ 7 8  int uacc = 0X20000000;             /* update access */ 8   int pnblk [18];  
  int pnbvec; 
    3  if (prspn (name, pnblk, &pnbvec)) return (ERROR); 3   ZREG (reg, 8);    reg [1] = pnbvec;    reg [6] = (int) rdu;    mpxsvc (0x202c, reg, reg);    if (reg [7]) return (ERROR);    ow = rdu [30];    pr = rdu [31];    @    ot = rdu [32];  
  owr = ow<0; 
 
  prr = pr<0; 
 
  otr = ot<0; 
 *  acc |= owr;      /* owner read access */ *   acc <<= 1;  =  acc |= (ow&wacc && ow&uacc);       /* owner write access */ =   acc <<= 1;  5  acc |= 1;        /* owner assumed execute access */ 5   acc <<= 1;  ,  acc |= prr;      /* project read access */ ,   acc <<= 1;  ?  acc |= (pr&wacc && pr&uacc);       /* project write access */ ?   acc <<= 1;  7  acc |= 1;        /* project assumed execute access */ 7   acc <<= 1;  *  acc |= otr;      /* other read access */ *   acc <<= 1;  =  acc |= (ot&wacc && ot&uacc);       /* other write access */ =   acc <<= 1;  5  acc |= 1;        /* other assumed execute access */ 5    
  return acc; 
 }     #endif            @  ,/* delete function (unlink if you insist) */ ,    int delete (pname)  char *pname;  {  5  return (unlink(pname));       /* delete the file */ 5 }     /* carriage control toggler */  void mpxccset (tog)  int tog;  {    carcont = tog;  }                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   