  @  /*~!rmdirp.c*/  */* Name:  rmdirp.c Part No.: _______-____r *  *  - * Copyright 1992 - J B Systems, Morrison, CO -  *  G * The recipient of this product specifically agrees not to distribute, G G * disclose, or disseminate in any way, to any one, nor use for its own G G * benefit, or the benefit of others, any information contained  herein G 8 * without the expressed written consent of J B Systems. 8  *  / *                     RESTRICTED RIGHTS LEGEND /  *  D * Use, duplication, or disclosure by the Government is  subject  to D D * restriction  as  set forth in paragraph (b) (3) (B) of the Rights D D * in Technical Data and Computer Software  Clause  in  DAR  7-104.9 D  * (a).   */      #ident	"@(#)nbclib:rmdirp.c	1.1"                @  D/* Rmdirp() removes directories in path "d". Removal starts from the D I** right most directory in the path and goes backward as far as possible. I O** The remaining path, which is not removed for some reason, is stored in "d1". O %** If nothing remains, "d1" is empty. %    ** Rmdirp()  B** returns 0 only if it succeeds in removing every directory in d. B J** returns -1 if removal stops because of errors other than the following. J G** returns -2 if removal stops when "." or ".." is encountered in path. G B** returns -3 if removal stops because it's the current directory. B */     #include <sys/types.h>  #include <sys/stat.h>  #include <stdio.h>  #include <errno.h>  #include <string.h>     char *strcpy(), *strrchr();              @  static int dotdot();     int  
rmdirp(d, d1) 
 
char *d, *d1; 
 {  	struct stat st, cst;  	int currstat;  	char *slash, *endptr;  	  	slash = strrchr(d, '/');  	currstat = stat(".", &cst);     )    	/* Starts from right most element */ )    	while (d) {			     +    		/* If it's under current directory */ +    		if (slash == NULL) {     			/* Stop if it's . or .. */     			if (dotdot(d)) {  				strcpy(d1, d);  				return(-2);  			}      			/* Stop if can not stat it */      			if (stat(d, &st) < 0) {  				strcpy(d1, d);  				return(-1);  			}  		}     $		/* If there's a slash before it */ $    		else {     			/* If extra / in the end */     			if (slash != d)                       @  %				if (++slash == strrchr(d,'\0')) { % 					*(--slash) = '\0';  					slash = strrchr(d, '/');  					continue;  				}  				else  
					slash--; 
    			/* Stop if it's . or .. */     			if (dotdot(++slash)) {  				strcpy(d1, d);  				return(-2);  			}  			slash--;      			/* Stop if can not stat it */      			if (stat(d, &st) < 0) {  				strcpy(d1, d);  				return(-1);  			}  			if (currstat == 0) {	     (				/* Stop if it's current directory */ (    8				if(st.st_ino==cst.st_ino && st.st_dev==cst.st_dev) { 8 					strcpy(d1, d);  					return(-3);  				}  			}  		} /* End of else */     .		/* Stop if no write permission for parent */ .    		endptr = strrchr(d, '\0');  		strcat(d, "/..");     @  		if (access(d, 02)) {  			if (errno != EACCES) {  				*endptr = '\0';  				strcpy(d1,d);  				return(-1);  			}  		}  		*endptr = '\0';     		/* Remove it */     		if (rmdir(d) != 0) {  			strcpy(d1, d);  			return(-1);  		}     #		/* Have reached left end, break*/ #    "		if (slash == NULL || slash == d) " 				break; 	    %		/* Go backward to next directory */ %    		*slash = '\0';  		slash = strrchr(d, '/');  	}  	*d1 = '\0';  	return(0);  }     
static int 
 dotdot(dir)  
char *dir; 
 {  5	if (strcmp(dir, ".") == 0 || strcmp(dir, "..") == 0) 5 
		return(-1); 
 	return(0);  }                                                                                                                  