  @  /*~!mpxini.c*/  */* Name:  mpxini.c Part No.: _______-____r *  *  - * Copyright 1992 - J B Systems, Morrison, CO -  *  G * The recipient of this product specifically agrees not to distribute, G G * disclose, or disseminate in any way, to any one, nor use for its own G G * benefit, or the benefit of others, any information contained  herein G 8 * without the expressed written consent of J B Systems. 8  *  / *                     RESTRICTED RIGHTS LEGEND /  *  D * Use, duplication, or disclosure by the Government is  subject  to D D * restriction  as  set forth in paragraph (b) (3) (B) of the Rights D D * in Technical Data and Computer Software  Clause  in  DAR  7-104.9 D  * (a).   */      #ident	"@(#)nbclib:mpxini.c	1.1"      /*      @   *	MPXINI.C   */     G/* This routine picks up arguments from the command line and constructs G F * an argument list for a C program.  In the process, input and output F - * redirection is performed if indicated.  */ -    7#include <mosde.h>	/* Machine dependent equates !MOD */ 7 #include <stdio.h>  #include <errno.h>  #include <prb.h>     !#define ARGCNT 60     /* WAS 8 */ ! "#define ARGLEN 80     /* was 30 */ " "#define LINELEN 768   /* was 80 */ " #define READ 0  #define WRITE 1  #define NULL 0  0#define MPX_DEFAULT 0x1ff	/* default to r,w,x */ 0    Estruct _myidbl _myid;   /* the ext def of the data block from myid */ E 2char *envdata[ARGCNT];  /* the environment data */ 2                                                      @  6char **environ=envdata; /* environment list pointer */ 6 *extern int runrflg;     /* run req flag */ * -struct prb prb;         /* param rec block */ - 8extern char* getenv();  /* get environment assignment */ 8 void getcwvd();  4char curvol[18];        /* current working volume */ 4 7char curdir[18];        /* current working directory */ 7    #ifdef MPX1X  7int curwdir[2];		/* curdir as two blank filled words */ 7 5short userkey;		/* for 1X, contains compressed key */ 5 static  int	r5val,r6val,r7val;  //* NOTE, this buffer must be on word boundry */ / Achar   argbuf[LINELEN];         /* buffer for argument strings */ A #endif     	_mpxini() 	 {  #include "version.h"     :    int    argc = 0;                /* argument counter */ :  @  ?    char   *argv[ARGCNT];           /* pointers to arguments */ ? 
#ifndef MPX1X 
 E    char   argbuf[LINELEN];         /* buffer for argument strings */ E #endif  =    char   *argptr = argbuf;        /* pointer into argbuf */ = =    char   *curptr = argptr;        /* current arg pointer */ = G    char   *argpin = 0;             /* pointer into argbuf (in redir)*/ G H    char   *argpot = 0;             /* pointer into argbuf (out redir)*/ H H    char   *argper = 0;             /* pointer into argbuf (err redir)*/ H A    int    sotapp = 0;              /* stdout redir and append */ A A    int    serapp = 0;              /* stderr redir and append */ A @    int    sersot = 0;              /* stderr redir to stdout */ @                                  @  7    int    argsize;                 /* argument size */ 7 K    int    sin,sout,eout;           /* file descriptors for input/output */ K     int    i,j;  6    int    exmode;                  /* execute mode */ 6 #ifdef MPX1X  ;    char   *iinp = "LFC=UT";        /* interactive input */ ; #else  ;    char   *iinp = "SYC";           /* interactive input */ ; #endif  3    char   *jinp = "SYC";           /* job input */ 3 6    char   *actinp;                 /* actual input */ 6 <    char   *iout = "LFC=UT";        /* interactive output */ < 4    char   *jout = "SLO";           /* job output */ 4 F    char   *utd = "UT=DTCHUN   ";   /* device assigned to "UT " lfc */ F 7    char   *actout;                 /* actual output */ 7                      @  <    char   *ierr = "LFC=UT";        /* interactive output */ < 4    char   *jerr = "SLO";           /* job output */ 4 7    char   *acterr;                 /* actual output */ 7 8    char   taskid[9];               /* task id string */ 8 F    char   *ept = 0;                /* ptr into argbuf for env info */ F :    char   **ep;                    /* curr env pointer */ : 2    int    reg[8];                  /* mpx regs */ 2    6    /* set default activation stdin, stdout, stderr */ 6 (    /* this for when we are activated */ (     actinp = "DEV=NU";      actout = "DEV=NU";      acterr = "DEV=NU";     =    exmode = _mpxin2();		/* Find out if task was activated */ = 0    getcwvd();			/* get curr vol/dir for task */ 0                            @  *    argbuf[0] = 0;		/* insure null args */ *    /    if (!runrflg) {		/* if not run requested */ /       for(i=0;i<8;i++)  6    	taskid[i] = ((j=_myid._lm[i]) != ' ') ? j : '\0'; 6       taskid[8] = '\0';  @      argv[argc++] = taskid;	/* set up first argument in list */ @     } else {  5      prb.rba = (int)argbuf;    /* arg buffer addr */ 5 .      prb.rbl = LINELEN;        /* buf size */ . 1      reg [2] = (int)&prb;      /* prb address */ 1 8      mpxsvc(0x107b, reg, reg); /* get run req params */ 8       if (reg[6])  .    	_exitmpx("rreq");	/* go abort if error */ .     }     8    if(exmode || runrflg) {	/* If task was TSM or JOB */ 8 0      if(exmode) {		/* If task was TSM or JOB */ 0 +    	actinp = ((exmode == 'J')?jinp: iinp); +   @  +    	actout = ((exmode == 'J')?jout: iout); + +    	acterr = ((exmode == 'J')?jerr: ierr); + :        argptr = argbuf;	/* set argument buffer pointer */ :       } else {      	/* if run requested */      	actinp = iout;      	actout = iout;      	acterr = ierr;     #ifdef MPX1X      	/* set key in r4 & r5 */      	asm (" zr r4");      	asm (" zr r5");  "    	/* set username in r6 & r7 */ "     	asm (" lw r6,_argbuf");      	asm (" lw r7,_argbuf+1w");  9    	asm (" svc 1,x'74'");	/* set new username, m.user */ 9 0    	getcwvd();		/* get curr vol/dir for task */ 0 <        argptr = argbuf+8;	/* set argument buffer pointer */ < #else  :        argptr = argbuf;	/* set argument buffer pointer */ : #endif        }             @  @      /* get arguments until last one found from command line */ @       while (1) {      	if (!runrflg) {  #    	  /* parse tsm command line */ # 2    	  if ((argsize = ctscan(argptr,ARGLEN)) == 0) 2     	    break;  @    	  curptr = argptr;     /* pointer to actual CL arguments */ @ @    	  argptr += argsize;   /* argptr points after arg string */ @ 7    	  *argptr++ = NULL;    /* null terminate string */ 7 
    	} else { 
 !    	  /* parse run req buffer */ !     	  if (*argptr == 0) {  2    	    ept = ++argptr;     /* set environ ptr */ 2 1    	    break;              /* done with args */ 1     	  }  4    	  curptr = argptr;      /* point to next arg */ 4 <    	  argsize = strlen(curptr); /* current string length */ <                     @  7    	  argptr += argsize + 1; /* skip to next string */ 7     	}     6    	/* Check if argument is a redirection argument */ 6     	switch(*curptr){         	  case '<':  8    	    argpin = curptr + 1;    /* input redirection */ 8     	    break;         	  case '>':  <    	    if (*++curptr != '>')   /* check for append mode */ <     	      argpot = curptr;      	    else {      	      sotapp = 1;      	      argpot = curptr + 1;  
    	    } 
     	    break;         	  case '2':  C    	    if (*++curptr != '>') { /* check for redirect of stderr */ C #    	      argv[argc++] = --curptr; # B    	      break;               /* add argument to argument list*/ B 
    	    } 
     	    else {                                 @  /    	      /* stderr is redirected somewhere */ /     	      switch (*++curptr) {     %    		case '>':          /* append */ %     		  argper = curptr + 1;      		  serapp = 1;      		  break;     7    		case '&':    /* redir to ? (only stdout so far)*/ 7     		  if(*++curptr == '1')      		    sersot = 1;      		    /* redirect to stdout  4    		     * which may not have been redirected yet! 4 
    		     */ 
     		    break;     ,    		default:           /* redir to file */ ,     		  argper = curptr;      		  break;      	      }  
    	    } 
     	    break;         	  default:  C    	  argv[argc++] = curptr;    /* add argument to argument list*/ C     	} /* end of switch */        } /* end of while */      @  +      if (runrflg) {  /* get environment */ +     	ep = environ;      	if (ept == 0 || *ept == 0)      	  environ = (char **)NULL;      	while (*ept) {      	  curptr = ept;  !    	  ept += strlen(curptr) + 1; !     	  *ep++ = curptr;      	}      	*ep = (char *)NULL;        } else {  6    	/* tsm task, get UT assignment for environment */ 6     	int *tsa;      	int *dqe;      	int kk[2];      	int *udt;      	short nudt;  
    	int dev; 
 #ifdef MPX35  .    	mpxsvc(0x207d, reg, reg);       /* jcb */ . .    	tsa = (int*)reg[1];             /* jcb */ . #else  8    	tsa = (int *)(*((int *)C_TSAD));	/* 0xa80 c.tsad */ 8 #endif  ;    	dqe = (int *)tsa[T_PRNO/sizeof(int)]; /* get t.prno */ ;                                 @  G    	kk[0] = dqe[(DQE_PSN/sizeof(int)) + 1]; /* get dev from dqe.psn */ G 5    	kk[1] = 0;              /* ensure zero at end */ 5 :    	sscanf(kk,"%4x", &dev);  /* get hex device address */ : <    	udt = (int *)(*(int*)C_UDTA);		/* addr of UDT tables */ < <    	nudt = (short) (*((short *)C_UDTN));	/* num of UDT's */ < 4    	for (; nudt--; udt += (UDT_SIZE/sizeof(int))) { 4 &    	  if ((udt[1] & 0xffff) == dev) { & D    	    dev |= ((udt[1] & 0x00ff0000) << 8);  /* get device type */ D     	    goto got;      	  }      	}  ,    	dev |= 0x0c000000;      /* assume ty */ , got:  '    	reg[2] = (dev & 0xff000000) >> 24; ' -    	mpxsvc (0x1014, reg, reg);	/* M.DEVID */ - =    	sprintf (utd, "UT=%c%c%04.4x", ((reg[2] & 0xff00) >> 8), =               @  (    	    (reg[2] & 0xff), dev & 0xffff); (     	ep = environ;      	*ep++ = utd;      	*ep = (char *)NULL;        }           if (runrflg) {  *    	/* must assign UT for run req task */ *     	static int rrs[6];  
    	int dev; 
     	int devty;      	static char *dp;  #ifdef RRDEBUG      	char msg[80];  '    	int * tfp = mpxopen("TRACE", 'w'); ' #endif  '    	if ((dp = getenv("UT")) == NULL) { ' 7    	  /* we only get here if we were run requested and 7 7    	   * no environment was passed.  This happens when 7 :    	   * a C task is started with the sequence directive. :     	   * fixed 05/13/92 JCB */  0    	  actinp = "DEV=NU";	/* set NULL devices */ 0     	  actout = "DEV=NU";      	  acterr = "DEV=NU";               @      	  goto rrnoenv;      	}  /*    	  _exitmpx("UT? "); */  #ifdef RRDEBUG  K    	sprintf(msg, "RUN BUG1: exmode = %x, getenv ret dp=%s\n", exmode, dp); K %    	mpxwrite(tfp,msg,strlen(msg),1); % #endif      	strcpy(utd, "DEV=");      	strcat(utd, dp);      	reg[2] = (int)dp[1];  #    	reg[2] |= (((int)dp[0]) << 8); #     	mpxsvc (0x1014, reg, reg);      	devty = reg[2];  @    	sscanf (&dp[2], "%4x", &dev);  /* get hex device address */ @     	dev |= (devty << 24);  *    	rrs[0] = 0x00555420;      /* "UT " */ *     	reg[1] = (int)rrs;  /*    	reg[7] = 0; */  6/*      mpxsvc (0x2053, reg, reg);*/ /* deassign UT */ 6 6    	rrs[1] = 0x03060000;      /* type 3 size 6 wds */ 6 1/*      rrs[2] = 0xf8000000;      /* allow r/w */ 1   @  .    	rrs[2] = 0x00000000;      /* allow r/w */ .     	rrs[3] = 0;  @    	rrs[4] = (dev | 0x80008000); /* dev type, chan, sub addr */ @     	rrs[5] = 0;      	reg[7] = 0;  #ifdef RRDEBUG  M    	sprintf(msg, "RUN BUG2: rrs built: %x %x %x %x %x %x\n", rrs[0], rrs[1], M )    	    rrs[2], rrs[3], rrs[4], rrs[5]); ) %    	mpxwrite(tfp,msg,strlen(msg),1); % #endif     #ifdef MPX1X  .    	r5val = 0x03555420;		/* type 3, lfc=ut */ . *    	r6val = (int)&rrs[4];		/* chan, sa */ * /    	r7val = (int)&rrs[5];		/* point to null */ / 4    	asm (" la 1,altret");		/* set error ret addr */ 4 0    	asm (" lw 5,_r5val");		/* get type & LFC */ 0 /    	asm (" lw 6,_r6val");		/* get chan & sa */ / 1    	asm (" lw 7,_r7val");		/* no reel or size */ 1           @  (    	asm (" svc 1,x'40'");		/* M.ALOC */ ( )    	asm (" li 6,-1");		/* o.k. return */ ) 7    	asm ("altret stw 6,_r6val");	/* save error code */ 7     	if (r6val != -1) {  #ifdef RRDEBUG  <    	sprintf(msg, "RUN BUG3: aloc error, r6 = %x\n", r6val); < %    	mpxwrite(tfp,msg,strlen(msg),1); % #endif      	  _exitmpx("rrs ");      	}     #else /* MPX1X */     ,    	mpxsvc (0x2052, reg, reg);	/* m.assn */ , #ifdef RRDEBUG  @    	sprintf(msg, "RUN BUG3: assign called: r7 = %x\n", reg[7]); @ %    	mpxwrite(tfp,msg,strlen(msg),1); %     	mpxclos (tfp);  #endif  '/*	if (reg[7] != 0)_exitmpx("rrs "); */ '     	if (reg[7] != 0) {      	  actinp = "DEV=NU";      	  actout = "DEV=NU";      	  acterr = "DEV=NU";      	}           @  #endif /* MPX1X */        }     1    } /* end of if for TSM, JOB or run request */ 1    >rrnoenv:	/* we come here for sequence directive from sysgen */ >     /*  B     * open the assigned devices, will be NULL for activated tasks B      */  =    argv[argc] = (char *)NULL;  /* null terminate argv JCB */ =    -    if (argpin) {		/* REDIRECTION OF STDIN */ - )      if ((sin = open(argpin,READ)) != 0) )     	_exitmpx("in2 ");  ,    } else {			/* NO REDIRECTION OF STDIN */ , (    	if ((sin = open(actinp,READ)) != 0) (     	  _exitmpx("in1 ");      }     .    if (argpot) {		/* REDIRECTION OF STDOUT */ . +      if (sotapp) {		/* WITH APPEND MODE */ +     	errno = 0;  ,    	if ((sout = open(argpot,WRITE)) == 1) { ,                       @      	  if (seek(sout,0,2) < 0)      	    _exitmpx("out3");       	} else if (errno == E004) {   3    	  if ((sout = creat(argpot,MPX_DEFAULT)) != 1) 3     	    _exitmpx("out1");      	}     *      } else {			/* WITHOUT APPEND MODE */ * 2    	/* check for keywords list, print and null */ 2        	/* LIST? */  B    	if (strcmp(argpot,"LIST") == 0 || strcmp(argpot,"list") == 0) B <    	  sout = open(actout,WRITE);       /* yes, open term */ <        	/* PRINT? */  I    	else if (strcmp(argpot,"PRINT") == 0 || strcmp(argpot,"print") == 0) I >    	  sout = open(jout,WRITE);            /* yes, open SLO */ >        	/* NULL? */  G    	else if (strcmp(argpot,"NULL") == 0 || strcmp(argpot,"null") == 0) G                                    @  ?    	  sout = open("DEV=NU",WRITE);        /* yes, open null */ ?        	/* Output is to a file */  7    	else if ((sout = creat(argpot, MPX_DEFAULT)) != 1) 7     	  _exitmpx("out4");        }  -    } else {			/* NO REDIRECTION OF STDOUT */ - +      if ((sout = open(actout,WRITE)) != 1) +     	_exitmpx("out6");      }     +    if (sersot) {		/* STDERR ONTO STDOUT */ + .      if ((eout = open("LFC=UX1",WRITE)) != 2) .     	_exitmpx("err7");  4    } else if (argper) {	/* REDIRECTION OF STDERR */ 4 &      if (serapp) {		/* APPEND MODE */ &     	errno = 0;  ,    	if ((eout = open(argper,WRITE)) == 2) { ,     	  if (seek(eout,0,2) < 0)      	    _exitmpx("err3");       	} else if (errno == E004) {                                      @  3    	  if ((eout = creat(argper,MPX_DEFAULT)) != 2) 3     	    _exitmpx("err1");      	}  *      } else {			/* WITHOUT APPEND MODE */ * 2    	/* check for keywords list, print and null */ 2 B    	if (strcmp(argper,"LIST") == 0 || strcmp(argper,"list") == 0) B !    	  eout = open(acterr,WRITE); ! I    	else if (strcmp(argper,"PRINT") == 0 || strcmp(argper,"print") == 0) I     	  eout = open(jerr,WRITE);  G    	else if (strcmp(argper,"NULL") == 0 || strcmp(argper,"null") == 0) G $    	  eout = open("DEV=NU", WRITE); $ 6    	else if ((eout = creat(argper,MPX_DEFAULT)) != 2) 6     	/* Output is to a file */      	  _exitmpx("err4");        }  -    } else {			/* NO REDIRECTION OF STDERR */ - +      if ((eout = open(acterr,WRITE)) != 2) +        @          _exitmpx("err6");      }     8/*XXXXX    } /* end of if for TSM, JOB or run request */ 8    <    asm (" lw 0,x'a80'");	/* if txpm turn off tsa biasing */ <     asm (" camw 0,x'a80'");      asm (" beq $+2w");      asm (" svc 1,3");     6    /* Call the C program with the arguments given. */ 6    1    main(argc,argv);		/* call the main routine */ 1 3    exit(0);			/* if main returns, exit normally */ 3 }        static int _mpxin2()  {   int   reg[8];  	 int   i; 	     for (i=0;i<8;i++) reg[i] = 0;      reg[5] = 0x80000000;   reg[7] = (int) &_myid;  # mpxsvc(0x1064,reg,reg);	/* M.ID */ #     return((int)_myid._pn[0]);  }                                                                                