  @  
/*~!hypot.c*/ 
 )/* Name:  hypot.c Part No.: _______-____r )  *  - * Copyright 1992 - J B Systems, Morrison, CO -  *  G * The recipient of this product specifically agrees not to distribute, G G * disclose, or disseminate in any way, to any one, nor use for its own G G * benefit, or the benefit of others, any information contained  herein G 8 * without the expressed written consent of J B Systems. 8  *  / *                     RESTRICTED RIGHTS LEGEND /  *  D * Use, duplication, or disclosure by the Government is  subject  to D D * restriction  as  set forth in paragraph (b) (3) (B) of the Rights D D * in Technical Data and Computer Software  Clause  in  DAR  7-104.9 D  * (a).   */     #ident	"@(#)nbclib:hypot.c	1.1"     /*         @  G *	hypot(a, b) returns sqrt(a^2 + b^2), avoiding unnecessary overflows. G K *	Returns ERANGE error and value HUGE if the correct value would overflow. K  */     #include <math.h>  #include <values.h>  #include <errno.h>     #define ITERATIONS	4     double  hypot(a, b)  register double a, b;  {  	register double t;  	register int i = ITERATIONS;  	struct exception exc;     	if ((exc.arg1 = a) < 0)  			a = -a; 	 	if ((exc.arg2 = b) < 0)  			b = -b; 	 +	if (a > b) {				/* make sure |a| <= |b| */ + 		t = a;  		a = b;  		b = t;  	}  :	if(b == 0.0) return(b);			/* both args are 0, result=0 */ : &	if ((t = a/b) < X_EPS)			/* t <= 1 */ & 		return (b);			/* t << 1 */  (	a = 1 + t * t;				/* a = 1 + (a/b)^2 */ (     @  0	t = 0.5 + 0.5 * a;			/* first guess for sqrt */ 0 	do {  		t = 0.5 * (t + a/t);  (	} while (--i > 0);			/* t <= sqrt(2) */ ( 8	if (b < MAXDOUBLE/M_SQRT2)		/* result can't overflow */ 8 		return (t * b);  >	if ((t *= 0.5 * b) < MAXDOUBLE/2)	/* result won't overflow */ > 		return (t + t);  	exc.type = OVERFLOW;  	exc.name = "hypot";  	exc.retval = HUGE;  	if (!matherr(&exc))  		errno = ERANGE;  	return (exc.retval);  }                                                                                                                                                                                                                                                                                                                           