  @  /*~!exo.c*/  '/* Name:  exp.c Part No.: _______-____r '  *  - * Copyright 1992 - J B Systems, Morrison, CO -  *  G * The recipient of this product specifically agrees not to distribute, G G * disclose, or disseminate in any way, to any one, nor use for its own G G * benefit, or the benefit of others, any information contained  herein G 8 * without the expressed written consent of J B Systems. 8  *  / *                     RESTRICTED RIGHTS LEGEND /  *  D * Use, duplication, or disclosure by the Government is  subject  to D D * restriction  as  set forth in paragraph (b) (3) (B) of the Rights D D * in Technical Data and Computer Software  Clause  in  DAR  7-104.9 D  * (a).   */     #ident	"@(#)nbclib:exp.c	1.1"     /*               @  I *	exp returns the exponential function of its double-precision argument. I : *	Returns ERANGE error and value 0 if argument too small, : ' *	   value HUGE if argument too large. ' 9 *	Algorithm and coefficients from Cody and Waite (1980). 9  *	Calls ldexp.   */     #include <math.h>  #include <values.h>  #include <errno.h>     static double p[] = {      0.31555192765684646356e-4,      0.75753180159422776666e-2,      0.25000000000000000000e0,  
}, q[] = { 
     0.75104028399870046114e-6,      0.63121894374398503557e-3,      0.56817302698551221787e-1,      0.50000000000000000000e0,  };     double  exp(x)  register double x;  {  	register double y;  	register int n;  	struct exception exc;                @  	exc.arg1 = x;  	if (x < 0)  			x = -x; 	 ?	if (x < X_EPS) /* use first term of Taylor series expansion */ ? 		return (1.0 + exc.arg1);  	exc.name = "exp";   	if (exc.arg1 <= LN_MINDOUBLE) {   >		if (exc.arg1 == LN_MINDOUBLE) /* protect against roundoff */ > 7			return (MINDOUBLE); /* causing ldexp to underflow */ 7 		exc.type = UNDERFLOW;  		exc.retval = 0.0;  		if (!matherr(&exc))  			errno = ERANGE;  		return (exc.retval);  	}   	if (exc.arg1 >= LN_MAXDOUBLE) {   >		if (exc.arg1 == LN_MAXDOUBLE) /* protect against roundoff */ > 6			return (MAXDOUBLE); /* causing ldexp to overflow */ 6 		exc.type = OVERFLOW;  		exc.retval = HUGE;  		if (!matherr(&exc))  			errno = ERANGE;  		return (exc.retval);  	}                     @  	n = (int)(x * M_LOG2E + 0.5);  	y = (double)n;  <	_REDUCE(int, x, y, 0.693359375, -2.1219444005469058277e-4); < 	if (exc.arg1 < 0) {  			x = -x; 	 			n = -n; 	 	}  	y = x * x;  	x *= _POLY2(y, p);  3	return (ldexp(0.5 + x/(_POLY3(y, q) - x), n + 1)); 3 }                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          