  @  
/*~!cassg.c*/ 
 )/* Name:  cassg.c Part No.: _______-____r )  *  - * Copyright 1991 - J B Systems, Morrison, CO -  *  G * The recipient of this product specifically agrees not to distribute, G G * disclose, or disseminate in any way, to any one, nor use for its own G G * benefit, or the benefit of others, any information contained  herein G 8 * without the expressed written consent of J B Systems. 8  *  / *                     RESTRICTED RIGHTS LEGEND /  *  D * Use, duplication, or disclosure by the Government is  subject  to D D * restriction  as  set forth in paragraph (b) (3) (B) of the Rights D D * in Technical Data and Computer Software  Clause  in  DAR  7-104.9 D  * (a).   */     #ident	"@(#)nbclib:cassg.c	1.0"     /*         @  B * cassg - syntax scanner for assignments - this is MPX 1X version B  *  ) *	Parse an assignment line into it's rrs )  *  ( *	Calling sequence ret = _cassg(buffer) ( 	 *	where: 	 ' *		ret:	returns 0 for O.K., else error ' * *		buffer:	char pointer to callers buffer *  */     
#define CASSG 
 #include "unixio.h"  #include <string.h>  #include <ctype.h>     5struct rrstag _rrs;		/* where current rrs is built */ 5 <struct finfo* _fib;		/* where file information block goes */ <    static int _parse();  7struct finfo* pn2fib();		/* parse pathname into _fib */ 7    6static char input[256];		/* local copy of scan line */ 6 >static char *linep = 0;		/* current position in input array */ >                                                   @  Dstatic int eol = 0;		/* end of line flag, set when c/r or ! found */ D &static int	mlen;		/* maximum length */ & -static int delim;		/* last delimiter found */ -    int _cassg(bufr)  char *	bufr;  {  9  char token[64];		/* where token is to be parsed into */ 9 $  int  ccnt;			/* curr char count */ $    char *tp;			/* temp pointer */     char *p;			/* temp pointer */    int  i,dt;			/* temp */     F  bzero ((char *)&_rrs, sizeof (struct rrstag));	/* clear local rrs */ F 8  strcpy (input, bufr);		/* make local copy of buffer */ 8 (  str2up (input);		/* make upper case */ ( 7  linep = input;		/* set buffer addres to be scanned */ 7 -  mlen = strlen(bufr);		/* set it's length */ - !  eol = 0;			/* not at eol yet */ !                        @  =  if ((ccnt = _parse(token, 0)) == 0)	/* parse off a token */ = 6    return (-1);		/* nothing to parse, return error */ 6    C  /* get the base token to determine the type of rrs to be built */ C #  /* see if LFC=, DEV=, or TEMP= */ #   if (delim == '=') {     %    if (strcmp (token, "LFC") == 0) { %          /* process LFC = */  1      _rrs.flags = 0x08;	/* show an LFC assign */ 1    '      /* parse off the LFC to assign */ ' A      if ((ccnt = _parse(token, 0)) == 0)	/* parse off a token */ A :        return (-1);		/* nothing to parse, return error */ :    4      /* copy the LFC into the rrs and blank fill */ 4 1      for (i=0, tp=(char *)&_rrs.wd2; i < 3; i++) 1         if (!token[i])      	  *++tp = ' ';          else           @      	  *++tp = token[i];           if (_parse(token, 0))  /    	return (-1);		/* error if anything else */ / 1      return (0);		/* return O.K. if EOL found */ 1    0    } else if (strncmp (token, "DEV", 3) == 0) { 0          /* process DEV= */  4      _rrs.flags |= 0x10;	/* show a type 3 assign */ 4    "      /* scan for device=dtchsa */ "       if (_pdevi(token) != 0)  +    	return (-1);		/* error parsing devi */ +    !      /* get next token if any */ !        if (_parse(token, 0) == 0)   ,    	return (0);		/* o.k. if nothing else */ ,    D      dt = (_rrs.wd2 & 0x7f000000) >> 24;	/* get device type code */ D    8      /* if mag tape get blocked=, id=, and/or multi= */ 8       if (dt >= 4 && dt <= 6) {                       @  $        /* default reel id to SCR */ $ )        _rrs.size = 0x53435320;	/* SCR */ )            while (!eol) {     &          /* scan for reel=  or id= */ & &          if ((i = _preel(token)) < 0) & 1    	    return (-1);	/* error parsing reel id */ 1    5          if (!i) 		/* found reel, scan next token */ 5 &            if (_parse(token, 0) == 0) & 1    	      return (0);	/* o.k. if nothing else */ 1    '          /* scan for multi= or vol= */ ' &          if ((i = _pmult(token)) < 0) & ,    	    return (-1);	/* error parsing id */ ,    3          if (!i) 		/* found id, scan next token */ 3 &            if (_parse(token, 0) == 0) & 1    	      return (0);	/* o.k. if nothing else */ 1    !          /* scan for blocked= */ !              @  &          if ((i = _pbloc(token)) < 0) & .    	    return (-1);	/* error parsing bloc */ .    5          if (!i) 		/* found bloc, scan next token */ 5 &            if (_parse(token, 0) == 0) & 1    	      return (0);	/* o.k. if nothing else */ 1 	        } 	       }     -      /* if disk, get blocked= and/or size */ -       if (dt >= 1 && dt <= 3) {     (        /* default size to 400 blocks */ (         _rrs.size = 400;             while (!eol) {               /* scan for size= */  &          if ((i = _psize(token)) < 0) & .    	    return (-1);	/* error parsing size */ .    5          if (!i) 		/* found size, scan next token */ 5 &            if (_parse(token, 0) == 0) & 1    	      return (0);	/* o.k. if nothing else */ 1      @     !          /* scan for blocked= */ ! &          if ((i = _pbloc(token)) < 0) & .    	    return (-1);	/* error parsing bloc */ .    5          if (!i) 		/* found bloc, scan next token */ 5 &            if (_parse(token, 0) == 0) & 1    	      return (0);	/* o.k. if nothing else */ 1 	        } 	       }  1      return (0);		/* return O.K. if EOL found */ 1    -    } else if (strcmp (token, "TEMP") == 0) { -    &      /* process TEMP=dtchsa,size,u */ &        }     F  /* check for filename in quotes, if not check for "special" files */ F   } else if (delim != '\'') {     @    /* check for "special" files: SLO, SBO, SYC, SGO, or TEMP */ @ %    if (strcmp (token, "SLO") == 0) { %          /* process SLO */                        @  2      _rrs.flags |= 0x40;	/* show an SLO assign */ 2 ,      _rrs.wd2 = 0x00534c4f;	/* lfc = SLO */ ,    7      /* if terminator was a ',' then # lines follow */ 7       if (delim == ',') {  C        if ((ccnt = _parse(token, 0)) == 0)	/* parse off a token */ C <          return (-1);		/* nothing to parse, return error */ <    *        /* check for valid numbers only */ *         for (p=token; *p; p++)      	  if (!isdigit(*p))      	    return(-1);             /* 5 lines per block */  B        _rrs.size = (atol(token) + 4)/5; /* get number of lines */ B       }     :      /* if no # lines, then nothing else should follow */ : H      /* NOTE: should allow DEVICE= for 3X compatability, but not now */ H       if (_parse(token, 0))   @  /    	return (-1);		/* error if anything else */ / 1      return (0);		/* return O.K. if EOL found */ 1    ,    } else if (strcmp (token, "SBO") == 0) { ,          /* process SBO */  2      _rrs.flags |= 0x40;	/* show an SBO assign */ 2 ,      _rrs.wd2 = 0x0053424f;	/* lfc = SBO */ ,    7      /* if terminator was a ',' then # cards follow */ 7       if (delim == ',') {  C        if ((ccnt = _parse(token, 0)) == 0)	/* parse off a token */ C <          return (-1);		/* nothing to parse, return error */ <    *        /* check for valid numbers only */ *         for (p=token; *p; p++)      	  if (!isdigit(*p))      	    return(-1);             /* 6 lines per block */                                                                     @  B        _rrs.size = (atol(token) + 5)/6; /* get number of lines */ B       }     :      /* if no # cards, then nothing else should follow */ :       if (_parse(token, 0))  /    	return (-1);		/* error if anything else */ / 1      return (0);		/* return O.K. if EOL found */ 1    ,    } else if (strcmp (token, "SYC") == 0) { ,          /* process SYC */  2      _rrs.flags |= 0x20;	/* show an SYC assign */ 2 ,      _rrs.wd2 = 0x00535943;	/* lfc = SYC */ ,          if (_parse(token, 0))  /    	return (-1);		/* error if anything else */ / 1      return (0);		/* return O.K. if EOL found */ 1    ,    } else if (strcmp (token, "SGO") == 0) { ,          /* process SGO */  2      _rrs.flags |= 0x20;	/* show an SGO assign */ 2               @  ,      _rrs.wd2 = 0x0053474f;	/* lfc = SGO */ ,          if (_parse(token, 0))  /    	return (-1);		/* error if anything else */ / 1      return (0);		/* return O.K. if EOL found */ 1    -    } else if (strcmp (token, "TEMP") == 0) { -    '      /* process TEMP with no volume */ ' 4      _rrs.flags |= 0x10;	/* show a type 3 assign */ 4 3      _rrs.size = 400;		/* default to 400 blocks */ 3 <      _rrs.wd2 = 0x01000000;	/* default to any disk  - DC */ <    ,      /* now look for an option  keywords */ , 6      /* size=nnnn   blocked=t/f y/n  device=dtchsa */ 6 7      /* or temp,size,u NOTE: add later if necessary */ 7        if (_parse(token, 0) == 0)   ,    	return (0);		/* o.k. if nothing else */ ,          while (!eol) {               @          /* scan for size= */  $        if ((i = _psize(token)) < 0) $ -    	  return (-1);		/* error parsing size */ -    3        if (!i) 		/* found size, scan next token */ 3 $          if (_parse(token, 0) == 0) $ 0    	    return (0);		/* o.k. if nothing else */ 0            /* scan for blocked= */  $        if ((i = _pbloc(token)) < 0) $ -    	  return (-1);		/* error parsing bloc */ -    3        if (!i) 		/* found bloc, scan next token */ 3 $          if (_parse(token, 0) == 0) $ 0    	    return (0);		/* o.k. if nothing else */ 0    $        /* scan for device=dtchsa */ $ $        if ((i = _pdevi(token)) < 0) $ -    	  return (-1);		/* error parsing devi */ -    3        if (!i) 		/* found devi, scan next token */ 3                @  $          if (_parse(token, 0) == 0) $ 0    	    return (0);		/* o.k. if nothing else */ 0       }  1      return (0);		/* return O.K. if EOL found */ 1     }    }     ,  /* it must be a file name, process path */ , %  /* reset parser, and scan for pn */ % 7  linep = input;		/* set buffer addres to be scanned */ 7 -  mlen = strlen(bufr);		/* set it's length */ - !  eol = 0;			/* not at eol yet */ !   if (_parse(token, 1) == 0)  (    return (-1);		/* error if nothing */ (    "  if ((_fib = pn2fib(token)) == 0) " &    return (-1);		/* pn parse error */ &      /* now set up rrs */  1  _rrs.flags |= 0x80;		/* show a type 1 assign */ 1      /* see if blocked= on line */    if (_parse(token, 0) ==0)                                      @  ,    return (0);			/* nothing else, return */ ,      if (_pbloc (token) < 0)  ,    return(-1);			/* error parsing block= */ ,    .  return (0);			/* return O.K. if EOL found */ .    }     $/* test for device=dtchsa in line */ $ static int _pdevi(tok)  char * tok;  {    char *p = tok;    char *tp;    int i, d;  
  int reg[8]; 
      if (!(*tok))  (    return (-1);		/* error if nothing */ (      if (delim != '=')  *    return (-1);		/* error if not devi= */ *    $  if (strncmp(tok, "DEV", 3) == 0) { $    :    if ((i = _parse(tok, 0)) == 0)	/* parse off a token */ : 8      return (-1);		/* nothing to parse, return error */ 8    =    reg[6] = reg[7] = 0x20202020;	/* set r6 & r7 to blanks */ =                            @      tp = (char *)&reg[6];         switch (i) {     $      /* if size is 6 have dtchsa */ $ $      case 6:			/* dtchsa, get sa */ $ 0        _rrs.wd2 |= 0x8000;	/* set sa present */ 0         tp[2] = tok[4];          tp[3] = tok[5];     "      /* if size is 4 have dtch */ " "      case 4:			/* dtch, get sa */ " 4        _rrs.wd2 |= 0x80000000;	/* set ch present */ 4         tp[0] = tok[2];          tp[1] = tok[3];  D        mpxsvc(0x1029, reg, reg);	/* convert ascii hex to bin hex */ D         if (reg[6] == 0)  ,    	  return (-1);		/* bad char in input */ , 0        _rrs.wd2 |= reg[7];	/* set chan &| sa */ 0           /* if size is 2 have dt */          case 2:			/* dt, get sa */                                                     @  O        reg[2] = ((int)tok[0] << 8) + (int)tok[1]; /* put dev mnemonic in r2 */ O <        mpxsvc(0x1014, reg, reg);	/* get device type code */ <          if (reg[2] & 0x80000000)   ,    	  return(-1);		/* dev type not found */ , @        _rrs.wd2 |= ((unsigned)reg[2] << 24);	/* set dev type */ @ &        return (0);		/* return O.K. */ &          default:  !        return (-1);		/* error */ !     }    }  $  return (1);			/* DEVI not found */ $ }     &/* test for blocked=t/f y/n in line */ & static int _pbloc(tok)  char * tok;  {    if (!(*tok))  (    return (-1);		/* error if nothing */ (      if (delim != '=')  -    return (-1);		/* error if not blocked= */ -    %  if (strncmp(tok, "BLOC", 4) == 0) { %                      @  4    if (_parse(tok, 0) == 0)	/* parse off a token */ 4 8      return (-1);		/* nothing to parse, return error */ 8    :    /* check for n or f in line, set unblocked if found */ : #    if (*tok == 'N' || *tok == 'F') # +      _rrs.flags |= 4;		/* set unblocked */ +    (    else if (*tok == 'Y' || *tok == 'T') ( "      ;				/* just test for y/t */ "    *    else return(-1);		/* not valid char */ * #    return (0);			/* return O.K. */ #   }  $  return (1);			/* BLOC not found */ $ }     +/* test for reel=abcd or id=abcd in line */ + static int _preel(tok)  char * tok;  {    char * p;    int i;       if (!(*tok))  (    return (-1);		/* error if nothing */ (      if (delim != '=')                                               @  *    return (-1);		/* error if not size= */ *    >  if ((strcmp(tok, "REEL") == 0) || (strncmp(tok, "ID", 2))) { >    :    if ((i = _parse(tok, 0)) == 0)	/* parse off a token */ : 8      return (-1);		/* nothing to parse, return error */ 8        if (i < 1 || i > 4)  -      return(-1);		/* not right char count */ -    )    /* first set reel id to all blanks */ ) *    _rrs.size = 0x20202020;	/* blank it */ * 9    p = (char*)&_rrs.size;	/* point where reel id goes */ 9     for (; i >0; i--)  &      *p++ = *tok++;		/* copy in id */ & #    return (0);			/* return O.K. */ #   }  $  return (1);			/* REEL not found */ $ }      /* test for size=nnnn in line */   static int _psize(tok)  char * tok;  {    char * p;                     @    if (!(*tok))  (    return (-1);		/* error if nothing */ (      if (delim != '=')  *    return (-1);		/* error if not size= */ *    !  if (strcmp(tok, "SIZE") == 0) { !    4    if (_parse(tok, 0) == 0)	/* parse off a token */ 4 8      return (-1);		/* nothing to parse, return error */ 8    &    /* check for valid numbers only */ &     for (p=tok; *p; p++)        if (!isdigit(*p))      	return(-1);     /    /* convert size to binary and put in rrs */ / 5    _rrs.size = atol(tok);	/* get number of blocks */ 5 #    return (0);			/* return O.K. */ #   }  $  return (1);			/* SIZE not found */ $ }     #/* test for multi=nnn or vol=nnn */ # static int _pmult(tok)  char * tok;  {    char * p;    int i;                     @    if (!(*tok))  (    return (-1);		/* error if nothing */ (      if (delim != '=')  *    return (-1);		/* error if not size= */ *    >  if ((strcmp(tok, "VOL") == 0) || (strncmp(tok, "MUL", 3))) { >    4    if (_parse(tok, 0) == 0)	/* parse off a token */ 4 8      return (-1);		/* nothing to parse, return error */ 8    &    /* check for valid numbers only */ &     for (p=tok; *p; p++)        if (!isdigit(*p))      	return(-1);     /    /* convert size to binary and put in rrs */ / +    i = atol(tok);		/* get volume number */ +     if (i < 0 || i > 255)  ,      return(-1);		/* number out of range */ , 2    _rrs.wd2 |= (i << 16);	/* put in vol number */ 2 #    return (0);			/* return O.K. */ #   }                                   @  #  return (1);			/* VOL not found */ # }     /* parse buffer */  static int _parse(bufr, pn)  char *	bufr;  0int     pn;			/* set if reparse for parthname */ 0 {  &  char cib;			/* current input byte */ & 6  char sb = 0;			/* zero if skipping leading blanks */ 6 +  int cnt = 0;			/* num of chars in bufr */ +    7  /* set output string to null,to show no output yet */ 7 -  *bufr = '\0';			/* terminate output line */ - 7  if (eol) 			/* at end of line, reset & return null */ 7 #    return (0);			/* return null */ #    3  /* process chars till end of line or max count */ 3 &  while ((cib = *linep++) && mlen--) { &        switch (cib) {           case ' ':			/* a blank */          if (!sb)                                           @  -    	  continue;		/* ignore leading blanks */ - .        /* drop thru if not ignoring blanks */ . ,        goto dond;		/* done with is entry */ ,    /      case '=':			/* equal sign is delimiter */ / *      case ',':			/* comma is delimiter */ * /      case '(':			/* left paren is delimiter */ / 0      case ')':			/* right paren is delimiter */ 0         if (pn)  >    	  goto ignore;		/* if pathname, scan till blank or EOL */ > ,        goto dond;		/* done with is entry */ ,    -      case '\n':		/* new line is delimiter */ - (      case '\r':		/* c/r is delimiter */ ( )      case '\0':		/* null is delimiter */ ) &      case '!':			/* ! is delimiter */ & .        eol = 1;		/* we are at end of input */ .                                            0@  1        goto dond;      	/* done with is entry */ 1          default:  ignore:  3        sb = 1;			/* not skipping blanks anymore */ 3 7        *bufr++ = cib;		/* put char in output buffer */ 7 %        cnt++;			/* bump the count */ % ,        continue;		/* continue processing */ ,     }    }     dond:  5  delim = cib;			/* tell caller what delimiter was */ 5 +  *bufr = '\0';			/* null terminate line */ +   if (!mlen)  :    eol = 1;			/* reset linepointer to read input again */ : )  return (cnt);			/* return what we go */ ) }                                                                                                                                                                                                                 