  @  /* stab.c */  /*  ! * 	(c) Copyright 1986 Gould Inc. !  * 	    All Rights Reserved.   */     /*  " * 	(c) Copyright 1990 J B Systems " 5 *	This file contains non-based support modifications 5 7 *	for operation under MPX.  Derived from Encores' base 7  *	mode C compiler.   */     #ifndef lint  Zstatic char *rcsid = "@(#) (Gould) $Header: stab.c,v 5.5 89/05/12 12:44:54 pcc Rel-3_0 $"; Z #endif     /*  C    C compiler for Gould processors, base register instruction set. C    *    Ported from the 4.1c Berkeley Standard * 3	Distribution source for a VAX portable C compiler. 3 */     /*  % * Symbolic debugging info interface. %  *  > * Here we generate pseudo-ops that cause the assembler to put >                            @  7 * symbolic debugging information into the object file. 7  */     #include "mfile1.h"     "#if defined(mpx) && !defined(i386) " #include <types.h>  #define N_LCSYM 0  #else  #include <sys/types.h>  #endif     #ifndef JCB  #define u370 1  #undef i386  #include <a.out.h>  #define i386  #else  #include <a.out.h>  #include "stab.h"  #endif /* JCB */     
#ifdef MPX 
 static int entertype();  static int inittypes();  static int maketype();  static int gentype();  static int genstruct();  static int geninfo();  static int old_fixarg();  static int old_outstab();  static int old_pstab();  static int old_psdot();  static int old_poffs();  static int old_psline();  static int old_plcstab();      @  static int old_prcstab();  static int old_pfstab();  #endif     #define private static  #define and &&  
#define or || 
 
#define not ! 
 
#define div / 
 
#define mod % 
 
#define nil 0 
    %#define bytes(bits) ((bits) / SZCHAR) % I#define bsize(p) bytes(dimtab[p->sizoff])	/* size in bytes of a symbol */ I    #define NILINDEX -1  #define FORWARD -2     typedef int     Boolean;     #define false 0  #define true 1     #ifndef BUG1  extern int  ddebug;  #endif  extern int  gdebug;  extern char    *malloc();     int         stabLCSYM;     /*  ; * Flag for producing either sdb or dbx symbol information. ;  */  int         oldway = false;     /*  + * Generate debugging info for a parameter. +        @  H * The offset isn't known when it is first entered into the symbol table H " * since the types are read later. "  */     	fixarg(p) 	 struct symtab  *p;  {  #ifndef BUG1      if(ddebug && gdebug) {  	printf("fixarg(%x)\n", p);      }  #endif      if (oldway) {  	old_fixarg(p);      }      else  	if (gdebug) {  ,	    printf("\t.stabs\t\"%s:p", p -> sname); , 	    gentype(p);  %	    printf("\",0x%x,0,%d,%d+LA%d\n", % 2		    N_PSYM, bsize(p), bytes(argoff), ftnno + 1); 2 	}  }     /*  . * Generate debugging info for a given symbol. .  */     outstab(sym)  struct symtab  *sym;  {      register struct symtab *p;      char       *classname;      int         offset;      Boolean     ignore;              @  %    static Boolean  firsttime = true; %    #ifndef BUG1      if(ddebug && gdebug) {  	printf("outstab(%x)\n", sym);      }  #endif      if (oldway) {  	old_outstab(sym);      }      else  	if (gdebug) {  	    if (firsttime) {  		firsttime = false;  		inittypes();  	    }  	    ignore = false;  
	    p = sym; 
 !	    offset = bytes(p -> offset); ! 	    switch (p -> sclass) {  		case REGISTER:   		    classname = "r";  		    offset = p -> offset;  		    break;     	    /*   %	     * Locals are the default class. % 	     */  
		case AUTO:  
 		    classname = "";  		    break;     		case STATIC:   		    if (ISFTN(p -> stype)) {  			ignore = true;  		    }  
		    else 
                         @  			if (p -> slevel <= 1) {  			    classname = "S";  			}  				else { 	 			    classname = "V";  			}  		    break;     		case EXTDEF:   		case EXTERN:   		    if (ISFTN(p -> stype)) {  			ignore = true;  		    }  		    else {  			classname = "G";  		    }  		    break;     		case TYPEDEF:   		    classname = "t";  		    break;     		case PARAM:   		case MOS:   		case MOU:   		case MOE:   		    ignore = true;  		    break;     		case ENAME:   		case UNAME:   		case STNAME:   H		    entertype(p -> stype, NILINDEX, FORWARD, dimtab[p -> sizoff + 3]); H 		    ignore = true;  		    break;     		default:   '		    if ((p -> sclass & FIELD) == 0) { '                                           @  @			printf("-- no info for %s (%d) \n", p -> sname, p -> sclass); @ 		    }  		    ignore = true;  		    break;  	    }  	    if (not ignore) {  5		printf("\t.stabs\t\"%s:%s", p -> sname, classname); 5 
		gentype(p); 
 
		geninfo(p); 
 	    }  	}  }     /*  = * Since type names are lost in the travels and because C has = A * structural type equivalence we keep a table of type words that A D * we've already seen.  The first time we see a type, it is assigned D A * (inline) a number and future references just list that number. A B * Structures, unions, enums, and arrays must be handled carefully B ? * since not all the necessary information is in the type word. ?  */     typedef struct Typeid  *Typeid;                          @  struct      Typeid  {      TWORD       tword;      int         tarray;      int         tstruct;      int         tstrtag;      int         tnum;      Typeid      chain;  };     #define TABLESIZE 2003     private int     tcount = 1;  private int     t_int, t_char;  %private Typeid  typetable[TABLESIZE]; %    /*  2 * Look for the given type word in the type table. 2  */     ;private Typeid typelookup(type, arrindex, strindex, strtag) ; TWORD       type;  int         arrindex;  int         strindex;  int         strtag;  {      register TWORD  tword;      register int    i1, i2;      Typeid      t;     #ifndef BUG1      if(ddebug && gdebug) {                                                         @  C	printf("typelookup(0x%x, %d, %d, %d)\n", type, arrindex, strindex, C 
		strtag); 
     }  #endif  &    t = typetable[type mod TABLESIZE]; &     while (t != nil) {  	if (t -> tword == type and  8		strindex == t -> tstruct and strtag == t -> tstrtag) { 8  	    if (arrindex == NILINDEX) {   		break;  	    }  	    else {  #		tword = (unsigned)type >> TSHIFT; # 		i1 = arrindex;  		i2 = t -> tarray;  9		while (ISARY(tword) and     dimtab[i1] == dimtab[i2]) { 9 		    ++i1;  		    ++i2;  (		    tword = (unsigned)tword >> TSHIFT; ( 		}  		if (!ISARY(tword)) {  		    break;  		}  	    }  	}  	t = t -> chain;      }  
    return t; 
 }     /*  G * Enter a type word and associated symtab indices into the type table. G  @   */     7private int entertype(type, arrindex, strindex, strtag) 7 TWORD       type;  int         arrindex;  int         strindex;  int         strtag;  {      register Typeid     t;      register int    i;     #ifndef BUG1      if(ddebug && gdebug) {  B	printf("entertype(0x%x, %d, %d, %d)\n", type, arrindex, strindex, B 
		strtag); 
     }  #endif  /    t = (Typeid) malloc(sizeof(struct Typeid)); /     t -> tword = type;      t -> tarray = arrindex;      t -> tstruct = strindex;      t -> tstrtag = strtag;      t -> tnum = tcount;  
    ++tcount; 
     i = type mod TABLESIZE;      t -> chain = typetable[i];      typetable[i] = t;      return t -> tnum;  }     /*                                        @  = * Change the information associated with a type table entry. = ? * Since I'm lazy this just creates a new entry with the number ?  * as the old one.   */     =private reentertype(typeid, type, arrindex, strindex, strtag) = Typeid      typeid;  TWORD       type;  int         arrindex;  int         strindex;  int         strtag;  {      register Typeid     t;      register int    i;     #ifndef BUG1      if(ddebug && gdebug) {  <	printf("reentertype(%d, 0x%x, %d, %d, %d)\n", typeid, type, < 		arrindex, strindex, strtag);      }  #endif  /    t = (Typeid) malloc(sizeof(struct Typeid)); /     t -> tword = type;      t -> tarray = arrindex;      t -> tstruct = strindex;      t -> tstrtag = strtag;                  @      t -> tnum = typeid -> tnum;      i = type mod TABLESIZE;      t -> chain = typetable[i];      typetable[i] = t;  }     /*  / * Initialize type table with predefined types. /  */     G#define builtintype(type) entertype(type, NILINDEX, NILINDEX, NILINDEX) G    private inittypes()  {      int         t;     #ifndef BUG1      if(ddebug && gdebug) {  	printf("inittypes()\n");      }  #endif      t_int = builtintype(INT);      t_char = builtintype(CHAR);  <    maketype("int", t_int, t_int, 0x80000000L, 0x7fffffffL); < /    maketype("char", t_char, t_char, 0L, 127L); / I    maketype("long", builtintype(LONG), t_int, 0x80000000L, 0x7fffffffL); I                                                                       @  G    maketype("short", builtintype(SHORT), t_int, 0xffff8000L, 0x7fffL); G C    maketype("unsigned char", builtintype(UCHAR), t_int, 0L, 255L); C H    maketype("unsigned short", builtintype(USHORT), t_int, 0L, 0xffffL); H J    maketype("unsigned long", builtintype(ULONG), t_int, 0L, 0xffffffffL); J L    maketype("unsigned int", builtintype(UNSIGNED), t_int, 0L, 0xffffffffL); L 9    maketype("float", builtintype(FLOAT), t_int, 4L, 0L); 9 ;    maketype("double", builtintype(DOUBLE), t_int, 8L, 0L); ;     t = builtintype(UNDEF);  ,    printf("\t.stabs\t\"void:t%d=%d", t, t); ,     geninfo(nil);      t = builtintype(FARG);  /    printf("\t.stabs\t\"???:t%d=%d", t, t_int); /     geninfo(nil);  }     /*                                           @  & * Generate info for a new range type. &  */     2private maketype(name, tnum, eqtnum, lower, upper) 2 char       *name;  int         tnum, eqtnum;  long        lower, upper;  {  #ifndef BUG1      if(ddebug && gdebug) {  	printf("maketype(...):\n");      }  #endif  N    printf("\t.stabs\t\"%s:t%d=r%d;%d;%d;", name, tnum, eqtnum, lower, upper); N     geninfo(nil);  }     /*  I * Generate debugging information for the given type of the given symbol. I  */     private gentype(sym)  struct symtab  *sym;  {      register struct symtab *p;      register TWORD  t;      register TWORD  basictype;      register Typeid     typeid;  .    int         i, arrindex, strindex, strtag; .    #ifndef BUG1               @      if(ddebug && gdebug) {  	printf("gentype(%x)\n", sym);      }  #endif      p = sym;      t = p -> stype;      if (ISFTN(t)) {  	t = DECREF(t);      }      basictype = BTYPE(t);      if (ISARY(t)) {  	arrindex = p -> dimoff;      }  
    else { 
 	arrindex = NILINDEX;      }  L    if (basictype == STRTY or basictype == UNIONTY or basictype == ENUMTY) { L $	strindex = dimtab[p -> sizoff + 1]; $ 	if (strindex == -1) {  	    strindex = FORWARD;  &	    strtag = dimtab[p -> sizoff + 3]; & 	}  	else {  	    strtag = NILINDEX;  	}      }  
    else { 
 	strindex = NILINDEX;  	strtag = NILINDEX;      }      i = arrindex;  7    typeid = typelookup(t, arrindex, strindex, strtag); 7                            @      while (t != basictype ) {  2	printf("%d=", entertype(t, i, strindex, strtag)); 2 	switch (t & TMASK) {  	    case PTR:   		printf("*");  		break;     	    case FTN:   		printf("f");  		break;     	    case ARY:   /		printf("ar%d;0;%d;", t_int, dimtab[i++] - 1); / 		break;  	}  	t = DECREF(t);  	if (t == basictype) {  8	    typeid = typelookup(t, NILINDEX, strindex, strtag); 8 	}  	else {  1	    typeid = typelookup(t, i, strindex, strtag); 1 	}      }      if (typeid == nil) {  	if (strindex == FORWARD) {  H	    typeid = typelookup(t, NILINDEX, FORWARD, dimtab[p -> sizoff + 3]); H 	    if (typeid == nil) {  +		cerror("unbelievable forward reference"); + 	    }  "	    printf("%d", typeid -> tnum); "       @  	}  	else {  <	    genstruct(t, NILINDEX, strindex, p -> sname, bsize(p)); < 	}      }  
    else { 
 	printf("%d", typeid -> tnum);      }  }     /*  F * Generate type information for structures, unions, and enumerations. F  */     1private genstruct(t, structid, index, name, size) 1 TWORD       t;  int         structid;  int         index;  char       *name;  int         size;  {      register int    i;  "    register struct symtab *field; "     int         id;     #ifndef BUG1      if(ddebug && gdebug) {  D	printf("genstruct(0x%x, %d, %d, %x: %s, %d)\n", t, structid, index, D 		name, name, size);      }  #endif      if (structid == NILINDEX) {  .	id = entertype(t, NILINDEX, index, NILINDEX); .      @      }  
    else { 
 	id = structid;      }      switch (t) {  
	case STRTY:  
 	case UNIONTY:   9	    printf("%d=%c%d", id, t == STRTY ? 's' : 'u', size); 9 	    i = index;  	    while (dimtab[i] != -1) {  		field = &stab[dimtab[i]];   		printf("%s:", field -> sname);   		gentype(field);   		if (field -> sclass > FIELD) {   B		    printf(",%d,%d;", field -> offset, field -> sclass - FIELD); B 		}  		else {  (		    printf(",%d,%d;", field -> offset, ( @			    tsize(field -> stype, field -> dimoff, field -> sizoff)); @ 		}  		++i;  	    }  	    putchar(';');  	    break;     	case ENUMTY:   	    printf("%d=e", id);  	    i = index;  	    while (dimtab[i] != -1) {  		field = &stab[dimtab[i]];                    @  4		printf("%s:%d,", field -> sname, field -> offset); 4 		i++;  	    }  	    break;     
	default:  
 ;	    cerror("couldn't find basic type %d for %s", t, name); ; 	    break;      }  }     /*  ! * Generate offset and size info. !  */     private geninfo(p)  register struct symtab *p;  {  #ifndef BUG1      if(ddebug && gdebug) {  	printf("geninfo(%x):\n", p);      }  #endif      if (p == nil) {  #	printf("\",0x%x,0,0,0\n", N_LSYM); #     }  
    else { 
 	switch (p -> sclass) {  	    case EXTERN:   	    case EXTDEF:   		if (ISFTN(p -> stype)) {  @		    printf("\",0x%x,0,%d,_%s\n", N_FUN, bsize(p), p -> sname); @ 		}  		else {  3		    printf("\",0x%x,0,%d,0\n", N_GSYM, bsize(p)); 3 		}             @  		break;     	    case STATIC:   		if (ISFTN(p -> stype)) {  @		    printf("\",0x%x,0,%d,_%s\n", N_FUN, bsize(p), p -> sname); @ 		}  		else  		    if (p -> slevel > 1) {  @			printf("\",0x%x,0,%d,L%d\n", N_STSYM, bsize(p), p -> offset); @ 		    }  		    else {  ?			printf("\",0x%x,0,%d,_%s\n", N_LCSYM, bsize(p), p -> sname); ? 		    }  		break;     	    case REGISTER:   =		printf("\",0x%x,0,%d,%d\n", N_RSYM, bsize(p), p -> offset); = 		break;     	    case PARAM:   "		printf("\",0x%x,0,%d,%d+LA%d\n", " /			N_PSYM, bsize(p), bytes(argoff), ftnno + 1); / 		break;     	    case TYPEDEF:   /		printf("\",0x%x,0,%d,0\n", N_LSYM, bsize(p)); / 		break;     	    case AUTO:  "		printf("\",0x%x,0,%d,%d+%s%d\n", "       @  7			N_LSYM, bsize(p), bytes(p -> offset), "LOC", ftnno); 7 		break;     &	    case STNAME:	/* structure name */ & "	    case UNAME:		/* union name */ " (	    case ENAME:		/* enumeration name */ ( 1		printf("\",0x%x,0,%d,0x0\n", N_SSYM, bsize(p)); 1 		break;     	    /*  C	     * For now complain if we ever try to geninfo for any of these C A	     * storage classes.  We'll fix them as we find it necessary. A 	     */  	    case SNULL:  	    case LABEL:  	    case ULABEL:  )	    case MOS:		/* member of structure */ ) %	    case MOU:		/* member of union */ % 	    case FORTRAN:  +	    case MOE:		/* member of enumeration */ + 	    case UFORTRAN:  	    case USTATIC:  	    default:   		fprintf(stderr,                                @  9			"warning: geninfo for unexpected storage class %d.\n", 9 			(p -> sclass));  #		printf("\",0x%x,0,%d,%d+LOC%d\n", # .			N_LSYM, bsize(p), bytes(p -> offset), ftnno . 		);  		break;  	}      }  }     /*  6 * Generate information for a newly-defined structure. 6  */     outstruct(szindex, paramindex)   int         szindex, paramindex;   {      register Typeid     typeid;      register struct symtab *p;  #    register int    i, t, strindex; #    #ifndef BUG1      if(ddebug && gdebug) {  4	printf("outstruct(%d, %d)\n", szindex, paramindex); 4     }  #endif      if (oldway) {  	 /* do nothing */ ;      }      else  	if (gdebug) {  	    i = dimtab[szindex + 3];  	    p = &stab[i];                        @  	    if (p -> sname != nil) {  %		strindex = dimtab[p -> sizoff + 1]; % 8		typeid = typelookup(p -> stype, NILINDEX, FORWARD, i); 8 		if (typeid == nil) {  		    t = 0;  		}  		else {  		    t = typeid -> tnum;  D		    reentertype(typeid, p -> stype, NILINDEX, strindex, NILINDEX); D 		}  )		printf("\t.stabs\t\"%s:T", p -> sname); ) ;		genstruct(p -> stype, t, strindex, p -> sname, bsize(p)); ; 
		geninfo(p); 
 	    }  	}  }     pstab(name, type)  char       *name;  int         type;  {      register int    i;      register char   c;     #ifndef BUG1      if(gdebug && ddebug) {  *	printf("pstab(%x, 0x%x):\n", name, type); *     }  #endif      if (!gdebug) {  	return;      }      else                    @  	if (oldway) {  	    old_pstab(name, type);  	    return;  	}  ; /* locctr(PROG);  /* .stabs must appear in .text for c2 */ ; #ifdef ASSTRINGS      if (name[0] == '\0')  	printf("\t.stabn\t");      else  #	printf("\t.stabs\t\"%s\",", name); # #else      printf("    .stab   ");      for (i = 0; i < 8; i++)  	if (c = name[i])  	    printf("'%c,", c);  	else  	    printf("0,");  #endif      printf("0x%x,", type);  }     #ifdef STABDOT  pstabdot(type, value)  int         type;  int         value;  {  #ifndef BUG1      if(ddebug && gdebug) {  -	printf("pstabdot(0x%x, %x)\n", type, value); -     }  #endif      if (!gdebug) {  	return;      }      else  	if (oldway) {                            @  	    old_psdot(type, value);  	    return;  	}  ; /* locctr(PROG);  /* .stabs must appear in .text for c2 */ ;     printf("\t.stabd\t");  )    printf("0x%x,0,0x%x\n", type, value); ) }  #endif     extern char     NULLNAME[8];  extern int  labelno;  extern int  fdefflag;     psline()  {      static int  lastlineno;      register char  *cp, *cq;      register int    i;     #ifndef BUG1      if(ddebug && gdebug) {  	printf("psline()\n");      }  #endif      if (!gdebug) {  	return;      }      else  	if (oldway) {  	    old_psline();  	    return;  	}         cq = ititle;      cp = ftitle;         while (*cq)  	if (*cp++ != *cq++)  	    goto neq;      if (*cp == '\0')              @  		goto eq; 	    neq: for (i = 0; i < 100; i++)  	ititle[i] = '\0';      cp = ftitle;      cq = ititle;      while (*cp)  	*cq++ = *cp++;      *cq = '\0';      *--cq = '\0';      pstab(ititle + 1, N_SOL);      if (gdebug)  	printf("0,0,LL%d\n", labelno);      *cq = '"';  !    printf("LL%d:\n", labelno++); !    eq: if (lineno == lastlineno)  	return;      lastlineno = lineno;         if (fdefflag) {  #ifdef STABDOT  	pstabdot(N_SLINE, lineno);  #else  	pstab(NULLNAME, N_SLINE);  (	printf("0,%d,LL%d\n", lineno, labelno); ( 	printf("LL%d:\n", labelno++);  #endif      }  }     plcstab(level)  int         level;  {  #ifndef BUG1      if(ddebug && gdebug) {   	printf("plcstab(%d)\n", level);    @      }  #endif      if (!gdebug) {  	return;      }      else  	if (oldway) {  	    old_plcstab(level);  	    return;  	}  #ifdef STABDOT  ?	/*..... UTX assembler is defective. You might be in data space ? 7		when the { stabd is emitted. Stabd is a misnomer, the 7 9		value of "dot" is supposed to come from the symboltype. 9    		DJK: CSD-Urbana 25 april 95     	*/      locctr(PROG);      pstabdot(N_LBRAC, level);  #else      pstab(NULLNAME, N_LBRAC);  *    printf("0,%d,LL%d\n", level, labelno); * !    printf("LL%d:\n", labelno++); ! #endif  }     prcstab(level)  int         level;  {  #ifndef BUG1      if(ddebug && gdebug) {   	printf("prcstab(%d)\n", level);       }  #endif                       @      if (!gdebug) {  	return;      }      else  	if (oldway) {  	    old_prcstab(level);  	    return;  	}  #ifdef STABDOT      pstabdot(N_RBRAC, level);  #else      pstab(NULLNAME, N_RBRAC);  *    printf("0,%d,LL%d\n", level, labelno); * !    printf("LL%d:\n", labelno++); ! #endif  }     
pfstab(sname) 
 char       *sname;  {      register struct symtab *p;     #ifndef BUG1      if(ddebug && gdebug) {  +	printf("pfstab(%x: %s)\n",  sname, sname); +     }  #endif      if (gdebug) {  	if (oldway) {  	    old_pfstab(sname);  	}  	else {  !	    p = &stab[lookup(sname, 0)]; ! +	    printf("\t.stabs\t\"%s:", p -> sname); + 2	    putchar((p -> sclass == STATIC) ? 'f' : 'F'); 2 	    gentype(p);          @  	    geninfo(p);  	}      }  }     /*   * Old way of doing things.   */     private old_fixarg(p)  struct symtab  *p;  {  #ifndef BUG1      if(ddebug && gdebug) {  	printf("old_fixarg(%x)\n", p);      }  #endif      if (gdebug) {  	old_pstab(p -> sname, N_PSYM);  	if (gdebug)  6	    printf("0,%d,%d\n", p -> stype, argoff / SZCHAR); 6 	old_poffs(p);      }  }     private old_outstab(p)  struct symtab  *p;  {      register TWORD  ptype;      register char  *pname;      register char   pclass;      register int    poffset;     #ifndef BUG1      if(ddebug && gdebug) {   	printf("old_outstab(%x)\n", p);       }  #endif      if (!gdebug)  	return;         ptype = p -> stype;      @      pname = p -> sname;      pclass = p -> sclass;      poffset = p -> offset;         if (ISFTN(ptype)) {  	return;      }         switch (pclass) {     	case AUTO:   	    old_pstab(pname, N_LSYM);  5	    printf("0,%d,%d\n", ptype, (-poffset) / SZCHAR); 5 	    old_poffs(p);  	    return;     	case EXTDEF:   	case EXTERN:   	    old_pstab(pname, N_GSYM);  	    printf("0,%d,0\n", ptype);  	    old_poffs(p);  	    return;     	case STATIC:   #ifdef LCOMM  C    /* stabLCSYM is 1 during nidcl so we can get stab type right */ C 5	    old_pstab(pname, stabLCSYM ? N_LCSYM : N_STSYM); 5 #else  	    old_pstab(pname, N_STSYM);  #endif  	    if (p -> slevel > 1) {  '		printf("0,%d,L%d\n", ptype, poffset); '  @  	    }  	    else {  #ifdef MAY2792  7		printf("0,%d,%s\n", ptype, exname(pname, p->sflags)); 7 #else  /		printf("0,%d,%s\n", ptype, exname(pname, p)); / #endif  	    }  	    old_poffs(p);  	    return;     	case REGISTER:   	    old_pstab(pname, N_RSYM);  )	    printf("0,%d,%d\n", ptype, poffset); ) 	    old_poffs(p);  	    return;     	case MOS:   	case MOU:   	    old_pstab(pname, N_SSYM);  2	    printf("0,%d,%d\n", ptype, poffset / SZCHAR); 2 	    old_poffs(p);  	    return;     
	case PARAM:  
 ;    /* parameter stab entries are processed in dclargs() */ ; 	    return;     
	default:  
 #ifndef BUG1  	    if (ddebug)  &		printf("	No .stab for %s\n", pname); & #endif  	    return;         }    @  }     private old_pstab(name, type)  char       *name;  int         type;  {      register int    i;      register char   c;     #ifndef BUG1      if(ddebug && gdebug) {  7	printf("old_pstab(%x: %s, 0x%x)\n", name, name, type); 7     }  #endif      if (!gdebug)  	return;  ; /* locctr(PROG);  /* .stabs must appear in .text for c2 */ ; #ifdef ASSTRINGS      if (name[0] == '\0')  	printf("\t.stabn\t");      else  $	printf("\t.stabs\t\"%s\", ", name); $ #else      printf("	.stab	");      for (i = 0; i < 8; i++)  	if (c = name[i])  	    printf("'%c,", c);  	else  	    printf("0,");  #endif      printf("0x%x,", type);  }     #ifdef STABDOT  private old_psdot(type, value)  int         type;     @  int         value;  {  #ifndef BUG1      if(ddebug && gdebug) {  0	printf("old_psdot(0x%x, 0x%x)\n", type, value); 0     }  #endif      if (!gdebug)  	return;  ; /* locctr(PROG);  /* .stabs must appear in .text for c2 */ ;     printf("\t.stabd\t");  )    printf("0x%x,0,0x%x\n", type, value); ) }  #endif     private old_poffs(p)  register struct symtab *p;  {      int         s;     #ifndef BUG1      if(ddebug && gdebug) {  	printf("old_poffs(%x)\n", p);      }  #endif      if (!gdebug)  	return;  1    if ((s = dimtab[p -> sizoff] / SZCHAR) > 1) { 1 	old_pstab(p -> sname, N_LENG);  	printf("1,0,%d\n", s);      }  }     private old_psline()  {      static int  lastlineno;                     @      register char  *cp, *cq;      register int    i;     #ifndef BUG1      if(ddebug && gdebug) {  	printf("old_psline()\n");      }  #endif      if (!gdebug)  	return;         cq = ititle;      cp = ftitle;         while (*cq)  	if (*cp++ != *cq++)  	    goto neq;      if (*cp == '\0')  		goto eq; 	    neq: for (i = 0; i < 100; i++)  	ititle[i] = '\0';      cp = ftitle;      cq = ititle;      while (*cp)  	*cq++ = *cp++;      *cq = '\0';      *--cq = '\0';  !    old_pstab(ititle + 1, N_SOL); !     if (gdebug)  	printf("0,0,LL%d\n", labelno);      *cq = '"';  !    printf("LL%d:\n", labelno++); !    eq: if (lineno == lastlineno)  	return;      lastlineno = lineno;                      @      if (fdefflag) {  #ifdef STABDOT  	old_psdot(N_SLINE, lineno);  #else  	old_pstab(NULLNAME, N_SLINE);  (	printf("0,%d,LL%d\n", lineno, labelno); ( 	printf("LL%d:\n", labelno++);  #endif      }  }     private old_plcstab(level)  {  #ifndef BUG1      if(ddebug && gdebug) {  $	printf("old_plcstab(%d)\n", level); $     }  #endif      if (!gdebug)  	return;  #ifdef STABDOT      old_psdot(N_LBRAC, level);  #else  !    old_pstab(NULLNAME, N_LBRAC); ! *    printf("0,%d,LL%d\n", level, labelno); * !    printf("LL%d:\n", labelno++); ! #endif  }     private old_prcstab(level)  {  #ifndef BUG1      if(ddebug && gdebug) {  $	printf("old_prcstab(%d)\n", level); $     }  #endif      if (!gdebug)         G@  	return;  #ifdef STABDOT      pstabdot(N_RBRAC, level);  #else      pstab(NULLNAME, N_RBRAC);  *    printf("0,%d,LL%d\n", level, labelno); * !    printf("LL%d:\n", labelno++); ! #endif  }     private old_pfstab(sname)  char       *sname;  {  #ifndef BUG1      if(ddebug && gdebug) {  .	printf("old_pfstab(%x: %s)\n", sname, sname); .     }  #endif      if (!gdebug)  	return;      pstab(sname, N_FUN);  (    printf("0,%d,_%s\n", lineno, sname); ( }     /*  ! * 	(c) Copyright 1986 Gould Inc. !  * 	    All Rights Reserved.   */                                                                                                                                                                                          