/*~!getpid.c*/
/* Name:  getpid.c Part No.: _______-____r
 *
 * Copyright 1995 - J B Systems, Morrison, CO
 *
 * The recipient of this product specifically agrees not to distribute,
 * disclose, or disseminate in any way, to any one, nor use for its own
 * benefit, or the benefit of others, any information contained  herein
 * without the expressed written consent of J B Systems.
 *
 *                     RESTRICTED RIGHTS LEGEND
 *
 * Use, duplication, or disclosure by the Government is  subject  to
 * restriction  as  set forth in paragraph (b) (3) (B) of the Rights
 * in Technical Data and Computer Software  Clause  in  DAR  7-104.9
 * (a).
 */

#ident	"$Id: getpid.c,v 1.1 1995/03/08 00:43:40 jbev Exp $"

/* $Log: getpid.c,v $
 * Revision 1.1  1995/03/08  00:43:40  jbev
 * Initial revision
 *
 */

#include <tsa.h>

getpid()    /* get program number*/
{
	int data[12];
	int reg[8];

	reg[5] = 0x80000000;
	reg[7] = (int)data;
	mpxsvc(0x1064,reg,reg);		/* m.myid */
	return (data[0]);		/*return task number */
}

getpgrp()	/* get process group */
{
	return (0);	/* return root process group */
}

getppid()    /* get parent process id */
{
	int reg[8];
	struct tsa *tsap;

	mpxsvc(0x207d,reg,reg);		/* m.gtsad */
	tsap = (struct tsa *)reg[1];	/* get tsa address */
	return (tsap->parent);		/* return parent task number */
}

