#ifdef NODUMP
/*
 * 'DBDSTART' HOLDS STARTING LOCATION AND IS INCREMENTED
 * UP TO THE VALUE IN 'DBDEND' FOR ALL DUMPS/SNAPS,ETC...
 */
DBDISP1  EQU       $
         STW       R2,DBDSTART     NEXT OR FIRST LOC TO DUMP
         BL        DII             DISPLAY INITIALIZE
         ZR        R2              ASSUME REGS
         TBM       7,FLAG
         BS        DBDISP2         IF DISPLAYIN REGS
         LA        R1,DBDSTART     ADDRESS OF CELL CONTAINING LOC
         LI        R2,1            PRINT LINE INDEX
         BL        SYMBOL
DBDISP2  EQU       $
*
*        INIT THE LINE LOOP - SETUP POINTERS FOR THIS LINE
*
         LW        R4,LINSIZ
         LI        R3,48           ASCII START COLUMN #
         TBM       4,FLAG          WRITING LP ?
         BS        DBDISP3         NO
*
*        CHANGE FOR LP OUTPUT
*
         LI        R4,-8           8 WIDE ON LP
         LI        R3,84           ASCII STARTING COLUMN
DBDISP3  EQU       $
         LI        R0,G'*'
         STB       R0,DBUFF-1,R3
         STW       R3,ASTOP        REMEMBER ASCII COLUMN # START
*
         LA        R3,DBUFF       NEW BUF LOC
         ADI       R3,1           PLUS 1 BYTE
         CI        R2,6            AT MIN LINE START
         BGT       $+2W            NO
         LI        R2,6            FORCE MINIMUM THEN
         ADR       R2,R3           POINT TO ENDING LOC
         STW       R3,DBP          SAVED
         LW        R2,DBDSTART     CURRENT DISPLAY LOCATON
DBDISP4  EQU       $
         STW       R2,DBDSTART     REMEMBER IT FOR ITERATION LATER
	lw r3,0w,x2		get word bounded instruction
         BL        BPCHK           CHK FOR BREAKPOINT LOC
         STW       R3,TEMP         INTERNAL REFERABLE TEMP
         BL        BINAH           CONVERT IT TO ASCII HEX
         STD       R6,DBOUTREG     PLANT IT FOR MOVE
         LA        R1,DBTCPB3
         BL        DIC             MOVE TI TO PRINT BUFFER
*        PUT OUT PRINTABLE ASCII
         LI        R1,0
         LW        R3,ASTOP        CURRENT COLUMN #
ASCII0   EQU       $
         LB        R7,TEMP,R1      GET A BYTE
         CI        R7,X'20'        PRINTABLE
         BLT       ASCII1          NOPE
         CI        R7,X'7F'        HI SIDE PRINTABLE ?
*!       BGT       ASCII1          NOPE                         S8600143
         BGE       ASCII1          '7F' NON-PRINTABLE CHAR.     S8600143
         BU        $+2W            IT IS PRINTABLE = MERGE
ASCII1   LI        R7,G'.'         FOR NON PRINTABLE CHARS
         STB       R7,DBUFF,R3     TO PRINT BUFFER
         ADI       R3,1
         ADI       R1,1
         CI        R1,4            DONE WITH THIS WORD ?
         BLT       ASCII0          NOT YET
         STW       R3,ASTOP        REMEMBER CURRENT COLUMN #
         LW        R2,DBDSTART     GET CURRENT LOC
         ADI       R2,1W           NEXT WORD TO DUMP
         CAMW      R2,DBDEND       DONE YET ?
         BGT       $+2W            YES
         BIB       R4,DBDISP4      FINISH THIS LINE THEN
         LW        R3,ASTOP        GET ASCII COLUMN # CURRENTLY
         LI        R0,G'*'
         STB       R0,DBUFF,R3
         BL        DIT             PRINT THIS LINE NOW
         LW        R2,DBDSTART     GET CURRENT LOCATION WE'RE AT
         ADI       R2,1W           NEXT WORD OF NEXT LINE
         CAMW      R2,DBDEND       COMPLETELY DONE WITH DUMP ?
         BLT       DBDISP1         NOT YET
*
*        DUMP FINISHED
*
         ZBM       7,FLAG          NOT REG DUMP
         BU        *DISMX          RETURN
DISMX    DATAW     0
ASTOP    DATAW     0
*
*        BINARY TO ASCII ROUTINE
*
BINAH    EQU       $
         LI        R1,-8
         ZR        R7
BAH001   EQU       $
         ZR        R2
         SLLD      R2,4
         SLLD      R6,8
         ORMB      R7,BAH004,R2
         BIB       R1,BAH001
         TRSW      R0
#endif NODUMP

/*
 * initialize print buffer
 */
char dobuf[134];		/* the data buffer */
chat *dbp;			/* data buffer pointer */

void init_print()		/* initialize print buffer */
{
dii:
	memset(dbuf, ' ', 133);	/* blank buffer */
	dbp = dbuf;		/* start at beginning */
}

/*
 * Dump symbolically without executing it
 */

/*
 * Instruction trace routine
 * psw - current execution address
 */

int addr;			/* current address */
int userloc;			/* current address */
int tr_stop;			/* last loc to trace */
unsigned opcode;		/* the instruction opcode */
unsigned int opcode;		/* 6 bit opcode << 2 */
unsigned int aug;		/* any augmend */
unsigned int pflags;		/* calm flags */
#define immed pflags		/* immed value */
#define tdcd pflags		/* cd/td value */
#define prot pflags		/* prot reg value */
unsigned int opadr;		/* operand address */
unsigned int rd;		/* dest reg */
unsigned int rs;		/* source reg */
unsigned int shift;		/* shift value */
#define bit shift		/* bit values */
#define condit shift		/* condition codes */
unsigned int plevel;		/* prority level */
unsigned int indir;		/* indirect value */
unsigned int indflg;		/* indirect flag */
unsigned int index;		/* index reg num */
unsigned int idflags;		/* instruction processing flags */
int	insx;			/* store index value */
int	reax;			/* store index value for regs */

void trace(psw)
{
	unsigned int tmpa;	/* a temp */
	int length;		/* instruction length */
	unsigned int *insptr;	/* wd bounded instruction ptr */
	unsigned int instr;	/* the instruction */

	init_print();		/* initialize print buffer */
	adrs = userloc = psw & 0xfffffe;	/* 16mb addr */
	if (adrs > tr_stop)		/* see if at last address */
		return;			/* return, done */
	symbol(adrs, 1);		/* check for hatching base addr */
	tmpa = addr & ~3;		/* word bound addr */
	psw += 2;			/* incr to next hw boundry */
	insptr = (int *)tmpa;		/* get instr wd addr */
	instr = tmpa = *insptr;		/* get 32 bits of instruction */
	if (addr & 2) {			/* is instr in rt hw boundry */
		/* yes, process rt halfword opcode */
		tmpa = ((tmpa << 16) | 2);	/* move instr to lf hw and */
					/* put nop in rt hw */
		psw |= 0x02000000;	/* set rt hw instr in psw */
		if (tmpa & 0x80000000)	/* is it really a hw instr? */
			goto undef;	/* no, cannot decode */
		length = 2;		/* got 2 byte instr */
	} else {			/* must be fw instruction */
		/* process fullword instructions */
		tmpa = ((tmpa >> 26) << 2);	/* isolate opcode */
		/* opcodes 50, 54, 58, and 5c are fw instructions */
		/* so is 34 (la instr) */
		/* bit 0 on means fw instr */
		/* if rt hw is nop, treat as fw instr */
		if ((tmpa & 0xf0) == 0x50 || 
		    tmpa == 0x34 || instr & 0x80000000 ||
		    (instr & 0xffff) == 2)) {
			/* we have word alligned instruction */
			psw += 2;	/* incr to next hw boundry */
			length = 4;	/* got 4 byte instr */
		} else {		/* lhw instruction */
			/* we have hw instr in left hw */
			length = 2;	/* got 2 byte instr */
		}
	}
	lasinc = curinc;		/* save last instr length */
	curinc = length;		/* save current length */
	aug = 0;			/* clear aug */
	opcode = ((instr >> 26) << 2);	/* isolate opcode */
	
	switch (opcode) {		/* service opcode */
	case 0x48:
	case 0x4c:
	case 0x50:
		goto undef;		/* undefined */
	case 0x34:
	case 0x58:
	case 0x80:
	case 0xcc:
	case 0xd0:
	case 0xdc:
		goto bust1;
	case 0x00:
	case 0x04:
	case 0x08:
	case 0x0c:
	case 0x10:
	case 0x14:
	case 0x28:
	case 0x2c:
	case 0x38:
	case 0x3c:
	case 0x40:
	case 0x44:
	case 0x60:
	case 0x64:
	case 0x68:
		goto bust2;
	case 0x18:
	case 0x1c:
	case 0x20:
	case 0x24:
		goto bust3;
	case 0x30:
		goto bust4;
	case 0x6c:
	case 0x70:
	case 0x74:
	case 0x78:
	case 0x7c:
		goto bust5;
	case 0x54:
	case 0x5c:
	case 0x84:
	case 0x88:
	case 0x8c:
	case 0x90:
	case 0x94:
	case 0xac:
	case 0xb0:
	case 0xb4:
	case 0xb8:
	case 0xbc:
	case 0xc0:
	case 0xc4:
	case 0xd4:
	case 0xd8:
	case 0xe8:
		goto bust6;
	case 0x98:
	case 0x9c:
	case 0xa0:
	case 0xa4:
		goto bust7;
	case 0xc8:
		goto bust8;
	case 0xe0:
	case 0xe4:
		goto bust9;
	case 0xec:
	case 0xf0:
		goto bust10;
	case 0xa8:
	case 0xf8:
		goto bust11;
	case 0xf4:
		goto bust12;
	case 0xfc:
		goto bust13;
	}
/*
 ***********************************************************************
 *                                                                     *
 *                 BUST ROUTINES                                       *
 *                                                                     *
 ***********************************************************************
 *       These routines isolate and store the data from the user's
 *       instruction, according to the instruction format.
 */

/*
 *                  Undefined instruction processor.
 */
undef:
	op = 0xff;			/* force opcode/aug to undefined */
	aug = 0xff;			/* force opcode/aug to undefined */
	goto bufload;			/* publish */
/*
 *       Instructions lf , stf , lea , la
 *
 *  Instructions:  Non-Base (34,80,cc,d0,dc,58)  These are the
 *                     opcodes for la,stf,lea,lf,stfbr,lfbr,lcra
 */

bust1:
	tmpa = (instr >> 16) & 0xfc08;	/* shift for opcd & aug */
	if (tmpa == 0xcc08 ||		/* lfbr */
	    tmpa == 0xdc08) {		/* stfbr */
		instr &= ~0x02000000;	/* clear aug bit */
		aug = tmpa & 0xff;	/* save stfbr aug code */
	}
	rd = (instr >> 23) & 7;		/* save reg number b6-b8 */
	index = (instr >> 21) & 3;	/* save index reg number b9-b10 */
	indir = (instr >> 20) & 1;	/* save indir bit b11 */
	opaddr = instr & 0xfffff;	/* save operand addr b12-b31 */
	goto bufload;			/* publish */
/*
 *        For op-codes=00,04,08,0c,10,14,28,2c,38,3c,40,44,60,64,68
 */
bust2:
	rd = (instr >> 23) & 7;		/* save reg number b6-b8 */
	rs = (instr >> 20) & 7;		/* save reg number b9-b11 */
	aug = (instr >> 16) & 0xf;	/* save aug code b12-b15 */
	if (opcode == 0x0c && aug == 0) {	/* is it eor */
		/* yes, see if rs == rd, if yes zr instruction */
		if (rs == rd)		/* test for zr instr */
			aug |= 0x10;	/* setup for zr */
		goto bufload;		/* publish */
	} else if (opcode == 0x68 && aug == 0) {/* see if scz instr */
		/* yes, swap rs & rd */
		tempa = rd;		/* get dest reg */
		rd =rs;			/* swap rs/rd */
		rs = tempa;		/* set src reg */
	}
	goto bufload;			/* publish */
/*
 *        For instructions=sbr,zbr,abr,tbr
 */
bust3:
	bit = (instr >> 23) & 7;	/* save bit number b6-b8 */
	rd = (instr >> 20) & 7;		/* save dest reg number b9-b11 */
	tempa = (instr >> 16) & 3;	/* get byte field b14-b15 */
	bit += tempa << 3;		/* add to bit field */
	goto bufload;			/* publish */
/*
 *        For instructions=calm
 */
bust4:
	pflags = (instr >> 16) & 0x3ff;	/* get calm num b6-b15 */
	goto bufload;			/* publish */
/*
 *       For op-codes=6c,70,74,78,7c (shifts)
 */
bust5:
	rd = (instr >> 23) & 7;		/* save dest reg number b6-b8 */
	aug = (instr >> 22) & 1;	/* save aug code b9 */
	shift = (instr >> 16) & 0x1f;	/* save shift val b11-b15 */
	goto bufload;			/* publish */
/*
 *        For op-codes=84,88,8c,90,94,ac,b0,b4,b8,bc,c0,c4,d4,d8,e8,54,5c
 */
bust6:
	rd = (instr >> 23) & 7;		/* save dest reg number b6-b8 */
	index = (instr >> 21) & 3;	/* save index reg number b9-b10 */
	indir = (instr >> 20) & 1;	/* save indir bit b11 */
	opaddr = instr & 0xfffff;	/* save operand addr b12-b31 */
	aug = augmr(opaddr);		/* mem ref type using f & c bits */
	goto bufload;			/* publish */
/*
 *       For instructions=sbm,zbm,abm,tbm,exm
 */
bust7:
	bit = (instr >> 23) & 7;	/* save bit number b6-b8 */
	index = (instr >> 21) & 3;	/* save index reg number b9-b10 */
	indir = (instr >> 20) & 1;	/* save indir bit b11 */
	opaddr = instr & 0xfffff;	/* save operand addr b12-b31 */
	goto bufload;			/* publish */
/*
 *        For instructions=li,adi,sui,mpi,dvi,ci,exr,exrr
 *                  also the svc and tc instruction
 */
bust8:
	rd = (instr >> 23) & 7;		/* save dest reg number b6-b8 */
	rs = (instr >> 20) & 7;		/* save reg number b9-b11 */
	aug = (instr >> 16) & 0xf;	/* save aug code b12-b15 */
	if (aug == 7) {			/* exr or exrr */
		/* yes, see if exr or exrr */
		if (instr & 2) {	/* exrr? */
			aug |= 0x10;	/* show as exrr */
		}
		goto bufload;		/* publish */
	}
	if ((instr >> 16) & 0xffff) == 0xc806) {	/* see if SVC */
		/* yes, get svc type # */
		index = (instr >> 16) & 0xf;	/* save svc type # b16-b19 */
		immed = (instr & 0xfff);	/* save svc # */
		goto bufload;			/* publish */
	}
	/* immed op, sign extend immed value */
	immed = instr & 0xffff);		/* 16 bit value */
	if (instr & 0x8000)			/* negative? */
		immed |= 0xffff0000;		/* sign extend */
	goto bufload;				/* publish */
/*
 *        For instructions=sufw,sufd,adfw,adfd,dvfw,dvfd,mpfw,mpfd
 */
bust9:
	rd = (instr >> 23) & 7;		/* save dest reg number b6-b8 */
	index = (instr >> 21) & 3;	/* save index reg number b9-b10 */
	indir = (instr >> 20) & 1;	/* save indir bit b11 */
	aug = (instr >> 19) & 1;	/* save float pt aug bit b12 */
	aug <<= 4;			/* position for later */
	opaddr = instr & 0x7ffff;	/* save operand addr b13-b31 */
	aug += augmr(opaddr);		/* mem ref type using c bits */
					/* add to aug */
	goto bufload;			/* publish */
/*
 *        For instructions=bu,bct,bft,bcf
 *                  and special codes bs,bgt,blt,beq,bge,ble,bany
 *                  bns,bnp,bnn,bne,baz
 */
bust10:
	condit = (instr >> 23) & 7;	/* save cond codes b6-b8 */
	aug = condit == 0 ? 0 : 1;	/* if cond = 0, aug = 0, else 1 */
	index = (instr >> 21) & 3;	/* save index reg number b9-b10 */
	indir = (instr >> 20) & 1;	/* save indir bit b11 */
					/* clear bit 31, assm error */
	opaddr = instr & 0xffffe;	/* save branch addr b12-b31 */
	goto bufload;			/* publish */
/*
 *        For instructions=bl,bri,trp,tpr,zmb,zmh,zmw,zmd
 */
bust10:
	indflg = 0;				/* clear indirect flag */
	aug = (instr >> 23) & 7;		/* save init aug code b6-b8 */
	if (aug == 4) {				/* check for jwcs instr */
		/* yes, special case */
		index = (instr >> 21) & 3;	/* save index reg b9-b10 */
		indir = (instr >> 20) & 1;	/* save indir bit b11 */
		if (indir)			/* if indirect, set flag */
			indflg = 1;		/* set indirect flag */
		prot = instr & 0xffff;		/* save addr b16-b31 */
		goto bufload;			/* publish */
	} else if ((aug == 5) ||		/* check for lpsdcm instr */
	   (instr & 0x02000000) == 0) {		/* or no bit 0 of aug */
		/* yes, special case */
		rd = 0;				/* no dest reg */
		index = (instr >> 21) & 3;	/* save index reg b9-b10 */
		indir = (instr >> 20) & 1;	/* save indir bit b11 */
		opaddr = instr & 0xfffff;	/* save op addr b12-b31 */
		tmpa = opaddr;			/* save for zmx instr */
		opaddr &= 0xffffe;		/* clear bit 31, assm err */
		if (aug == 0) {			/* zmx instr? */
			opaddr = tmpa;		/* restore op addr with goof */
			aug = augmr(opaddr);	/* mem ref type using c bits */
			aug <<= 4;		/* position for later */
		}
		goto bufload;			/* publish */
	} else {				/* trp instr */
		prot = (instr >> 19) & 0xf;	/* save prot reg b9-b12 */
		rd = (instr >> 16) & 7;		/* save dest reg num b13-b15 */
		goto bufload;			/* publish */
	}
/*
 *        For instructions=bib,bih,biw,bid
 */
bust12:
	rd = (instr >> 23) & 7;		/* save dest reg b6-b8 */
	aug = (instr >> 21) & 3;	/* save aug b9-b10 */
	indir = (instr >> 20) & 1;	/* save indir bit b11 */
	opaddr = instr & 0xffffe;	/* save op addr b12-b31 */
					/* without assm goof */
	index = 0;			/* no xr */
	goto bufload;			/* publish */
/*
 *        For instructions=ei,di,ri,ai,dai,td,cd,xio
 */
bust13:
	plevel = (instr >> 19) & 0x3f;	/* save pri level b6-b12 */
	index = (instr >> 23) & 7;	/* save reg for xio b6-b8 */
	bit = (instr >> 19) & 0xf;	/* save type for xio b9-b12 */
	aug = (instr >> 16) & 7;	/* save aug for xio b13-b15 */
	if (aug == 7)			/* xio if aug == 7 */
		aug += bit;		/* combine for aug 9 - 16 */
	tdcd = instr & 0xffff;		/* save cd td info b16-b31 */
	goto bufload;			/* publish */
}

/*
 * bufload
 * Loads the do buffer with all information concerning the
 * current instruction.
 */
bufload:
	mnemout();		/* load mnemonic and idflags */
	insx = 18;		/* buffer index for regs */
	reax = 81;		/* error index */
	if (idflags & 0x8000)	/* rs or just r? */
		rsout();	/* output rs */
	if (idflags & 0x4000)	/* rd or just r? */
		rdout();	/* output rd */
	if (idflags & 0x2000)	/* dbl reg or just r? */
		rdout();	/* output dbl reg */
	if ((opcode >> 8) == 0xfc)	/* is it I/O instr? */
		goto bufx;	/* no, process others */
	if (aug < 0x07)		/* is this an xio instruction */
		goto bufxx;	/* yes, skip ahead */
	if (index == 0)		/* index defined? */
		goto bufxx;	/* no, skip ahead */
	dobuf[insx++] = 'R';	/* we have a reg, put in output */
	dobuf[insx++] = index + '0';	/* put in reg number */
	dobuf[insx++] = ',';	/* put in seperator */
	goto bufxx;		/* ignore cc's for now */
	/* Not I/O */
bufx:
	if (idflags & 0x10)	/* is this branch instr */
		goto bufxx;	/* skip cc's if yes */
	if (idflags & 0x1000)	/* bit, condition or shift field */
		bcsout();	/* yes, go output */
bufxx:
	if (idflags & 0x0800);	/* pri lev or dev addr? */
		pdout();	/* yes, go output */
	if (idflags & 0x0400) {	/* prog flags, immed op, cd/td code? */
		if (indflg) {	/* indirect? */
			if (indir)	/* got indirect */
				dobuf[insx++] = '*';	/* insert indir ind */
			indir = 0;	/* clear flag */
		}
		pictout();	/* output immed ops, cd/td */
	}
	if (idflags & 0x0200)	/* indirect indicator used? */
		if (indir)	/* got indirect */
			dobuf[insx++] = '*';	/* insert indir ind */
	if (idflags & 0x0100)	/* effective addr? */
		eaout();	/* output effective addr */
	if (idflags & 0x0100)	/* index reg? */
		xout();		/* output index reg */
	insx = 0;		/* clear instr store index */
	reax = 42;		/* init result reg/ea store index */
bload:
	if (idflags & 0x0008)	/* rs or ra going out? */
		rsout();	/* yes, output it */
	if (idflags & 0x0004)	/* rd or r going out? */
		rdout();	/* yes, output it */
	if (idflags & 0x0002)	/* dbl reg rd or r going out? */
		rdout();	/* yes, output it */
	if (idflags & 0x0001)	/* effective addr? */
		eaout();	/* yes, output it */
	if (idflags & 0x1000)	/* cc's to go? */
		ccout();	/* yes, output it */
	userloc = psw & 0xfffffe;	/* clean psw */
	dowrite();		/* print the line */
	goto tce;		/* go do next instr */
}

/*
 *        Check for bct/bcf type branches
 */
void mneb()			/* br type processing */
{
	if (opcode == 0xec) {	/* is op bct */
		switch (condit & 7) {	/* what type */
		case 0:			/* bu */
			break;		/* nothing to do */
		case 1:			/* bs */
			strcpy(&dobuf[10], "BS  ");
			break;		/* done */
		case 2:			/* bgt */
			strcpy(&dobuf[10], "BGT ");
			break;		/* done */
		case 3:			/* blt */
			strcpy(&dobuf[10], "BLT ");
			break;		/* done */
		case 4:			/* beq */
			strcpy(&dobuf[10], "BEQ ");
			break;		/* done */
		case 5:			/* bge */
			strcpy(&dobuf[10], "BGE ");
			break;		/* done */
		case 6:			/* ble */
			strcpy(&dobuf[10], "BLE ");
			break;		/* done */
		case 7:			/* bany */
			strcpy(&dobuf[10], "BANY");
			break;		/* done */
		}
		return;			/* done */
	}
	if (opcode == 0xf0) {		/* is op bcf */
		switch (condit & 7) {	/* what type */
		case 0:			/* bcf */
			break;		/* nothing to do */
		case 1:			/* bns */
			strcpy(&dobuf[10], "BNS ");
			break;		/* done */
		case 2:			/* bnp */
			strcpy(&dobuf[10], "BNP ");
			break;		/* done */
		case 3:			/* bnn */
			strcpy(&dobuf[10], "BNN ");
			break;		/* done */
		case 4:			/* bne */
			strcpy(&dobuf[10], "BNE ");
			break;		/* done */
		case 5:			/* xxxx */
			break;		/* nothing to do */
		case 6:			/* xxxx */
			break;		/* nothing to do */
		case 7:			/* baz */
			strcpy(&dobuf[10], "BAZ ");
			break;		/* done */
		}
		return;			/* done */
	}
	return;				/* done */
}
		
/*
 * Loads the do buffer with the appropriate instr mnemonic.
 */
void mnemout()			/* output opcode mnemonic */
{
	struct itbl *itp;	/* pointer to instruction table */

	itp = itable;		/* table start */
	while (itp->mnem && *itp->mnem) {	/* while entries */
		/* match opcode and aug */
		if (opcode == itp->op &&
		    aug == itp->aug) {		/* we have a match */
			strcpy(&dobuf[10], itp->mnem);	/* copy mnemonic */
			idflags = itp->flags;	/* set bust flags */
			if (idflags & 0x0010)	/* branch instr */
				mneb();		/* yes, adj mnemonic */
			return;			/* done */
		}
		itp++;			/* next entry */
	}
	/* not found, show undefined */
	strcpy(&dobuf[10], "*UND");	/* undefined instruction */
	idflags = 0x0060;		/* set bust flags */
	return;				/* done */
}
		
/*
 * rsout - output source reg
 */
void rsout()			/* display reg */
{
	if (!insx)			/* displaying */
		return;			/* no, exit */
	dobuf[insx++] = 'R';		/* reg type */
	dobuf[insx++] = rs + '0';	/* reg number */
/*
 *        If register followed by effective memory address
 *        or another value - put in a comma
 */
	if (idflags & 0x1500)		/* ea, immed val, or val */
		dobuf[insx++] = ',';	/* insert comma */
}

/*
 * rdout - output dest reg
 */
void rdout()			/* display reg */
{
	if (!insx)			/* displaying */
		return;			/* no, exit */
	if (idflags & 0x8000)		/* did rs reg go 1st */
		dobuf[insx++] = ',';	/* insert comma */
	dobuf[insx++] = 'R';		/* reg type */
	dobuf[insx++] = rd + '0';	/* reg number */
	/*
	 * If register followed by effective memory address
	 * or another value - put in a comma
	 */
	if (idflags & 0x1500)		/* ea, immed val, or val */
		dobuf[insx++] = ',';	/* insert comma */
}

/*
 * Outputs the bit, condition, or shift field to the do buffer.
 */
void bcsout()
{
	char tb[32];			/* temp buffer */

	sprintf(tb, "%x", bit & 0xff);	/* bin to hex */
	strcpy(&dobuf[insx], tb);	/* copy data */
	insx += strlen(tb);		/* new position */
	if (idflags & 0x0100)		/* got efa to go out */
		dobuf[insx++] = ',';	/* insert comma */
}

/*
 * Outputs priority level or device address in do buffer.
 */
void bcsout()
{
	char tb[32];			/* temp buffer */

	dobuf[insx++] = 'X';		/* insert X */
	dobuf[insx++] = '\'';		/* insert ' */
	sprintf(tb, "%x", plevel & 0xff);	/* bin to hex */
	strcpy(&dobuf[insx], tb);	/* copy data */
	insx += strlen(tb);		/* new position */
	dobuf[insx++] = '\'';		/* insert ' */
	if (idflags & 0x0400)		/* got immed val to go out */
		dobuf[insx++] = ',';	/* insert comma */
}

/*
 * Outputs program flags, immediate operand, cd code,
 * td code or protect register num to the do buffer.
 */
void pictout()
{
	char tb[32];			/* temp buffer */

	dobuf[insx++] = 'X';		/* insert X */
	dobuf[insx++] = '\'';		/* insert ' */
	sprintf(tb, "%x", plevel & 0xffff);	/* bin to hex */
	strcpy(&dobuf[insx], tb);	/* copy data */
	insx += strlen(tb);		/* new position */
	dobuf[insx++] = '\'';		/* insert ' */
}

/*
 * Outputs the effective address and value at the
 * effective address to the do buffer.
 */
void eaout()
{
	char tb[32];			/* temp buffer */

	adrs = opaddr & 0x7ffff;	/* mask the address */
	if (insx) {			/* addr to go out */
#ifdef LATER
		symbol(adrs);		/* output address */
#endif
		dobuf[insx++] = 'X';		/* insert X */
		dobuf[insx++] = '\'';		/* insert ' */
		sprintf(tb, "%x", adrs & 0xffffffff);	/* bin to hex */
		strcpy(&dobuf[insx], tb);	/* copy data */
		insx += strlen(tb);		/* new position */
		dobuf[insx++] = '\'';		/* insert ' */
	}
}

#ifdef LATER
/*
 * Check if input value has an associated base character
 * if so - shove character into print line
 * if not - put out hex value into print line
 */
void symbol(unsigned int addr)
{
         BOUND     1W
SYMBOL   EQU       $
         STF       R0,SYMSAV       PUT EM DOWN FOR A SECOND
         STW       R2,SYMBX        SAVE PASSED INDEX
         TBM       18,FLAG         GOT ABS DUMP MODE ?
         BNS       SYMBOL3         YES-> SHOW AS ABSOLUTE
         ZMW       SYMTMP1         ZIP FLAG
*        LW        R4,=X'1000000'                       3201    E3G1635A
         LW        R4,=X'10000000' GET VALUE GREATER THAN MAX   E3G1635A
         STW       R4,SYMTMP       PREP COMPARISON CELL
         LI        R4,3
         TRRM      R1,R7           SEE IF BYTE ADDRESS
         CI        R7,0            GOT PROBLEM ?
         BNE       SYMBOL3         YES- TREAT AS ABSOLUTE VALUE
         ANMW      R1,=X'FFFFFF'   24 BIT ADDR FOR STORAGE CELL     3201
*
*        VALUE IS OK TO FETCH
*
         LW        R3,0W,R1        GET IT
*!       BZ        SYMBOL3         SHOW ABSOLUTE IF ZERO        EDEB-35G
         ANMW      R3,MSK.PHYB     RETAIN MAXIMUM BYTE ADDRESS  E3G1635A
         TBM       ATR.VA,ADR.ATR  IS THIS A VIRTUAL ADDRESS?   E3G1635A
         BNS       SYM.000         NO.  PROCESS PHYSICAL ADDR   E3G1635A
*        TRR       R3,R1           COPY TO R1                   E3G1635A
*        SRL       R1,24           POSITION BITS 0-7  O 3201    E3G1635A
*        CI        R1,0            IF ANY THING THERE           E3G1635A
*        BNE       SYMBOL3         SHOW AS ABSOLUTE             E3G1635A
         ANMW      R3,=X'FFFFFF'   MAY BE BYTE ADDRESS ONLY         3201
SYM.000  CEQU      $               MERGE FOR VIRTUAL/PHYSICAL   E3G1635A
         STW       R3,SYMAD        REMEMBER IT IN CASE OF ABORT
         ZR        R1
*!       LA        R2,BATB         STARTING INDEX               EDEB-35G
         ZR        R2              STARTING INDEX TO TABLES     EDEB-35G
SYMBOL1  EQU       $
         TBM       ATR.DEF,BAATR,X2  IS THIS BASE DEFINED?      CP11421
         BNS       SYMBOL2         NO. IGNORE IT AND CONTINUE   CP11421
         LW        R0,BATB,R2      GOT SYMBOL HERE              EDEB-35G
*!       CAMW      R3,0W,R2        GOT A MATCH ?                EBRG-33
*!                                                              EBRG-33
         IFF       C.MPXOUT,%SEIS  ASSEMBLE IN MAPPED IN MODE   CP12443
         ZBR       R0,6            BASE MPX OFFSET ADDRESS?     EBRG-33
         BNS       SYM.001         NO, ADDRESS IS COMPLETE      EBRG-33
         ADMW      R0,BASEMPX      YES, ADD BASE MPX ADDRESS    EBRG-33
%SEIS    ANOP      CONTINUE ASSEMBLY                            CP12443
SYM.001  CAR       R0,R3           GOT A MATCH ?                EBRG-33
         BLT       SYMBOL2         NOT YET
*
*        MATCH FOUND ONCE VALUE IS GREATER THAN ENTRY (,X)
*
*!       SUMW      R3,0W,R2        CALC. OFFSET TO THAT SYMBOL  EBRG-33
*!                                                              EBRG-33
         SUR       R0,R3           CALCULATE OFFSET TO SYMBOL   EBRG-33
         CAMW      R3,SYMTMP       HOW CLOSE IS IT ?
         BGT       SYMBOL2         TOO FAR YET
         STW       R3,SYMTMP       STORE CLOSEST OFFSET
         STW       R1,SYMTMP1      AND CLOSEST CHAR VALUE
         SBM       0,SYMTMP1       SET WE GOT HERE FLAG
SYMBOL2  EQU       $
         LW        R3,SYMAD        REFRESH R3 AGAIN
         ADI       R2,1W
         ADI       R1,1            NEXT CHAR POSITION
         CI        R1,G'Z'-G'G'+1  DONE ?
         BLT       SYMBOL1         NOT YET
*
*        DONE - SEE IF WE FOUND A VALUE
*
         LW        R1,SYMTMP1      FIND A CHAR ?
         BZ        SYMBOL3         NO-SHOW AS ABSOLUTE
         ANMW      R1,=X'FF'       SCREEN FLAGS
         LW        R2,SYMBX        GET PASSED INDEX
         LW        R3,SYMTMP       GET OFFSET FROM CHARACTER
         ADI       R1,G'G'         SET IT UP
         STB       R1,DOBUF,R2     PLANT CHARACTER AWAY
         LI        R1,G'+'
         ADI       R2,1B
         STB       R1,DOBUF,R2
         ADI       R2,1B
         STW       R2,SYMBX        SAVE UPDATED INDEX
         LF        R0,SYMSAV       RETRIEVE REGISTERS
         LA        R1,SYMTMP       LOCATION OF OFFSET VALUE
         BU        SYMBOL4         MERGE
*
*        NO MATCHUP
*
SYMBOL3  EQU       $
         LF        R0,SYMSAV
SYMBOL4  EQU       $
         LW        R2,SYMBX        SAVED INDEX TO GO TO
SYMBOL5  EQU       $
         LI        R5,-4B
         BU        AHSTORE         MERGE WITH CONVERT CODE
         BOUND     8W
SYMSAV   RES       8W
SYMBX    DATAW     0
SYMTMP   DATAW     0
SYMTMP1  DATAW     0
SYMAD    DATAW     0
#endif

/*
 * Outputs index register num to do buffer.
 */
void xout()
{
	if (index == 0)			/* got a real index reg */
		return;			/* exit */
	dobuf[insx++] = ',';		/* insert comma */
	dobuf[insx++] = 'X';		/* reg type */
	dobuf[insx++] = index + '0';	/* reg number */
	insx++;				/* step over one position */
}

/*
 * Get augment (F,C bits) for mem.reference instructions.
 * Input           Memory reference address.
 * Return          0,Byte addr.
 *                 1,Half-wd.addr.
 *                 2,Word addr.
 *                 3,Dble-wd.addr.
 */
int augmr(int opadr)
{
	if (opadr & 0x80000)
		return(0);		/* byte addr */
	if (opadr & 1)
		return(1);		/* hw addr */
	if (opadr & 2)
		return(2);		/* word addr */
	return(3);			/* dbl word addr */
}


struct itbl {
	char *mnem;		/* mnemonic */
	int op;			/* opdode */
	int aug;		/* augmend */
	int flags;		/* bust flags */
};

/*
*        THIS TABLE CONTAINS 2 WORDS FOR EACH VALID INSTRUCTION
*        MNEMONIC. THE FORMAT OF THE TABLE IS AS FOLLOWS.
*        BITS  0-31=INSTRUCTION MNEMONIC IN ASCII.
*        BITS 32-39=PRIMARY OP-CODE, LEFT-JUSTIFIED.
*        BITS 40-47=AUGMENT, AS IT EXISTS IN THE INSTRUCTION, OR AS IT
*                   IS COMPUTED IN THE BUST ROUTINES.
*        BITS 48-63=IDENTIFICATION FLAGS INDICATING WHAT INFORMATION
*                   IS REQUIRED IN THE TRACE BUFFER BEFORE AND AFTER
*                  EXECUTING THE INSTRUCTION, AND INFORMATION
*                   CONCERNING EXECUTION.
*
*
*        BIT SETTINGS IN BITS 48-63 GO TO 'IDLFLAGS' AND
*        ARE INTERPRETED AS FOLLOWS ONCE IN 'IDLFAGS'
*
*        BIT       MEANING
*        ---       -----------------------------------
*        00        REG 'S' OR REG 'D' TO BE OUTPUT
*        01        REG 'D' OR REG TO BE OUTPUT
*        02        DOUBLE REGISTER REG 'D' OR REG
*        03        BIT,CONDITION OR SHIFT FIELD TO GO OUT
*        04        PRIORITY LEVEL OR DEVICE NUMBER
*        05        PRGRAM FLAGS OR IMMEDIATE FIELD VALUE
*        06        INDIRECT INDICATOR TO GO OUT
*        07        EFFECTIVE ADDRESS TO BE OUTPUT
*        08        SPECIAL EXECUTION CASE (IN 'SPEC')
*        09        NON-EXECUTABLE INSTRUCTION (HALT..ETC..)
*        10        32 BIT OPCODE IF SET (ELSE IT IS 16 BIT)
*        11        BRANCH SIMULATION REQUIRED
*        12        REG 'S' OR REG 'A' TO GO AFTER EXU
*        13        REG 'D' OR REG TO GO AFTER EXU
*        14        DOBLE REG AFTER EXU
*        15        EFFECTIVE ADDRS AFTER EXU ONLY
*/

struct itbl itable[] = {
	"HALT", 0x00, 0x00, 0x0040,
	"WAIT", 0x00, 0x01, 0x0040,
	"NOP ", 0x00, 0x02, 0x0000,
	"LCS ", 0x00, 0x03, 0x4004,
	"ES  ", 0x00, 0x04, 0x2002,
	"RND ", 0x00, 0x05, 0x2002,
	"BEI ", 0x00, 0x06, 0x0040,
	"UEI ", 0x00, 0x07, 0x0040,
	"EAE ", 0x00, 0x08, 0x0040,
	"RDST", 0x00, 0x09, 0x4044,
	"SIPU", 0x00, 0x0A, 0x0040,
	"RWCS", 0x00, 0x0B, 0xC04C,
	"WWCS", 0x00, 0x0C, 0xC04C,
	"SEA ", 0x00, 0x0D, 0x0040,
	"DAE ", 0x00, 0x0E, 0x0040,
	"CEA ", 0x00, 0x0F, 0x0040,
	"ANR ", 0x04, 0x00, 0xC004,
	"SMC ", 0x04, 0x07, 0x4040,
	"CMC ", 0x04, 0x0A, 0x4040,
	"ORR ", 0x08, 0x00, 0xC004,
	"ORRM", 0x08, 0x08, 0xC004,
	"EOR ", 0x0C, 0x00, 0xC004,
	"EORM", 0x0C, 0x08, 0xC004,
	"ZR  ", 0x0C, 0x10, 0x4004,
	"CAR ", 0x10, 0x00, 0xC00C,
	"CMR ", 0x14, 0x00, 0xC00C,
	"SBR ", 0x18, 0x00, 0x5004,
	"ZBR ", 0x1C, 0x00, 0x5004,
	"ABR ", 0x20, 0x00, 0x5004,
	"TBR ", 0x24, 0x00, 0x5000,
	"TRSW", 0x28, 0x00, 0x4080,
	"TRR ", 0x2C, 0x00, 0xC004,
	"TRC ", 0x2C, 0x03, 0xC004,
	"TRN ", 0x2C, 0x04, 0xC004,
	"XCR ", 0x2C, 0x05, 0xC00C,
	"LMAP", 0x2C, 0x07, 0x4044,
	"TRRM", 0x2C, 0x08, 0xC004,
	"SCPU", 0x2C, 0x09, 0x4044,
	"TMTR", 0x2C, 0x0A, 0xC044,
	"TRCM", 0x2C, 0x0B, 0xC004,
	"TRNM", 0x2C, 0x0C, 0xC004,
	"XCRM", 0x2C, 0x0D, 0xC00C,
	"TRSC", 0x2C, 0x0E, 0xC004,
	"TSCR", 0x2C, 0x0F, 0xC004,
	"CALM", 0x30, 0x00, 0x0400,
	"LA  ", 0x34, 0x00, 0x4324,
	"ADR ", 0x38, 0x00, 0xC004,
	"ARFW", 0x38, 0x01, 0xC004,
	"SRFW", 0x38, 0x03, 0xC004,
	"DRFW", 0x38, 0x04, 0xC004,
	"FIXW", 0x38, 0x05, 0xC004,
	"MRFW", 0x38, 0x06, 0xC004,
	"FLTW", 0x38, 0x07, 0xC004,
	"ADRM", 0x38, 0x08, 0xC004,
	"ARFD", 0x38, 0x09, 0xC002,
	"SRFD", 0x38, 0x0B, 0xC002,
	"DRFD", 0x38, 0x0C, 0xC002,
	"FIXD", 0x38, 0x0D, 0xC002,
	"MRFD", 0x38, 0x0E, 0xC002,
	"FLTD", 0x38, 0x0F, 0xC002,
	"SUR ", 0x3C, 0x00, 0xC004,
	"SURM", 0x3C, 0x08, 0xC004,
	"MPR ", 0x40, 0x00, 0xA002,
	"DVR ", 0x44, 0x00, 0xA002,
	"NOR ", 0x60, 0x00, 0xC00C,
	"NORD", 0x64, 0x00, 0xA00A,
	"SCZ ", 0x68, 0x00, 0xC00C,
	"SRA ", 0x6C, 0x00, 0x5004,
	"SLA ", 0x6C, 0x01, 0x5004,
	"SRL ", 0x70, 0x00, 0x5004,
	"SLL ", 0x70, 0x01, 0x5004,
	"SRC ", 0x74, 0x00, 0x5004,
	"SLC ", 0x74, 0x01, 0x5004,
	"SRAD", 0x78, 0x00, 0x3002,
	"SLAD", 0x78, 0x01, 0x3002,
	"SRLD", 0x7C, 0x00, 0x3002,
	"SLLD", 0x7C, 0x01, 0x3002,
	"SCSR", 0x04, 0x01, 0x4040,
	"SDSR", 0x04, 0x02, 0x4040,
	"PIT ", 0x04, 0x04, 0x0040,
	"DCSR", 0x04, 0x05, 0x4000,
	"DDSR", 0x04, 0x06, 0x4000,
	"SEAR", 0x04, 0x0E, 0x0040,
	"CEAR", 0x04, 0x0F, 0x0040,
	"MRMW", 0x0C, 0x02, 0xA002,
	"RRMW", 0x0C, 0x03, 0xC004,
	"WRMS", 0x0C, 0x09, 0x4004,
	"RRMS", 0x0C, 0x0A, 0x4004,
	"CXIW", 0x28, 0x06, 0xC004,
	"CXID", 0x28, 0x07, 0xA00A,
	"CIXW", 0x28, 0x0A, 0xC004,
	"CIXD", 0x28, 0x0B, 0xA00A,
	/* BELOW ARE 16 BIT */
	"LEAR", 0x80, 0x00, 0x4324,
	"LCRA", 0x58, 0x00, 0x4324,
	"ANMB", 0x84, 0x00, 0x4324,
	"ANMH", 0x84, 0x01, 0x4324,
	"ANMW", 0x84, 0x02, 0x4324,
	"ANMD", 0x84, 0x03, 0x2322,
	"ORMB", 0x88, 0x00, 0x4324,
	"ORMH", 0x88, 0x01, 0x4324,
	"ORMW", 0x88, 0x02, 0x4324,
	"ORMD", 0x88, 0x03, 0x2322,
	"EOMB", 0x8C, 0x00, 0x4324,
	"EOMH", 0x8C, 0x01, 0x4324,
	"EOMW", 0x8C, 0x02, 0x4324,
	"EOMD", 0x8C, 0x03, 0x2322,
	"CAMB", 0x90, 0x00, 0x4325,
	"CAMH", 0x90, 0x01, 0x4325,
	"CAMW", 0x90, 0x02, 0x4325,
	"CAMD", 0x90, 0x03, 0x2322,
	"CMMB", 0x94, 0x00, 0x4325,
	"CMMH", 0x94, 0x01, 0x4325,
	"CMMW", 0x94, 0x02, 0x4325,
	"CMMD", 0x94, 0x03, 0x2322,
	"SBM ", 0x98, 0x00, 0x1321,
	"ZBM ", 0x9C, 0x00, 0x1321,
	"ABM ", 0xA0, 0x00, 0x1321,
	"TBM ", 0xA4, 0x00, 0x1321,
	"EXM ", 0xA8, 0x00, 0x03A0,
	"LB  ", 0xAC, 0x00, 0x4324,
	"LH  ", 0xAC, 0x01, 0x4324,
	"LW  ", 0xAC, 0x02, 0x4324,
	"LD  ", 0xAC, 0x03, 0x2322,
	"LCB ", 0x5C, 0x00, 0x4324,
	"LCH ", 0x5C, 0x01, 0x4324,
	"LCW ", 0x5C, 0x02, 0x4324,
	"LCD ", 0x5C, 0x03, 0x2322,
	"LMB ", 0xB0, 0x00, 0x4324,
	"LMH ", 0xB0, 0x01, 0x4324,
	"LMW ", 0xB0, 0x02, 0x4324,
	"LMD ", 0xB0, 0x03, 0x2322,
	"LNB ", 0xB4, 0x00, 0x4324,
	"LNH ", 0xB4, 0x01, 0x4324,
	"LNW ", 0xB4, 0x02, 0x4324,
	"LND ", 0xB4, 0x03, 0x2322,
	"ADMB", 0xB8, 0x00, 0x4324,
	"ADMH", 0xB8, 0x01, 0x4324,
	"ADMW", 0xB8, 0x02, 0x4324,
	"ADMD", 0xB8, 0x03, 0x2322,
	"SUMB", 0xBC, 0x00, 0x4324,
	"SUMH", 0xBC, 0x01, 0x4324,
	"SUMW", 0xBC, 0x02, 0x4324,
	"SUMD", 0xBC, 0x03, 0x2322,
	"MPMB", 0xC0, 0x00, 0x2323,
	"MPMH", 0xC0, 0x01, 0x2323,
	"MPMW", 0xC0, 0x02, 0x2323,
	"DVMB", 0xC4, 0x00, 0x2323,
	"DVMH", 0xC4, 0x01, 0x2323,
	"DVMW", 0xC4, 0x02, 0x2323,
	"LI  ", 0xC8, 0x00, 0x4424,
	"ADI ", 0xC8, 0x01, 0x4424,
	"SUI ", 0xC8, 0x02, 0x4424,
	"MPI ", 0xC8, 0x03, 0x2422,
	"DVI ", 0xC8, 0x04, 0x2422,
	"CI  ", 0xC8, 0x05, 0x4424,
	"SVC ", 0xC8, 0x06, 0x0420,
	"EXR ", 0xC8, 0x07, 0x40A0,
	"EXRR", 0xC8, 0x17, 0x40A0,
	"LF  ", 0xCC, 0x00, 0x43A4,
	"LFBR", 0xCC, 0x08, 0x43A4,
	"LEA ", 0xD0, 0x00, 0x4324,
	"STB ", 0xD4, 0x00, 0x4321,
	"STH ", 0xD4, 0x01, 0x4321,
	"STW ", 0xD4, 0x02, 0x4321,
	"STD ", 0xD4, 0x03, 0x2321,
	"STCB", 0x54, 0x00, 0x4321,
	"STCH", 0x54, 0x01, 0x4321,
	"STCW", 0x54, 0x02, 0x4321,
	"STCD", 0x54, 0x03, 0x2321,
	"STMB", 0xD8, 0x00, 0x4321,
	"STMH", 0xD8, 0x01, 0x4321,
	"STMW", 0xD8, 0x02, 0x4321,
	"STMD", 0xD8, 0x03, 0x2321,
	"STF ", 0xDC, 0x00, 0x43A1,
	"STBF", 0xDC, 0x08, 0x43A1,
	"SUFW", 0xE0, 0x02, 0x4324,
	"SUFD", 0xE0, 0x03, 0x2322,
	"ADFW", 0xE0, 0x12, 0x4324,
	"ADFD", 0xE0, 0x13, 0x2322,
	"DVFW", 0xE4, 0x02, 0x4324,
	"DVFD", 0xE4, 0x03, 0x2322,
	"MPFW", 0xE4, 0x12, 0x4324,
	"MPFD", 0xE4, 0x13, 0x2322,
	"ARMB", 0xE8, 0x00, 0x4321,
	"ARMH", 0xE8, 0x01, 0x4321,
	"ARMW", 0xE8, 0x02, 0x4321,
	"ARMD", 0xE8, 0x03, 0x2321,
	"BU  ", 0xEC, 0x00, 0x0330,
	"BCT ", 0xEC, 0x01, 0x1330,
	"BFT ", 0xF0, 0x00, 0x1330,
	"BCF ", 0xF0, 0x01, 0x1330,
	"BIB ", 0xF4, 0x00, 0x4334,
	"BIH ", 0xF4, 0x01, 0x4334,
	"BIW ", 0xF4, 0x02, 0x4334,
	"BID ", 0xF4, 0x03, 0x4334,
	"BL  ", 0xF8, 0x01, 0x1331,
	"BRI ", 0xF8, 0x02, 0x1370,
	"LPSD", 0xF8, 0x03, 0x1371,
	"JWCS", 0xF8, 0x04, 0x0660,
	"LPCM", 0xF8, 0x05, 0x1371,
	"TRP ", 0xF8, 0x06, 0x4460,
	"TPR ", 0xF8, 0x07, 0x4464,
	"ZMB ", 0xF8, 0x00, 0x0321,
	"ZMH ", 0xF8, 0x10, 0x0321,
	"ZMW ", 0xF8, 0x20, 0x0321,
	"ZMD ", 0xF8, 0x30, 0x0321,
	"EI  ", 0xFC, 0x00, 0x0860,
	"DI  ", 0xFC, 0x01, 0x0860,
	"RI  ", 0xFC, 0x02, 0x0860,
	"AI  ", 0xFC, 0x03, 0x0860,
	"DAI ", 0xFC, 0x04, 0x0860,
	"TD  ", 0xFC, 0x05, 0x1C60,
	"CD  ", 0xFC, 0x06, 0x1C60,
	"SIO ", 0xFC, 0x09, 0x1460,
	"TIO ", 0xFC, 0x0A, 0x1460,
	"STPI", 0xFC, 0x0B, 0x1460,
	"RSCH", 0xFC, 0x0C, 0x1460,
	"HIO ", 0xFC, 0x0D, 0x1460,
	"GRIO", 0xFC, 0x0E, 0x1460,
	"RSCT", 0xFC, 0x0F, 0x1460,
	"EWCW", 0xFC, 0x10, 0x1460,
	"WCWC", 0xFC, 0x12, 0x1460,
	"ECI ", 0xFC, 0x13, 0x1460,
	"DCI ", 0xFC, 0x14, 0x1460,
	"ACI ", 0xFC, 0x15, 0x1460,
	"DACI", 0xFC, 0x16, 0x1460,
	"GFPC", 0xC8, 0x0D, 0xA02A,
	"RFPW", 0xC8, 0x0E, 0xA02A,
	"RFPD", 0xC8, 0x0F, 0xA02A,
	"TC  ", 0xC8, 0x08, 0x0420,
	"XCBR", 0x28, 0x02, 0xC00C,
	"TCCR", 0x28, 0x04, 0x4004,
	"TRCC", 0x28, 0x05, 0x4004,
	"TRBR", 0x2C, 0x01, 0xC004,
	"TBRR", 0x2C, 0x02, 0xC004,
	"RINT", 0xC8, 0x0A, 0x4424,
	"PINT", 0xC8, 0x09, 0x4420,
	"*UND", 0xFF, 0xFF, 0x0060,
	0, 0, 0, 0,
};
