/*
 * obd.c
 *
 * This program uncompresses MPX compressed files and
 * dumps the object records in a readable form.
 * input - stdin or specified file name
 * output - stdout
 */

#include <stdio.h>
#include <fcntl.h>

/* #define QUIET */

void trace(int sect);
void mnemout();			/* output opcode mnemonic */
void eaout();
void rsout();
void rdout();
void bcsout();
void pdout();
void pictout();
void xout();
void dataout(unsigned int data);
void datahout(unsigned int data);
void asciiout(int length);
int symbol(unsigned int address, unsigned int opaddress, int label);

int binary = 1;
int dounix;	/* set if doing unix object */
int first;	/* set after 1st time */
int ifd;	/* input file number */

main (argc, argv)
int	argc;
char *	argv[];
{
    unsigned char s[BUFSIZ];
    int i;

    if (argc == 1) {	/* no file given, use stdin */
    	ifd = fileno(stdin);
    } else {
#ifdef mpx
    	if((ifd = open(*++argv, O_RDWR | O_UNBLK, 0666)) < 0) {
    	    fprintf(stderr, "file %s not found\n", *argv);
    	    exit (1);
    	}
#else
    	if((ifd = open(*++argv, O_RDWR)) < 0) {
    	    fprintf(stderr, "file %s not found\n", *argv);
    	    exit (1);
    	}
#endif
    }

    while (1) {
    	memset (s, '\0', BUFSIZ);
    	if ((i = rbl(s, (int)BUFSIZ)) <= 0) exit(0);
    	s [i] = '\0';
    	putloi (s, i);
    }
}
		
/* get a line of input. */

int
getloi ( s, lim )                    /*  right from the book.  */
unsigned char s[];
int lim;
{
    int c, i, j;

#ifdef OLD_WAY_TOO
    j = rmread(fileno(stdin), s);
#else
    j = rmread(ifd, s);
#endif
    if (j <= 0) return (0);
    if (!binary) {
    	s[j] = '\n';
	for(i=0; --lim > 0 && i < j; ) {
    	  c = s[i];
    
	  s[i++] = c;
	  if ((*s != 0xbf) && (*s != 0x9f)) {
	    if (c == '\n') {
		if ((s[i-1] == '\n') && (i > 1)) {
			while ((s[i-2] == ' ') && (i > 1)) --i;
				s[i-1] = '\n';
		}
		s [ i ] = '\0';
		return (i);
	    }
          }
	}
    	return (i);
    }
    return (j);
}

int sect_org[256];		/* sect origin */
int sect_size[256];		/* sect size */
int sect_off[256];		/* sect offset */
int sect_base[256];		/* sect base */
unsigned char *sect_addr[256];	/* sect address */
int curr_sect;			/* current section */
int doem;			/* 1st time flag */
unsigned char *sa;

struct dpr {			/* datapool reference table */
	char name[8];		/* datapool item name */
	unsigned int refa;	/* address of reference */
};

#define DP_SIZE 500			/* datapool reference size */
int ndpr;
struct dpr datapool[DP_SIZE];		/* enough for 500 references */
struct dpr *pdpp = datapool;

struct extr {			/* external reference table */
	char name[8];		/* item name */
	unsigned int refa;	/* address of reference */
	unsigned int sba;	/* string back to next reference */
};

#define EXT_SIZE 100			/* external reference size */
int nextr;
struct extr external[EXT_SIZE];		/* enough for 100 references */
struct extr *pextp = external;

struct defr {			/* definition reference table */
	char name[8];		/* item name */
	unsigned int refa;	/* address of reference */
};

#define DEF_SIZE 100			/* external definition size */
int ndefr;
struct defr defined[DEF_SIZE];		/* enough for 100 references */
struct defr *pdefp = defined;

unsigned int endaddr;		/* end transfer address, if given */

/*
 **  output line of text from the source
 */
int
putloi(s, cnt)
unsigned char *s;
int	cnt;
{
    int i,j,k;
    int seq;
    int bc = s[1];
    int type, objcnt, repeat, bound;
    int exttype, offset;
    int temp1, temp2;

    if (!doem) {
	temp1 = 0x40000;
	curr_sect = 0;				/* dsect */
	sect_base[curr_sect] = 0x20000;		/* assume dsect start */
	sect_org[curr_sect] = 0;		/* origin */
#ifdef NOT_NOW
	sect_size[curr_sect] = temp1;		/* size */
#endif
	 /* get area momory */
	sect_addr[curr_sect] = (unsigned char *)malloc(temp1);
	doem = 1;
    }
/*    if(*s == 0xdf)printf("**last record\n"); */
    seq = s[4] << 8 | s[5];
#ifdef QUIET
    printf("**record %x cnt %d\n", seq, bc);
#endif
    offset = 6;
doit:
    if(offset >= bc + 6)return;
    type = (s[offset] >> 4) & 0x0f;	/* get object record type */
    objcnt = s[offset] & 0x0f;		/* get object record count */
    if (objcnt == 0)objcnt = 16;	/* zero cnt means 16 */

    switch (type) {
    	case 0:			/* absolute data */
	    sa = sect_addr[curr_sect];	/* address of section */
#ifdef QUIET
    	    printf("addr %x abs data cnt = %d data = ",
	      sect_org[curr_sect] + sect_base[curr_sect], objcnt);
#endif
    	    for (k = 0; k < objcnt; k++) {
#ifdef QUIET
    		if (k > 0 && (k % 4 == 0))printf(" ");
    		printf("%.2x", s[k + offset + 1]);
#endif
		/* put data in memory */
		sa[sect_org[curr_sect]++] = s[k + offset + 1];
    	    }
    	    if (!first) {
    		first = 1;	/* we been here */
    		type = 0;
    		for (k = 0; k < 4; k++) {
    		    type |= (s[k+offset+1] << ((3-k)*8));
    		}
    		if (type == 0x2243223a)
    		    dounix = 1;		/* doing c object */
    	    }
#ifdef QUIET
    	    printf("\n");
#endif
    	    offset += (objcnt + 1);
    	    break;
    	case 1:			/* program origin */
#ifdef QUIET
    	    printf("%s program origin addr = ",
    	      (s[offset + 1] & 0x80) ? "rel" : "abs");
#endif
    	    s[offset + 1] &= 0x7f;	/* turn off rel bit */
	    temp1 = 0;			/* clear for new org */
    	    for (k = 0; k < objcnt; k++) {
#ifdef QUIET
    		printf("%.2x", s[k + offset + 1]);
#endif
    		temp1 = (temp1 << 8) | s[offset + 1 + k];
    	    }
#ifdef QUIET
    	    printf("\n");
#endif
	    sect_org[curr_sect] = temp1;	/* set new origin */
    	    offset += (objcnt + 1);
    	    break;
    	case 2:			/* absolute data repeat */
#ifdef OLD_JUNK
printf("DUMP abs data repeat cnt = %d\n", objcnt);
for (k = 0; k < objcnt + 1; k++) {
    if (k > 0 && (k % 20 == 0)) printf("\n");
    printf("%.2x ", s[offset + k]);
}
printf("\n");
#endif
	    sa = sect_addr[curr_sect];	/* address of section */
    	    repeat = s[offset + 1];
    	    if (repeat == 0)repeat = 1;
    	    printf("abs data repeat cnt = %d\n", repeat);
    	    for (k = 0; k < objcnt - 1; k++) {
    		printf("%.2x ", s[k + offset + 2]);
		/* put data in memory */
		sa[sect_org[curr_sect]++] = s[k + offset + 2];
    	    }
    	    printf("\n");
    	    offset += (objcnt + 1);
    	    break;
    	case 3:			/* transfer address */
#ifdef OLD_JUNK
printf("DUMP transfer address cnt = %d\n", objcnt);
for (k = 0; k < objcnt + 1; k++) {
    if (k > 0 && (k % 20 == 0)) printf("\n");
    printf("%.2x ", s[offset + k]);
}
printf("\n");
#endif
#ifdef QUIET
    	    printf("transfer address cnt = %d addr = ", objcnt);
#endif
	    temp1 = 0;
    	    s[offset + 1] &= 0x7f;	/* turn off rel bit */
    	    for (k = 0; k < objcnt; k++) {
		temp1 = (temp1 << 8) | s[k + offset + 1];
#ifdef QUIET
    		printf("%.2x", s[k + offset + 1]);
#endif
    	    }
	    temp1 += sect_base[curr_sect];
	    endaddr = temp1;
#ifdef QUIET
    	    printf("\n");
#endif
    	    offset += (objcnt + 1);
    	    break;

    	case 4:			/* relocatable data */
	    sa = sect_addr[curr_sect];	/* address of section */
#ifdef QUIET
    	    printf("addr %x rel data cnt = %d data = ",
	      sect_org[curr_sect] + sect_base[curr_sect], objcnt);
#endif
    	    for (k = 0; k < objcnt; k++) {
		if (k == 0)temp1 = 0;
    		temp1 = (temp1 << 8) | s[offset + 1 + k];
    		if (k > 0 && (k % 4 == 3)) {
		    temp1 += sect_base[curr_sect];
#ifdef QUIET
    		    printf("%.8x", temp1);
		    printf(" ");
#endif
		    /* put data in memory */
		    for (i=0; i < 4; i++)
			sa[sect_org[curr_sect]++] =
			    (temp1 >> ((3-i)*8)) & 0xff;
		    temp1 = 0;
		}
    	    }
#ifdef QUIET
    	    printf("\n");
#endif
    	    offset += (objcnt + 1);
    	    break;

    	case 5:			/* program name */
#ifdef OLD_WAY
    	    bound = s[offset + 1 + objcnt - 3] << 16 |
    		s[offset + 1 + objcnt - 2] << 8 |
    		s[offset + 1 + objcnt - 1];
#else
    	    bound = s[offset + 1 + objcnt - 1];
    	    repeat = s[offset + 1 + objcnt - 2];
    	    /* see if 'C' object */
    	    if (repeat == 0x04)
    		dounix = 1;		/* doing c object */
#endif
#ifdef JUNK
    	    printf("program name = ");
#endif
	    printf("          PROGRAM  ");
    	    for (k = 0; k < objcnt - 3; k++) {
    		printf("%c", s[k + offset + 1]);
    	    }
#ifdef QUIET1
#ifdef OLD_WAY
    	    printf(" bound = %x", bound);
#else
    	    printf(" bound = %x obj type = %x", bound, repeat);
#endif
#endif
    	    printf("\n");
    	    offset += (objcnt + 1);
    	    break;
    	case 6:			/* relocatable data repeat */
    	    repeat = s[offset + 1];
    	    if (repeat == 0)repeat = 1;
    	    printf("rel data repeat cnt = %d\n", repeat);
    	    for (k = 0; k < objcnt - 1; k++) {
    		printf("%.2x ", s[k + offset + 2]);
    	    }
    	    printf("\n");
    	    offset += (objcnt + 1);
    	    break;
    	case 7:			/* external definition */
#ifdef JUNK
    	    printf("%s external def name = ",
    	      (s[offset + 1 + objcnt - 3] & 0x80) ? "rel" : "abs");
#endif
    	    s[offset + 1 + objcnt - 3] &= 0x7f;	/* turn off rel bit */
    	    bound = s[offset + 1 + objcnt - 3] << 16 |
    		s[offset + 1 + objcnt - 2] << 8 |
    		s[offset + 1 + objcnt - 1];
	    printf("          DEF      ");
    	    for (k = 0; k < objcnt - 3; k++) {
    		printf("%c", s[k + offset + 1]);
		pdefp->name[k] = s[k + offset + 1];
    	    }
	    ndefr++;			/* next reference */
	    pdefp->refa = bound + sect_base[curr_sect];
	    pdefp++;
#ifdef JUNK
    	    printf(" address = %x", bound);
#endif
	    printf("\n");
    	    offset += (objcnt + 1);
    	    break;
    	case 8:			/* forward reference */
    	    printf("%s forward reference addr = ",
    	      (s[offset + 1] & 0x80) ? "rel" : "abs");
    	    s[offset + 1] &= 0x7f;	/* turn off rel bit */
    	    for (k = 0; k < objcnt - 3; k++) {
    		printf("%.2x", s[k + offset + 1]);
    	    }
    	    printf(" sb addr = ");
    	    for (k = 3; k < objcnt; k++) {
    		printf("%.2x", s[k + offset + 1]);
    	    }
    	    printf("\n");
    	    offset += (objcnt + 1);
    	    break;
    	case 9:			/* external reference */
#ifdef JUNK
    	    printf("%s external ref name = ",
    	      (s[offset + 1 + objcnt - 3] & 0x80) ? "rel" : "abs");
#endif
    	    s[offset + 1 + objcnt - 3] &= 0x7f;	/* turn off rel bit */
    	    bound = s[offset + 1 + objcnt - 3] << 16 |
    		s[offset + 1 + objcnt - 2] << 8 |
    		s[offset + 1 + objcnt - 1];
	    printf("          EXT      ");
    	    for (k = 0; k < objcnt - 3; k++) {
    		printf("%c", s[k + offset + 1]);
		pextp->name[k] = s[k + offset + 1];
    	    }
	    nextr++;			/* next reference */
	    pextp->refa = sect_org[curr_sect] + sect_base[curr_sect];
	    pextp->sba = bound + sect_base[curr_sect];
	    pextp++;
#ifdef JUNK
    	    printf(" sb addr = %x", bound);
#endif
    	    printf("\n");
    	    offset += (objcnt + 1);
    	    break;
    	case 10:		/* common definition */
    	    printf("common def name = ");
    	    /* get common block number */
    	    repeat = s[offset + 1 + objcnt - 3];
    	    /* get common size */
    	    bound = s[offset + 1 + objcnt - 2] << 8 |
    		s[offset + 1 + objcnt - 1];
    	    for (k = 0; k < objcnt - 3; k++) {
    		printf("%c", s[k + offset + 1]);
    	    }
    	    printf(" block = %d size = %x\n", repeat, bound);
    	    offset += (objcnt + 1);
    	    break;
    	case 11:		/* common reference */
    	    /* get common block number */
    	    repeat = s[offset + 1];
    	    printf("common ref block = %d data = ", repeat);
    	    for (k = 0; k < objcnt - 1; k++) {
    		if (k == 4 || k == 8 || k == 12)printf(" ");
    		printf("%.2x", s[k + offset + 2]);
    	    }
    	    printf("\n");
    	    offset += (objcnt + 1);
    	    break;
    	case 12:		/* datapool reference */
	    sa = sect_addr[curr_sect];	/* address of section */
#ifdef JUNK
    	    printf("datapool ref name = ");
#endif
    	    printf("DATAPOOL  COMMON   ");
    	    for (k = 0; k < objcnt - 4; k++) {
    		printf("%c", s[k + offset + 1]);
		pdpp->name[k] = s[k + offset + 1];
    	    }
	    ndpr++;			/* next reference */
	    pdpp->refa = sect_org[curr_sect] + sect_base[curr_sect];
	    pdpp++;
#ifdef JUNK
    	    printf(" at %x addr = ", sect_org[curr_sect] + sect_base[curr_sect]);
#endif
    	    for (k = 0; k < 4; k++) {
		if (k == 0)temp1 = 0;
    		temp1 = (temp1 << 8) | s[k + offset + objcnt + 1 - 4];
    		if (k > 0 && (k % 4 == 3)) {
/*		    temp1 += sect_base[curr_sect]; */
		    /* put data in memory */
		    for (i=0; i < 4; i++)
			sa[sect_org[curr_sect]++] =
			    (temp1 >> ((3-i)*8)) & 0xff;
		    temp1 = 0;
		}
#ifdef JUNK
    		printf("%.2x", s[k + offset + objcnt + 1 - 4]);
#endif
    	    }
    	    printf("\n");
    	    offset += (objcnt + 1);
    	    break;
    	case 13:		/* escape to extended functions */
    	    objcnt = s[offset] & 0x0f;		/* get sub type */
    	    exttype = s[offset + 1];		/* get ext type */

    	    switch (exttype) {
    		case 0:			/* undefined */
    	    for (k = 0; k < s[offset+2]; k++) {
    		if (k > 0 && (k % 20 == 0)) printf("\n");
    		printf("%.2x ", s[offset + k]);
    	    }
    	    printf("\n");
    		    offset += s[offset + 2];
    		    break;
    		case 1:			/* section definition */
#ifdef QUIET
    		    printf("section def bound = %x num = %d size = ",
    		      s[offset + 3], s[offset + 4]);
#endif
		    temp1 = 0;
    		    for (k = 0; k < 3; k++) {
#ifdef QUIET
    			printf("%.2x", s[offset + 5 + k]);
#endif
			temp1 = (temp1 << 8) | s[offset + 5 + k];
    		    }
#ifdef QUIET
    		    printf(" name = ");
    		    for (k = 0; k < 8; k++) {
    			printf("%c", s[offset + 8 + k]);
    		    }
    		    printf("\n");
#endif
		    curr_sect = s[offset + 4];		/* sect # */
		    if (curr_sect == 0)
			sect_base[curr_sect] = 0x20000;	/* assume dsect start */
		    if (curr_sect == 1) {
			/* assume csect start */
			temp2 = (temp1 / 0x2000) + 1;	/* mod page size */
			sect_base[curr_sect] = 0x80000 - (temp2 * 0x2000);
		    }
		    sect_org[curr_sect] =  0;		/* origin */

		    sect_size[curr_sect] = temp1;	/* size */
		    /* get area momory */
		    if (sect_addr[curr_sect])		/* if we got one */
			realloc((void *)sect_addr[curr_sect], temp1);	/* resize */
		    else				/* get a new one */
			sect_addr[curr_sect] = (unsigned char *)malloc(temp1);

    		    offset += s[offset + 2];
    		    break;
    		case 2:			/* section origin */
#ifdef QUIET
    		    printf("section origin bound = %x sect %s origin = ",
    		      s[offset + 3],
    		      s[offset + 4] == 0 ? "DSECT" : s[offset + 4] == 1 ?
    		      "CSECT" : "UNKNOWN");
#endif
		    temp1 = 0;
    		    for (k = 0; k < 3; k++) {
#ifdef QUIET
    			printf("%.2x", s[offset + 5 + k]);
#endif
			temp1 = (temp1 << 8) | s[offset + 5 + k];
    		    }
#ifdef QUIET
    		    printf("\n");
#endif
		    curr_sect = s[offset + 4];		/* sect # */
		    sect_org[curr_sect] = temp1;	/* origin */

    		    offset += s[offset + 2];
    		    break;
    		case 3:			/* section relocatable ref */
    		    repeat = s[offset + 5];
	    	    sa = sect_addr[curr_sect];	/* address of section */
    		    if (repeat == 0)repeat = 1;	/* 0 is 1 */
#ifdef QUIET
    		    printf("addr %x sect rel ref %s rep cnt = %d data = ",
		      sect_org[curr_sect] + sect_base[curr_sect],
    		      s[offset + 4] == 0 ? "DSECT" : s[offset + 4] == 1 ?
    		      "CSECT" : "UNKNOWN", repeat);
#endif
    		    for (k = 0; k < (s[offset + 2] - 6); k++) {
			if (k == 0)temp1 = 0;
    			temp1 = (temp1 << 8) | s[offset + 6 + k];
    			if (k > 0 && (k % 4 == 3)) {
			    temp1 += sect_base[s[offset + 4]];
#ifdef QUIET
    			    printf("%.8x", temp1);
			    printf(" ");
#endif
			    /* put data in memory */
			    for (i=0; i < 4; i++)
				sa[sect_org[curr_sect]++] =
				    (temp1 >> ((3-i)*8)) & 0xff;
			    temp1 = 0;
			}
#ifdef QUIET
    			if (k > 0 && (k % 20 == 0)) printf("\n");
#endif
    		    }
#ifdef QUIET
    		    if (k % 20 != 0)printf("\n");
#endif
    		    offset += s[offset + 2];
    		    break;
    		case 4:			/* section transfer address */
    		    printf("section transfer address num = %d address = ",
    		      s[offset + 4]);
    		    for (k = 0; k < 3; k++) {
    			printf("%.2x", s[offset + 5 + k]);
    		    }
    		    printf("\n");
    		    offset += s[offset + 2];
    		    break;
    		case 5:			/* section external def */
    		    printf("sect ext def num = %d address = ",
    		      s[offset + 4]);
    		    for (k = 0; k < 3; k++) {
    			printf("%.2x", s[offset + 5 + k]);
    		    }
    		    printf(" name = ");
    		    for (k = 0; k < s[offset + 2] - 8; k++) {
    			printf("%c", s[offset + 8 + k]);
    		    }
    		    printf("\n");
    		    offset += s[offset + 2];
    		    break;
    		case 6:			/* section external ref */
    		    printf("section ext ref num = %d sb address = ",
    		      s[offset + 4]);
    		    for (k = 0; k < 3; k++) {
    			printf("%.2x", s[offset + 5 + k]);
    		    }
    		    printf(" name = ");
    		    for (k = 0; k < s[offset + 2] - 8; k++) {
    			printf("%c", s[offset + 8 + k]);
    		    }
    		    printf("\n");
    		    offset += s[offset + 2];
    		    break;
    		case 7:			/* section forward ref */
    		    printf("sect forward ref num = %d address = ",
    		      s[offset + 4]);
    		    for (k = 0; k < 3; k++) {
    			printf("%.2x", s[offset + 5 + k]);
    		    }
    		    printf(" num = %d sb addr = ", s[offset + 8]);
    		    for (k = 0; k < 3; k++) {
    			printf("%.2x", s[offset + 9 + k]);
    		    }
    		    printf("\n");
    		    offset += s[offset + 2];
    		    break;
    		case 8:			/* large common def */
    		    printf("large com def num = %d sb size = ",
    		      s[offset + 4]);
    		    for (k = 0; k < 3; k++) {
    			printf("%.2x", s[offset + 5 + k]);
    		    }
    		    printf(" name = ");
    		    for (k = 0; k < s[offset + 2] - 8; k++) {
    			printf("%c", s[offset + 8 + k]);
    		    }
    		    printf("\n");
    		    offset += s[offset + 2];
    		    break;
    		case 9:			/* large common origin */
    		    printf("large com origin num = %d sb origin = ",
    		      s[offset + 4]);
    		    for (k = 0; k < 3; k++) {
    			printf("%.2x", s[offset + 5 + k]);
    		    }
    		    printf("\n");
    		    offset += s[offset + 2];
    		    break;
    		case 10:		/* large common ref */
    		    repeat = s[offset + 5];
    		    if (repeat == 0)repeat = 1;	/* 0 is 1 */
    		    printf("large com ref num = %d rep cnt = %d data = ",
    		      s[offset + 4], repeat);
    		    for (k = 0; k < (s[offset + 2] - 6); k++) {
    			if (k > 0 && (k % 4 == 0)) printf(" ");
    			if (k > 0 && (k % 20 == 0)) printf("\n");
    			printf("%.2x", s[offset + 6 + k]);
    		    }
    		    if (k % 20 != 0)printf("\n");
    		    offset += s[offset + 2];
    		    break;
    		case 11:		/* debugger information */
    		    printf("debugger info: flg: %d len: %d %s %s type: ",
    		      objcnt, s[offset + 2], s[offset + 3] & 2 ? "abs" : "rel",
    		      s[offset + 3] & 1 ? "CSECT" : "DSECT");
    		    switch (s[offset + 4]) {
    			case 0: printf("int * 1"); break;
    			case 1: printf("int * 2"); break;
    			case 2: printf("int * 4"); break;
    			case 3: printf("int * 8"); break;
    			case 4: printf("real * 4"); break;
    			case 5: printf("real * 8"); break;
    			case 6: printf("complex * 8"); break;
    			case 7: printf("complex * 16"); break;
    			case 8: printf("bit logical"); break;
    			case 9: printf("logical * 1"); break;
    			case 10: printf("logical * 4"); break;
    			case 11: printf("char * n"); break;
    			case 12: printf("type 12"); break;
    			case 13: printf("type 13"); break;
    			case 14: printf("statement label"); break;
    			case 15: printf("proceedure"); break;
    			default: printf("unknown type %d", s[offset + 4]);
    			    break;
    		    }
    		    bound = 0;
    		    for (k = 0; k < 3; k++) {
    			bound = (bound << 8) | (s[offset + 5 + k]);
    		    }
    		    printf("\n* %s address: %x bitnum: %x",
    		      s[offset + 3] & 1 ? "csect" : "dsect", 
    		      bound >> 3, bound & 7);
    		    printf(" size: %d symbol: ",
    		      s[offset + 8] << 8 | s[offset + 9]);
    		    /* now print the 8 chars of the symbol */
    		    for (k = 0; k < s[offset + 2] - 10; k++) {
    			printf("%c", s[offset + 10 + k]);
    		    }
    		    /* see if common */
    		    if (s[offset + 2] == 26) {
    			printf(" common: ");
    			for (k = 0; k < 8; k++) {
    			    printf("%c", s[offset + 18 + k]);
    			}
    		    }
    		    printf("\n");
    		    offset += s[offset + 2];
    		    break;
    		case 12:		/* object creation information */
    		    /* object creation date/time */
    		    if (objcnt == 0) {
	    		printf("* OBJECT CREATED   ");
#ifdef JUNK
    			printf("object creation date/time: ");
#endif
    			for (k = 0; k < 8; k++) {
    			    printf("%c", s[offset + 4 + k]);
    			}
    			printf(" ");
    			for (k = 0; k < 8; k++) {
    			    printf("%c", s[offset + 12 + k]);
    			}
    			printf("\n");
    			offset += s[offset + 2];
    			break;
    		    }
    		    /* product id leader */
    		    if (objcnt == 1) {
    			printf("* product id: ");
    			for (k = 0; k < s[offset + 2] - 4; k++) {
    			    printf("%c", s[offset + 4 + k]);
    			}
    			printf("\n");
    			offset += s[offset + 2];
    			break;
    		    }
    		    /* generating processor info */
    		    if (objcnt == 2) {
    			printf("* generating processor info: opt wd1 = ");
    			for (k = 0; k < 4; k++) {
    			    printf("%.2x", s[offset + 4 + k]);
    			}
    			printf(" opt wd2 = ");
    			for (k = 0; k < 4; k++) {
    			    printf("%.2x", s[offset + 8 + k]);
    			}
#ifdef FUTURE
    			printf(" rev lev = ");
    			for (k = 0; k < 4; k++) {
    			    printf("%.2x", s[offset + 12 + k]);
    			}
#endif
    			printf("\n");
    			printf("* rrs cnt = ");
    			for (k = 0; k < 2; k++) {
    			    printf("%.2x", s[offset + 16 + k]);
    			}
    			printf(" incl cnt = ");
    			for (k = 0; k < 2; k++) {
    			    printf("%.2x", s[offset + 18 + k]);
    			}
/*    			printf("\n"); */
    			printf(" pathname: ");
    			for (k = 0; k < s[offset + 2] - 20; k++) {
    			    printf("%c", s[offset + 20 + k]);
    			}
    			printf("\n");
    			offset += s[offset + 2];
    			break;
    		    }
    		    /* required resources info */
    		    if (objcnt == 3) {
    			repeat = s[offset + 3];
    			printf("* required resource info: %s lfc = ", 
    			  repeat & 1 ? "FORT incl file" : "req obj file");
    			for (k = 0; k < 3; k++) {
    			    printf("%c", s[offset + 5 + k]);
    			}
    			printf("\n");
    			repeat = s[offset + 10];
    			printf("* acc mode = ");
    			for (k = 0; k < 4; k++) {
    			    printf("%.2x", s[offset + 12 + k]);
    			}
    			printf(" opts = ");
    			for (k = 0; k < 4; k++) {
    			    printf("%.2x", s[offset + 16 + k]);
    			}
    			printf(" pathname: ");
#ifdef OLDWAY
    			for (k = 0; k < repeat; k++) {
    			    printf("%c", s[offset + 20 + k]);
    			}
#else
    			for (k = 0; k < s[offset + 2] - 20; k++) {
    			    printf("%c", s[offset + 20 + k]);
    			}
#endif
    			printf("\n");
#ifdef OLD_JUNK
printf("PNAM LEN %d PATH LEN %d\n", repeat, s[offset + 2] - 20);
#endif
    			offset += s[offset + 2];
    			break;
    		    }
    	    for (k = 0; k < s[offset+2]; k++) {
    		if (k > 0 && (k % 20 == 0)) printf("\n");
    		printf("%.2x ", s[offset + k]);
    	    }
    	    printf("\n");
    		    offset += s[offset + 2];
    		    break;
      		case 13:		/* multiple datapool ref */
    		    printf("multiple datapool ref sym =");
    		    for (k = 0; k < (s[offset + 2] - 12); k++) {
    			printf("%c ", s[offset + 4 + k]);
    		    }
    		    printf("\naddr = ");
    		    for (k = 0; k < 4; k++) {
    			printf("%.2x ", s[offset + 2] - 8 + k);
    		    }
    		    printf(" pool num = ");
    		    for (k = 0; k < 4; k++) {
    			printf("%.2x ", s[offset + 2] - 4 + k);
    		    }
    		    printf("\n");
    		    offset += s[offset + 2];
    		    break;
      		case 14:		/* new debugger information */
#ifdef NOT_NOW
    		    printf("new debugger info (hex dump)\n");
    		    for (k = 0; k < s[offset+2]; k++) {
    			if (k > 0 && (k % 20 == 0)) printf("\n");
    			printf("%.2x ", s[offset + k]);
    		    }
    		    printf("\n");
#endif
    		    printf("new debugger info: flags: %x type: ",
    		      s[offset + 3]);
    		if (dounix) {
    		    /* see if we have an enum */
    		    if (s[offset + 4] & 0x20) {
    			printf ("enum ");
    		    }
    		    /* see if stack variable */
    		    if (s[offset + 3] & 0x10) {
    			printf("stack ");
    		    }
    		    /* see if register variable */
    		    if (s[offset + 3] & 0x04) {
    			printf("register ");
    		    }
    		    /* see if pointer */
    		    if (s[offset + 3] & 0x20) {
    			int indcnt = s[offset + 5];
    			/* print number of indirections */
    			while (indcnt--)
    			    printf("*");
    		    }
    		    switch (s[offset + 4] & ~0x20) {
    			case 0: printf("char"); break;
    			case 1: printf("short"); break;
    			case 2: printf("int"); break;
    			case 3: printf("long"); break;
    			case 4: printf("float"); break;
    			case 5: printf("double"); break;
    			case 6:
    			    printf("struct ");
    			    for (k = 0; k < 8; k++) {
    				printf("%c", s[offset + 20 + k]);
    			    }
    			    break;
    			case 7:
    			    printf("union ");
    			    for (k = 0; k < 8; k++) {
    				printf("%c", s[offset + 20 + k]);
    			    }
    			    break;
    			case 8: printf("uchar"); break;
    			case 9: printf("ushort"); break;
    			case 10: printf("uint"); break;
    			case 11: printf("ulong"); break;
    			case 12: printf("enum"); break;
    			case 13: printf("struct def"); break;
    			case 14: printf("statement label"); break;
    			case 15: printf("entry point"); break;
    			case 16: printf("illegal"); break;
    			case 17: printf("CSECT load origin"); break;
    			case 18: printf("DSECT load origin"); break;
    			default: printf("unknown type %d", s[offset + 4]);
    			    break;
    		    }
    		} else {
    		    /* see if we have a parameter */
    		    if ((s[offset + 4] & 0x60) == 0x20) {
    			printf ("parameter ");
    		    }
    		    switch (s[offset + 4] & ~0x20) {
    			case 0: printf("int * 1"); break;
    			case 1: printf("int * 2"); break;
    			case 2: printf("int * 4"); break;
    			case 3: printf("int * 8"); break;
    			case 4: printf("real * 4"); break;
    			case 5: printf("real * 8"); break;
    			case 6: printf("complex * 8"); break;
    			case 7: printf("complex * 16"); break;
    			case 8: printf("bit logical"); break;
    			case 9: printf("logical * 1"); break;
    			case 10: printf("logical * 4"); break;
    			case 11: printf("char * n"); break;
    			case 12: printf("type 12"); break;
    			case 13: printf("type 13"); break;
    			case 14: printf("statement label"); break;
    			case 15: printf("proceedure"); break;
    			default: printf("unknown type %d", s[offset + 4]);
    			    break;
    		    }
    		}
    		    printf(" rsvd: %x size: %d\n",
    		      s[offset + 5], s[offset + 6] * 256 + s[offset + 7]);
    		    repeat = 0;
    		    for (k = 0; k < 4; k++) {
    			repeat = (repeat << 8) | s[offset + 8 + k];
    		    }
    		    printf("* %s address: %x, bitnum: %d symbol: ",
    		        s[offset + 3] & 1 ? "csect" : "dsect", 
    			repeat >> 3, repeat & 7);
    		    for (k = 0; k < 8; k++) {
    			printf("%c", s[offset + 12 + k]);
    		    }
    		    printf("\n");
    		    /* only look at ISC type if len is > 20 */
    		    if (s[offset + 2] <= 20) goto wedone;
    		    /* only look at ISC type if flags is zero */
    		    /* and not a parameter */
    		if (s[offset + 3] <= 1 && s[offset + 4] < 0x20) {
    		    /* do ISC record */
    		    printf("* ISC type: ");
    		    switch (s[offset + 20] & 0x7f) {
    			case 0: printf("no src"); break;
    			case 1: printf("declaration"); break;
    			case 2: printf("xeq statement"); break;
    			case 3: printf("cont line"); break;
    			case 4: printf("comment"); break;
    			case 5: printf("FORTRAN err"); break;
    			default:
    			    printf("undefined %x", s[offset + 20] & 0x7f);
    			    break;
    		    }
    		    printf(" caret %d\n", s[offset + 21]);
    		    /* only process source if caret is zero */
    		    if (s[offset + 21] != 0) goto wedone;
    		    if (s[offset + 20] & 0x80) {
    			/* uncompressed source */
    			int srccnt = s[offset + 22];
    			int blkcnt = s[offset + 23];

    			for (k = 0; k < blkcnt; k++) {
    			    printf(" ");	/* blanks */
    			}
    			for (k = 0; k < srccnt; k++) {
    			    printf("%c", s[offset + 24 + k]);	/* source */
    			}
    		    } else {
    			/* compressed source */
    			unsigned char chr;
    			int srccnt = s[offset + 22];
    			int blkcnt = s[offset + 23];
    			int j = 0;
    			int l = offset + 24;

    			for (k = 0; k < blkcnt; k++) {
    			    printf(" ");	/* blanks */
    			}
    			for (k = 0; k < srccnt; k++) {
    			    switch (j) {
    				case 0:
    				    chr = ((s[offset + l]) >> 2) & 0x3f + 32;
    				    j++;
    				    break;
    				case 1:
    				    chr = (((s[offset + l++] & 3) << 4) |
    				      ((s[offset + l] & 0xf0) >> 4) + 32);
    				    j++;
    				    break;
    				case 2:
    				    chr = (((s[offset + l++] & 0xf) << 2) |
    				      ((s[offset + l] & 0xc0) >> 6) + 32);
    				    j++;
    				    break;
    				case 3:
    				    chr = ((s[offset + l] & 0x3f) + 32);
    				    j = 0;
    				    break;
    			    }
    			    printf("%c", chr);	/* source */
    			}
    		    }
    		    printf("\n");
    		} else {	/* else handle Encore debug record */
    		    int srccnt;
    		    unsigned int srcval;
    		    unsigned int srcval2;
    		    int sv;		/* switch value */
    		    int xx = 20;	/* array info offset */

    		    /* First look for a parameter.  Flags will be zero. */
    		    /* Type will be >= 32 (0x20) */
    		    if (dounix) {
    			sv = s[offset + 3] & 0x48;
    		    } else {
    			sv = s[offset + 3];
    		    }
    		    switch (s[offset + 3]) {	/* switch on flags */
    			case 0x00:		/* parameter */
    			    switch (s[offset + 4] & 0x1f) {
    				case 0:		/* int * 1 */
    				case 9:		/* logical * 1 */
    				    /* wd 5 byte 0 has value */
    				    printf("* param value: 0x");
    				    printf ("%.2x", s[offset + 20]);
    				    printf ("\n");
    				    break;
    				case 1:		/* int * 2 */
    				    /* wd 5 bytes 0-1 has value */
    				    srcval = s[offset + 20] << 8
    				      | s[offset + 21];
    				    printf("* param value: 0x");
    				    printf ("%.4x", srcval);
    				    printf ("\n");
    				    break;
    				case 2:		/* int * 4 */
    				case 4:		/* real * 4 */
    				case 10:	/* logical * 4 */
    				    /* wd 5 bytes 0-3 has value */
    				    srcval = s[offset + 20] << 24
    				      | s[offset + 21] << 16
    				      | s[offset + 22] << 8
    				      | s[offset + 23];
    				    printf("* param value: 0x");
    				    printf ("%.8x", srcval);
    				    printf ("\n");
    				    break;
    				case 3:		/* int * 8 */
    				case 5:		/* real * 8 */
    				case 6:		/* complex * 8 */
    				    /* wd 5-6 bytes 0-3 has value */
    				    srcval = s[offset + 20] << 24
    				      | s[offset + 21] << 16
    				      | s[offset + 22] << 8
    				      | s[offset + 23];
    				    srcval2 = s[offset + 24] << 24
    				      | s[offset + 25] << 16
    				      | s[offset + 26] << 8
    				      | s[offset + 27];
    				    printf("* param value: 0x");
    				    printf ("%.8x %.8x", srcval, srcval2);
    				    printf ("\n");
    				    break;
    				case 7:		/* complex * 16 */
    				    /* wd 5-6 bytes 0-3 has value */
    				    srcval = s[offset + 20] << 24
    				      | s[offset + 21] << 16
    				      | s[offset + 22] << 8
    				      | s[offset + 23];
    				    srcval2 = s[offset + 24] << 24
    				      | s[offset + 25] << 16
    				      | s[offset + 26] << 8
    				      | s[offset + 27];
    				    printf("* param value: 0x");
    				    printf ("%.8x %.8x ", srcval, srcval2);
    				    /* wd 7-8 bytes 0-3 has value */
    				    srcval = s[offset + 28] << 24
    				      | s[offset + 29] << 16
    				      | s[offset + 30] << 8
    				      | s[offset + 31];
    				    srcval2 = s[offset + 32] << 24
    				      | s[offset + 33] << 16
    				      | s[offset + 34] << 8
    				      | s[offset + 35];
    				    printf ("%.8x %.8x", srcval, srcval2);
    				    printf ("\n");
    				    break;
    				case 8:		/* bit logical */
    				    /* wd 5 bit 0 has value */
    				    printf("* param value: ");
    				    printf ("%s\n", s[offset + 20] & 0x80 ?
    				      ".TRUE. (1)" : ".FALSE. (0)");
    				    break;
    				case 11:	/* char * n */
    				    /* size has array length */
    				    /* wds 5 - 8 has char values */
    				    srccnt = s[offset + 6] << 8 | s[offset + 7];
    				    printf("* param value (%d): ", srccnt);
    				    if (srccnt > 16) srccnt = 16;
    				    for (k = 0; k < srccnt; k ++) {
    					printf ("%c", s[offset + 20 + k]);
    				    }
    				    printf ("\n");
    				    break;
    				default:
    				    goto jumpit;
    			    }
    			    break;
    			case 0x04:		/* datapool */
    			    if (dounix) {
    				/* register variable, ignore */
    				break;
    			    } else {
    				/* print datapool name */
    				printf("* len = %d Dpool: ", s[offset + 2]);
    			    }
    			    for (k = 0; k < 8; k++) {
    				printf("%c", s[offset + 20 + k]);
    			    }
    			    printf("\n");
    			    break;
    			case 0x08:		/* common symbol */
    			    if (dounix) {
    				/* print struct/union ref name */
    				printf("* len = %d S/U ref: ", s[offset + 2]);
    			    } else {
    				/* print common name */
    				printf("* len = %d Common: ", s[offset + 2]);
    			    }
    			    for (k = 0; k < 8; k++) {
    				printf("%c", s[offset + 20 + k]);
    			    }
    			    printf("\n");
    			    break;
    			case 0x48:		/* array of structures */
    			    xx = 28;		/* account for struct name */
    			case 0x40:		/* array info present */
printf("* array dims: %d bnds: %d len: %d lbflags %x sbflags %x\n",
s[offset + xx + 0], s[offset + xx + 1], s[offset + xx + 4],
s[offset + xx + 2] << 8 | s[offset + xx + 3],
s[offset + xx + 6] << 8 | s[offset + xx + 7]);
printf("* wds: ");
for (k = 0; k < s[offset+xx+4] - 8; k++) {
  if (k > 0 && (k % 4 == 0)) {
   if ((k % 20 == 0)) printf("\n");
   else printf(" ");
  }
  printf("%.2x", s[offset + xx + 8 + k]);
}
printf("\n");
    			    break;
    			case 0x50:		/* array parameters */
printf("* array param dims: %d bnds: %d len: %d lbflags %x sbflags %x\n",
s[offset + 20], s[offset + 21], s[offset + 24],
s[offset + 22] << 8 | s[offset + 23],
s[offset + 26] << 8 | s[offset + 27]);
printf("* wds: ");
for (k = 0; k < s[offset+24] - 8; k++) {
  if (k > 0 && (k % 20 == 0)) printf("\n");
  printf("%.2x ", s[offset + 28 + k]);
}
printf("\n");
    			    break;
    			case 0x01:		/* CSECT */
    			case 0x02:		/* absolute address */
    			case 0x10:		/* parameter/stack variable */
    			case 0x20:		/* ext memory address/pointer */
printf("* unprocessed flags %x\n", s[offset+3]);
    			default:
jumpit:
    			    printf("* Encore record flags = %x\n",
    			      s[offset + 3]);
    		    printf("Encore debugger info (hex dump)\n");
    		    for (k = 0; k < s[offset+2]; k++) {
    			if (k > 0 && (k % 20 == 0)) printf("\n");
    			printf("%.2x ", s[offset + k]);
    		    }
    		    printf("\n");
    			    break;
    		    }
    		}
wedone:
    		    offset += s[offset + 2];
    		    break;
    		case 15:		/* undefined */
    		    for (k = 0; k < s[offset+2]; k++) {
    			if (k > 0 && (k % 20 == 0)) printf("\n");
    			printf("%.2x ", s[offset + k]);
    		    }
    		    printf("\n");
    		    offset += s[offset + 2];
    		    break;
    	    }
    	    break;
    	case 14:		/* common origin */
    	    /* get common block number */
    	    repeat = s[offset + 1];
    	    /* get common size */
    	    bound = s[offset + 2] << 8 |
    		s[offset + 3];
    	    printf("common origin block = %x origin = %x\n",
    	      repeat, bound);
    	    offset += (objcnt + 1);
    	    break;
    	case 15:		/* object termination */
#ifdef QUIET
    	    printf("program object termination\n");
#endif
    	    offset += (objcnt + 1);

	    /* define dsect start */
	    strcpy(pdefp->name, "DS");	/* dsect start */
	    ndefr++;			/* next reference */
	    pdefp->refa = sect_base[0];	/* section start */
	    pdefp++;

	    if (sect_size[1]) {
		/* define csect start */
		strcpy(pdefp->name, "CS");	/* dsect start */
		ndefr++;			/* next reference */
		pdefp->refa = sect_base[0];	/* section start */
		pdefp++;
	    }

	    /* dump csect/dsect */
	    curr_sect = 0;		/* dsect */
	    /* if no size given, use last origin address */
	    if (sect_size[curr_sect] == 0)
		sect_size[0] = sect_org[0];
#ifdef NODUMP
	    printf("DSECT contents %x bytes\n", sect_size[0]);
	    sa = sect_addr[0];		/* address of section */
	    temp2 = 0;
	    for (j = 0; j < sect_size[0]; j += 4) {
		printf("%.4x ", j);
		for (i = 0; i < 4; i++) {
		    printf("%0.2x", sa[j + i]);
		}
		printf(" ");
		for (i = 0; i < 4; i++) {
		    if (sa[j + i] >= 0x20 && sa[j + i] < 0x7f)
			printf("%c", sa[j + i]);
		    else
			printf(".", sa[j + i]);
		}
		printf("\n");
	    }
#endif
	    if (sect_size[0]) 
		trace(0);		/* trace the instructions */

	    curr_sect = 1;		/* csect */
#ifdef NODUMP
	    printf("CSECT contents %x bytes\n", sect_size[1]);
	    sa = sect_addr[1];		/* address of section */
	    temp2 = 0;
	    for (j = 0; j < sect_size[1]; j += 4) {
		printf("%.4x ", j);
		for (i = 0; i < 4; i++) {
		    printf("%02x", sa[j + i]);
		}
		printf(" ");
		for (i = 0; i < 4; i++) {
		    if (sa[j + i] >= 0x20 && sa[j + i] < 0x7f)
			printf("%c", sa[j + i]);
		    else
			printf(".", sa[j + i]);
		}
		printf("\n");
	    }
#endif
	    if (sect_size[1])
		trace(1);		/* trace the instructions */
    	    break;
    }
    goto doit;
}

unsigned char line [BUFSIZ];
int cmpop =0;
int cmpflg =0;
int bcnt = 0;
unsigned char *bptr = 0;
int recl = 0;

int rbl (buf, n)
unsigned char *buf;
int n;
{
  int count = 0;
  unsigned char *cp;
  int i;

  unsigned char *linadrs = line;

  if (!cmpop) {    /* see if we tested for compressed */
    cmpop = 1;     /* set comp tested flag */
    /* read in the first record */
    if ((recl = getloi(line, BUFSIZ)) == 0)return (0);	/* this means eof */
    linadrs = line;
    if (*linadrs == 0xbf || *linadrs == 0x9f) { /* is this file compressed */
      cmpflg = 1; /* set comp data flag */
      bcnt = linadrs[1];     /* set record count */
      bptr = &linadrs[6];      /* set data address */
    } else goto re00;
  }

  if (cmpflg) {      /* reading compressed data? */
    if (bcnt == 0) { /* any data left in buffer */
re18:
      /* read in a data record */
    if ((recl = getloi(line, BUFSIZ)) == 0)return (0);	/* this means eof */
      linadrs = line;
      if ((*linadrs & 0xdf) != 0x9f)    /* is this valid rec */
        return (EOF);         /* error if not */
      bcnt = linadrs[1];     /* set record count */
      bptr = &linadrs[6];      /* set data address */
    }
re20:
    /* see if any blanks */
    if (i = *bptr++) {       /* next buffer pointer */
      if (i == 0xff)goto re60;      /* if eol, get out */
      while (i--) {
        if(count < n) {
          *buf++ = ' ';       /* put blank in buffer */
          count++;
        }
      }
    }
      if (--bcnt <= 0)goto re18; /* read next record */

    if (i = *bptr++) {       /* next buffer pointer */
      while (i--) {
        if(count < n)
          *buf++ = *bptr;  /* put char in buffer */
          bcnt--;        /* decr count */
        bptr++;        /* next buffer pointer */
        count++;
      }
    }
      if (--bcnt <= 0)goto re18; /* read next record */
    goto re20;

re60:
    bcnt--;		/* decr count */
    if ((*--buf == ' ') && (count == 1)) {
      *buf = '\n';	/* put new line at eol */
      *++buf = '\0';    /* put new line at eol */
    } else {
      count++;
      *++buf = '\n';    /* put new line at eol */
      *++buf = '\0';    /* put new line at eol */
    }
/* printf("ret cnt = %ld\n", count); */
    return (count);

  } else {

    /* non compressed read here */

    /* read the next record */
    if ((recl = getloi(line, BUFSIZ)) == 0)return (0);	/* this means eof */

re00:
    /* here we need to strip off blank put in during write */
    /* this is because mpx does not support zero length blocks */
    if(!binary) {
    	if ((recl == 1) && (*linadrs == ' ')) recl = 0;
    	/* now append new line to end of buffer */
    	*(cp = linadrs + recl) = '\n';       /* point to last char */
    } else {
    	cp = linadrs + recl - 1;       /* point to last char */
    }

    /* copy this layer buffer to upper caller's buffer */

/* printf ("recl = %x, cp = %x, linadrs = %x\n", recl, cp, linadrs); */
    while (count < n) {
      if (linadrs > cp) break;
      *buf++ = *linadrs++;
      count++;
    }
  }

/* printf("ret1 cnt = %ld\n", count); */
  return (count);

}

/*~!bbio.c*/
/* Name:  bbio.c Part No.: _______-____r
 *
 * Copyright 1991 - J B Systems, Morrison, CO
 *
 * The recipient of this product specifically agrees not to distribute,
 * disclose, or disseminate in any way, to any one, nor use for its own
 * benefit, or the benefit of others, any information contained  herein
 * without the expressed written consent of J B Systems.
 *
 *                     RESTRICTED RIGHTS LEGEND
 *
 * Use, duplication, or disclosure by the Government is  subject  to
 * restriction  as  set forth in paragraph (b) (3) (B) of the Rights
 * in Technical Data and Computer Software  Clause  in  DAR  7-104.9
 * (a).
 */

#ident	"@(#)nbrtl:bbio.c	1.0"

#include <stdio.h>

/********************************************************************/
/* These routines handle blocked and optionally compressed MPX files */

#define IOCMAX 10	/* start with 10 for now */

struct ioc {
    int 	iofcb;	/* fcb for i/o */
    int		afcb;	/* callers fcb address */
    unsigned char *	bufaddr;/* callers buffer address */
    int		bufcnt;	/* callers buffer size */
    unsigned char *	cba;	/* current buffer address */
    unsigned char *	rcba;	/* record control block pointer */
    int		cpp;	/* current pool position */
    int		cfp;	/* current file position */
    char	cbn;	/* current buffer number */
    char	nab;	/* number of active buffers */
    struct {		/* ioc bit flags */
    	unsigned openop	 : 1;	/* open flag */
    	unsigned writop	 : 1;	/* last op was write */
    	unsigned outaop	 : 1;	/* output active flag */
	unsigned compop	 : 1;	/* if set, tested for comp'ed file */
	unsigned cmpflg	 : 1;	/* if set, reading comp'ed file */
	unsigned iocaloc : 1;	/* ioc allocated */
	unsigned free	 : 3;	/* free flags, available */
    } flag;
    int	bcnt;	/* compressed rec cur count */
    unsigned char *	bptr;	/* compressed rec pointer */
    unsigned char *	bufa;	/* start of contiguous buffers */
};

struct ioc iocx[IOCMAX];

#define ERRFLAG 0x04000000
#define EOFFLAG 0x02000000
#define EOMFLAG 0x01000000

#define RCBEOF 0x80 /* bit 0 */
#define RCBBOB 0x40 /* bit 1 */
#define RCBEOB 0x20 /* bit 2 */
#define RCBNULL 0x10 /* bit 3 */
#define RCBCONT 0x08 /* bit 4 */

#define SBLR 0
#define BCLR 1
#define SBTR 2
#define BCTR 3

#define BLKSIZE 768
#define BLKS (10*BLKSIZE)

/* ircont - establish ioc address for this fcb */
/* input - file number */
/* output - ioc address */
struct ioc * ircont (cfcb)
int cfcb;
{
    int	i;
    struct ioc * wioc;	/* current ioc */

    for (i = 0, wioc = &iocx[0]; i < IOCMAX; wioc = &iocx[++i]) {
    	if (wioc->flag.iocaloc)
    	    if (wioc->afcb == cfcb) {
    		return(wioc);
    	    }
    }
    /* not yet allocated, get a new one */
    for (i = 0, wioc = &iocx[0]; i < IOCMAX; wioc = &iocx[++i]) {
    	if (!wioc->flag.iocaloc) {
    	    wioc->flag.iocaloc = 1;	/* ioc allocated */
    	    if((wioc->bufa = (unsigned char *)malloc(BLKS)) <= 0) {
    		fprintf(stderr, "ioc malloc error\n");
    		return (0);
    	    }
    	    /* initialize new ioc */
    	    wioc->afcb = cfcb;		/* save callers fcb address */
    	    wioc->iofcb = cfcb;		/* use callers fcb for I/O */
    	    wioc->cba = wioc->bufa;	/* set buffer addr in fcb */
    	    wioc->cbn = 0;		/* no curr buf number */
    	    wioc->nab = 0;		/* no active bufs */
    	    /* clear flags */
    	    wioc->flag.openop = 0;	/* open ioc */
    	    wioc->flag.writop = 0;
    	    wioc->flag.outaop = 0;
    	    wioc->flag.compop = 0;
    	    wioc->flag.cmpflg = 0;
    	    wioc->cpp = 0;		/* pool empty */
    	    wioc->bcnt = 0;		/* no compress cnt */
    	    wioc->bptr = 0;		/* no pointer either */
    	    wioc->cfp = 1;		/* curr position is 1st blk */
    	    return (wioc);
    	}
    }
    fprintf(stderr, "no ioc space left\n");
    return (0);
}

/* rmopen - open up a file stream */
rmopen (cfcb)
int cfcb;
{
    struct ioc * wioc;

    wioc = ircont(cfcb);
    if(wioc->flag.openop)
    	return(1);		/* return o.k. */
    /* not open yet, do open */
    wioc->flag.openop = 1;	/* mark open */
    return(1);			/* return o.k. */
}

/* rmclose - close a file stream */
rmclose (cfcb)
int cfcb;
{
    struct ioc * wioc;

    wioc = ircont (cfcb);
    if(!wioc->flag.openop)
    	return(1);		/* if not open, return o.k. */
    /* open, do close */
    wioc->flag.openop = 0;	/* mark closed */
    wioc->flag.iocaloc = 0;	/* mark unallocated */
    free (wioc->bufa);		/* free buffer */
    return (1);
}

/* rmread - read from file stream */
rmread (cfcb, buffer)
int cfcb;
unsigned char * buffer;
{
    struct ioc * wioc;
    int	fillcnt, i, bytecnt;
    unsigned char * buffp;

    rmopen(cfcb);		/* make sure open */
    wioc = ircont (cfcb);
    if (wioc->flag.writop)
    	fprintf(stderr, "read after write not allowed");
    if (wioc->cpp == 0) {	/* if no data in pool yet, read it in */
    	bfredf (wioc);		/* read in a block */
    	wioc->rcba = wioc->cba + 4;
    	/* have we tested for comp data yet */
    	if(!wioc->flag.compop) {
    	    wioc->flag.compop = 1;
    	    /* test for comp rec */
    	    if (wioc->rcba[4] == 0xbf || wioc->rcba[4] == 0x9f) {
    		wioc->flag.cmpflg = 1;	/* this is comp data */
    		wioc->bcnt = 0;		/* init pointer */
    	    }
    	}
    }
    bytecnt = 0;		/* no bytes to caller yet */
    buffp = buffer;		/* save caller buff addr */
    if (wioc->flag.cmpflg) 	/* reading compressed */
    	if (wioc->bcnt)
    	    goto re07; 		/* any data left */
re18:
    if (wioc->rcba[SBLR] & RCBEOB) {
re06:
    	if (bfredf(wioc) == -1)
    	    return(-1);
    	wioc->rcba = wioc->cba + 4;
    }
#define JIM	/* define for non-library reading */
#ifdef JIM
    if (wioc->rcba[SBTR] & RCBEOF) {
#else
    if (wioc->rcba[SBTR] & RCBEOF) {
    	wioc->rcba[SBTR] &= ~RCBEOF;
    	goto re06;
#endif
re05:
    	return(-1);	/* return EOF */
    }
    if (wioc->flag.cmpflg) {	/* reading compressed */
    	if ((wioc->rcba[4] & 0xdf) != 0x9f) {
    	    return(-1);		/* return EOF */
    	}
    	wioc->bptr = wioc->rcba + 10;	/* first data byte */
    	wioc->bcnt = wioc->rcba[5];	/* get bytes this record */
    	if (wioc->bcnt == 0) {
re10:
    	    wioc->rcba += (wioc->rcba[BCTR] + 4);
    	    goto re18;
    	}
re07:
    	if (*wioc->bptr) {		/* got blanks */
    	    if (*wioc->bptr == 0xff) {
    		wioc->bptr++;
    		if(--wioc->bcnt == 0) {
    		    wioc->rcba += (wioc->rcba[BCTR] + 4);
    		    wioc->bptr = wioc->rcba + 10;
    		}
    		wioc->bufcnt = bytecnt;
    		return (bytecnt);
    	    }
    	    for (i = *wioc->bptr; i; *buffp++ = ' ', i--, bytecnt++);
    	}
    	wioc->bptr++;
    	if (--wioc->bcnt > 0) {
    	    if (i = *wioc->bptr) {
    		wioc->bptr++;
    		wioc->bcnt--;
    		for (; i; i--) {
    		    *buffp++ = *wioc->bptr++;
    		    bytecnt++;
    		    wioc->bcnt--;
    		}
    		if (wioc->bcnt)
    		    goto re07;
    		goto re10;
    	    }
re24:
    	    wioc->bptr++;
    	    if (--wioc->bcnt > 0)
    		goto re07;
    	}
    	goto re10;
    }

    /* process uncompressed record */
    wioc->bufcnt = wioc->rcba[BCTR];
    for (i = 0; i < wioc->bufcnt; i++)
    	buffer[i] = wioc->rcba[i+4];
    wioc->rcba += (wioc->rcba[BCTR] + 4);
    return (wioc->bufcnt);
}

/* bfredf - read next buffer from file stream */
bfredf (wioc)
struct ioc * wioc;
{
    unsigned char * cbaddr;

    /* see if next buffer in memory */
    if (wioc->cbn >= wioc->nab) {
    	/* no, read in next pool */
    	if (plredf(wioc) == -1)	/* read next pool */
    	    return(-1);		/* show EOF */
    	wioc->cbn = 1;	/* we start at 1st buffer */
    	cbaddr = wioc->bufa;	/* reset address pointer */
    } else {
    	wioc->cbn++;	/* bump buffer number */
    	cbaddr = wioc->cba + BLKSIZE;	/* next buffer address */
    }
    wioc->cba = cbaddr;	/* set new address */
    /* check for cnt < 0x300 (768) */
    /* check for BOB on in control bits */
    return(1);			/* return O.K. */
}

/* plredf - read next buffer pool from file stream */
plredf (wioc)
struct ioc * wioc;
{
    int retc;

    /* read the file */
    retc = read(wioc->iofcb, wioc->bufa, BLKS);
    if (retc <= 0) {
    	return (-1);		/* show EOF for error */
    }
    /* compute # of block we read */
    wioc->nab = (retc + BLKSIZE-1) / BLKSIZE;
    wioc->cpp = wioc->cfp;	/* update curr pool position */
    wioc->cfp += wioc->nab;	/* update current file position */
}

/*
 * initialize print buffer
 */
char dobuf[134];		/* the data buffer */
char *dbp;			/* data buffer pointer */

void init_print()		/* initialize print buffer */
{
dii:
	memset(dobuf, ' ', 133);	/* blank buffer */
	dobuf[133] = '\0';
	dbp = dobuf;		/* start at beginning */
}

/*
 * Dump symbolically without executing it
 */

/*
 * Instruction trace routine
 * psw - current execution address
 */

unsigned int psw;		/* current address */
unsigned int addr;		/* current address */
unsigned int userloc;		/* current address */
int tr_stop;			/* last loc to trace */
unsigned int instr;		/* the instruction */
unsigned int oinstr;		/* the instruction */
unsigned opcode;		/* the instruction opcode */
unsigned int opcode;		/* 6 bit opcode << 2 */
unsigned int aug;		/* any augmend */
unsigned int pflags;		/* calm flags */
#define immed pflags		/* immed value */
#define tdcd pflags		/* cd/td value */
#define prot pflags		/* prot reg value */
unsigned int opaddr;		/* operand address */
unsigned int rd;		/* dest reg */
unsigned int rs;		/* source reg */
unsigned int shift;		/* shift value */
#define bit shift		/* bit values */
#define condit shift		/* condition codes */
unsigned int plevel;		/* prority level */
unsigned int indir;		/* indirect value */
unsigned int indflg;		/* indirect flag */
unsigned int xreg;		/* index reg num */
unsigned int idflags;		/* instruction processing flags */
int	insx;			/* store index value */
int	length;			/* instruction length */

void trace(int sect)
{
	unsigned int tmpa;	/* a temp */
	unsigned int *insptr;	/* wd bounded instruction ptr */
	int k;

	psw = sect_base[sect];		/* starting psw */
	tr_stop = sect_base[sect] + sect_size[sect];
tce:
#ifdef QUIET1
printf("trace psw = %x\n", psw);
fflush(stdout);
#endif
	init_print();			/* initialize print buffer */
	insx = 0;
	psw &= 0x7fffe;			/* .5mb addr */
	addr = userloc = psw;		/* .5mb addr */
	if (addr >= tr_stop) {		/* see if at last address */
	    strncpy(&dobuf[10], "END", 3);
	    insx = 19;			/* where to start */
	    length = 4;			/* got 4 byte instr */
	    if (endaddr) {
		opaddr = endaddr;	/* where we are */
		eaout();		/* publish address */
		instr = endaddr;
		asciiout(length);
	    }
	    /* print the line */
	    insx = strlen(dobuf) - 1;	/* length of buffer */
	    while (insx > 0 && dobuf[insx--] == ' ')
		dobuf[insx+1] = '\0';	/* trim trailing blanks */
	    printf("%s\n", dobuf);
	    return;			/* return, done */
	}
#ifndef LATER
/*	symbol(addr, 1);		/* check for matching base addr */
	symbol(addr, addr, 1);		/* output label */
#endif
	tmpa = addr & ~3;		/* word bound addr */
	psw += 2;			/* incr to next hw boundry */
	sa = sect_addr[sect];		/* address of section */
	instr = 0;
	for (k = 0; k < 4; k++) {
	    instr = (instr << 8) | sa[tmpa -  sect_base[sect] + k];
	}
	oinstr = instr;			/* save original instruction */
	length = 4;			/* got 4 byte instr */
	if (instr == 0) {		/* see if all zero */
dodataw:
		/* assume dataw */
		dataout(instr);		/* dump data word */
		psw += 2;		/* incr to next hw boundry */
		goto bloadout;		/* continue */

	}
#ifdef QUIET1
printf("trace instr = %x\n", instr);
fflush(stdout);
#endif
	if (addr & 2) {			/* is instr in rt hw boundry */
		/* yes, process rt halfword opcode */
		tmpa = ((instr << 16) | 2);	/* move instr to lf hw and */
					/* put nop in rt hw */
		psw |= 0x02000000;	/* set rt hw instr in psw */
		length = 2;		/* got 2 byte instr */
		if (tmpa & 0x80000000) {	/* is it really a hw instr? */
		    datahout(tmpa >> 16);	/* dump data halfword */
		    goto bloadout;		/* continue */
/*		    goto undef;		/* no, cannot decode */
		}
		instr = tmpa;		/* new instruction */
	} else {			/* must be fw instruction */
		/* process fullword instructions */
		tmpa = ((instr >> 26) << 2);	/* isolate opcode */
		/* opcodes 50, 54, 58, and 5c are fw instructions */
		/* so is 34 (la instr) */
		/* bit 0 on means fw instr */
		/* if rt hw is nop, treat as fw instr */
		if (tmpa == 0x34 ||
		    (tmpa & 0xf0) == 0x50 || 
		    instr & 0x80000000 ||
		    ((instr != 0x20002) & (instr & 0xffff) == 2)) {
			/* we have word alligned instruction */
			psw += 2;	/* incr to next hw boundry */
			length = 4;	/* got 4 byte instr */
		} else {		/* lhw instruction */
			/* we have hw instr in left hw */
			length = 2;	/* got 2 byte instr */
		}
	}
	aug = 0;			/* clear aug */
	opcode = ((instr >> 26) << 2);	/* isolate opcode */
	
#ifdef QUIET1
printf("trace opcode = %x\n", opcode);
fflush(stdout);
#endif
	switch (opcode) {		/* service opcode */
	default:
	case 0x48:
	case 0x4c:
	case 0x50:
		goto undef;		/* undefined */
	case 0x34:
	case 0x58:
	case 0x80:
	case 0xcc:
	case 0xd0:
	case 0xdc:
		goto bust1;
	case 0x00:
	case 0x04:
	case 0x08:
	case 0x0c:
	case 0x10:
	case 0x14:
	case 0x28:
	case 0x2c:
	case 0x38:
	case 0x3c:
	case 0x40:
	case 0x44:
	case 0x60:
	case 0x64:
	case 0x68:
		goto bust2;
	case 0x18:
	case 0x1c:
	case 0x20:
	case 0x24:
		goto bust3;
	case 0x30:
		goto bust4;
	case 0x6c:
	case 0x70:
	case 0x74:
	case 0x78:
	case 0x7c:
		goto bust5;
	case 0x54:
	case 0x5c:
	case 0x84:
	case 0x88:
	case 0x8c:
	case 0x90:
	case 0x94:
	case 0xac:
	case 0xb0:
	case 0xb4:
	case 0xb8:
	case 0xbc:
	case 0xc0:
	case 0xc4:
	case 0xd4:
	case 0xd8:
	case 0xe8:
		goto bust6;
	case 0x98:
	case 0x9c:
	case 0xa0:
	case 0xa4:
		goto bust7;
	case 0xc8:
		goto bust8;
	case 0xe0:
	case 0xe4:
		goto bust9;
	case 0xec:
	case 0xf0:
		goto bust10;
	case 0xa8:
	case 0xf8:
		goto bust11;
	case 0xf4:
		goto bust12;
	case 0xfc:
		goto bust13;
	}
printf("switch failure opcode = %x\n", opcode);
fflush(stdout);
/*
 ***********************************************************************
 *                                                                     *
 *                 BUST ROUTINES                                       *
 *                                                                     *
 ***********************************************************************
 *       These routines isolate and store the data from the user's
 *       instruction, according to the instruction format.
 */

/*
 *                  Undefined instruction processor.
 */
undef:
#ifdef OLDWAY
	opcode = 0xff;			/* force opcode/aug to undefined */
	aug = 0xff;			/* force opcode/aug to undefined */
	goto bufload;			/* publish */
#else
	if (length == 4)
	    dataout(instr);		/* dump data word */
	else
	    datahout(instr >> 16);	/* dump data halfword */
	goto bloadout;		/* continue */
#endif
/*
 *       Instructions lf , stf , lea , la
 *
 *  Instructions:  Non-Base (34,80,cc,d0,dc,58)  These are the
 *                     opcodes for la,stf,lea,lf,stfbr,lfbr,lcra
 */

bust1:
	tmpa = (instr >> 16) & 0xfc08;	/* shift for opcd & aug */
	if (tmpa == 0xcc08 ||		/* lfbr */
	    tmpa == 0xdc08) {		/* stfbr */
		instr &= ~0x02000000;	/* clear aug bit */
		aug = tmpa & 0xff;	/* save stfbr aug code */
	}
	rd = (instr >> 23) & 7;		/* save reg number b6-b8 */
	xreg = (instr >> 21) & 3;	/* save index reg number b9-b10 */
	indir = (instr >> 20) & 1;	/* save indir bit b11 */
	opaddr = instr & 0xfffff;	/* save operand addr b12-b31 */
	goto bufload;			/* publish */
/*
 *        For op-codes=00,04,08,0c,10,14,28,2c,38,3c,40,44,60,64,68
 */
bust2:
	rd = (instr >> 23) & 7;		/* save reg number b6-b8 */
	rs = (instr >> 20) & 7;		/* save reg number b9-b11 */
	aug = (instr >> 16) & 0xf;	/* save aug code b12-b15 */
	if (opcode == 0x0c && aug == 0) {	/* is it eor */
		/* yes, see if rs == rd, if yes zr instruction */
		if (rs == rd)		/* test for zr instr */
			aug |= 0x10;	/* setup for zr */
		goto bufload;		/* publish */
	} else if (opcode == 0x68 && aug == 0) {/* see if scz instr */
		/* yes, swap rs & rd */
		tmpa = rd;		/* get dest reg */
		rd =rs;			/* swap rs/rd */
		rs = tmpa;		/* set src reg */
	}
	goto bufload;			/* publish */
/*
 *        For instructions=sbr,zbr,abr,tbr
 */
bust3:
	bit = (instr >> 23) & 7;	/* save bit number b6-b8 */
	rd = (instr >> 20) & 7;		/* save dest reg number b9-b11 */
	tmpa = (instr >> 16) & 3;	/* get byte field b14-b15 */
	bit += (tmpa << 3);		/* add to bit field */
	goto bufload;			/* publish */
/*
 *        For instructions=calm
 */
bust4:
	pflags = (instr >> 16) & 0x3ff;	/* get calm num b6-b15 */
	goto bufload;			/* publish */
/*
 *       For op-codes=6c,70,74,78,7c (shifts)
 */
bust5:
	rd = (instr >> 23) & 7;		/* save dest reg number b6-b8 */
	aug = (instr >> 22) & 1;	/* save aug code b9 */
	shift = (instr >> 16) & 0x1f;	/* save shift val b11-b15 */
	goto bufload;			/* publish */
/*
 *        For op-codes=84,88,8c,90,94,ac,b0,b4,b8,bc,c0,c4,d4,d8,e8,54,5c
 */
bust6:
	rd = (instr >> 23) & 7;		/* save dest reg number b6-b8 */
	xreg = (instr >> 21) & 3;	/* save index reg number b9-b10 */
	indir = (instr >> 20) & 1;	/* save indir bit b11 */
	opaddr = instr & 0xfffff;	/* save operand addr b12-b31 */
	aug = augmr(opaddr);		/* mem ref type using f & c bits */
	goto bufload;			/* publish */
/*
 *       For instructions=sbm,zbm,abm,tbm,exm
 */
bust7:
	bit = (instr >> 23) & 7;	/* save bit number b6-b8 */
	xreg = (instr >> 21) & 3;	/* save index reg number b9-b10 */
	indir = (instr >> 20) & 1;	/* save indir bit b11 */
	opaddr = instr & 0xfffff;	/* save operand addr b12-b31 */
	goto bufload;			/* publish */
/*
 *        For instructions=li,adi,sui,mpi,dvi,ci,exr,exrr
 *                  also the svc and tc instruction
 */
bust8:
	rd = (instr >> 23) & 7;		/* save dest reg number b6-b8 */
	rs = (instr >> 20) & 7;		/* save reg number b9-b11 */
	aug = (instr >> 16) & 0xf;	/* save aug code b12-b15 */
	if (aug == 7) {			/* exr or exrr */
		/* yes, see if exr or exrr */
		if (instr & 2) {	/* exrr? */
			aug |= 0x10;	/* show as exrr */
		}
		goto bufload;		/* publish */
	}
	if (((instr >> 16) & 0xffff) == 0xc806) {	/* see if SVC */
		/* yes, get svc type # */
		bit = (instr >> 12) & 0xf;	/* save svc type # b16-b19 */
		immed = (instr & 0xfff);	/* save svc # */
		goto bufload;			/* publish */
	}
	/* immed op, sign extend immed value */
	immed = instr & 0xffff;			/* 16 bit value */
	if (instr & 0x8000)			/* negative? */
		immed |= 0xffff0000;		/* sign extend */
	goto bufload;				/* publish */
/*
 *        For instructions=sufw,sufd,adfw,adfd,dvfw,dvfd,mpfw,mpfd
 */
bust9:
	rd = (instr >> 23) & 7;		/* save dest reg number b6-b8 */
	xreg = (instr >> 21) & 3;	/* save index reg number b9-b10 */
	indir = (instr >> 20) & 1;	/* save indir bit b11 */
	aug = (instr >> 19) & 1;	/* save float pt aug bit b12 */
	aug <<= 4;			/* position for later */
	opaddr = instr & 0x7ffff;	/* save operand addr b13-b31 */
	aug += augmr(opaddr);		/* mem ref type using c bits */
					/* add to aug */
	goto bufload;			/* publish */
/*
 *        For instructions=bu,bct,bft,bcf
 *                  and special codes bs,bgt,blt,beq,bge,ble,bany
 *                  bns,bnp,bnn,bne,baz
 */
bust10:
	condit = (instr >> 23) & 7;	/* save cond codes b6-b8 */
	aug = condit == 0 ? 0 : 1;	/* if cond = 0, aug = 0, else 1 */
	xreg = (instr >> 21) & 3;	/* save index reg number b9-b10 */
	indir = (instr >> 20) & 1;	/* save indir bit b11 */
					/* clear bit 31, assm error */
	opaddr = instr & 0xffffe;	/* save branch addr b12-b31 */
	goto bufload;			/* publish */
/*
 *        For instructions=bl,bri,trp,tpr,zmb,zmh,zmw,zmd
 */
bust11:
	indflg = 0;				/* clear indirect flag */
	aug = (instr >> 23) & 7;		/* save init aug code b6-b8 */
	if (aug == 4) {				/* check for jwcs instr */
		/* yes, special case */
		xreg = (instr >> 21) & 3;	/* save index reg b9-b10 */
		indir = (instr >> 20) & 1;	/* save indir bit b11 */
		if (indir)			/* if indirect, set flag */
			indflg = 1;		/* set indirect flag */
		prot = instr & 0xffff;		/* save addr b16-b31 */
		goto bufload;			/* publish */
	} else if ((aug == 5) ||		/* check for lpsdcm instr */
	   (instr & 0x02000000) == 0) {		/* or no bit 0 of aug */
		/* yes, special case */
		rd = 0;				/* no dest reg */
		xreg = (instr >> 21) & 3;	/* save index reg b9-b10 */
		indir = (instr >> 20) & 1;	/* save indir bit b11 */
		opaddr = instr & 0xfffff;	/* save op addr b12-b31 */
		tmpa = opaddr;			/* save for zmx instr */
		opaddr &= 0xffffe;		/* clear bit 31, assm err */
		if (aug == 0) {			/* zmx instr? */
			opaddr = tmpa;		/* restore op addr with goof */
			aug = augmr(opaddr);	/* mem ref type using c bits */
			aug <<= 4;		/* position for later */
		}
		goto bufload;			/* publish */
	} else {				/* trp instr */
		prot = (instr >> 19) & 0xf;	/* save prot reg b9-b12 */
		rd = (instr >> 16) & 7;		/* save dest reg num b13-b15 */
		goto bufload;			/* publish */
	}
/*
 *        For instructions=bib,bih,biw,bid
 */
bust12:
	rd = (instr >> 23) & 7;		/* save dest reg b6-b8 */
	aug = (instr >> 21) & 3;	/* save aug b9-b10 */
	indir = (instr >> 20) & 1;	/* save indir bit b11 */
	opaddr = instr & 0xffffe;	/* save op addr b12-b31 */
					/* without assm goof */
	xreg = 0;			/* no xr */
	goto bufload;			/* publish */
/*
 *        For instructions=ei,di,ri,ai,dai,td,cd,xio
 */
bust13:
	plevel = (instr >> 19) & 0x3f;	/* save pri level b6-b12 */
	xreg = (instr >> 23) & 7;	/* save reg for xio b6-b8 */
	bit = (instr >> 19) & 0xf;	/* save type for xio b9-b12 */
	aug = (instr >> 16) & 7;	/* save aug for xio b13-b15 */
	if (aug == 7)			/* xio if aug == 7 */
		aug += bit;		/* combine for aug 9 - 16 */
	tdcd = instr & 0xffff;		/* save cd td info b16-b31 */
	goto bufload;			/* publish */

/*
 * bufload
 * Loads the do buffer with all information concerning the
 * current instruction.
 */
bufload:
	mnemout();		/* load mnemonic and idflags */
#ifdef QUIET1
printf("bufload entry - idflags %x, aug %x, xreg %x, rs %x, rd %x bit %x immed %x\n",
    idflags, aug, xreg, rs, rd, bit, immed);
fflush(stdout);
#endif
	insx = 19;		/* buffer index for regs */
	if (idflags & 0x8000)	/* rs or just r? */
		rsout();	/* output rs */
	if (idflags & 0x4000)	/* rd or just r? */
		rdout();	/* output rd */
	if (idflags & 0x2000)	/* dbl reg or just r? */
		rdout();	/* output dbl reg */
	if (opcode != 0xfc)	/* is it I/O instr? */
		goto bufx;	/* no, process others */
	if (aug < 0x07)		/* is this an xio instruction */
		goto bufxx;	/* yes, skip ahead */
	if (xreg == 0)		/* index defined? */
		goto bufxx;	/* no, skip ahead */
	dobuf[insx++] = 'R';	/* we have a reg, put in output */
	dobuf[insx++] = xreg + '0';	/* put in reg number */
	dobuf[insx++] = ',';	/* put in seperator */
	goto bufxx;		/* ignore cc's for now */
	/* Not I/O */
bufx:
	if (idflags & 0x10)	/* is this branch instr */
		goto bufxx;	/* skip cc's if yes */
	if (idflags & 0x1000)	/* bit, condition or shift field */
		bcsout();	/* yes, go output */
bufxx:
	if (idflags & 0x0800)	/* pri lev or dev addr? */
		pdout();	/* yes, go output */
	if (idflags & 0x0400) {	/* prog flags, immed op, cd/td code? */
		if (indflg) {	/* indirect? */
			if (indir)	/* got indirect */
				dobuf[insx++] = '*';	/* insert indir ind */
			indir = 0;	/* clear flag */
		}
		pictout();	/* output immed ops, cd/td */
	}
	if (idflags & 0x0200)	/* indirect indicator used? */
		if (indir)	/* got indirect */
			dobuf[insx++] = '*';	/* insert indir ind */
	if (idflags & 0x0100)	/* effective addr? */
		eaout();	/* output effective addr */
	if (idflags & 0x0100)	/* index reg? */
		xout();		/* output index reg */
	insx = 0;		/* clear instr store index */
bloadout:
	/* dump instruction/data in ascii */
	asciiout(length);
	/* print the line */
	insx = strlen(dobuf) - 1;	/* length of buffer */
	while (insx > 0 && dobuf[insx--] == ' ')
		dobuf[insx+1] = '\0';	/* trim trailing blanks */
	printf("%s\n", dobuf);
	userloc = psw & 0x7fffe;	/* clean psw */
	goto tce;			/* go do next instr */
}

/*
 * Output ascii of instruction.
 */
void asciiout(int length)
{
	char tb[32];			/* temp buffer */
	int sx = 42;			/* where to dump it */
	unsigned int ldata = instr;	/* what to dump */
	int i, k;			/* temp */

	
	dobuf[sx++] = 'X';		/* insert X */
	dobuf[sx++] = '\'';		/* insert ' */
	if (length == 4)
	    sprintf(tb, "%.8x", instr);	/* bin to hex */
	else
	    sprintf(tb, "%.4x", instr >> 16);	/* bin to hex */
	strncpy(&dobuf[sx], tb, strlen(tb));	/* copy data */
	sx += strlen(tb);		/* new position */
	dobuf[sx++] = '\'';		/* insert ' */
	sx = 54;			/* ascii data */
	dobuf[sx++] = 'C';		/* insert comma */
	dobuf[sx++] = '\'';		/* insert ' */
	for (i = 0; i < length; i++) {
		k = ldata >> 24;	/* 1st char */
		ldata <<= 8;		/* next one */
		if (k < 0x20 || k >= 0x7f)	/* unprintable */
			dobuf[sx++] = '.';	/* insert ' */
		else 
			dobuf[sx++] = k;	/* insert ' */
			
	}
	dobuf[sx++] = '\'';		/* insert ' */
}

/*
 *        Check for bct/bcf type branches
 */
void mneb()			/* br type processing */
{
	if (opcode == 0xec) {	/* is op bct */
		switch (condit & 7) {	/* what type */
		case 0:			/* bu */
			break;		/* nothing to do */
		case 1:			/* bs */
			strncpy(&dobuf[10], "BS  ", 4);
			break;		/* done */
		case 2:			/* bgt */
			strncpy(&dobuf[10], "BGT ", 4);
			break;		/* done */
		case 3:			/* blt */
			strncpy(&dobuf[10], "BLT ", 4);
			break;		/* done */
		case 4:			/* beq */
			strncpy(&dobuf[10], "BEQ ", 4);
			break;		/* done */
		case 5:			/* bge */
			strncpy(&dobuf[10], "BGE ", 4);
			break;		/* done */
		case 6:			/* ble */
			strncpy(&dobuf[10], "BLE ", 4);
			break;		/* done */
		case 7:			/* bany */
			strncpy(&dobuf[10], "BANY", 4);
			break;		/* done */
		}
		return;			/* done */
	}
	if (opcode == 0xf0) {		/* is op bcf */
		switch (condit & 7) {	/* what type */
		case 0:			/* bcf */
			break;		/* nothing to do */
		case 1:			/* bns */
			strncpy(&dobuf[10], "BNS ", 4);
			break;		/* done */
		case 2:			/* bnp */
			strncpy(&dobuf[10], "BNP ", 4);
			break;		/* done */
		case 3:			/* bnn */
			strncpy(&dobuf[10], "BNN ", 4);
			break;		/* done */
		case 4:			/* bne */
			strncpy(&dobuf[10], "BNE ", 4);
			break;		/* done */
		case 5:			/* xxxx */
			break;		/* nothing to do */
		case 6:			/* xxxx */
			break;		/* nothing to do */
		case 7:			/* baz */
			strncpy(&dobuf[10], "BAZ ", 4);
			break;		/* done */
		}
		return;			/* done */
	}
	return;				/* done */
}
		
/*
 * rsout - output source reg
 */
void rsout()			/* display reg */
{
	dobuf[insx++] = 'R';		/* reg type */
	dobuf[insx++] = rs + '0';	/* reg number */
/*
 *        If register followed by effective memory address
 *        or another value - put in a comma
 */
	if (idflags & 0x1500)		/* ea, immed val, or val */
		dobuf[insx++] = ',';	/* insert comma */
}

/*
 * rdout - output dest reg
 */
void rdout()			/* display reg */
{
	if (idflags & 0x8000)		/* did rs reg go 1st */
		dobuf[insx++] = ',';	/* insert comma */
	dobuf[insx++] = 'R';		/* reg type */
	dobuf[insx++] = rd + '0';	/* reg number */
	/*
	 * If register followed by effective memory address
	 * or another value - put in a comma
	 */
	if (idflags & 0x1500)		/* ea, immed val, or val */
		dobuf[insx++] = ',';	/* insert comma */
}

/*
 * Outputs the bit, condition, or shift field to the do buffer.
 */
void bcsout()
{
	char tb[32];			/* temp buffer */

	sprintf(tb, "%d", bit & 0xff);	/* bin to dec */
	strncpy(&dobuf[insx], tb, strlen(tb));	/* copy data */
	insx += strlen(tb);		/* new position */
	if (idflags & 0x0500)		/* got efa or immed to go out */
		dobuf[insx++] = ',';	/* insert comma */
}

/*
 * Outputs priority level or device address in do buffer.
 */
void pdout()
{
	char tb[32];			/* temp buffer */

	dobuf[insx++] = 'X';		/* insert X */
	dobuf[insx++] = '\'';		/* insert ' */
	sprintf(tb, "%x", plevel & 0xff);	/* bin to hex */
	strncpy(&dobuf[insx], tb, strlen(tb));	/* copy data */
	insx += strlen(tb);		/* new position */
	dobuf[insx++] = '\'';		/* insert ' */
	if (idflags & 0x0400)		/* got immed val to go out */
		dobuf[insx++] = ',';	/* insert comma */
}

/*
 * Outputs program flags, immediate operand, cd code,
 * td code or protect register num to the do buffer.
 */
void pictout()
{
	char tb[32];			/* temp buffer */

	dobuf[insx++] = 'X';		/* insert X */
	dobuf[insx++] = '\'';		/* insert ' */
	sprintf(tb, "%x", immed & 0xffff);	/* bin to hex */
	strncpy(&dobuf[insx], tb, strlen(tb));	/* copy data */
	insx += strlen(tb);		/* new position */
	dobuf[insx++] = '\'';		/* insert ' */
}

/*
 * Outputs data word to the do buffer.
 */
void dataout(unsigned int data)
{
	char tb[32];			/* temp buffer */

	strncpy(&dobuf[10], "DATAW", 5);	/* copy mnemonic */
	insx = 19;			/* where to start */
	dobuf[insx++] = 'X';		/* insert X */
	dobuf[insx++] = '\'';		/* insert ' */
	sprintf(tb, "%x", data);	/* bin to hex */
	strncpy(&dobuf[insx], tb, strlen(tb));	/* copy data */
	insx += strlen(tb);		/* new position */
	dobuf[insx++] = '\'';		/* insert ' */
}

/*
 * Outputs data halfword to the do buffer.
 */
void datahout(unsigned int data)
{
	char tb[32];			/* temp buffer */

	strncpy(&dobuf[10], "DATAH", 5);	/* copy mnemonic */
	insx = 19;			/* where to start */
	dobuf[insx++] = 'X';		/* insert X */
	dobuf[insx++] = '\'';		/* insert ' */
	sprintf(tb, "%x", data);	/* bin to hex */
	strncpy(&dobuf[insx], tb, strlen(tb));	/* copy data */
	insx += strlen(tb);		/* new position */
	dobuf[insx++] = '\'';		/* insert ' */
}

/*
 * Outputs the effective address and value at the
 * effective address to the do buffer.
 */
void eaout()
{
	char tb[32];			/* temp buffer */
	unsigned int oaddr;		/* operand addr */

	oaddr = opaddr & 0x7ffff;	/* mask the address */
	if (symbol(addr, oaddr, 0))	/* output address */
		return;
	dobuf[insx++] = 'X';		/* insert X */
	dobuf[insx++] = '\'';		/* insert ' */
	sprintf(tb, "%x", oaddr & 0xffffff);	/* bin to hex */
	strncpy(&dobuf[insx], tb, strlen(tb));	/* copy data */
	insx += strlen(tb);		/* new position */
	dobuf[insx++] = '\'';		/* insert ' */
}

/*
 * Outputs index register num to do buffer.
 */
void xout()
{
	if (xreg == 0)			/* got a real index reg */
		return;			/* exit */
	dobuf[insx++] = ',';		/* insert comma */
	dobuf[insx++] = 'X';		/* reg type */
	dobuf[insx++] = xreg + '0';	/* reg number */
	insx++;				/* step over one position */
}

/*
 * Get augment (F,C bits) for mem.reference instructions.
 * Input           Memory reference address.
 * Return          0,Byte addr.
 *                 1,Half-wd.addr.
 *                 2,Word addr.
 *                 3,Dble-wd.addr.
 */
int augmr(int opadr)
{
	if (opadr & 0x80000)
		return(0);		/* byte addr */
	if (opadr & 1)
		return(1);		/* hw addr */
	if (opadr & 2)
		return(3);		/* word addr */
	return(2);			/* dbl word addr */
}


struct itbl {
	char *mnem;		/* mnemonic */
	int op;			/* opdode */
	int aug;		/* augmend */
	int flags;		/* bust flags */
};

/*
*        THIS TABLE CONTAINS 2 WORDS FOR EACH VALID INSTRUCTION
*        MNEMONIC. THE FORMAT OF THE TABLE IS AS FOLLOWS.
*        BITS  0-31=INSTRUCTION MNEMONIC IN ASCII.
*        BITS 32-39=PRIMARY OP-CODE, LEFT-JUSTIFIED.
*        BITS 40-47=AUGMENT, AS IT EXISTS IN THE INSTRUCTION, OR AS IT
*                   IS COMPUTED IN THE BUST ROUTINES.
*        BITS 48-63=IDENTIFICATION FLAGS INDICATING WHAT INFORMATION
*                   IS REQUIRED IN THE TRACE BUFFER BEFORE AND AFTER
*                  EXECUTING THE INSTRUCTION, AND INFORMATION
*                   CONCERNING EXECUTION.
*
*
*        BIT SETTINGS IN BITS 48-63 GO TO 'IDLFLAGS' AND
*        ARE INTERPRETED AS FOLLOWS ONCE IN 'IDLFAGS'
*
*        BIT       MEANING
*        ---       -----------------------------------
*        00        REG 'S' OR REG 'D' TO BE OUTPUT
*        01        REG 'D' OR REG TO BE OUTPUT
*        02        DOUBLE REGISTER REG 'D' OR REG
*        03        BIT,CONDITION OR SHIFT FIELD TO GO OUT
*        04        PRIORITY LEVEL OR DEVICE NUMBER
*        05        PRGRAM FLAGS OR IMMEDIATE FIELD VALUE
*        06        INDIRECT INDICATOR TO GO OUT
*        07        EFFECTIVE ADDRESS TO BE OUTPUT
*        08        SPECIAL EXECUTION CASE (IN 'SPEC')
*        09        NON-EXECUTABLE INSTRUCTION (HALT..ETC..)
*        10        32 BIT OPCODE IF SET (ELSE IT IS 16 BIT)
*        11        BRANCH SIMULATION REQUIRED
*        12        REG 'S' OR REG 'A' TO GO AFTER EXU
*        13        REG 'D' OR REG TO GO AFTER EXU
*        14        DOBLE REG AFTER EXU
*        15        EFFECTIVE ADDRS AFTER EXU ONLY
*/

struct itbl itable[] = {
	"HALT", 0x00, 0x00, 0x0040,
	"WAIT", 0x00, 0x01, 0x0040,
	"NOP ", 0x00, 0x02, 0x0000,
	"LCS ", 0x00, 0x03, 0x4004,
	"ES  ", 0x00, 0x04, 0x2002,
	"RND ", 0x00, 0x05, 0x2002,
	"BEI ", 0x00, 0x06, 0x0040,
	"UEI ", 0x00, 0x07, 0x0040,
	"EAE ", 0x00, 0x08, 0x0040,
	"RDST", 0x00, 0x09, 0x4044,
	"SIPU", 0x00, 0x0A, 0x0040,
	"RWCS", 0x00, 0x0B, 0xC04C,
	"WWCS", 0x00, 0x0C, 0xC04C,
	"SEA ", 0x00, 0x0D, 0x0040,
	"DAE ", 0x00, 0x0E, 0x0040,
	"CEA ", 0x00, 0x0F, 0x0040,
	"ANR ", 0x04, 0x00, 0xC004,
	"SMC ", 0x04, 0x07, 0x4040,
	"CMC ", 0x04, 0x0A, 0x4040,
	"ORR ", 0x08, 0x00, 0xC004,
	"ORRM", 0x08, 0x08, 0xC004,
	"EOR ", 0x0C, 0x00, 0xC004,
	"EORM", 0x0C, 0x08, 0xC004,
	"ZR  ", 0x0C, 0x10, 0x4004,
	"CAR ", 0x10, 0x00, 0xC00C,
	"CMR ", 0x14, 0x00, 0xC00C,
	"SBR ", 0x18, 0x00, 0x5004,
	"ZBR ", 0x1C, 0x00, 0x5004,
	"ABR ", 0x20, 0x00, 0x5004,
	"TBR ", 0x24, 0x00, 0x5000,
	"TRSW", 0x28, 0x00, 0x4080,
	"TRR ", 0x2C, 0x00, 0xC004,
	"TRC ", 0x2C, 0x03, 0xC004,
	"TRN ", 0x2C, 0x04, 0xC004,
	"XCR ", 0x2C, 0x05, 0xC00C,
	"LMAP", 0x2C, 0x07, 0x4044,
	"TRRM", 0x2C, 0x08, 0xC004,
	"SCPU", 0x2C, 0x09, 0x4044,
	"TMTR", 0x2C, 0x0A, 0xC044,
	"TRCM", 0x2C, 0x0B, 0xC004,
	"TRNM", 0x2C, 0x0C, 0xC004,
	"XCRM", 0x2C, 0x0D, 0xC00C,
	"TRSC", 0x2C, 0x0E, 0xC004,
	"TSCR", 0x2C, 0x0F, 0xC004,
#ifdef NOTUSED
	"CALM", 0x30, 0x00, 0x0400,
#endif
	"LA  ", 0x34, 0x00, 0x4324,
	"ADR ", 0x38, 0x00, 0xC004,
	"ARFW", 0x38, 0x01, 0xC004,
	"SRFW", 0x38, 0x03, 0xC004,
	"DRFW", 0x38, 0x04, 0xC004,
	"FIXW", 0x38, 0x05, 0xC004,
	"MRFW", 0x38, 0x06, 0xC004,
	"FLTW", 0x38, 0x07, 0xC004,
	"ADRM", 0x38, 0x08, 0xC004,
	"ARFD", 0x38, 0x09, 0xC002,
	"SRFD", 0x38, 0x0B, 0xC002,
	"DRFD", 0x38, 0x0C, 0xC002,
	"FIXD", 0x38, 0x0D, 0xC002,
	"MRFD", 0x38, 0x0E, 0xC002,
	"FLTD", 0x38, 0x0F, 0xC002,
	"SUR ", 0x3C, 0x00, 0xC004,
	"SURM", 0x3C, 0x08, 0xC004,
	"MPR ", 0x40, 0x00, 0xA002,
	"DVR ", 0x44, 0x00, 0xA002,
	"NOR ", 0x60, 0x00, 0xC00C,
	"NORD", 0x64, 0x00, 0xA00A,
	"SCZ ", 0x68, 0x00, 0xC00C,
	"SRA ", 0x6C, 0x00, 0x5004,
	"SLA ", 0x6C, 0x01, 0x5004,
	"SRL ", 0x70, 0x00, 0x5004,
	"SLL ", 0x70, 0x01, 0x5004,
	"SRC ", 0x74, 0x00, 0x5004,
	"SLC ", 0x74, 0x01, 0x5004,
	"SRAD", 0x78, 0x00, 0x3002,
	"SLAD", 0x78, 0x01, 0x3002,
	"SRLD", 0x7C, 0x00, 0x3002,
	"SLLD", 0x7C, 0x01, 0x3002,
	"SCSR", 0x04, 0x01, 0x4040,
	"SDSR", 0x04, 0x02, 0x4040,
	"PIT ", 0x04, 0x04, 0x0040,
	"DCSR", 0x04, 0x05, 0x4000,
	"DDSR", 0x04, 0x06, 0x4000,
	"SEAR", 0x04, 0x0E, 0x0040,
	"CEAR", 0x04, 0x0F, 0x0040,
	"MRMW", 0x0C, 0x02, 0xA002,
	"RRMW", 0x0C, 0x03, 0xC004,
	"WRMS", 0x0C, 0x09, 0x4004,
	"RRMS", 0x0C, 0x0A, 0x4004,
	"CXIW", 0x28, 0x06, 0xC004,
	"CXID", 0x28, 0x07, 0xA00A,
	"CIXW", 0x28, 0x0A, 0xC004,
	"CIXD", 0x28, 0x0B, 0xA00A,
	/* BELOW ARE 16 BIT */
	"LEAR", 0x80, 0x00, 0x4324,
#ifdef BRI
	"LCRA", 0x58, 0x00, 0x4324,
#endif
	"ANMB", 0x84, 0x00, 0x4324,
	"ANMH", 0x84, 0x01, 0x4324,
	"ANMW", 0x84, 0x02, 0x4324,
	"ANMD", 0x84, 0x03, 0x2322,
	"ORMB", 0x88, 0x00, 0x4324,
	"ORMH", 0x88, 0x01, 0x4324,
	"ORMW", 0x88, 0x02, 0x4324,
	"ORMD", 0x88, 0x03, 0x2322,
	"EOMB", 0x8C, 0x00, 0x4324,
	"EOMH", 0x8C, 0x01, 0x4324,
	"EOMW", 0x8C, 0x02, 0x4324,
	"EOMD", 0x8C, 0x03, 0x2322,
	"CAMB", 0x90, 0x00, 0x4325,
	"CAMH", 0x90, 0x01, 0x4325,
	"CAMW", 0x90, 0x02, 0x4325,
	"CAMD", 0x90, 0x03, 0x2322,
	"CMMB", 0x94, 0x00, 0x4325,
	"CMMH", 0x94, 0x01, 0x4325,
	"CMMW", 0x94, 0x02, 0x4325,
	"CMMD", 0x94, 0x03, 0x2322,
	"SBM ", 0x98, 0x00, 0x1321,
	"ZBM ", 0x9C, 0x00, 0x1321,
	"ABM ", 0xA0, 0x00, 0x1321,
	"TBM ", 0xA4, 0x00, 0x1321,
	"EXM ", 0xA8, 0x00, 0x03A0,
	"LB  ", 0xAC, 0x00, 0x4324,
	"LH  ", 0xAC, 0x01, 0x4324,
	"LW  ", 0xAC, 0x02, 0x4324,
	"LD  ", 0xAC, 0x03, 0x2322,
#ifdef BRI
	"LCB ", 0x5C, 0x00, 0x4324,
	"LCH ", 0x5C, 0x01, 0x4324,
	"LCW ", 0x5C, 0x02, 0x4324,
	"LCD ", 0x5C, 0x03, 0x2322,
#endif
	"LMB ", 0xB0, 0x00, 0x4324,
	"LMH ", 0xB0, 0x01, 0x4324,
	"LMW ", 0xB0, 0x02, 0x4324,
	"LMD ", 0xB0, 0x03, 0x2322,
	"LNB ", 0xB4, 0x00, 0x4324,
	"LNH ", 0xB4, 0x01, 0x4324,
	"LNW ", 0xB4, 0x02, 0x4324,
	"LND ", 0xB4, 0x03, 0x2322,
	"ADMB", 0xB8, 0x00, 0x4324,
	"ADMH", 0xB8, 0x01, 0x4324,
	"ADMW", 0xB8, 0x02, 0x4324,
	"ADMD", 0xB8, 0x03, 0x2322,
	"SUMB", 0xBC, 0x00, 0x4324,
	"SUMH", 0xBC, 0x01, 0x4324,
	"SUMW", 0xBC, 0x02, 0x4324,
	"SUMD", 0xBC, 0x03, 0x2322,
	"MPMB", 0xC0, 0x00, 0x2323,
	"MPMH", 0xC0, 0x01, 0x2323,
	"MPMW", 0xC0, 0x02, 0x2323,
	"DVMB", 0xC4, 0x00, 0x2323,
	"DVMH", 0xC4, 0x01, 0x2323,
	"DVMW", 0xC4, 0x02, 0x2323,
	"LI  ", 0xC8, 0x00, 0x4424,
	"ADI ", 0xC8, 0x01, 0x4424,
	"SUI ", 0xC8, 0x02, 0x4424,
	"MPI ", 0xC8, 0x03, 0x2422,
	"DVI ", 0xC8, 0x04, 0x2422,
	"CI  ", 0xC8, 0x05, 0x4424,
	"SVC ", 0xC8, 0x06, 0x1420,
	"EXR ", 0xC8, 0x07, 0x40A0,
	"EXRR", 0xC8, 0x17, 0x40A0,
	"LF  ", 0xCC, 0x00, 0x43A4,
	"LFBR", 0xCC, 0x08, 0x43A4,
	"LEA ", 0xD0, 0x00, 0x4324,
	"STB ", 0xD4, 0x00, 0x4321,
	"STH ", 0xD4, 0x01, 0x4321,
	"STW ", 0xD4, 0x02, 0x4321,
	"STD ", 0xD4, 0x03, 0x2321,
#ifdef BRI
	"STCB", 0x54, 0x00, 0x4321,
	"STCH", 0x54, 0x01, 0x4321,
	"STCW", 0x54, 0x02, 0x4321,
	"STCD", 0x54, 0x03, 0x2321,
#endif
	"STMB", 0xD8, 0x00, 0x4321,
	"STMH", 0xD8, 0x01, 0x4321,
	"STMW", 0xD8, 0x02, 0x4321,
	"STMD", 0xD8, 0x03, 0x2321,
	"STF ", 0xDC, 0x00, 0x43A1,
	"STBF", 0xDC, 0x08, 0x43A1,
	"SUFW", 0xE0, 0x02, 0x4324,
	"SUFD", 0xE0, 0x03, 0x2322,
	"ADFW", 0xE0, 0x12, 0x4324,
	"ADFD", 0xE0, 0x13, 0x2322,
	"DVFW", 0xE4, 0x02, 0x4324,
	"DVFD", 0xE4, 0x03, 0x2322,
	"MPFW", 0xE4, 0x12, 0x4324,
	"MPFD", 0xE4, 0x13, 0x2322,
	"ARMB", 0xE8, 0x00, 0x4321,
	"ARMH", 0xE8, 0x01, 0x4321,
	"ARMW", 0xE8, 0x02, 0x4321,
	"ARMD", 0xE8, 0x03, 0x2321,
	"BU  ", 0xEC, 0x00, 0x0330,
	"BCT ", 0xEC, 0x01, 0x1330,
	"BFT ", 0xF0, 0x00, 0x1330,
	"BCF ", 0xF0, 0x01, 0x1330,
	"BIB ", 0xF4, 0x00, 0x4334,
	"BIH ", 0xF4, 0x01, 0x4334,
	"BIW ", 0xF4, 0x02, 0x4334,
	"BID ", 0xF4, 0x03, 0x4334,
	"BL  ", 0xF8, 0x01, 0x1331,
	"BRI ", 0xF8, 0x02, 0x1370,
	"LPSD", 0xF8, 0x03, 0x1371,
	"JWCS", 0xF8, 0x04, 0x0660,
	"LPCM", 0xF8, 0x05, 0x1371,
	"TRP ", 0xF8, 0x06, 0x4460,
	"TPR ", 0xF8, 0x07, 0x4464,
	"ZMB ", 0xF8, 0x00, 0x0321,
	"ZMH ", 0xF8, 0x10, 0x0321,
	"ZMW ", 0xF8, 0x20, 0x0321,
	"ZMD ", 0xF8, 0x30, 0x0321,
	"EI  ", 0xFC, 0x00, 0x0860,
	"DI  ", 0xFC, 0x01, 0x0860,
	"RI  ", 0xFC, 0x02, 0x0860,
	"AI  ", 0xFC, 0x03, 0x0860,
	"DAI ", 0xFC, 0x04, 0x0860,
	"TD  ", 0xFC, 0x05, 0x1C60,
	"CD  ", 0xFC, 0x06, 0x1C60,
	"SIO ", 0xFC, 0x09, 0x1460,
	"TIO ", 0xFC, 0x0A, 0x1460,
	"STPI", 0xFC, 0x0B, 0x1460,
	"RSCH", 0xFC, 0x0C, 0x1460,
	"HIO ", 0xFC, 0x0D, 0x1460,
	"GRIO", 0xFC, 0x0E, 0x1460,
	"RSCT", 0xFC, 0x0F, 0x1460,
	"EWCW", 0xFC, 0x10, 0x1460,
	"WCWC", 0xFC, 0x12, 0x1460,
	"ECI ", 0xFC, 0x13, 0x1460,
	"DCI ", 0xFC, 0x14, 0x1460,
	"ACI ", 0xFC, 0x15, 0x1460,
	"DACI", 0xFC, 0x16, 0x1460,
	"GFPC", 0xC8, 0x0D, 0xA02A,
	"RFPW", 0xC8, 0x0E, 0xA02A,
	"RFPD", 0xC8, 0x0F, 0xA02A,
	"TC  ", 0xC8, 0x08, 0x0420,
	"XCBR", 0x28, 0x02, 0xC00C,
	"TCCR", 0x28, 0x04, 0x4004,
	"TRCC", 0x28, 0x05, 0x4004,
	"TRBR", 0x2C, 0x01, 0xC004,
	"TBRR", 0x2C, 0x02, 0xC004,
	"RINT", 0xC8, 0x0A, 0x4424,
	"PINT", 0xC8, 0x09, 0x4420,
	"*UND", 0xFF, 0xFF, 0x0060,
	0, 0, 0, 0,
};

/*
 * Loads the do buffer with the appropriate instr mnemonic.
 */
void mnemout()			/* output opcode mnemonic */
{
	struct itbl *itp;	/* pointer to instruction table */

	itp = itable;		/* table start */
	while (itp->mnem && *itp->mnem) {	/* while entries */
		/* match opcode and aug */
		if (opcode == itp->op &&
		    aug == itp->aug) {		/* we have a match */
			strncpy(&dobuf[10], itp->mnem, 4);	/* copy mnemonic */
			idflags = itp->flags;	/* set bust flags */
			if (idflags & 0x0010)	/* branch instr */
				mneb();		/* yes, adj mnemonic */
			return;			/* done */
		}
		itp++;			/* next entry */
	}
	/* not found, show undefined */
#ifdef OLDWAY
	strncpy(&dobuf[10], "*UND", 4);	/* undefined instruction */
#else
	if (length == 4)
	    dataout(instr);		/* dump data word */
	else
	    datahout(instr >> 16);	/* dump data halfword */
#endif
	idflags = 0x0060;		/* set bust flags */
	return;				/* done */
}
		
/*
 * output symbol for specified location
 */

int symbol(unsigned int address, unsigned int opaddress, int label)
{
	int i, k, off;			/* temps */
	unsigned int tin;		/* temp instr */
	unsigned int sba;		/* temp sba */
	struct dpr *dpp = datapool;	/* datapool references */
	struct extr *extp = external;	/* external references */
	struct defr *defp = defined;	/* defined symbol references */
	int offset = 0xfffff;		/* offset from symbol */
	char *pn;			/* datapool name */
	char tb[32];			/* temp buffer */

	if (label)
		goto dolabel;
	/* search for datapool reference */
	for (i=0; i<ndpr; i++) {
#ifdef JUNK
printf("\n addr %x refa %x\n", address, dpp->refa);
#endif
		if (address == dpp->refa) {	/* our address */
			offset = opaddress & 0x7ffff;
			pn = dpp->name;		/* the name */
			break;
		}
		dpp++;
	}
	if (offset < 0xfffff) {			/* symbol found? */
		for (k=0; k < 8; k++) {
			if (pn[k] == ' ' || pn[k] == 0)	/* end of name */
				break;		/* yes stop */
			dobuf[insx++] = pn[k];	/* copy symbol */
		}
		if (offset) {			/* any offset */
			dobuf[insx++] = '+';	/* copy */
			dobuf[insx++] = 'X';	/* insert X */
			dobuf[insx++] = '\'';	/* insert ' */
			sprintf(tb, "%x", offset);	/* bin to hex */
			strncpy(&dobuf[insx], tb, strlen(tb));	/* copy data */
			insx += strlen(tb);	/* new position */
			dobuf[insx++] = '\'';	/* insert ' */
		}
		return(1);			/* found */
	}

	/* not a datapool, try external reference */
	sa = sect_addr[curr_sect];		/* address of section */
	for (i=0; i<nextr; i++) {
		/*
		 * search backward through the stringback address
		 * looking for sba pointing to current address
		 */
		sba = extp->sba;			/* off + base */
trynext:
#ifdef JUNK
printf("\n addr %x sba %x\n", address, sba);
#endif
		if (address == sba) {			/* our address */
			offset = opaddress & 0x7ffff;
			pn = extp->name;		/* the name */
			break;
		}
		off = sba - sect_base[curr_sect];	/* off only */
		tin = 0;
		for (k = 0; k < 4; k++) {
		    tin = (tin << 8) | sa[off + k];
		}
		tin &= 0x7fffc;			/* word bound addr */
		if (tin) {			/* more addresses */
			sba = tin;		/* next addr */
			goto trynext;		/* loop */
		}
		/* not this sb, try the next one */
		extp++;
	}
	if (offset < 0xfffff) {			/* symbol found? */
		for (k=0; k < 8; k++) {
			if (pn[k] == ' ' || pn[k] == 0)	/* end of name */
				break;		/* yes stop */
			dobuf[insx++] = pn[k];	/* copy symbol */
		}
		return(1);			/* found */
	}

	/* not external reference, try local symbol */
dolabel:
	for (i=0; i<ndefr; i++) {
#ifdef JUNK
printf("\n addr %x refa %x\n", address, dpp->refa);
#endif
		if (opaddress == defp->refa) {	/* our address */
			offset = 0;
			pn = defp->name;	/* the name */
			break;
		}
		if (!label && opaddress >= defp->refa) {	/* at symbol yet */
			off = opaddress - defp->refa;	/* addr - base */
			if (off > sect_size[curr_sect])
				continue;	/* beyond end */
			if (off < offset) {	/* new low value */
				offset = off;	/* new offset */
				pn = defp->name;	/* the name */
			}
		}
		defp++;				/* try next */
	}
	if (offset < 0xfffff) {			/* symbol found? */
		for (k=0; k < 8; k++) {
			if (pn[k] == ' ' || pn[k] == 0)	/* end of name */
				break;		/* yes stop */
			dobuf[insx++] = pn[k];	/* copy symbol */
		}
		if (offset) {			/* any offset */
			dobuf[insx++] = '+';	/* copy */
			dobuf[insx++] = 'X';	/* insert X */
			dobuf[insx++] = '\'';	/* insert ' */
			sprintf(tb, "%x", offset);	/* bin to hex */
			strncpy(&dobuf[insx], tb, strlen(tb));	/* copy data */
			insx += strlen(tb);	/* new position */
			dobuf[insx++] = '\'';	/* insert ' */
		}
		return(1);			/* found */
	}
	return(0);				/* not found */
	
}
