  @     	     NAME 	 9          scanf, fscanf, sscanf - convert formatted input 9         SYNTAX            #include <stdio.h>     0          int scanf (format [ , pointer ] ...  ) 0           char *format;     9          int fscanf (stream, format [ , pointer ] ...  ) 9           FILE *stream;            char *format;     4          int sscanf (s, format [ , pointer ] ...  ) 4           char *s, *format;          DESCRIPTION  C          Scanf reads from the standard input stream stdin.  Fscanf C C          reads from the named input stream.  Sscanf reads from the C >          character string s.  Each function reads characters, > ?          interprets them according to a format, and stores the ?                                     @  B          results in its arguments.  Each expects, as arguments, a B E          control string format described below, and a set of pointer E B          arguments indicating where the converted input should be B           stored.     8          The control string usually contains conversion 8 D          specifications, which are used to direct interpretation of D ;          input sequences.  The control string may contain: ;    @          1. White-space characters (blanks, tabs, new-lines, or @ D             form-feeds) which, except in two cases described below, D B             cause input to be read up to the next non-white-space B              character.  E          2. An ordinary character (not %), which must match the next E               @  +             character of the input stream. + F          3. Conversion specifications, consisting of the character %, F ?             an optional assignment suppressing character *, an ? B             optional numerical maximum field width, an optional l B F             (ell) or h indicating the size of the receiving variable, F #             and a conversion code. #    B          A conversion specification directs the conversion of the B @          next input field; the result is placed in the variable @ E          pointed to by the corresponding argument, unless assignment E =          suppression was indicated by *.  The suppression of = F          assignment provides a way of describing an input field which F                                      @  E          is to be skipped.  An input field is defined as a string of E D          non-space characters; it extends to the next inappropriate D >          character or until the field width, if specified, is > A          exhausted.  For all descriptors except ``['' and ``c'', A 8          white space leading an input field is ignored. 8    A          The conversion code indicates the interpretation of the A F          input field; the corresponding pointer argument must usually F F          be of a restricted type.  For a suppressed field, no pointer F @          argument is given.  The following conversion codes are @           legal:     D          %    a single % is expected in the input at this point; no D                                     @  "               assignment is done. " ?          d    a decimal integer is expected; the corresponding ? 5               argument should be an integer pointer. 5 ;          u    an unsigned decimal integer is expected; the ; C               corresponding argument should be an unsigned integer C                pointer.  >          o    an octal integer is expected; the corresponding > 5               argument should be an integer pointer. 5 C          x    a hexadecimal integer is expected; the corresponding C 5               argument should be an integer pointer. 5           e,f,g  E               a floating point number is expected; the next field is E ;               converted accordingly and stored through the ;                                   @  E               corresponding argument, which should be a pointer to a E E               float.  The input format for floating point numbers is E >               an optionally signed string of digits, possibly > B               containing a decimal point, followed by an optional B E               exponent field consisting of an E or an e, followed by E B               an optional +, -, or space, followed by an integer. B @          s    a character string is expected; the corresponding @ D               argument should be a character pointer pointing to an D D               array of characters large enough to accept the string D 8               and a terminating \0, which will be added 8                                                                   @  A               automatically.  The input field is terminated by a A %               white-space character. % B          c    a character is expected; the corresponding argument B C               should be a character pointer.  The normal skip over C B               white space is suppressed in this case; to read the B F               next non-space character, use %1s.  If a field width is F B               given, the corresponding argument should refer to a B E               character array; the indicated number of characters is E                read.  E          [    indicates string data and the normal skip over leading E >               white space is suppressed.  The left bracket is >                                                               @  F               followed by a set of characters, which we will call the F C               scanset, and a right bracket; the input field is the C >               maximal sequence of input characters consisting > E               entirely of characters in the scanset.  The circumflex E A               (^), when it appears as the first character in the A E               scanset, serves as a complement operator and redefines E E               the scanset as the set of all characters not contained E F               in the remainder of the scanset string.  There are some F F               conventions used in the construction of the scanset.  A F F               range of characters may be represented by the construct F                                           @  D               first-last, thus [0123456789] may be expressed [0-9]. D    B               Using this convention, first must be lexically less B E               than or equal to last, or else the dash will stand for E D               itself.  The dash will also stand for itself whenever D D               it is the first or the last character in the scanset. D C               To include the right square bracket as an element of C A               the scanset, it must appear as the first character A F               (possibly preceded by a circumflex) of the scanset, and F D               in this case it will not be syntactically interpreted D B               as the closing bracket.  The corresponding argument B                                            @  C               must point to a character array large enough to hold C C               the data field and the terminating \0, which will be C F               added automatically.  At least one character must match F ?               for this conversion to be considered successful. ?    E          The conversion characters d, u, o, and x may be preceded by E F          l or h to indicate that a pointer to long or to short rather F >          than to int is in the argument list.  Similarly, the > C          conversion characters e, f, and g may be preceded by l to C F          indicate that a pointer to double rather than to float is in F F          the argument list.  The l or h modifier is ignored for other F            conversion characters.        @  ?          Scanf conversion terminates at EOF, at the end of the ? C          control string, or when an input character conflicts with C @          the control string.  In the latter case, the offending @ 7          character is left unread in the input stream. 7    >          Scanf returns the number of successfully matched and > D          assigned input items; this number can be zero in the event D A          of an early conflict between an input character and the A F          control string.  If the input ends before the first conflict F )          or conversion, EOF is returned. )    
     EXAMPLES 
           The call:     0               int i, n; float x; char name[50]; 0 1               n = scanf("%d%f%s", &i, &x, name); 1           @            with the input line:     #               25 54.32E-1 thompson #    C          will assign to n the value 3, to i the value 25, to x the C =          value 5.432, and name will contain thompson\0.  Or: =    -               int i; float x; char name[50]; - =               (void) scanf("%2d%f%*d %[0-9]", &i, &x, name); =              with input:                    56789 0123 56a72     C          will assign 56 to i, 789.0 to x, skip 0123, and place the C =          string 56\0 in name.  The next call to getchar (see = "          getc(3S)) will return a. "    
     SEE ALSO 
 .          getc.m, printf.m, strtod.m, strtol.m .    	     NOTE 	 D          Trailing white space (including a new-line) is left unread D               @  /          unless matched in the control string. /         DIAGNOSTICS  F          These functions return EOF on end of input and a short count F ,          for missing or illegal data items. ,         SPECIAL CONSIDERATIONS  F          The success of literal matches and suppressed assignments is F $          not directly determinable. $    *          (printed 07/30/92 - J B Systems) *                                                                                                                                                                                                                                                                                                                                                                       