  @         Name  *        matherr - Error-handling function. *    
    Syntax 
         #include <math.h>             int matherr (x)          struct exception *x;         Description  @        matherr is invoked by functions in the Math Library when @ C        errors are detected.  Users may define their own procedures C B        for handling errors, by including a function named matherr B A        in their programs.  matherr must be of the form described A @        above.  When an error occurs, a pointer to the exception @ ?        structure x will be passed to the user-supplied matherr ? C        function.  This structure, which is defined in the <math.h> C #        header file, is as follows: #            struct exception {        @              int type;              char *name;  &            double arg1, arg2, retval; & 
        }; 
    C        The element type is an integer describing the type of error C ?        that has occurred, from the following list of constants ? %        (defined in the header file): %    (        DOMAIN     argument domain error ( '        SING       argument singularity ' '        OVERFLOW   overflow range error ' (        UNDERFLOW  underflow range error ( -        TLOSS      total loss of significance - /        PLOSS      partial loss of significance /    B        The element name points to a string containing the name of B A        the function that incurred the error.  The variables arg1 A                                                 @  >        and arg2 are the arguments with which the function was > A        invoked.  retval is set to the default value that will be A B        returned by the function unless the user's matherr sets it B         to a different value.     A        If the user's matherr function returns non-zero, no error A ;        message will be printed, and errno will not be set. ;    B        If matherr is not supplied by the user, the default error- B >        handling procedures, described with the math functions > C        involved, will be invoked upon error.  These procedures are C D        also summarized in the table below.  In every case, errno is D 8        set to EDOM or ERANGE and the program continues. 8        Example                          @          #include <math.h>             int          matherr(x)  %        register struct exception *x; % 	        { 	         switch (x->type) {          case DOMAIN:              /*  7             * change sqrt to return sqrt(-arg1), not 0 7              */  -            if (!strcmp(x->name, ``sqrt'')) { - +                x->retval = sqrt(-x->arg1); +                 return (0);                  /*  .                 * print message and set errno .                  */  
            } 
         case SING:              /*  /             * all other domain or sing errors, / &             * print message and abort &              */  @             fprintf(stderr, ``domain error in %s\n'', x->name); @              abort( );     @          case PLOSS:               /*  ,              * print detailed error message ,               */  G             fprintf(stderr, ``loss of significance in %s(%g) = %g\n'', G .                 x->name, x->arg1, x->retval); .              return (1);               /*  $              * take no other action $               */  	        } 	         return (0);  
        /* 
 6         * all other errors, execute default procedure 6          */  	        } 	    E    _________________________________________________________________ E F    |                        DEFAULT ERROR HANDLING PROCEDURES       | F F    |___________________|____________________________________________| F                                                            @  F    |                   |               Types of Errors              | F F    |___________________|_____|______|________|_________|_____|______| F F    |        type       |DOMAI|  SING|OVERFLOW|UNDERFLOW|TLOSS| PLOSS| F F    |___________________|_____|______|________|_________|_____|______| F F    |       errno       | EDOM|  EDOM| ERANGE |  ERANGE |ERANG| ERANG| F F    |___________________|_____|______|________|_________|_____|______| F F    |BESSEL:            |  -  |   -  |   -    |    -    | M, 0|   *  | F F    |y0, y1, yn (arg _ 0|M, -H|   -  |   -    |    -    |  -  |   -  | F F    |___________________|_____|______|________|_________|_____|______| F F    |EXP:               |  -  |   -  |   H    |    0    |  -  |   -  | F                        @  F    |___________________|_____|______|________|_________|_____|______| F F    |LOG, LOG10:        |     |      |        |         |     |      | F F    | (arg < 0)         |M, -H|   -  |   -    |    -    |  -  |   -  | F F    | (arg = 0)         |  -  | M, -H|   -    |    -    |  -  |   -  | F F    |___________________|_____|______|________|_________|_____|______| F F    |POW:               |  -  |   -  |  _H    |    0    |  -  |   -  | F F    |neg ** non-int     |M, 0 |   -  |   -    |    -    |  -  |   -  | F F    |  0 ** non-pos     |     |      |        |         |     |      | F F    |___________________|_____|______|________|_________|_____|______| F F    |SQRT:              | M, 0|   -  |   -    |    -    |  -  |   -  | F                        @  F    |___________________|_____|______|________|_________|_____|______| F F    |GAMMA:             |  -  |  M, H|   H    |    -    |  -  |   -  | F F    |___________________|_____|______|________|_________|_____|______| F F    |HYPOT:             |  -  |   -  |   H    |    -    |  -  |   -  | F F    |___________________|_____|______|________|_________|_____|______| F F    |SINH:              |  -  |   -  |  _H    |    -    |  -  |   -  | F F    |___________________|_____|______|________|_________|_____|______| F F    |COSH:              |  -  |   -  |   H    |    -    |  -  |   -  | F F    |___________________|_____|______|________|_________|_____|______| F F    |SIN, COS, TAN:     |  -  |   -  |   -    |    -    | M, 0|   *  | F                        @  F    |___________________|_____|______|________|_________|_____|______| F F    |ASIN, ACOS,        |     |      |        |         |     |      | F F    |ATAN2:             | M, 0|   -  |   -    |    -    |  -  |   -  | F F    |___________________|_____|______|________|_________|_____|______| F    =        _____________________________________________________ = >        |                    ABBREVIATIONS                   | > >        |  *    As much as possible of the value is returned.| > >        |  M    Message is printed (EDOM error).             | > >        |  H    HUGE is returned.                            | > >        |  -H   -HUGE is returned.                           | >                                                                    j@  >        |  _H   HUGE or -HUGE is returned.                   | > >        |  0    0 is returned.                               | > >        |____________________________________________________| >    	    Notes 	 =        These routines must be linked by using the -lm linker =         option.     (        (printed 07/29/92 - J B Systems) (                                                                                                                                                                                                                                                                                                                                                                                                                         