  @     	     NAME 	 9          getopt - get option letter from argument vector 9         SYNTAX  ,          int getopt (argc, argv, optstring) ,           int argc;  !          char **argv, *opstring; !              extern char *optarg;  $          extern int optind, opterr; $         DESCRIPTION  F          Getopt returns the next option letter in argv that matches a F C          letter in optstring.  Optstring is a string of recognized C A          option letters; if a letter is followed by a colon, the A D          option is expected to have an argument that may or may not D F          be separated from it by white space.  Optarg is set to point F D          to the start of the option argument on return from getopt. D                   @  E          Getopt places in optind the argv index of the next argument E F          to be processed.  Because optind is external, it is normally F D          initialized to zero automatically before the first call to D           getopt.     E          When all options have been processed (i.e., up to the first E @          non-option argument), getopt returns EOF.  The special @ F          option -- may be used to delimit the end of the options; EOF F 3          will be returned, and -- will be skipped. 3         DIAGNOSTICS  @          Getopt prints an error message on stderr and returns a @ C          question mark (?) when it encounters an option letter not C D          included in optstring.  This error message may be disabled D             @  0          by setting opterr to a non-zero value. 0         EXAMPLE  E          The following code fragment shows how one might process the E F          arguments for a command that can take the mutually exclusive F A          options a and b, and the options f and o, both of which A           require arguments:                     main (argc, argv)                  int argc;                 char **argv;                 {                      int c;  (                    extern char *optarg; ( &                    extern int optind; &                     .                      .                      .  E                    while ((c = getopt(argc, argv, "abf:o:")) != EOF) E    %                         switch (c) { %             @  "                         case 'a': " '                              if (bflg) ' ,                                   errflg++; , "                              else " *                                   aflg++; * $                              break; $ "                         case 'b': " '                              if (aflg) ' ,                                   errflg++; , "                              else " ,                                   bproc( ); , $                              break; $ "                         case 'f': " -                              ifile = optarg; - $                              break; $ "                         case 'o': " -                              ofile = optarg; -                                          R@  $                              break; $ "                         case '?': " '                              errflg++; '                          }  !                    if (errflg) { ! :                         fprintf(stderr, "usage: . . . "); : "                         exit (2); "                     }  6                    for ( ; optind < argc; optind++) { 6 7                         if (access(argv[optind], 4)) { 7                     .                      .                      .                 }        *          (printed 07/29/92 - J B Systems) *                                                                                                                                                                                 