  @     	     NAME 	 ;          printf, fprintf, sprintf - print formatted output ;         SYNTAX            #include <stdio.h>     -          int printf (format [ , arg ] ...  ) -           char *format;     6          int fprintf (stream, format [ , arg ] ...  ) 6           FILE *stream;            char *format;     1          int sprintf (s, format [ , arg ] ...  ) 1           char *s, format;          DESCRIPTION  D          Printf places output on the standard output stream stdout. D D          Fprintf places output on the named output stream.  Sprintf D D          places ``output,'' followed by the null character (\0), in D <          consecutive bytes starting at *s; it is the user's <                                        @  D          responsibility to ensure that enough storage is available. D D          Each function returns the number of characters transmitted D F          (not including the \0 in the case of sprintf), or a negative F 3          value if an output error was encountered. 3    C          Each of these functions converts, formats, and prints its C F          args under control of the format.  The format is a character F F          string that contains two types of objects: plain characters, F F          which are simply copied to the output stream, and conversion F F          specifications, each of which results in fetching of zero or F <          more args.  The results are undefined if there are <                                                       @  =          insufficient args for the format.  If the format is = A          exhausted while args remain, the excess args are simply A           ignored.     F          Each conversion specification is introduced by the character F <          %.  After the %, the following appear in sequence: <    B               Zero or more flags, which modify the meaning of the B (               conversion specification. (    D               An optional decimal digit string specifying a minimum D =               field width.  If the converted value has fewer = D               characters than the field width, it will be padded on D C               the left (or right, if the left-adjustment flag `-', C                                                             @  C               described below, has been given) to the field width. C F               If the field width for an s conversion is preceded by a F C               0, the string is right adjusted with zero-padding on C                the left.     E               A precision that gives the minimum number of digits to E F               appear for the d, o, u, x, or X conversions, the number F D               of digits to appear after the decimal point for the e D C               and f conversions, the maximum number of significant C D               digits for the g conversion, or the maximum number of D F               characters to be printed from a string in s conversion. F D               The precision takes the form of a period (.) followed D       @  @               by a decimal digit string; a null digit string is @                treated as zero.     D               An optional l (ell) specifying that a following d, o, D @               u, x, or X conversion character applies to a long @ F               integer arg.  A l before any other conversion character F                is ignored.     F               A character that indicates the type of conversion to be F                applied.     D          A field width or precision may be indicated by an asterisk D F          (*) instead of a digit string.  In this case, an integer arg F A          supplies the field width or precision.  The arg that is A @          actually converted is not fetched until the conversion @                  @  ?          letter is seen, so the args specifying field width or ? =          precision must appear before the arg (if any) to be =           converted.     5          The flag characters and their meanings are: 5 >          -         The result of the conversion will be left- > /                    justified within the field. / A          +         The result of a signed conversion will always A /                    begin with a sign (+ or -). / D          blank     If the first character of a signed conversion is D ?                    not a sign, a blank will be prefixed to the ? A                    result.  This implies that if the blank and + A F                    flags both appear, the blank flag will be ignored. F                           @  ?          #         This flag specifies that the value is to be ? E                    converted to an ``alternate form.''  For c, d, s, E E                    and u conversions, the flag has no effect.  For o E C                    conversion, it increases the precision to force C F                    the first digit of the result to be a zero.  For x F F                    or X conversion, a non-zero result will have 0x or F =                    0X prefixed to it.  For e, E, f, g, and G = A                    conversions, the result will always contain a A E                    decimal point, even if no digits follow the point E D                    (normally, a decimal point appears in the result D                                                     @  E                    of these conversions only if a digit follows it). E E                    For g and G conversions, trailing zeroes will not E C                    be removed from the result (which they normally C                     are).     ;          The conversion characters and their meanings are: ;    C          d,o,u,x,X The integer arg is converted to signed decimal, C D                    unsigned octal, decimal, or hexadecimal notation D C                    (x and X), respectively; the letters abcdef are C F                    used for x conversion and the letters ABCDEF for X F D                    conversion.  The precision specifies the minimum D B                    number of digits to appear; if the value being B               @  D                    converted can be represented in fewer digits, it D ?                    will be expanded with leading zeroes.  (For ? C                    compatibility with older versions, padding with C D                    leading zeroes may alternatively be specified by D D                    prepending a zero to the field width.  This does D F                    not imply an octal value for the field width.) The F E                    default precision is 1.  The result of converting E C                    a zero value with a precision of zero is a null C                     string.  C          f         The float or double arg is converted to decimal C C                    notation in the style ``[-]ddd.ddd,'' where the C                   @  E                    number of digits after the decimal point is equal E E                    to the precision specification.  If the precision E =                    is missing, six digits are output; if the = ?                    precision is explicitly 0, no decimal point ?                     appears.  E          e,E       The float or double arg is converted in the style E E                    ``[-]d.ddde+dd,'' where there is one digit before E D                    the decimal point and the number of digits after D D                    it is equal to the precision; when the precision D ?                    is missing, six digits are produced; if the ? E                    precision is zero, no decimal point appears.  The E                        @  F                    E format code will produce a number with E instead F @                    of e introducing the exponent.  The exponent @ 8                    always contains at least two digits. 8 F          g,G       The float or double arg is printed in style f or e F C                    (or in style E in the case of a G format code), C ?                    with the precision specifying the number of ? F                    significant digits.  The style used depends on the F E                    value converted: style e will be used only if the E B                    exponent resulting from the conversion is less B D                    than -4 or greater than the precision.  Trailing D                                                             @  A                    zeroes are removed from the result; a decimal A D                    point appears only if it is followed by a digit. D 1          c         The character arg is printed. 1 >          s         The arg is taken to be a string (character > ?                    pointer) and characters from the string are ? F                    printed until a null character (\0) is encountered F @                    or the number of characters indicated by the @ ?                    precision specification is reached.  If the ? E                    precision is missing, it is taken to be infinite, E D                    so all characters up to the first null character D A                    are printed.  A NULL value for arg will yield A              @  &                    undefined results. & 8          %         Print a %; no argument is converted. 8    C          In no case does a non-existent or small field width cause C A          truncation of a field; if the result of a conversion is A E          wider than the field width, the field is simply expanded to E A          contain the conversion result.  Characters generated by A >          printf and fprintf are printed as if putc() had been >           called.     
     EXAMPLES 
 @          To print a date and time in the form ``Sunday, July 3, @ @          10:02,'' where weekday and month are pointers to null- @           terminated strings:     L               printf("%s, %s %d, %d:%.2d", weekday, month, day, hour, min); L           @  *          To print pi to 5 decimal places: *    2               printf("pi = %.5f", 4 * atan(1.0)); 2    
     SEE ALSO 
 *          ecvt.m, putc.m, scanf.m, stdio.m *    *          (printed 07/30/92 - J B Systems) *                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      