  @     	     Name 	 5          sh - Invokes the shell command interpreter. 5         Syntax  &          sh [ -ceiknrstuvx ] [ args ] &         Description  E          The shell is the standard command programming language that E @          executes commands read from a terminal or a file.  See @ E          Invocation below for the meaning of arguments to the shell. E    
     Commands 
 D          A simple-command is a sequence of nonblank words separated D B          by blanks (a blank is a tab or a space).  The first word B F          specifies the name of the command to be executed.  Except as F F          specified below, the remaining words are passed as arguments F @          to the invoked command.  The command name is passed as @        @  F          argument 0 (see (NBC)exec.m).  The value of a simple-command F B          is its exit status if it terminates normally, or (octal) B E          1000+status if it terminates abnormally.  See (NBC)signal.m E &          for a list of status values. &    D          A list is a sequence of one or more pipelines separated by D C          ;, &, &&, or ||, and optionally terminated by ; or &.  Of C E          these four symbols, ; and & have equal precedence, which is E C          lower than that of && and ||.  The symbols && and || also C C          have equal precedence.  A semicolon (;) causes sequential C B          execution of the preceding pipeline.  The symbol && (||) B A          causes the list following it to be executed only if the A   @  B          preceding pipeline returns a zero (nonzero) exit status. B ?          An arbitrary number of newlines may appear in a list, ? 5          instead of semicolons, to delimit commands. 5    F          A command is either a simple-command or one of the following F E          commands.  Unless otherwise stated, the value returned by a E D          command is that of the last simple-command executed in the D           command:     "          for name [ in word ... ] "           do                 list            done  F          Each time a for command is executed, name is set to the next F H          word taken from the in word list.  If in word is omitted, then H                                                                          @  G          the for command executes the do list once for each positional G C          parameter that is set (see Parameter Substitution below). C B          Execution ends when there are no more words in the list. B              case word in  1               [ pattern [ | pattern ] ... ) list 1                ;;  ]            esac  D          A case command executes the list associated with the first D E          pattern that matches word.  The form of the patterns is the E A          same as that used for filename generation (see Filename A           Generation below).               if list then                 list            [ elif list then                 list ]            [ else list ]            fi                         @  E          The list following if is executed and, if it returns a zero E E          exit status, the list following the first then is executed. E D          Otherwise, the list following elif is executed and, if its D F          value is zero, the list following the next then is executed. F F          Failing that, the else list is executed.  If no else list or F H          then list is executed, then the if command returns a zero exit H           status.               while list            do                 list            done  H          A while command repeatedly executes the while list and, if the H G          exit status of the last command in the list is zero, executes G                                                                @  H          the do list; otherwise the loop terminates.  If no commands in H I          the do list are executed, then the while command returns a zero I H          exit status; until may be used in place of while to negate the H            loop termination test.                (list)  &          Executes list in a subshell. &              {list;}  "          list is simply executed. "              name () {list;}  A          Define a function which is referenced by name. The body A ?          of functions is the list of commands between { and }. ? 8          Execution of functions is described later (see 8           Execution.)        F          The following words are recognized only as the first word of F                             @  (          a command and when not quoted: (    D          if then else elif fi case esac for while until do done { } D    
     Comments 
 >          A word beginning with # causes that word and all the > =          following characters up to a newline to be ignored. =         Command Substitution  B          The standard output from a command enclosed in a pair of B B          grave accents (``) may be used as part or all of a word; B (          trailing newlines are removed. (         Parameter Substitution  <          The character $ is used to introduce substitutable < F          parameters.  Positional parameters may be assigned values by F 0          set.  Variables may be set by writing: 0                                            @  ,               name=value [ name=value ] ... ,    5          Pattern-matching is not performed on value. 5              ${parameter}  ?               A parameter is a sequence of letters, digits, or ? F               underscores (a name), a digit, or any of the characters F B               *, @, #, ?, -, $, and !.  The value, if any, of the B F               parameter is substituted.  The braces are required only F @               when parameter is followed by a letter, digit, or @ F               underscore that is not to be interpreted as part of its F D               name.  A name must begin with a letter or underscore. D >               If parameter is a digit then it is a positional >                                                          @  ?               parameter.  If parameter is * or @, then all the ? ;               positional parameters, starting with $1, are ; F               substituted (separated by spaces).  Parameter $0 is set F <               from argument zero when the shell is invoked. <              ${parameter:-word}  >               If parameter is set and is not a null argument, > ?               substitute its value; otherwise substitute word. ?              ${parameter:=word}  A               If parameter is not set or is null, then set it to A D               word; the value of the parameter is then substituted. D C               Positional parameters may not be assigned to in this C                way.               ${parameter:?word}                  @  >               If parameter is set and is not a null argument, > C               substitute its value; otherwise, print word and exit C >               from the shell. If word is omitted, the message > 8               ``parameter null or not set'' is printed. 8              ${parameter:+word}  >               If parameter is set and is not a null argument, > E               substitute word; otherwise substitute nothing.  In the E F               above, word is not evaluated unless it is to be used as F ?               the substituted string, so that in the following ? B               example, pwd is executed only if d is not set or is B                null:     $                    echo ${d:-`pwd`} $                                           @  F               If the colon (:) is omitted from the above expressions, F C               then the shell only checks whether parameter is set. C    F          The following parameters are automatically set by the shell: F    =          #    The number of positional parameters in decimal =    F          -    Flags supplied to the shell on invocation or by the set F                command     C          ?    The decimal value returned by the last synchronously C                executed command     /          $    The process number of this shell /    @          !    The process number of the last background command @                invoked     9          The following parameters are used by the shell: 9              CDPATH         @  >               Defines search path for the cd command. See the > 0               section Special Commands, ``cd''. 0    ?          HOME The default argument (home directory) for the cd ?                command     A          PATH The search path for commands (see Execution below) A    7          PS1  Primary prompt string, by default ``$ '' 7    9          PS2  Secondary prompt string, by default ``> '' 9    B          IFS  Internal field separators, normally space, tab, and B                newline               SHELL  B               When the shell is invoked, it scans the environment B E               (see Environment below) for this name.  If it is found E                                                                            @  F               and there is an `r' in the file name part of its value, F 4               the shell becomes a restricted shell. 4    I               The shell gives default values to PATH, PS1, PS2, and IFS, I 9               while HOME is not set at all by the shell. 9         Blank Interpretation  B          After parameter and command substitution, the results of B ?          substitution are scanned for internal field separator ? A          characters (those found in IFS) and split into distinct A C          arguments where such characters are found.  Explicit null C E          arguments ("" or '') are retained.  Implicit null arguments E C          (those resulting from parameters that have no values) are C           removed.             @       Filename Generation  F          Following substitution, each command word is scanned for the F F          characters *, ?, and [.  If one of these characters appears, F B          the word is regarded as a pattern.  The word is replaced B F          with alphabetically sorted filenames that match the pattern. F D          If no filename is found that matches the pattern, the word D ?          is left unchanged.  The character . at the start of a ? ?          filename or immediately following a /, as well as the ? ?          character / itself, must be matched explicitly. These ? 5          characters and their matching patterns are: 5    =          *    Matches any string, including the null string. =                                          @  ,          ?    Matches any single character. ,              [...]  E               Matches any one of the enclosed characters.  A pair of E >               characters separated by - matches any character > C               lexically between the pair, inclusive.  If the first C @               character following the opening bracket ([) is an @ D               exclamation mark (!), then any character not enclosed D                is matched.          Quoting  F          The following characters have a special meaning to the shell F 8          and cause termination of a word unless quoted: 8    8               ;  &  ( )  |  ^  <  >  newline space  tab 8    D          A character may be quoted (i.e., made to stand for itself) D               @  B          by preceding it with a \.  The pair \newline is ignored. B D          All characters enclosed between a pair of single quotation D A          marks (''), except a single quotation mark, are quoted. A C          Inside double quotation marks (""), parameter and command C F          substitution occurs and \ quotes the characters \, `, ", and F B          $.  "$*" is equivalent to "$1 $2 ...", whereas ``$@'' is B %          equivalent to "$1" "$2" ... %         Prompting  F          When used interactively, the shell prompts with the value of F D          PS1 before reading a command.  If at any time a newline is D F          typed and further input is needed to complete a command, the F                                                      @  >          secondary prompt (i.e., the value of PS2) is issued. >         Input/Output  C          Before a command is executed, its input and output may be C @          redirected using a special notation interpreted by the @ 8          shell.  The following may appear anywhere in a 8 E          simple-command or may precede or follow a command. They are E ?          passed on to the invoked command; substitution occurs ? '          before word or digit is used: '    9          <word     Use file word as standard input (file 9 "                    descriptor 0). "    :          >word     Use file word as standard output (file : A                    descriptor 1). If the file does not exist, it A                                                  @  B                    is created; otherwise, it is truncated to zero B                     length.     B          >>word    Use file word as standard output.  If the file B >                    exists, output is appended to it (by first > A                    seeking the end-of-file); otherwise, the file A                     is created.     @          <<[-]word The shell input is read up to a line that is @ @                    the same as word, or to an end-of-file.  The @ B                    resulting document becomes the standard input. B :                    If any character of word is quoted, no : @                    interpretation is placed upon the characters @ =                    of the document; otherwise, parameter and =            @  <                    command substitution occurs, (unescaped) < >                    \newline is ignored, and \ must be used to > ?                    quote the characters \, $, `, and the first ? @                    character of word.  If - is appended to << , @ ?                    all leading tabs are stripped from word and ? &                    from the document. &    >          <&digit   The standard input is duplicated from file > @                    descriptor digit (see dup(S)). Similarly for @ 0                    the standard output using >. 0    @          <&-       The standard input is closed.  Similarly for @ 0                    the standard output using >. 0    >          If one of the above is preceded by a digit, the file >   @  D          descriptor created is that specified by the digit (instead D /          of the default 0 or 1).  For example: /                   ... 2>&1     ?          creates file descriptor 2 that is a duplicate of file ?           descriptor 1.     C          If a command is followed by &, the default standard input C <          for the command is the null device. Otherwise, the < A          environment for the execution of a command contains the A ?          file descriptors of the invoking shell as modified by ? &          input/output specifications. &         Environment  C          The environment (see (NBC)exec.m) is a list of name-value C E          pairs that is passed to an executed program in the same way E                       @  B          as a normal argument list.  The shell interacts with the B E          environment in several ways. On invocation, the shell scans E F          the environment and creates a parameter for each name found, F ?          giving it the corresponding value.  Executed commands ? A          inherit the same environment.  If the user modifies the A A          values of these parameters or creates new ones, none of A C          these affect the environment unless the export command is C E          used to bind the shell's parameter to the environment.  The E E          environment seen by any executed command is composed of any E A          unmodified name-value pairs originally inherited by the A                                                        @  ;          shell, minus any pairs removed by unset, plus any ; C          modifications or additions, all of which must be noted in C           export commands.     D          The environment for any simple-command may be augmented by D B          prefixing it with one or more assignments to parameters. B           Thus:                     TERM=450 cmd args      
          and 
    0               (export TERM; TERM=450; cmd args) 0    A          are equivalent (as far as the above execution of cmd is A           concerned).     D          If the -k flag is set, all keyword arguments are placed in D E          the environment, even if they occur after the command name. E         Signals                                             @  C          The INTERRUPT and QUIT signals for an invoked command are C           ignored.          Execution  F          Each time a command is executed, the above substitutions are F C          carried out. If the command name does not match a Special C B          Command, but matches the name of a defined function, the B B          function is executed in the shell process (note how this B >          differs from the execution of shell procedures). The > D          positional parameters $1, $2, ... are set to the arguments D @          of the function. If the command name matches neither a @ C          Special Command nor the name of a defined function, a new C B          process is created and an attempt is made to execute the B                @  "          command via (NBC)exec.m. "    B          The shell parameter PATH defines the search path for the B B          directory containing the command.  Alternative directory B B          names are separated by a colon (:).  The default path is B H          :/system/bin:/system/system (specifying the current directory, H E          /system/bin, and /system/system, in that order).  Note that E @          the current directory is specified by a null pathname, @ F          which can appear immediately after the equal sign or between F F          the colon delimiters anywhere else in the path list.  If the F F          command name contains a /, then the search path is not used. F                                                                        @  B          Otherwise, each directory in the path is searched for an B E          executable file.  If the file is not an executable file, it E H          is assumed to be a file containing shell commands.  A subshell H =          (i.e., a separate process) is activated to read it. = A          A parenthesized command is also executed in a subshell. A    F          The location in the search path where a command was found is F B          remembered by the shell (to help avoid unnecessary execs B D          later).  If the command was found in a relative directory, D A          its location must be re-determined whenever the current A >          directory changes.  The shell forgets all remembered >                                                       @  @          locations whenever the PATH variable is changed or the @ 2          hash -r command is executed (see below). 2         Special Commands  C          Input/output redirection is permitted for these commands: C    E          :    No effect; the command does nothing.  A zero exit code E                is returned.               . file  F               Reads and executes commands from file and returns.  The F @               search path specified by PATH is used to find the @ )               directory containing file. )              break [ n ]  F               Exits from the enclosing for or while loop, if any.  If F 2               n is specified, it breaks n levels. 2              continue [ n ]                              @  A               Resumes the next iteration of the enclosing for or A E               while loop.  If n is specified, it resumes at the n-th E                enclosing loop.               cd [ arg ]  ?               Changes the current directory to arg.  The shell ? F               parameter HOME is the default arg.  The shell parameter F ?               CDPATH defines the search path for the directory ? >               containing arg. Alternative directory names are > D               separated by a colon (:).  The default path is <null> D A               (specifying the current directory).  Note that the A B               current directory is specified by a null path name, B C               which can appear immediately after the equal sign or C   @  E               between the colon delimiters anywhere else in the path E D               list.  If arg begins with a /, the search path is not D >               used.  Otherwise, each directory in the path is >                 searched for arg.                echo [ arg ]  E               Writes arguments separated by blanks and terminated by E B               a newline on the standard output.  Arguments may be B C               enclosed in quotes.  Quotes are required so that the C >               shell correctly interprets these special escape >                sequences:                    \b  Backspace  /               \c  Prints line without newline. /                \f  Form feed                 \n  Newline                            @  "               \r  Carriage return "                \t  Tab                 \v  Vertical tab                 \\  Backslash  I               \n  The 8-bit character whose ASCII code is the 1, 2 or 3- I >                   digit octal number n must start with a zero >              eval [ arg ... ]  C               The arguments are read as input to the shell and the C -               resulting command(s) executed. -              exec [ arg ... ]  D               The command specified by the arguments is executed in D B               place of this shell without creating a new process. B A               Input/output arguments may appear and, if no other A F               arguments are given, cause the shell input/output to be F               @                 modified.               exit [ n ]  D               Causes a shell to exit with the exit status specified D E               by n.  If n is omitted, the exit status is that of the E E               last command executed.  An end-of-file will also cause E !               the shell to exit. !              export [ name ... ]  E               The given names are marked for automatic export to the E D               environment of subsequently executed commands.  If no D @               arguments are given, a list of all names that are @ 1               exported in this shell is printed. 1    "          hash [ -r ] [ name ... ] " D               For each name, the location in the search path of the D                                 @  E               command specified by name is determined and remembered E F               by the shell.  The -r option causes the shell to forget F D               all remembered locations.  If no arguments are given, D B               information about remembered commands is presented. B    B          pwd  Print the current working directory.  See pwd.m for B %               usage and description. %              read [ name ... ]  E               One line is read from the standard input and the first E E               word is assigned to the first name, the second word to E E               the second name, etc., with leftover words assigned to E =               the last name.  The return code is 0 unless an =                                       @  *               end-of-file is encountered. *              readonly [ name ... ]  D               The given names are marked readonly and the values of D ?               the these names may not be changed by subsequent ? D               assignment.  If no arguments are given, a list of all D )               readonly names is printed. )              return [ n ]  >               Causes a function to exit with the return value > E               specified by n.  If n is omitted, the return status is E 1               that of the last command executed. 1    %          set [ -eknuvx [ arg ... ] ] % E               -e   If the shell is noninteractive, exits immediately E B                    if a command exits with a nonzero exit status. B          @  2               -f   Disables file name generation. 2 >               -h   Locates and remembers function commands as > @                    functions are defined (function commands are @ D                    normally located when the function is executed). D C               -k   Places all keyword arguments in the environment C B                    for a command, not just those that precede the B !                    command name. ! =               -n   Reads commands but does not execute them. = ;               -u   Treats unset variables as an error when ; !                    substituting. ! >               -v   Prints shell input lines as they are read. > C               -x   Prints commands and their arguments as they are C                        @                      executed.  ?               --   Does not change any of the flags; useful in ? $                    setting $1 to -. $    D               Using + rather than - causes these flags to be turned D D               off.  These flags can also be used upon invocation of D C               the shell.  The current set of flags may be found in C E               $-.  The remaining arguments are positional parameters E @               and are assigned, in order, to $1, $2, ...  If no @ ?               arguments are given, the values of all names are ?                printed.               shift  H               The positional parameters from $2 ...  are renamed $1 ... H              test                                               @  @               Evaluates conditional expressions. See test.m for @ %               usage and description. %               trap [ arg ] [ n ] ...   F               arg is a command to be read and executed when the shell F D               receives signal(s) n.  (Note that arg is scanned once D E               when the trap is set and once when the trap is taken.) E D               Trap commands are executed in order of signal number. D C               The highest signal number allowed is 16. Any attempt C E               to set a trap on a signal that was ignored on entry to E C               the current shell is ineffective.  If arg is absent, C D               all trap(s) n are reset to their original values.  If D                                    @  D               arg is the null string, this signal is ignored by the D 4               shell and by the commands it invokes. 4    F               If n is 0, the command arg is executed on exit from the F B               shell.  The trap command with no arguments prints a B C               list of commands associated with each signal number. C              unset [ name ... ]  B               For each name, remove the corresponding variable or B ?               function.  The variables PATH, PS1, PS2, and IFS ?                cannot be unset.               umask [ ooo ]  E               The user file-creation mask is set to the octal number E @               ooo where o is an octal digit. If ooo is omitted, @                                  @  8               the current value of the mask is printed. 8         Invocation  A          If the shell is invoked through (NBC)exec and the first A C          character of argument 0 is -, commands are initially read C H          from /system/bin/profile and then from $HOME/.profile, if such H B          files exist.  Thereafter, commands are read as described B D          below, which is also the case when the shell is invoked as D J          /system/bin/sh.  The flags below are interpreted by the shell on J @          invocation only; note that unless the -c or -s flag is @ F          specified, the first argument is assumed to be the name of a F C          file containing commands, and the remaining arguments are C                               @  ?          passed as positional parameters to that command file: ? E          -c string If the -c flag is present, commands are read from E                     string.  @          -s        If the -s flag is present or if no arguments @ F                    remain, commands are read from the standard input. F B                    Any remaining arguments specify the positional B ?                    parameters. Shell output is written to file ? !                    descriptor 2. ! B          -t        If the -t flag is present, a single command is B F                    read and executed, and the shell exits.  This flag F E                    is intended for use by C programs only and is not E )                    useful interactively. )               @  C          -i        If the -i flag is present or if the shell input C E                    and output are attached to a terminal, this shell E #                    is interactive. # =          -r        If the -r flag is present, the shell is a = %                    restricted shell. %    C          The remaining flags and arguments are described under the C           set command above.          Exit Status  D          Errors detected by the shell, such as syntax errors, cause D E          the shell to return a nonzero exit status.  If the shell is E E          being used noninteractively, execution of the shell file is E E          abandoned.  Otherwise, the shell returns the exit status of E                                                   @  @          the last command executed. See the exit command above. @    
     Files 
 I          /system/bin/profile   system default profile if none is present I    
     See Also 
 .          cd.m, test.m, (NBC)exec, (NBC)signal .    
     Notes 
 D          The command readonly (without arguments) produces the same D '          output as the command export. '    D          If a command is executed, and a command with the same name D C          is installed in a directory in the search path before the C C          directory where the original command was found, the shell C C          will continue to exec the original command.  Use the hash C ,          command to correct this situation. ,                                                      @  D          If you move the current directory or one above it, pwd may D C          not give the correct response.  Use the cd command with a C 3          full path name to correct this situation. 3    I          When the shell is executed, the shell system reads and executes I J          commands in /system/bin/profile.  You can, therefore, modify the J B          environment for all shell users on the system by editing B           /system/bin/profile.        (          (printed 5/7/94 - J B Systems) (                                                                                                                                                                                                                                                  